/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.chooser;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManagerListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsPanel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringMultipleContextsEditorNotification
implements EditorNotificationProvider {
    SpringMultipleContextsEditorNotification() {
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SpringMultipleContextsEditorNotification.$$$reportNull$$$0(0);
        }
        if (file == null) {
            SpringMultipleContextsEditorNotification.$$$reportNull$$$0(1);
        }
        if (!SpringGeneralSettings.getInstance((Project)project).isShowMultipleContextsPanel()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (!(psiFile instanceof XmlFile) || !SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile))) {
            return null;
        }
        List<SpringContextDescriptor> descriptors = SpringMultipleContextsManager.getInstance().getAllContextDescriptors(psiFile);
        if (descriptors.size() <= 1) {
            return null;
        }
        ArrayList<SpringContextDescriptor> allDescriptors = new ArrayList<SpringContextDescriptor>();
        allDescriptors.add(SpringContextDescriptor.LOCAL_CONTEXT);
        allDescriptors.add(SpringContextDescriptor.ALL_CONTEXTS);
        allDescriptors.addAll(descriptors);
        SpringContextDescriptor currentContext = SpringMultipleContextsEditorNotification.getUpdatedCurrentContext(psiFile, allDescriptors);
        return fileEditor -> new SpringMultipleContextsPanel((FileEditor)fileEditor, psiFile, (List<SpringContextDescriptor>)allDescriptors, currentContext);
    }

    @NotNull
    private static SpringContextDescriptor getUpdatedCurrentContext(PsiFile psiFile, List<SpringContextDescriptor> allDescriptors) {
        SpringContextDescriptor userDefinedDescriptor = SpringMultipleContextsManager.getInstance().getUserDefinedContextDescriptor(psiFile);
        if (userDefinedDescriptor == null) {
            SpringContextDescriptor springContextDescriptor = SpringMultipleContextsManager.getInstance().getContextDescriptor(psiFile);
            if (springContextDescriptor == null) {
                SpringMultipleContextsEditorNotification.$$$reportNull$$$0(2);
            }
            return springContextDescriptor;
        }
        for (SpringContextDescriptor existing : allDescriptors) {
            if (!userDefinedDescriptor.getQualifiedName().equals(existing.getQualifiedName())) continue;
            SpringContextDescriptor springContextDescriptor = existing;
            if (springContextDescriptor == null) {
                SpringMultipleContextsEditorNotification.$$$reportNull$$$0(3);
            }
            return springContextDescriptor;
        }
        SpringContextDescriptor springContextDescriptor = SpringContextDescriptor.DEFAULT;
        if (springContextDescriptor == null) {
            SpringMultipleContextsEditorNotification.$$$reportNull$$$0(4);
        }
        return springContextDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdatedCurrentContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNotificationData";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class SpringFacetsChangedListener
    implements FacetManagerListener {
        public void facetAdded(@NotNull Facet facet) {
            if (facet == null) {
                SpringFacetsChangedListener.$$$reportNull$$$0(0);
            }
            SpringFacetsChangedListener.facetChanged(facet);
        }

        public void facetRemoved(@NotNull Facet facet) {
            if (facet == null) {
                SpringFacetsChangedListener.$$$reportNull$$$0(1);
            }
            SpringFacetsChangedListener.facetChanged(facet);
        }

        public void facetConfigurationChanged(@NotNull Facet facet) {
            if (facet == null) {
                SpringFacetsChangedListener.$$$reportNull$$$0(2);
            }
            SpringFacetsChangedListener.facetChanged(facet);
        }

        private static void facetChanged(Facet<?> facet) {
            if (facet.getTypeId() == SpringFacet.FACET_TYPE_ID) {
                EditorNotifications.getInstance((Project)facet.getModule().getProject()).updateAllNotifications();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "facet";
            objectArray2[1] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsEditorNotification$SpringFacetsChangedListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "facetAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "facetRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "facetConfigurationChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

