/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFileResolveMode;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlImportBuilder {
    public static final SqlImportBuilder INSTANCE = new SqlImportBuilder();

    protected boolean maybeImportStatement(@NotNull PsiElement element) {
        if (element == null) {
            SqlImportBuilder.$$$reportNull$$$0(0);
        }
        return element instanceof SqlUseDatabaseStatement && DbSqlUtilCore.getFileResolveMode((PsiElement)element) == SqlFileResolveMode.SCRIPT;
    }

    @NotNull
    protected SqlImportState produceNextState(@NotNull SqlImportState current, @NotNull SqlImportState.Shared shared, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement element) {
        if (current == null) {
            SqlImportBuilder.$$$reportNull$$$0(1);
        }
        if (shared == null) {
            SqlImportBuilder.$$$reportNull$$$0(2);
        }
        if (dialect == null) {
            SqlImportBuilder.$$$reportNull$$$0(3);
        }
        if (element == null) {
            SqlImportBuilder.$$$reportNull$$$0(4);
        }
        SqlUseDatabaseStatement statement = (SqlUseDatabaseStatement)element;
        return new SqlImportState((PsiElement)statement, false, shared, dialect.processImports(statement, current.state), current);
    }

    @NotNull
    public SqlImportState buildImports(@NotNull SqlFile sqlFile) {
        if (sqlFile == null) {
            SqlImportBuilder.$$$reportNull$$$0(5);
        }
        SqlFileResolveMode mode = DbSqlUtilCore.getFileResolveMode((PsiElement)sqlFile);
        TreePattern overlay = SqlDialectImplUtilCore.buildOverlayPattern(sqlFile);
        SqlImportState.Shared originalShared = new SqlImportState.Shared(sqlFile, overlay);
        SqlImportState.Shared nextShared = mode == SqlFileResolveMode.SCRIPT ? new SqlImportState.Shared(sqlFile, null) : originalShared;
        SqlImportState current = new SqlImportState(null, false, originalShared, SqlImportBuilder.calcInitialImportState(sqlFile), null);
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        for (PsiElement element : JBIterable.from((Iterable)sqlFile.getDdl()).filter(e -> this.maybeImportStatement((PsiElement)e))) {
            current = this.produceNextState(current, nextShared, language, element);
        }
        SqlImportState sqlImportState = current;
        if (sqlImportState == null) {
            SqlImportBuilder.$$$reportNull$$$0(6);
        }
        return sqlImportState;
    }

    @NotNull
    private static TreePattern calcInitialImportState(@NotNull SqlFile sqlFile) {
        TreePattern resolvePattern;
        SearchPath searchPath;
        SqlFile hostFile;
        SqlFile orig;
        if (sqlFile == null) {
            SqlImportBuilder.$$$reportNull$$$0(7);
        }
        if ((orig = (SqlFile)ObjectUtils.tryCast((Object)sqlFile.getOriginalFile(), SqlFile.class)) != null && orig != sqlFile) {
            return SqlImportBuilder.calcInitialImportState(orig);
        }
        VirtualFile vfile = sqlFile.getVirtualFile();
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)sqlFile.getProject()).getInjectionHost((PsiElement)sqlFile);
        if (host == null) {
            host = sqlFile.getContext();
        }
        SqlFile sqlFile2 = hostFile = host == null ? null : (SqlFile)ObjectUtils.tryCast((Object)host.getContainingFile(), SqlFile.class);
        if (hostFile != null && SqlImplUtil.getSqlDialectSafe((PsiElement)hostFile) == SqlImplUtil.getSqlDialectSafe((PsiElement)sqlFile)) {
            SqlImportState at = SqlDialectImplUtilCore.getImportCheckerAt(hostFile, (PsiElement)host);
            TreePattern treePattern = at.state;
            if (treePattern == null) {
                SqlImportBuilder.$$$reportNull$$$0(8);
            }
            return treePattern;
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        if (DbSrcUtilsCore.isDbSrcFile((VirtualFile)vfile)) {
            String dataSourceId = DbSrcUtilsCore.getDataSource((VirtualFile)vfile);
            DbDataSource ds2 = dataSourceId == null ? null : DbPsiFacade.getInstance((Project)sqlFile.getProject()).findDataSource(dataSourceId);
            SearchPath searchPath2 = DatabaseEditorHelperCore.dbSrcSearchPath((Project)sqlFile.getProject(), (VirtualFile)vfile, (boolean)true);
            TreePattern treePattern = searchPath2 != null ? language.srcFilePattern(ds2, searchPath2) : TreePattern.EMPTY;
            if (treePattern == null) {
                SqlImportBuilder.$$$reportNull$$$0(9);
            }
            return treePattern;
        }
        if (vfile instanceof DatabaseElementVirtualFileImpl) {
            DbElement o = ((DatabaseElementVirtualFileImpl)vfile).findElement(sqlFile.getProject());
            SearchPath searchPath3 = ObjectPaths.searchPathOf((DasObject)DbImplUtilCore.getSearchPathObject((DatabaseDialectEx)language.getDatabaseDialect(), (DasObject)o));
            TreePattern treePattern = searchPath3 != null && o != null ? language.srcFilePattern(o.getDataSource(), searchPath3) : TreePattern.EMPTY;
            if (treePattern == null) {
                SqlImportBuilder.$$$reportNull$$$0(10);
            }
            return treePattern;
        }
        JdbcConsoleCore console = JdbcConsoleProviderCore.getValidConsole((Project)sqlFile.getProject(), (VirtualFile)vfile);
        SearchPath searchPath4 = searchPath = console != null ? console.getSearchPath() : null;
        if (searchPath != null) {
            JBIterable<DbDataSource> dataSources = SqlImportBuilder.getFilteredDataSources(sqlFile, null);
            TreePattern treePattern = TreePatternUtils.union((Iterable)dataSources.transform(ds -> language.srcFilePattern((DbDataSource)ds, searchPath)));
            if (treePattern == null) {
                SqlImportBuilder.$$$reportNull$$$0(11);
            }
            return treePattern;
        }
        TreePattern treePattern = resolvePattern = console == null ? SqlImportUtil.getResolveScopePattern(sqlFile) : null;
        if (resolvePattern != null && !TreePatternUtils.isWildcard((TreePatternNode.Group)resolvePattern.root.getGroup(SqlImportUtil.DATA_SOURCE))) {
            JBIterable<DbDataSource> dataSources = SqlImportBuilder.getFilteredDataSources(sqlFile, resolvePattern);
            JBIterable scopePatterns = dataSources.filterMap(ds -> SqlImportUtil.createScopePatternIfAny(ds, language, sqlFile));
            TreePattern scopePattern = scopePatterns.isNotEmpty() ? TreePatternUtils.union((Iterable)scopePatterns) : null;
            TreePattern pattern = SqlImportUtil.processResolveScopePattern(resolvePattern, scopePattern);
            pattern = (TreePattern)dataSources.reduce((Object)pattern, (p2, ds) -> language.applyImplicitImports(SqlImportUtil.getRealDsNames(ds), (TreePattern)p2));
            TreePattern treePattern2 = language.applyImplicitImports(null, pattern);
            if (treePattern2 == null) {
                SqlImportBuilder.$$$reportNull$$$0(12);
            }
            return treePattern2;
        }
        SearchPath searchPathFromFile = (SearchPath)sqlFile.getUserData(DatabaseDataKeysCore.SEARCH_PATH_KEY);
        if (searchPathFromFile != null) {
            JBIterable<DbDataSource> dataSources = SqlImportBuilder.getFilteredDataSources(sqlFile, null);
            TreePattern treePattern3 = TreePatternUtils.union((Iterable)dataSources.transform(ds -> language.srcFilePattern((DbDataSource)ds, searchPathFromFile)));
            if (treePattern3 == null) {
                SqlImportBuilder.$$$reportNull$$$0(13);
            }
            return treePattern3;
        }
        return SqlImportBuilder.getDefaultInitialPattern(sqlFile, null);
    }

    @NotNull
    private static JBIterable<DbDataSource> getFilteredDataSources(@NotNull SqlFile sqlFile, @Nullable TreePattern filter) {
        boolean all;
        if (sqlFile == null) {
            SqlImportBuilder.$$$reportNull$$$0(14);
        }
        TreePatternNode.Group group = filter == null ? null : filter.root.getGroup(SqlImportUtil.DATA_SOURCE);
        boolean bl = all = filter == null || TreePatternUtils.isWildcard((TreePatternNode.Group)group);
        if (!all && group == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlImportBuilder.$$$reportNull$$$0(15);
            }
            return jBIterable;
        }
        JBIterable res = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)sqlFile));
        if (!all) {
            res = res.filter(ds -> {
                SqlDataSource sql = (SqlDataSource)ObjectUtils.tryCast((Object)ds.getDelegate(), SqlDataSource.class);
                return sql != null && sql.containsFile(sqlFile.getVirtualFile()) || group.matchedChildren(SqlImportUtil.getDataSourceName((DasDataSource)ds), Casing.EXACT, null);
            });
        }
        JBIterable jBIterable = res;
        if (jBIterable == null) {
            SqlImportBuilder.$$$reportNull$$$0(16);
        }
        return jBIterable;
    }

    @NotNull
    private static TreePattern getDefaultInitialPattern(@NotNull SqlFile sqlFile, @Nullable TreePattern filter) {
        if (sqlFile == null) {
            SqlImportBuilder.$$$reportNull$$$0(17);
        }
        SqlLanguageDialectEx language = (SqlLanguageDialectEx)sqlFile.getSqlLanguage();
        JBIterable<DbDataSource> dataSources = SqlImportBuilder.getFilteredDataSources(sqlFile, filter);
        TreePattern treePattern = TreePatternUtils.union((Iterable)dataSources.transform(ds -> SqlImportUtil.createDefaultScopePattern(ds, language, sqlFile)).append((Object)SqlImportUtil.createDefaultScopePattern(null, language, sqlFile)));
        if (treePattern == null) {
            SqlImportBuilder.$$$reportNull$$$0(18);
        }
        return treePattern;
    }

    @NotNull
    public static TreePattern getDefaultInitialPattern(@NotNull SqlFile sqlFile) {
        if (sqlFile == null) {
            SqlImportBuilder.$$$reportNull$$$0(19);
        }
        return SqlImportBuilder.getDefaultInitialPattern(sqlFile, SqlImportUtil.getResolveScopePattern(sqlFile));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8, 9, 10, 11, 12, 13, 15, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shared";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 5: 
            case 7: 
            case 14: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlImportBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlImportBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildImports";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInitialImportState";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredDataSources";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultInitialPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "maybeImportStatement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "produceNextState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildImports";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcInitialImportState";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredDataSources";
                break;
            }
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultInitialPattern";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8, 9, 10, 11, 12, 13, 15, 16, 18 -> new IllegalStateException(string);
        };
    }
}

