/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway.settings;

import com.intellij.flyway.msg.FlywayResourceBundle;
import com.intellij.flyway.settings.FlywayVersionPatternField;
import com.intellij.jpa.jpb.model.StateConfigurable;
import com.intellij.jpa.jpb.model.help.JpaHelpConstants;
import com.intellij.jpa.jpb.model.help.JpaHelpConstantsKt;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.liquibase.common.gui.settings.db.DatabaseVersioningConfigurableKt;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001dB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0002H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0002H\u0014J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0002H\u0014J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\b\u0010\u001c\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/flyway/settings/FlywayConfigurable;", "Lcom/intellij/jpa/jpb/model/StateConfigurable;", "Lcom/intellij/liquibase/common/config/DatabaseMigrationState;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "state", "prefixField", "Lcom/intellij/ui/components/JBTextField;", "versionPatternField", "Lcom/intellij/flyway/settings/FlywayVersionPatternField;", "separatorField", "descriptionField", "useFlywayField", "Ljavax/swing/JCheckBox;", "createComponent", "Ljavax/swing/JComponent;", "getDisplayName", "", "getState", "saveToState", "", "loadFromState", "getHelpTopic", "getId", "Companion", "intellij.flyway"})
@SourceDebugExtension(value={"SMAP\nFlywayConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlywayConfigurable.kt\ncom/intellij/flyway/settings/FlywayConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class FlywayConfigurable
extends StateConfigurable<DatabaseMigrationState>
implements SearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseMigrationState state;
    @NotNull
    private final JBTextField prefixField;
    @NotNull
    private final FlywayVersionPatternField versionPatternField;
    @NotNull
    private final JBTextField separatorField;
    @NotNull
    private final JBTextField descriptionField;
    @NotNull
    private final JCheckBox useFlywayField;
    @NotNull
    public static final String ID = "com.intellij.flyway.settings.FlywayConfigurable";
    @NotNull
    public static final String DISPLAY_NAME = "Flyway";

    public FlywayConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.state = DatabaseMigrationConfig.Companion.getInstance(this.project).getState();
        this.prefixField = new JBTextField();
        this.versionPatternField = new FlywayVersionPatternField();
        this.separatorField = new JBTextField();
        this.descriptionField = new JBTextField();
        this.useFlywayField = new JCheckBox(FlywayResourceBundle.message("use.flyway.without.dependency", new Object[0]));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public JComponent createComponent() {
        BorderLayoutPanel borderLayoutPanel;
        this.prefixField.getDocument().addDocumentListener(this.documentListener);
        this.versionPatternField.getDocument().addDocumentListener(this.documentListener);
        this.separatorField.getDocument().addDocumentListener(this.documentListener);
        this.descriptionField.getDocument().addDocumentListener(this.documentListener);
        this.useFlywayField.addActionListener(this.modifyListener);
        JPanel formPanel = FormBuilder.createFormBuilder().addLabeledComponent(FlywayResourceBundle.messageWithColon("migration.prefix", new Object[0]), (JComponent)this.prefixField).addLabeledComponent(FlywayResourceBundle.messageWithColon("version.pattern", new Object[0]), DatabaseVersioningConfigurableKt.wrapToVelocityHelpPanel((JComponent)((JComponent)((Object)this.versionPatternField)), (String)JpaHelpConstantsKt.helpUrlWithoutPrefix((String)JpaHelpConstants.PluginDoc.INSTANCE.getFlywaySettings()))).addLabeledComponent(FlywayResourceBundle.messageWithColon("migration.separator", new Object[0]), (JComponent)this.separatorField).addLabeledComponent(FlywayResourceBundle.messageWithColon("migration.description", new Object[0]), (JComponent)this.descriptionField).addComponent((JComponent)this.useFlywayField).getPanel();
        BorderLayoutPanel $this$createComponent_u24lambda_u240 = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl = false;
        $this$createComponent_u24lambda_u240.addToTop((Component)formPanel);
        return (JComponent)borderLayoutPanel;
    }

    @NotNull
    public String getDisplayName() {
        String string = FlywayResourceBundle.message("flyway.category", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected DatabaseMigrationState getState() {
        return this.state;
    }

    protected void saveToState(@NotNull DatabaseMigrationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String string = this.prefixField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        state.setFlywayMigrationPrefix(((Object)StringsKt.trim((CharSequence)string)).toString());
        String string2 = this.versionPatternField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        state.setFlywayVersionPattern(((Object)StringsKt.trim((CharSequence)string2)).toString());
        String string3 = this.separatorField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        state.setFlywayMigrationSeparator(((Object)StringsKt.trim((CharSequence)string3)).toString());
        String string4 = this.descriptionField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        state.setFlywayMigrationDescription(((Object)StringsKt.trim((CharSequence)string4)).toString());
        state.setUseFlywayForce(this.useFlywayField.isSelected());
    }

    protected void loadFromState(@NotNull DatabaseMigrationState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.prefixField.setText(state.getFlywayMigrationPrefix());
        this.versionPatternField.setText(state.getFlywayVersionPattern());
        this.separatorField.setText(state.getFlywayMigrationSeparator());
        this.descriptionField.setText(state.getFlywayMigrationDescription());
        this.useFlywayField.setSelected(state.getUseFlywayForce());
    }

    @NotNull
    public String getHelpTopic() {
        return JpaHelpConstants.PluginDoc.INSTANCE.getFlywaySettings();
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/flyway/settings/FlywayConfigurable$Companion;", "", "<init>", "()V", "ID", "", "DISPLAY_NAME", "intellij.flyway"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

