/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway;

import com.intellij.execution.filters.Filter;
import com.intellij.jpa.jpb.model.ui.util.HColor;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/flyway/FlywayStatusFilter;", "Lcom/intellij/execution/filters/Filter;", "<init>", "()V", "myPattern", "Ljava/util/regex/Pattern;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "intellij.flyway"})
public final class FlywayStatusFilter
implements Filter {
    @NotNull
    private final Pattern myPattern;

    public FlywayStatusFilter() {
        Pattern pattern = Pattern.compile("\\|\\s+?(Success|Pending|Failed|Ignored|Deleted)\\s+?\\|", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.myPattern = pattern;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Matcher matcher = this.myPattern.matcher(line);
        if (!matcher.find()) {
            return null;
        }
        String status = matcher.group(1);
        Intrinsics.checkNotNull((Object)status);
        if (StringsKt.contains((CharSequence)status, (CharSequence)"Success", (boolean)true)) {
            Color color2 = HColor.GREEN;
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"GREEN");
        } else if (StringsKt.contains((CharSequence)status, (CharSequence)"Pending", (boolean)true)) {
            Color color3 = HColor.YELLOW;
            color = color3;
            Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"YELLOW");
        } else if (StringsKt.contains((CharSequence)status, (CharSequence)"Failed", (boolean)true)) {
            Color color4 = HColor.RED;
            color = color4;
            Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"RED");
        } else if (StringsKt.contains((CharSequence)status, (CharSequence)"Ignored", (boolean)true)) {
            Color color5 = HColor.BLACK;
            color = color5;
            Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"BLACK");
        } else if (StringsKt.contains((CharSequence)status, (CharSequence)"Deleted", (boolean)true)) {
            Color color6 = HColor.ORANGE;
            color = color6;
            Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"ORANGE");
        } else {
            return null;
        }
        Color color7 = color;
        int startLineIdx = entireLength - line.length();
        int highlightStartOffset = startLineIdx + matcher.start(1);
        int highlightEndOffset = startLineIdx + matcher.end(1);
        return new Filter.Result(highlightStartOffset, highlightEndOffset, null, new TextAttributes(color7, null, null, null, 1));
    }
}

