/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.types.JSContext;

public enum JSTypeContext {
    STATIC,
    INSTANCE,
    PROTOTYPE,
    UNKNOWN;


    public static JSTypeContext fromJSContext(JSContext jsContext) {
        return JSTypeContext.fromJSContext(jsContext, false);
    }

    public static JSTypeContext fromJSContext(JSContext jsContext, boolean isDeclaration) {
        return switch (jsContext) {
            default -> throw new MatchException(null, null);
            case JSContext.STATIC -> STATIC;
            case JSContext.INSTANCE -> {
                if (isDeclaration) {
                    yield PROTOTYPE;
                }
                yield INSTANCE;
            }
            case JSContext.UNKNOWN -> UNKNOWN;
        };
    }

    public JSContext toJSContext() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> JSContext.STATIC;
            case 1, 2 -> JSContext.INSTANCE;
            case 3 -> JSContext.UNKNOWN;
        };
    }
}

