/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.generic.introspector.jdbc;

import com.intellij.database.Dbms;
import com.intellij.database.HSet;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ResultSetWrapper;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.TableIt;
import com.intellij.database.dialects.generic.GenericDbms;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.openapi.util.text.StringUtil;
import java.rmi.RemoteException;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenericMetadataWrapper
extends DatabaseMetaDataWrapper {
    @NotNull
    private static final HSet BROKEN_ESCAPING = Dbms.asSet((Dbms[])new Dbms[]{GenericDbms.MONET, GenericDbms.ATHENA});

    public GenericMetadataWrapper(@NotNull DatabaseConnectionCore connection, @NotNull RemoteDatabaseMetaData data) {
        if (connection == null) {
            GenericMetadataWrapper.$$$reportNull$$$0(0);
        }
        if (data == null) {
            GenericMetadataWrapper.$$$reportNull$$$0(1);
        }
        super(connection, data);
    }

    protected boolean isBrokenEscaping() {
        return this.getDbms().in(BROKEN_ESCAPING);
    }

    @NotNull
    protected ClosableIt<? extends DatabaseMetaDataWrapper.Table> tablesInner(@NotNull DatabaseMetaDataWrapper.Schema schema, @Nullable String name2, String @Nullable [] types) {
        if (schema == null) {
            GenericMetadataWrapper.$$$reportNull$$$0(2);
        }
        ClosableIt closableIt = super.tablesInner(schema, name2, this.isIris() ? null : types);
        if (closableIt == null) {
            GenericMetadataWrapper.$$$reportNull$$$0(3);
        }
        return closableIt;
    }

    @NotNull
    protected TableIt createTableIt(@NotNull DatabaseMetaDataWrapper.Schema schema, ResultSetWrapper rs, boolean hasNext) {
        if (schema == null) {
            GenericMetadataWrapper.$$$reportNull$$$0(4);
        }
        return new TableIt(rs, hasNext, schema){

            protected boolean fillValue(DatabaseMetaDataWrapper.Table res) throws SQLException {
                if (!super.fillValue(res)) {
                    return false;
                }
                if (GenericMetadataWrapper.this.getDbms() == GenericDbms.ATHENA && "VIRTUAL_VIEW".equals(res.type)) {
                    res.type = "VIEW";
                }
                return true;
            }
        };
    }

    private boolean isIris() {
        String dbmsName;
        if (this.getDbms() != Dbms.UNKNOWN) {
            return false;
        }
        try {
            dbmsName = this.myConnection.getRemoteConnection().getDetectedDbmsName();
        }
        catch (RemoteException e) {
            dbmsName = "";
        }
        return StringUtil.containsIgnoreCase((String)dbmsName, (String)"iris");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/generic/introspector/jdbc/GenericMetadataWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/generic/introspector/jdbc/GenericMetadataWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tablesInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tablesInner";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTableIt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    extends DatabaseMetaDataWrapper.MDFactory {
        @NotNull
        public DatabaseMetaDataWrapper create(@NotNull DatabaseConnectionCore connection, @NotNull RemoteDatabaseMetaData metaData) {
            if (connection == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (metaData == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new GenericMetadataWrapper(connection, metaData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "metaData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/generic/introspector/jdbc/GenericMetadataWrapper$Factory";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

