/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.families.FamilyWithId;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbObject;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.UtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0000J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014J \u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0000\"\u0004\b\u0001\u0010\u00012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0017J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0000\"\u0004\b\u0001\u0010\u0019H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0000J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u0000J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0000H\u0002J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u0000H\u0002J\u001c\u0010 \u001a\u0004\u0018\u00010\u00122\b\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020#H\u0002J\u0017\u0010$\u001a\u0004\u0018\u00010\u00122\u0006\u0010%\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010(\u001a\u00020)2\u0006\u0010%\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010*J8\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0000\"\u0004\b\u0001\u0010\u00192\u001e\u0010,\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\b0-H\u0086\b\u00f8\u0001\u0000J \u0010+\u001a\b\u0012\u0004\u0012\u0002H\u00190\u0000\"\u0004\b\u0001\u0010\u00192\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00190\bJ\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006/"}, d2={"Lcom/intellij/database/view/DbContextDataSourceElements;", "T", "", "project", "Lcom/intellij/openapi/project/Project;", "dataSource", "Lcom/intellij/database/model/RawDataSource;", "selection", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/model/RawDataSource;Ljava/lang/Iterable;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDataSource", "()Lcom/intellij/database/model/RawDataSource;", "getSelection", "()Ljava/lang/Iterable;", "asNodes", "Lcom/intellij/database/model/basic/BasicNode;", "asIterable", "Lcom/intellij/util/containers/JBIterable;", "filter", "clazz", "Ljava/lang/Class;", "unsafeCast", "U", "asDbElements", "Lcom/intellij/database/psi/DbElement;", "parentsForGroups", "expandGroups", "dataSourcesToRoots", "sel", "parentForGroup", "n", "ss", "Lcom/intellij/database/view/structure/DvTreeStructureService;", "asNode", "o", "(Ljava/lang/Object;)Lcom/intellij/database/model/basic/BasicNode;", "asDbElement", "dbDs", "Lcom/intellij/database/psi/DbDataSource;", "(Lcom/intellij/database/psi/DbDataSource;Ljava/lang/Object;)Lcom/intellij/database/psi/DbElement;", "replace", "replacer", "Lkotlin/Function1;", "nullize", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDbContextElements.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbContextElements.kt\ncom/intellij/database/view/DbContextDataSourceElements\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n158#1:165\n158#1:166\n158#1:167\n158#1:170\n30#2,2:168\n30#2,2:174\n19#3:171\n19#3:172\n1#4:173\n*S KotlinDebug\n*F\n+ 1 DbContextElements.kt\ncom/intellij/database/view/DbContextDataSourceElements\n*L\n99#1:165\n121#1:166\n123#1:167\n131#1:170\n124#1:168,2\n133#1:174,2\n145#1:171\n146#1:172\n*E\n"})
public final class DbContextDataSourceElements<T> {
    @NotNull
    private final Project project;
    @NotNull
    private final RawDataSource dataSource;
    @NotNull
    private final Iterable<T> selection;

    public DbContextDataSourceElements(@NotNull Project project, @NotNull RawDataSource dataSource, @NotNull Iterable<? extends T> selection) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        this.project = project;
        this.dataSource = dataSource;
        this.selection = selection;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final RawDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public final Iterable<T> getSelection() {
        return this.selection;
    }

    @NotNull
    public final DbContextDataSourceElements<BasicNode> asNodes() {
        DbContextDataSourceElements<Object> dbContextDataSourceElements;
        if (CollectionsKt.firstOrNull(this.selection) instanceof BasicNode) {
            dbContextDataSourceElements = this.unsafeCast();
        } else {
            JBIterable jBIterable = this.asIterable().filterMap(arg_0 -> DbContextDataSourceElements.asNodes$lambda$1(arg_0 -> DbContextDataSourceElements.asNodes$lambda$0(this, arg_0), arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
            dbContextDataSourceElements = this.replace((Iterable)jBIterable);
        }
        return dbContextDataSourceElements;
    }

    @NotNull
    public final JBIterable<T> asIterable() {
        return UtilKt.asJBIterable(this.selection);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> DbContextDataSourceElements<T> filter(@NotNull Class<T> clazz) {
        void it;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        DbContextDataSourceElements this_$iv = this;
        boolean $i$f$replace = false;
        DbContextDataSourceElements dbContextDataSourceElements = this_$iv;
        DbContextDataSourceElements dbContextDataSourceElements2 = this_$iv;
        boolean bl = false;
        JBIterable jBIterable = it.asIterable().filter(clazz);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        return dbContextDataSourceElements2.replace((Iterable)jBIterable);
    }

    private final <U> DbContextDataSourceElements<U> unsafeCast() {
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.database.view.DbContextDataSourceElements<U of com.intellij.database.view.DbContextDataSourceElements.unsafeCast>");
        return this;
    }

    @NotNull
    public final DbContextDataSourceElements<DbElement> asDbElements() {
        DbContextDataSourceElements<Object> dbContextDataSourceElements;
        if (CollectionsKt.firstOrNull(this.selection) instanceof BasicNode) {
            JBIterable jBIterable;
            DbDataSource dbDs = DbPsiFacade.getInstance((Project)this.project).findDataSource(this.dataSource.getUniqueId());
            if (dbDs == null) {
                JBIterable jBIterable2 = JBIterable.empty();
                jBIterable = jBIterable2;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"empty(...)");
            } else {
                JBIterable jBIterable3 = this.asIterable().filterMap(arg_0 -> DbContextDataSourceElements.asDbElements$lambda$1(arg_0 -> DbContextDataSourceElements.asDbElements$lambda$0(this, dbDs, arg_0), arg_0));
                jBIterable = jBIterable3;
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"filterMap(...)");
            }
            dbContextDataSourceElements = this.replace((Iterable)jBIterable);
        } else {
            dbContextDataSourceElements = this.unsafeCast();
        }
        return dbContextDataSourceElements;
    }

    @NotNull
    public final DbContextDataSourceElements<T> parentsForGroups() {
        return CollectionsKt.firstOrNull(this.selection) instanceof BasicNode ? super.unsafeCast() : this;
    }

    @NotNull
    public final DbContextDataSourceElements<T> expandGroups() {
        return CollectionsKt.firstOrNull(this.selection) instanceof BasicNode ? super.unsafeCast() : this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DbContextDataSourceElements<BasicNode> dataSourcesToRoots() {
        void s;
        DbContextDataSourceElements<BasicNode> this_$iv = this.asNodes();
        boolean $i$f$replace = false;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements = this_$iv;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements2 = this_$iv;
        boolean bl = false;
        JBIterable jBIterable = s.asIterable().filterMap(arg_0 -> DbContextDataSourceElements.dataSourcesToRoots$lambda$0$1(DbContextDataSourceElements::dataSourcesToRoots$lambda$0$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return dbContextDataSourceElements2.replace((Iterable)jBIterable);
    }

    /*
     * WARNING - void declaration
     */
    private final DbContextDataSourceElements<BasicNode> expandGroups(DbContextDataSourceElements<BasicNode> sel) {
        void selection;
        DbContextDataSourceElements<BasicNode> this_$iv = sel;
        boolean $i$f$replace = false;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements = this_$iv;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements2 = this_$iv;
        boolean bl = false;
        ComponentManager $this$service$iv = (ComponentManager)sel.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvTreeStructureService ss = (DvTreeStructureService)object;
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> DbContextDataSourceElements.expandGroups$lambda$0$1(arg_0 -> DbContextDataSourceElements.expandGroups$lambda$0$0(ss, arg_0), arg_0)).withRoots(selection.selection)).expandAndSkip(arg_0 -> DbContextDataSourceElements.expandGroups$lambda$0$3(DbContextDataSourceElements::expandGroups$lambda$0$2, arg_0))).traverse();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"traverse(...)");
        return dbContextDataSourceElements2.replace((Iterable)jBIterable);
    }

    /*
     * WARNING - void declaration
     */
    private final DbContextDataSourceElements<BasicNode> parentsForGroups(DbContextDataSourceElements<BasicNode> sel) {
        void selection;
        DbContextDataSourceElements<BasicNode> this_$iv = sel;
        boolean $i$f$replace = false;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements = this_$iv;
        DbContextDataSourceElements<BasicNode> dbContextDataSourceElements2 = this_$iv;
        boolean bl = false;
        JBIterable jBIterable = selection.asIterable().filterMap(arg_0 -> DbContextDataSourceElements.parentsForGroups$lambda$0$1(arg_0 -> DbContextDataSourceElements.parentsForGroups$lambda$0$0(sel, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filterMap(...)");
        return dbContextDataSourceElements2.replace((Iterable)jBIterable);
    }

    private final BasicNode parentForGroup(BasicNode n, DvTreeStructureService ss) {
        BasicNode basicNode = n;
        return basicNode instanceof DataSourceNode ? (BasicNode)((DataSourceNode)n).getModelRoot() : (basicNode instanceof FamilyWithId ? this.parentForGroup(ss.parentOf(n), ss) : n);
    }

    private final BasicNode asNode(T o) {
        Object object;
        T t = o;
        if (t instanceof DbDataSource) {
            DasModel $this$asSafely$iv = ((DbDataSource)o).getDelegateDataSource().getModel();
            boolean $i$f$asSafely = false;
            DasModel dasModel = $this$asSafely$iv;
            if (!(dasModel instanceof BasicModel)) {
                dasModel = null;
            }
            BasicModel basicModel = (BasicModel)dasModel;
            object = (BasicNode)(basicModel != null ? basicModel.getRoot() : null);
        } else if (t instanceof DataSourceNode) {
            DasModel $this$asSafely$iv = ((DataSourceNode)o).dataSource.getModel();
            boolean $i$f$asSafely = false;
            DasModel dasModel = $this$asSafely$iv;
            if (!(dasModel instanceof BasicModel)) {
                dasModel = null;
            }
            BasicModel basicModel = (BasicModel)dasModel;
            object = (BasicNode)(basicModel != null ? basicModel.getRoot() : null);
        } else {
            DasObject dasObject;
            object = t instanceof DbObject ? ((dasObject = ((DbObject)o).getDelegate()) instanceof BasicNode ? (BasicNode)dasObject : null) : (o instanceof BasicNode ? (BasicNode)o : null);
        }
        return object;
    }

    private final DbElement asDbElement(DbDataSource dbDs, T o) {
        T t = o;
        return t instanceof DasObject ? dbDs.findElement((DasObject)o) : (t instanceof DataSourceNode ? (DbElement)dbDs : null);
    }

    @NotNull
    public final <U> DbContextDataSourceElements<U> replace(@NotNull Function1<? super DbContextDataSourceElements<T>, ? extends Iterable<? extends U>> replacer) {
        Intrinsics.checkNotNullParameter(replacer, (String)"replacer");
        boolean $i$f$replace = false;
        return this.replace((Iterable)replacer.invoke((Object)this));
    }

    @NotNull
    public final <U> DbContextDataSourceElements<U> replace(@NotNull Iterable<? extends U> selection) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        return new DbContextDataSourceElements<U>(this.project, this.dataSource, selection);
    }

    @Nullable
    public final DbContextDataSourceElements<T> nullize() {
        DbContextDataSourceElements<T> dbContextDataSourceElements;
        DbContextDataSourceElements<T> it = dbContextDataSourceElements = this;
        boolean bl = false;
        return this.selection.iterator().hasNext() ? dbContextDataSourceElements : null;
    }

    private static final BasicNode asNodes$lambda$0(DbContextDataSourceElements this$0, Object it) {
        return this$0.asNode(it);
    }

    private static final BasicNode asNodes$lambda$1(Function1 $tmp0, Object p0) {
        return (BasicNode)$tmp0.invoke(p0);
    }

    private static final DbElement asDbElements$lambda$0(DbContextDataSourceElements this$0, DbDataSource $dbDs, Object it) {
        return this$0.asDbElement($dbDs, it);
    }

    private static final DbElement asDbElements$lambda$1(Function1 $tmp0, Object p0) {
        return (DbElement)$tmp0.invoke(p0);
    }

    private static final BasicNode dataSourcesToRoots$lambda$0$0(BasicNode it) {
        return it instanceof DataSourceNode ? (BasicNode)((DataSourceNode)it).getModelRoot() : it;
    }

    private static final BasicNode dataSourcesToRoots$lambda$0$1(Function1 $tmp0, Object p0) {
        return (BasicNode)$tmp0.invoke(p0);
    }

    private static final Iterable expandGroups$lambda$0$0(DvTreeStructureService $ss, BasicNode it) {
        Intrinsics.checkNotNull((Object)it);
        return SequencesKt.asIterable((Sequence)$ss.childrenOf(it));
    }

    private static final Iterable expandGroups$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Iterable)$tmp0.invoke(p0);
    }

    private static final boolean expandGroups$lambda$0$2(BasicNode it) {
        return it instanceof FamilyWithId;
    }

    private static final boolean expandGroups$lambda$0$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final BasicNode parentsForGroups$lambda$0$0(DbContextDataSourceElements $sel, DbContextDataSourceElements this$0, BasicNode n) {
        ComponentManager $this$service$iv = (ComponentManager)$sel.project;
        boolean $i$f$service = false;
        Class<DvTreeStructureService> serviceClass$iv = DvTreeStructureService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DvTreeStructureService ss = (DvTreeStructureService)object;
        return this$0.parentForGroup(n, ss);
    }

    private static final BasicNode parentsForGroups$lambda$0$1(Function1 $tmp0, Object p0) {
        return (BasicNode)$tmp0.invoke(p0);
    }
}

