/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diagnostic;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.RegularIntrospectionContext;
import com.intellij.database.diagnostic.DiagnosticMonitor;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0007H\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/diagnostic/DataSourceDiagnosticRecorderAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "", "setSelected", "state", "startDiagnosticLog", "ds", "Lcom/intellij/database/model/DasDataSource;", "project", "Lcom/intellij/openapi/project/Project;", "stopDiagnosticLog", "getDataSource", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceDiagnosticRecorderAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceDiagnosticRecorderAction.kt\ncom/intellij/database/diagnostic/DataSourceDiagnosticRecorderAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,63:1\n30#2,2:64\n*S KotlinDebug\n*F\n+ 1 DataSourceDiagnosticRecorderAction.kt\ncom/intellij/database/diagnostic/DataSourceDiagnosticRecorderAction\n*L\n46#1:64,2\n*E\n"})
public final class DataSourceDiagnosticRecorderAction
extends ToggleAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DasDataSource ds = this.getDataSource(e);
        if (ds == null) return false;
        String string = ds.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        if (!DiagnosticMonitor.INSTANCE.isRecordingDataSource(string)) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ds = this.getDataSource(e);
        v0 = ok = ds != null;
        if (ds == null) ** GOTO lbl-1000
        v1 = ds.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getUniqueId(...)");
        if (DiagnosticMonitor.INSTANCE.isRecordingDataSource(v1)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        running = v2;
        v3 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getPresentation(...)");
        presentation = v3;
        presentation.setEnabledAndVisible(ok);
        Toggleable.setSelected((Presentation)presentation, (boolean)running);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DasDataSource dasDataSource = this.getDataSource(e);
        if (dasDataSource == null) {
            return;
        }
        DasDataSource ds = dasDataSource;
        String string = ds.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        boolean oldState = DiagnosticMonitor.INSTANCE.isRecordingDataSource(string);
        if (oldState == state) {
            return;
        }
        if (state) {
            this.startDiagnosticLog(ds, project2);
        } else {
            this.stopDiagnosticLog(ds);
        }
    }

    private final void startDiagnosticLog(DasDataSource ds, Project project) {
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<RegularIntrospectionContext> serviceClass$iv = RegularIntrospectionContext.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        DBIntrospectionContext introspectionContext = (DBIntrospectionContext)object;
        DiagnosticMonitor.INSTANCE.startRecordingDataSource(ds, introspectionContext);
    }

    private final void stopDiagnosticLog(DasDataSource ds) {
        DiagnosticMonitor.INSTANCE.stopRecordingDataSource(ds);
    }

    private final DasDataSource getDataSource(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dc = dataContext;
        Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(dc);
        if (!CollectionFun.containsOnly((Collection)ranks, (Object)DvTreeNodeRank.TL_ROOT)) {
            return null;
        }
        Collection<LocalDataSource> selectedDSs = DatabaseViewTreeFun.getSelectedLocalDataSourcesIfOnly(dc);
        if (selectedDSs == null || selectedDSs.size() != 1) {
            return null;
        }
        return (DasDataSource)CollectionsKt.first((Iterable)selectedDSs);
    }
}

