/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.RemoteProcessInitializer;
import com.intellij.database.dataSource.ui.DesktopActionsOptionProvider;
import com.intellij.database.remote.jdbc.RemoteProcessController;
import com.intellij.database.remote.toolkit.RemoteDesktopActions;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandler;
import com.intellij.database.remote.toolkit.RemoteDesktopActionsHandlerImpl;
import com.intellij.database.run.ConsoleConfigurationParamProvider;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.net.URI;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fH\u0016J.\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/DesktopActionsConnectionInterceptor;", "Lcom/intellij/database/run/ConsoleConfigurationParamProvider;", "Lcom/intellij/database/dataSource/RemoteProcessInitializer;", "<init>", "()V", "populate", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "params", "Lcom/intellij/execution/configurations/ParametersList;", "env", "", "", "initProcess", "controller", "Lcom/intellij/database/remote/jdbc/RemoteProcessController;", "runConfiguration", "Lcom/intellij/database/run/ConsoleRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/database/remote/jdbc/RemoteProcessController;Lcom/intellij/database/dataSource/LocalDataSource;Lcom/intellij/database/run/ConsoleRunConfiguration;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.database.impl"})
public final class DesktopActionsConnectionInterceptor
extends RemoteProcessInitializer
implements ConsoleConfigurationParamProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void populate(@NotNull LocalDataSource dataSource, @NotNull ParametersList params, @NotNull Map<String, String> env) {
        block2: {
            ParamsGroup group;
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter(env, (String)"env");
            RemoteDesktopActionsHandlerImpl.State state = DesktopActionsConnectionInterceptor.Companion.getState(dataSource.getDatabaseDriver());
            if (state != RemoteDesktopActionsHandlerImpl.State.ENABLED) {
                params.addProperty(RemoteDesktopActionsHandlerImpl.getActionsProperty(), state.getId());
            }
            if (state != RemoteDesktopActionsHandlerImpl.State.ENABLED && state != RemoteDesktopActionsHandlerImpl.State.TOOLKIT) break block2;
            ParamsGroup paramsGroup = group = params.getParamsGroup("exports");
            if (paramsGroup != null) {
                paramsGroup.addParametersString("--add-exports java.desktop/sun.awt=ALL-UNNAMED --add-exports java.desktop/java.awt.peer=ALL-UNNAMED --add-opens java.desktop/java.awt=ALL-UNNAMED");
            }
        }
    }

    @Nullable
    public Object initProcess(@NotNull RemoteProcessController controller, @NotNull LocalDataSource dataSource, @NotNull ConsoleRunConfiguration runConfiguration, @NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        Companion.ensureDesktopActionsConfigured(controller, (DatabaseConnectionPoint)dataSource);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/dataSource/DesktopActionsConnectionInterceptor$Companion;", "", "<init>", "()V", "ensureDesktopActionsConfigured", "", "controller", "Lcom/intellij/database/remote/jdbc/RemoteProcessController;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "getState", "Lcom/intellij/database/remote/toolkit/RemoteDesktopActionsHandlerImpl$State;", "databaseDriver", "Lcom/intellij/database/dataSource/DatabaseDriver;", "intellij.database.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void ensureDesktopActionsConfigured(@NotNull RemoteProcessController controller, @NotNull DatabaseConnectionPoint point) {
            Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            if (this.getState(point.getDatabaseDriver()) == RemoteDesktopActionsHandlerImpl.State.DISABLED) {
                return;
            }
            RemoteDesktopActions handler2 = new RemoteDesktopActions(){

                public void open(File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    throw new UnsupportedOperationException();
                }

                public void edit(File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    throw new UnsupportedOperationException();
                }

                public void print(File file) {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    throw new UnsupportedOperationException();
                }

                public void mail(URI mailtoURL) {
                    Intrinsics.checkNotNullParameter((Object)mailtoURL, (String)"mailtoURL");
                    throw new UnsupportedOperationException();
                }

                public void browse(URI uri) {
                    Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                    BrowserUtil.browse((URI)uri);
                }
            };
            try {
                Remote remote = UnicastRemoteObject.exportObject((Remote)RemoteDesktopActionsHandlerImpl.wrap((RemoteDesktopActions)handler2), 0);
                Intrinsics.checkNotNull((Object)remote, (String)"null cannot be cast to non-null type com.intellij.database.remote.toolkit.RemoteDesktopActionsHandler");
                controller.setDesktopActionsHandler((RemoteDesktopActionsHandler)remote);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }

        private final RemoteDesktopActionsHandlerImpl.State getState(DatabaseDriver databaseDriver) {
            RemoteDesktopActionsHandlerImpl.State value = databaseDriver == null ? null : (RemoteDesktopActionsHandlerImpl.State)DbOptionProvider.getOptionValue((Object)databaseDriver, DesktopActionsOptionProvider.class);
            RemoteDesktopActionsHandlerImpl.State state = Objects.requireNonNullElse(value, RemoteDesktopActionsHandlerImpl.State.ENABLED);
            Intrinsics.checkNotNullExpressionValue((Object)state, (String)"requireNonNullElse(...)");
            return state;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

