/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.css.refs;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.Processor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.css.refs.JavaFxCssIdSelectorReference;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

final class JavaFxIdCssReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    JavaFxIdCssReferenceSearcher() {
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        block4: {
            PsiElement elementToSearch;
            if (queryParameters == null) {
                JavaFxIdCssReferenceSearcher.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                JavaFxIdCssReferenceSearcher.$$$reportNull$$$0(1);
            }
            if (!((elementToSearch = queryParameters.getElementToSearch()) instanceof PsiField)) break block4;
            PsiField field = (PsiField)elementToSearch;
            String fieldName = (String)ReadAction.compute(() -> ((PsiField)field).getName());
            String containingClassQN = (String)ReadAction.compute(() -> {
                PsiClass aClass = field.getContainingClass();
                return aClass != null ? aClass.getQualifiedName() : null;
            });
            if (containingClassQN != null) {
                PsiFile fxml;
                boolean goOn;
                Project project = PsiUtilCore.getProjectInReadAction((PsiElement)field);
                List fxmls = JavaFxControllerClassIndex.findFxmlWithController((Project)project, (String)containingClassQN);
                Iterator iterator = fxmls.iterator();
                while (iterator.hasNext() && (goOn = ((Boolean)ReadAction.compute(() -> JavaFxIdCssReferenceSearcher.lambda$processQuery$1(queryParameters, fxml = (PsiFile)iterator.next(), fieldName, consumer))).booleanValue())) {
                }
            }
        }
    }

    private static /* synthetic */ Boolean lambda$processQuery$1(ReferencesSearch.SearchParameters queryParameters, PsiFile fxml, String fieldName, Processor consumer) throws RuntimeException {
        PsiReference[] references;
        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        if (!searchScope.contains(fxml.getVirtualFile())) {
            return true;
        }
        Map fxIds = JavaFxPsiUtil.collectFileIds((PsiFile)fxml, (boolean)true);
        XmlAttributeValue fxIdValue = (XmlAttributeValue)fxIds.get(fieldName);
        if (fxIdValue == null) {
            return true;
        }
        for (PsiReference reference : references = fxIdValue.getReferences()) {
            if (!(reference instanceof JavaFxCssIdSelectorReference)) continue;
            if (consumer.process((Object)reference)) break;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/javaFX/css/refs/JavaFxIdCssReferenceSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

