/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.MethodHelper;
import org.testng.internal.RunInfo;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.Pair;

public class MethodGroupsHelper {
    private static final Map<String, Pattern> PATTERN_CACHE = new ConcurrentHashMap<String, Pattern>();
    private static final Map<Pair<String, String>, Boolean> MATCH_CACHE = new ConcurrentHashMap<Pair<String, String>, Boolean>();

    static void collectMethodsByGroup(ITestNGMethod[] methods, boolean forTests, List<ITestNGMethod> outIncludedMethods, List<ITestNGMethod> outExcludedMethods, RunInfo runInfo, IAnnotationFinder finder, boolean unique) {
        for (ITestNGMethod tm : methods) {
            boolean in = false;
            Method m = tm.getConstructorOrMethod().getMethod();
            if (forTests) {
                in = MethodGroupsHelper.includeMethod(AnnotationHelper.findTest(finder, m), runInfo, tm, forTests, unique, outIncludedMethods);
            } else {
                IConfigurationAnnotation annotation = AnnotationHelper.findConfiguration(finder, m);
                if (annotation.getAlwaysRun()) {
                    if (!unique || MethodGroupsHelper.isMethodAlreadyNotPresent(outIncludedMethods, tm)) {
                        in = true;
                    }
                } else {
                    in = MethodGroupsHelper.includeMethod(AnnotationHelper.findTest(finder, tm), runInfo, tm, forTests, unique, outIncludedMethods);
                }
            }
            if (in) {
                outIncludedMethods.add(tm);
                continue;
            }
            outExcludedMethods.add(tm);
        }
    }

    private static boolean includeMethod(ITestOrConfiguration annotation, RunInfo runInfo, ITestNGMethod tm, boolean forTests, boolean unique, List<ITestNGMethod> outIncludedMethods) {
        boolean result = false;
        if (MethodHelper.isEnabled(annotation) && runInfo.includeMethod(tm, forTests)) {
            if (unique) {
                if (MethodGroupsHelper.isMethodAlreadyNotPresent(outIncludedMethods, tm)) {
                    result = true;
                }
            } else {
                result = true;
            }
        }
        return result;
    }

    private static boolean isMethodAlreadyNotPresent(List<ITestNGMethod> result, ITestNGMethod tm) {
        Class<?> cls = tm.getConstructorOrMethod().getDeclaringClass();
        return result.parallelStream().map(ITestNGMethod::getConstructorOrMethod).filter(m -> m.getName().equals(tm.getConstructorOrMethod().getName())).map(ConstructorOrMethod::getDeclaringClass).noneMatch(eachCls -> eachCls.isAssignableFrom(cls) || cls.isAssignableFrom((Class<?>)eachCls));
    }

    public static Map<String, List<ITestNGMethod>> findGroupsMethods(Collection<ITestClass> classes, boolean before) {
        Map<String, List<ITestNGMethod>> result = Maps.newHashMap();
        for (ITestClass cls : classes) {
            ITestNGMethod[] methods;
            for (ITestNGMethod method : methods = before ? cls.getBeforeGroupsMethods() : cls.getAfterGroupsMethods()) {
                String[] grp = before ? method.getBeforeGroups() : method.getAfterGroups();
                List groups = Stream.concat(Arrays.stream(grp), Arrays.stream(method.getGroups())).collect(Collectors.toList());
                for (String group : groups) {
                    List methodList = result.computeIfAbsent(group, k -> Lists.newArrayList());
                    if (methodList.contains(method)) continue;
                    methodList.add(method);
                }
            }
        }
        return result;
    }

    protected static void findGroupTransitiveClosure(List<ITestNGMethod> includedMethods, List<ITestNGMethod> allMethods, String[] includedGroups, Set<String> outGroups, Set<ITestNGMethod> outMethods) {
        Map<ITestNGMethod, ITestNGMethod> runningMethods = includedMethods.stream().collect(Collectors.toMap(m -> m, m -> m));
        Map<String, String> runningGroups = Arrays.stream(includedGroups).collect(Collectors.toMap(g -> g, g -> g));
        boolean keepGoing = true;
        Map<ITestNGMethod, ITestNGMethod> newMethods = Maps.newHashMap();
        while (keepGoing) {
            for (ITestNGMethod m2 : includedMethods) {
                String[] mdu;
                String[] ig;
                for (String g2 : ig = m2.getGroupsDependedUpon()) {
                    ITestNGMethod[] im;
                    if (runningGroups.containsKey(g2)) continue;
                    runningGroups.put(g2, g2);
                    for (ITestNGMethod thisMethod : im = MethodGroupsHelper.findMethodsThatBelongToGroup(m2, allMethods.toArray(new ITestNGMethod[0]), g2)) {
                        if (runningMethods.containsKey(thisMethod)) continue;
                        runningMethods.put(thisMethod, thisMethod);
                        newMethods.put(thisMethod, thisMethod);
                    }
                }
                for (String tm : mdu = m2.getMethodsDependedUpon()) {
                    ITestNGMethod thisMethod = MethodGroupsHelper.findMethodNamed(tm, allMethods);
                    if (thisMethod == null || runningMethods.containsKey(thisMethod)) continue;
                    runningMethods.put(thisMethod, thisMethod);
                    newMethods.put(thisMethod, thisMethod);
                }
            }
            keepGoing = newMethods.size() > 0;
            includedMethods = Lists.newArrayList();
            includedMethods.addAll(newMethods.keySet());
            newMethods = Maps.newHashMap();
        }
        outMethods.addAll(runningMethods.keySet());
        outGroups.addAll(runningGroups.keySet());
    }

    private static ITestNGMethod findMethodNamed(String tm, List<ITestNGMethod> allMethods) {
        return allMethods.stream().filter(m -> m.getQualifiedName().equals(tm)).findFirst().orElse(null);
    }

    public static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod method, ITestNGMethod[] methods, String groupRegexp) {
        ITestNGMethod[] found = MethodGroupsHelper.findMethodsThatBelongToGroup(methods, groupRegexp);
        if (found.length == 0) {
            method.setMissingGroup(groupRegexp);
        }
        return found;
    }

    protected static ITestNGMethod[] findMethodsThatBelongToGroup(ITestNGMethod[] methods, String groupRegexp) {
        Pattern pattern = MethodGroupsHelper.getPattern(groupRegexp);
        Predicate<ITestNGMethod> matchingGroups = tm -> Arrays.stream(tm.getGroups()).anyMatch(group -> MethodGroupsHelper.isMatch(pattern, group));
        return (ITestNGMethod[])Arrays.stream(methods).filter(matchingGroups).toArray(ITestNGMethod[]::new);
    }

    private static Boolean isMatch(Pattern pattern, String group) {
        Pair<String, String> cacheKey = Pair.create(pattern.pattern(), group);
        return MATCH_CACHE.computeIfAbsent(cacheKey, k -> pattern.matcher(group).matches());
    }

    private static Pattern getPattern(String groupRegexp) {
        return PATTERN_CACHE.computeIfAbsent(groupRegexp, Pattern::compile);
    }
}

