/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.lexer;

import com.intellij.java.syntax.JavaSyntaxDefinition;
import com.intellij.java.syntax.element.JavaSyntaxTokenType;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.element.SyntaxTokenTypes;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.platform.syntax.util.lexer.LexerBase;
import com.intellij.pom.java.LanguageLevel;
import org.jetbrains.annotations.NotNull;

public class EscapedJavaLexer
extends LexerBase {
    private char mySurroundingQuote;
    private final Lexer myJavaLexer;
    private CharSequence myBuffer;
    private int myBufferEnd;
    private int myCurOffset;
    private SyntaxElementType myTokenType = null;
    private int myTokenEnd;

    public EscapedJavaLexer(char surroundingQuote, LanguageLevel languageLevel) {
        this.mySurroundingQuote = surroundingQuote;
        this.myJavaLexer = JavaSyntaxDefinition.createLexer((LanguageLevel)languageLevel);
    }

    public char getSurroundingQuote() {
        return this.mySurroundingQuote;
    }

    public void setSurroundingQuote(char surroundingQuote) {
        this.mySurroundingQuote = surroundingQuote;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int state) {
        if (buffer == null) {
            EscapedJavaLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myCurOffset = startOffset;
        this.myTokenEnd = startOffset;
        this.myBufferEnd = endOffset;
        this.myTokenType = null;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            EscapedJavaLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getState() {
        return 0;
    }

    public SyntaxElementType getTokenType() {
        this.locateToken();
        return this.myTokenType;
    }

    public final int getTokenStart() {
        this.locateToken();
        return this.myCurOffset;
    }

    public final int getTokenEnd() {
        this.locateToken();
        return this.myTokenEnd;
    }

    public final void advance() {
        this.locateToken();
        this.myTokenType = null;
        this.myCurOffset = this.myTokenEnd;
    }

    public final int getBufferEnd() {
        return this.myBufferEnd;
    }

    private void locateToken() {
        int offset;
        if (this.myTokenType != null) {
            return;
        }
        if (this.myCurOffset >= this.myBufferEnd) {
            return;
        }
        boolean esc = false;
        int state = 0;
        char literalStarter = '\u0000';
        for (offset = this.myCurOffset; offset < this.myBufferEnd; ++offset) {
            char c = this.myBuffer.charAt(offset);
            boolean wasEsc = esc;
            esc = false;
            if (c == '\\') {
                if (!wasEsc) {
                    esc = true;
                } else {
                    state = 2;
                }
            } else if (state == 0) {
                if (c == '\'' || c == '\"') {
                    literalStarter = c;
                    state = 1;
                }
            } else if (state == 1) {
                if (c == literalStarter) {
                    state = 0;
                    ++offset;
                    break;
                }
            } else {
                assert (state == 2);
                state = 1;
            }
            if (!esc && state == 0) break;
        }
        if (offset >= this.myBufferEnd - 1) {
            state = 0;
        }
        switch (state) {
            case 0: {
                if (offset == this.myCurOffset) {
                    this.myJavaLexer.start(this.myBuffer, this.myCurOffset, this.myBufferEnd);
                    this.myTokenType = this.myJavaLexer.getTokenType();
                    this.myTokenEnd = this.myJavaLexer.getTokenEnd();
                    break;
                }
                this.myTokenType = literalStarter == '\"' ? JavaSyntaxTokenType.STRING_LITERAL : JavaSyntaxTokenType.CHARACTER_LITERAL;
                this.myTokenEnd = offset;
                break;
            }
            case 1: {
                this.myTokenType = literalStarter == '\"' ? JavaSyntaxTokenType.STRING_LITERAL : JavaSyntaxTokenType.CHARACTER_LITERAL;
                this.myTokenEnd = offset;
                break;
            }
            default: {
                this.myTokenType = SyntaxTokenTypes.getBAD_CHARACTER();
                this.myTokenEnd = offset;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/lexer/EscapedJavaLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/lexer/EscapedJavaLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

