/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.impl.local.files;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.progress.CancellationUtil;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.completion.full.line.LocalModelDescriptor;
import org.jetbrains.completion.full.line.impl.UtilsKt;
import org.jetbrains.completion.full.line.impl.local.files.LocalModelsBundleManager;
import org.jetbrains.completion.full.line.impl.local.files.LocalModelsCorruptedManager;
import org.jetbrains.completion.full.line.impl.local.files.LocalModelsDownloadConsentManager;
import org.jetbrains.completion.full.line.impl.local.files.LocalModelsDownloadManager;
import org.jetbrains.completion.full.line.impl.local.files.LocalModelsFilesService;
import org.jetbrains.completion.full.line.impl.local.files.LocalModelsSchemaManager;
import org.jetbrains.completion.full.line.impl.local.files.LocalModelsShipmentState;
import org.jetbrains.completion.full.line.impl.settings.FullLineBundle;
import org.jetbrains.completion.full.line.local.ModelDownloadNetworkException;
import org.jetbrains.completion.full.line.local.ModelSchema;
import org.jetbrains.completion.full.line.services.FullLineServiceScope;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\b\u0001\u0018\u0000 %2\u00020\u0001:\u0001%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0011J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0011H\u0003J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0$H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R3\u0010\u000f\u001a'\u0012\u000e\u0012\f0\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013\u0012\u000e\u0012\f0\u0014\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u00130\u0010\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/completion/full/line/impl/local/files/LocalModelsFilesService;", "", "<init>", "()V", "root", "Ljava/io/File;", "getRoot", "()Ljava/io/File;", "schemaFile", "schemaManager", "Lorg/jetbrains/completion/full/line/impl/local/files/LocalModelsSchemaManager;", "downloadManager", "Lorg/jetbrains/completion/full/line/impl/local/files/LocalModelsDownloadManager;", "corruptedManager", "Lorg/jetbrains/completion/full/line/impl/local/files/LocalModelsCorruptedManager;", "refreshingDescriptors", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/completion/full/line/LocalModelDescriptor;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "tryGetNow", "Lorg/jetbrains/completion/full/line/local/ModelSchema;", "descriptor", "refreshAsyncFor", "isRefreshing", "", "scheduleRefreshFor", "refreshLock", "Ljava/util/concurrent/locks/ReentrantLock;", "refreshFor", "cleanUp", "getBrokenModels", "", "", "getLostModels", "", "Companion", "intellij.fullLine.core.impl"})
@SourceDebugExtension(value={"SMAP\nLocalModelsFilesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalModelsFilesService.kt\norg/jetbrains/completion/full/line/impl/local/files/LocalModelsFilesService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,141:1\n1#2:142\n1563#3:143\n1634#3,3:144\n1869#3,2:147\n827#3:149\n855#3,2:150\n1563#3:152\n1634#3,3:153\n1563#3:160\n1634#3,3:161\n11561#4:156\n11896#4,3:157\n*S KotlinDebug\n*F\n+ 1 LocalModelsFilesService.kt\norg/jetbrains/completion/full/line/impl/local/files/LocalModelsFilesService\n*L\n119#1:143\n119#1:144,3\n120#1:147,2\n129#1:149\n129#1:150,2\n129#1:152\n129#1:153,3\n134#1:160\n134#1:161,3\n133#1:156\n133#1:157,3\n*E\n"})
public final class LocalModelsFilesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File root;
    @NotNull
    private final File schemaFile;
    @NotNull
    private final LocalModelsSchemaManager schemaManager;
    @NotNull
    private final LocalModelsDownloadManager downloadManager;
    @NotNull
    private final LocalModelsCorruptedManager corruptedManager;
    @NotNull
    private final ConcurrentMap<LocalModelDescriptor, Unit> refreshingDescriptors;
    @NotNull
    private final ReentrantLock refreshLock;

    /*
     * WARNING - void declaration
     */
    public LocalModelsFilesService() {
        void it;
        Application application = ApplicationManager.getApplication();
        File file = Intrinsics.areEqual((Object)(application != null ? Boolean.valueOf(application.isUnitTestMode()) : null), (Object)false) ? new File(PathManager.getSystemPath()) : Files.createTempDirectory("full-line-temp", new FileAttribute[0]).toFile();
        Intrinsics.checkNotNull((Object)file);
        File file2 = file = FilesKt.resolve((File)file, (String)"full-line/models");
        LocalModelsFilesService localModelsFilesService = this;
        boolean bl = false;
        Files.createDirectories(it.toPath(), new FileAttribute[0]);
        localModelsFilesService.root = file;
        this.schemaFile = FilesKt.resolve((File)this.root, (String)"models.xml");
        this.schemaManager = new LocalModelsSchemaManager(this.schemaFile);
        this.downloadManager = new LocalModelsDownloadManager(this.root);
        this.corruptedManager = new LocalModelsCorruptedManager(this.root);
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakMap(...)");
        this.refreshingDescriptors = concurrentMap;
        this.refreshLock = new ReentrantLock(true);
    }

    @NotNull
    public final File getRoot() {
        return this.root;
    }

    @Nullable
    public final ModelSchema tryGetNow(@NotNull LocalModelDescriptor descriptor) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ModelSchema modelSchema = this.schemaManager.getModel(descriptor);
        if (modelSchema != null) {
            ModelSchema modelSchema2;
            ModelSchema it = modelSchema2 = modelSchema;
            boolean bl = false;
            object = this.corruptedManager.hasReadyFlag(it) ? modelSchema2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public final void refreshAsyncFor(@NotNull LocalModelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.tryGetNow(descriptor) != null || ((Map)this.refreshingDescriptors).containsKey(descriptor)) {
            return;
        }
        if (LocalModelsBundleManager.Companion.getInstance().isBundled(descriptor)) {
            this.scheduleRefreshFor(descriptor);
            return;
        }
        LocalModelsDownloadConsentManager.Companion.getInstance().withRequestingConsent(descriptor.getLanguage(), (Function0<Unit>)((Function0)() -> LocalModelsFilesService.refreshAsyncFor$lambda$0(this, descriptor)));
    }

    public final boolean isRefreshing(@NotNull LocalModelDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.refreshingDescriptors.containsKey(descriptor);
    }

    private final void scheduleRefreshFor(LocalModelDescriptor descriptor) {
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null || (projectManager = UtilsKt.currentOpenProject(projectManager)) == null) {
            return;
        }
        ProjectManager project2 = projectManager;
        if (this.refreshingDescriptors.putIfAbsent(descriptor, Unit.INSTANCE) != null) {
            return;
        }
        LocalModelsShipmentState.Companion.downloadingStarted(descriptor.getLanguage());
        BuildersKt.launch$default((CoroutineScope)FullLineServiceScope.fullLinePluginScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Project)project2, this, descriptor, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ LocalModelsFilesService this$0;
            final /* synthetic */ LocalModelDescriptor $descriptor;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$descriptor = $descriptor;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)FullLineBundle.message("full.line.progress.downloading.models.title", new Object[0]), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$descriptor, null){
                            int label;
                            final /* synthetic */ LocalModelsFilesService this$0;
                            final /* synthetic */ LocalModelDescriptor $descriptor;
                            {
                                this.this$0 = $receiver;
                                this.$descriptor = $descriptor;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Loose catch block
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        Object object2 = CoroutinesKt.coroutineToIndicator(arg_0 -> scheduleRefreshFor.1.invokeSuspend$lambda$0(this.this$0, this.$descriptor, arg_0), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        Object object2;
                                        try {
                                            ResultKt.throwOnFailure((Object)$result);
                                            object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                        catch (ModelDownloadNetworkException modelDownloadNetworkException) {
                                            return Unit.INSTANCE;
                                        }
                                        catch (ProcessCanceledException processCanceledException) {
                                            return Unit.INSTANCE;
                                            {
                                                catch (Throwable throwable) {
                                                    throw throwable;
                                                }
                                            }
                                        }
                                        finally {
                                            LocalModelsFilesService.access$getRefreshingDescriptors$p(this.this$0).remove(this.$descriptor);
                                        }
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Unit invokeSuspend$lambda$0(LocalModelsFilesService this$0, LocalModelDescriptor $descriptor, ProgressIndicator it) {
                                LocalModelsFilesService.access$refreshFor(this$0, $descriptor);
                                return Unit.INSTANCE;
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @RequiresBackgroundThread
    private final void refreshFor(LocalModelDescriptor descriptor) {
        CancellationUtil.withLockCancellable((Lock)this.refreshLock, () -> LocalModelsFilesService.refreshFor$lambda$0(this, descriptor));
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanUp() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.schemaManager.getUselessModels();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ModelSchema modelSchema = (ModelSchema)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.uid());
        }
        List toDelete = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.getBrokenModels()), (Iterable)this.getLostModels());
        Iterable $this$forEach$iv = toDelete;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.schemaManager.removeModel(it);
            this.corruptedManager.deleteReadyFlag(it);
            FilesKt.deleteRecursively((File)FilesKt.resolve((File)this.root, (String)it));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getBrokenModels() {
        void $this$mapTo$iv$iv;
        ModelSchema it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = this.schemaManager.getAllModels();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (ModelSchema)element$iv$iv;
            boolean bl = false;
            if (this.corruptedManager.hasReadyFlag(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ModelSchema)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.uid());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getLostModels() {
        void $this$mapTo$iv$iv;
        ModelSchema it;
        Collection collection;
        void $this$mapTo$iv$iv2;
        File[] fileArray = this.root.listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        File[] $this$map$iv = fileArray;
        boolean $i$f$map = false;
        File[] fileArray2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void var10_13 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        Set allFiles = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv2 = this.schemaManager.getAllModels();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ModelSchema)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.uid());
        }
        Set allKnownModels = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return SetsKt.minus((Set)SetsKt.minus((Set)allFiles, (Iterable)allKnownModels), (Object)this.schemaFile.getName());
    }

    private static final Unit refreshAsyncFor$lambda$0(LocalModelsFilesService this$0, LocalModelDescriptor $descriptor) {
        this$0.scheduleRefreshFor($descriptor);
        return Unit.INSTANCE;
    }

    private static final Unit refreshFor$lambda$0(LocalModelsFilesService this$0, LocalModelDescriptor $descriptor) {
        if (this$0.tryGetNow($descriptor) != null) {
            return Unit.INSTANCE;
        }
        this$0.cleanUp();
        ModelSchema modelSchema = LocalModelsBundleManager.Companion.getInstance().unpackBundled($descriptor);
        if (modelSchema == null) {
            modelSchema = this$0.downloadManager.download($descriptor);
        }
        ModelSchema schema = modelSchema;
        this$0.corruptedManager.writeReadyFlag(schema);
        this$0.schemaManager.addModel(schema);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ConcurrentMap access$getRefreshingDescriptors$p(LocalModelsFilesService $this) {
        return $this.refreshingDescriptors;
    }

    public static final /* synthetic */ void access$refreshFor(LocalModelsFilesService $this, LocalModelDescriptor descriptor) {
        $this.refreshFor(descriptor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/completion/full/line/impl/local/files/LocalModelsFilesService$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/completion/full/line/impl/local/files/LocalModelsFilesService;", "intellij.fullLine.core.impl"})
    @SourceDebugExtension(value={"SMAP\nLocalModelsFilesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalModelsFilesService.kt\norg/jetbrains/completion/full/line/impl/local/files/LocalModelsFilesService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,141:1\n42#2,3:142\n*S KotlinDebug\n*F\n+ 1 LocalModelsFilesService.kt\norg/jetbrains/completion/full/line/impl/local/files/LocalModelsFilesService$Companion\n*L\n139#1:142,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalModelsFilesService getInstance() {
            boolean $i$f$service = false;
            Class<LocalModelsFilesService> serviceClass$iv = LocalModelsFilesService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LocalModelsFilesService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

