/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.postprocessing.transformer;

import com.intellij.ml.inline.completion.impl.MLCompletionProposal;
import com.intellij.ml.inline.completion.impl.RawMLCompletionProposal;
import com.intellij.ml.inline.completion.impl.postprocessing.transformer.DiagnosableProposalTransformer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\r\u001a\u00020\u000e*\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\b\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/TrimEmptyLinesAtStartTransformer;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/transformer/DiagnosableProposalTransformer;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "<init>", "(Lcom/intellij/openapi/editor/Document;I)V", "isCurrentLineEmpty", "", "()Z", "isCurrentLineEmpty$delegate", "Lkotlin/Lazy;", "removeBlankLinesIfNeeded", "", "transformRaw", "Lcom/intellij/ml/inline/completion/impl/RawMLCompletionProposal;", "proposal", "getOrder", "intellij.fullLine.core.completion"})
public final class TrimEmptyLinesAtStartTransformer
extends DiagnosableProposalTransformer {
    @NotNull
    private final Document document;
    private final int offset;
    @NotNull
    private final Lazy isCurrentLineEmpty$delegate;

    public TrimEmptyLinesAtStartTransformer(@NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        super("Trim empty lines at the start");
        this.document = document;
        this.offset = offset;
        this.isCurrentLineEmpty$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
            final /* synthetic */ TrimEmptyLinesAtStartTransformer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Boolean invoke() {
                int line = TrimEmptyLinesAtStartTransformer.access$getDocument$p(this.this$0).getLineNumber(TrimEmptyLinesAtStartTransformer.access$getOffset$p(this.this$0));
                TextRange textRange = DocumentUtil.getLineTextRange((Document)TrimEmptyLinesAtStartTransformer.access$getDocument$p(this.this$0), (int)line);
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getLineTextRange(...)");
                TextRange lineRange = textRange;
                String string = TrimEmptyLinesAtStartTransformer.access$getDocument$p(this.this$0).getText(lineRange);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                return StringsKt.isBlank((CharSequence)string);
            }
        }));
    }

    private final boolean isCurrentLineEmpty() {
        Lazy lazy = this.isCurrentLineEmpty$delegate;
        return (Boolean)lazy.getValue();
    }

    private final String removeBlankLinesIfNeeded(String $this$removeBlankLinesIfNeeded) {
        if (!this.isCurrentLineEmpty()) {
            return $this$removeBlankLinesIfNeeded;
        }
        List suggestionLines = CollectionsKt.toMutableList((Collection)StringsKt.lines((CharSequence)$this$removeBlankLinesIfNeeded));
        while (true) {
            String string = (String)CollectionsKt.firstOrNull((List)suggestionLines);
            boolean bl = string != null ? StringsKt.isBlank((CharSequence)string) : false;
            if (!bl) break;
            suggestionLines.removeFirst();
        }
        return CollectionsKt.joinToString$default((Iterable)suggestionLines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public RawMLCompletionProposal transformRaw(@NotNull RawMLCompletionProposal proposal2) {
        Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
        return (RawMLCompletionProposal)this.diagnoseMapping((MLCompletionProposal)proposal2, (Function0)new Function0<RawMLCompletionProposal>(proposal2, this){
            final /* synthetic */ RawMLCompletionProposal $proposal;
            final /* synthetic */ TrimEmptyLinesAtStartTransformer this$0;
            {
                this.$proposal = $proposal;
                this.this$0 = $receiver;
                super(0);
            }

            public final RawMLCompletionProposal invoke() {
                return this.$proposal.withSuggestion(TrimEmptyLinesAtStartTransformer.access$removeBlankLinesIfNeeded(this.this$0, this.$proposal.getSuggestion()));
            }
        });
    }

    @Override
    public int getOrder() {
        return 700;
    }

    public static final /* synthetic */ String access$removeBlankLinesIfNeeded(TrimEmptyLinesAtStartTransformer $this, String $receiver) {
        return $this.removeBlankLinesIfNeeded($receiver);
    }

    public static final /* synthetic */ Document access$getDocument$p(TrimEmptyLinesAtStartTransformer $this) {
        return $this.document;
    }

    public static final /* synthetic */ int access$getOffset$p(TrimEmptyLinesAtStartTransformer $this) {
        return $this.offset;
    }
}

