/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.ConfigUrlBean;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DatabaseDriverListener;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.url.template.UrlTemplate;
import com.intellij.database.util.DatabaseDriverManagerUtil;
import com.intellij.database.util.RunnableWithDebounce;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

@State(name="LocalDatabaseDriverManager", storages={@Storage(value="databaseDrivers.xml")}, category=SettingsCategory.TOOLS)
public final class DatabaseDriverManagerImpl
extends DatabaseDriverManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(DatabaseDriverManagerImpl.class);
    private static final String VERSION_PRE_141 = null;
    private static final String VERSION_141 = "141+";
    private static final String VERSION_LATEST = "201";
    private final ReadWriteLock updatingDriversLock;
    private final Map<String, DatabaseDriverImpl> myDrivers;
    private Map<String, DatabaseDriverImpl> myPredefinedDrivers;
    private final EventDispatcher<DatabaseDriverListener> myDispatcher;
    private static final Map<String, String> MIGRATION_MAP = Map.ofEntries(Map.entry("sqlite.zentus", "sqlite.xerial"), Map.entry("h2.embedded", "h2.unified"), Map.entry("h2.in-memory", "h2.unified"), Map.entry("h2.remote", "h2.unified"), Map.entry("hsqldb.embedded", "hsqldb.local"), Map.entry("hsqldb.in-memory", "hsqldb.local"));
    public static final ExtensionPointName<ConfigUrlBean> CONFIG_EP = ExtensionPointName.create((String)"com.intellij.database.driversConfig");

    @TestOnly
    public void dump(@NotNull StringBuilder sb) {
        if (sb == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(0);
        }
        ArrayList<DatabaseDriverImpl> drivers = new ArrayList<DatabaseDriverImpl>(this.getDrivers());
        drivers.sort((o1, o2) -> Comparing.compare((Comparable)((Object)o1.getId()), (Comparable)((Object)o2.getId())));
        for (DatabaseDriverImpl driver : drivers) {
            driver.dump(sb);
            sb.append("\n----\n");
        }
    }

    @TestOnly
    public static DatabaseDriverManagerImpl create(@Nullable CoroutineScope cs, @NotNull String file) throws MalformedURLException {
        if (file == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(1);
        }
        return new DatabaseDriverManagerImpl(cs, Collections.singletonList(Pair.create(null, (Object)new File(file).toURI().toURL())));
    }

    @TestOnly
    public static DatabaseDriverManagerImpl create(@Nullable CoroutineScope cs, @NotNull List<ConfigUrlBean> beans) {
        if (beans == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(2);
        }
        return new DatabaseDriverManagerImpl(cs, (Iterable<Pair<PluginDescriptor, URL>>)JBIterable.from(beans).flatten(DatabaseDriverManagerImpl::extractUrls));
    }

    public DatabaseDriverManagerImpl(@NotNull CoroutineScope cs) {
        if (cs == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(3);
        }
        this(cs, (Iterable<Pair<PluginDescriptor, URL>>)JBIterable.from((Iterable)CONFIG_EP.getExtensionList()).flatten(DatabaseDriverManagerImpl::extractUrls));
        this.loadTestDrivers();
    }

    private void loadTestDrivers() {
        File testDrivers = DatabaseDriverManagerUtil.existentTestPath((String)"test-database-drivers.xml");
        if (testDrivers == null) {
            return;
        }
        try {
            Element drivers = JDOMUtil.load((File)testDrivers);
            ArrayList<Element> toRemove = new ArrayList<Element>();
            for (Element element : DatabaseDriverManagerImpl.getDrivers(drivers)) {
                String id = DatabaseDriverManagerImpl.getDriverId(element);
                String baseId = DatabaseDriverImpl.getDriverBaseId(element);
                if (baseId != null) {
                    baseId = StringUtil.trimEnd((String)baseId, (String)".4");
                    baseId = StringUtil.trimEnd((String)baseId, (String)".8");
                    baseId = StringUtil.trimEnd((String)baseId, (String)".19");
                    baseId = StringUtil.trimEnd((String)baseId, (String)".unified");
                    baseId = StringUtil.trimEnd((String)baseId, (String)"_test");
                }
                if (baseId != null && id != null && id.startsWith(baseId)) {
                    toRemove.add(element);
                    continue;
                }
                Element remarks = element.getChild("remarks");
                if (remarks == null) {
                    remarks = new Element("remarks");
                    element.addContent(remarks);
                }
                remarks.setText(testDrivers.getName());
            }
            for (Element element : toRemove) {
                element.getParentElement().removeContent((Content)element);
            }
            this.loadLatest(drivers, true, true, VERSION_LATEST, null);
            for (Map.Entry entry : this.myDrivers.entrySet()) {
                if (!((DatabaseDriverImpl)((Object)entry.getValue())).isPredefined() || this.myPredefinedDrivers.containsKey(entry.getKey())) continue;
                this.backupPredefined((DatabaseDriverImpl)((Object)entry.getValue()));
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    private static JBIterable<Pair<PluginDescriptor, URL>> extractUrls(ConfigUrlBean bean) {
        JBIterable jBIterable = JBIterable.once((Iterator)ContainerUtil.iterate((Enumeration)ConfigUrlBean.enumerateUrls((ConfigUrlBean)bean))).map(url -> new Pair((Object)bean.pluginDescriptor, url));
        if (jBIterable == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NonInjectable
    private DatabaseDriverManagerImpl(@Nullable CoroutineScope cs, @NotNull Iterable<Pair<PluginDescriptor, URL>> urls) {
        if (urls == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(5);
        }
        this.updatingDriversLock = new ReentrantReadWriteLock();
        this.myDrivers = new LinkedHashMap<String, DatabaseDriverImpl>();
        this.myPredefinedDrivers = new LinkedHashMap<String, DatabaseDriverImpl>();
        this.myDispatcher = EventDispatcher.create(DatabaseDriverListener.class);
        for (Pair<PluginDescriptor, URL> url : urls) {
            try {
                this.loadLatest(JDOMUtil.load((URL)((URL)url.getSecond())), true, true, VERSION_LATEST, (PluginDescriptor)url.getFirst());
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        this.backupPredefined();
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            application.getMessageBus().connect().subscribe(DatabaseArtifactManager.TOPIC, v -> {
                ArrayList<DatabaseDriverImpl> values = new ArrayList<DatabaseDriverImpl>(this.myDrivers.values());
                for (DatabaseDriverImpl driver : values) {
                    boolean affected;
                    if (driver.getArtifacts().isEmpty() || !(affected = v == null || ContainerUtil.exists(driver.getArtifacts(), a -> DatabaseDriverImpl.matches(a, v)))) continue;
                    ((DatabaseDriverListener)this.myDispatcher.getMulticaster()).driverUpdated((DatabaseDriver)driver);
                }
            });
        }
        if (cs != null) {
            CONFIG_EP.addChangeListener(cs, (Runnable)new RunnableWithDebounce(cs, () -> this.updateDrivers()));
        }
    }

    private void updateDrivers() {
        this.updateDriversImpl(this.getModifiedOrCreatedDrivers(), DatabaseDriverManagerImpl.getUsedDrivers(), DatabaseDriverManagerImpl.getDriversByIdFromConfigs((Iterable<Pair<PluginDescriptor, URL>>)JBIterable.from((Iterable)CONFIG_EP.getExtensionList()).flatten(DatabaseDriverManagerImpl::extractUrls)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDriversImpl(Map<String, Element> modifiedOrCreatedDrivers, Set<String> usedDrivers, Map<String, Pair<Element, PluginDescriptor>> driversFromEPs) {
        HashMap<String, DatabaseDriverImpl> removedDrivers = new HashMap<String, DatabaseDriverImpl>();
        HashMap<String, DatabaseDriverImpl> addedDrivers = new HashMap<String, DatabaseDriverImpl>();
        HashMap<String, DatabaseDriverImpl> modifiedDrivers = new HashMap<String, DatabaseDriverImpl>();
        this.updatingDriversLock.writeLock().lock();
        try {
            for (Map.Entry<String, DatabaseDriverImpl> entry : this.myDrivers.entrySet()) {
                String driverId = entry.getKey();
                if (!modifiedOrCreatedDrivers.containsKey(driverId) && !usedDrivers.contains(driverId) && !driversFromEPs.containsKey(driverId) && this.noneUseIdAsCite(driverId, modifiedOrCreatedDrivers.keySet(), usedDrivers)) {
                    removedDrivers.put(driverId, entry.getValue());
                    continue;
                }
                if (driversFromEPs.containsKey(driverId)) continue;
                entry.getValue().setPredefined(false);
            }
            for (Iterator<Map.Entry<String, Pair<Element, PluginDescriptor>>> removedDriverId : removedDrivers.keySet()) {
                this.myDrivers.remove(removedDriverId);
            }
            int version = DatabaseDriverManagerImpl.parseVersion(VERSION_LATEST);
            for (Map.Entry<String, Pair<Element, PluginDescriptor>> driversFromEP : driversFromEPs.entrySet()) {
                String driverIdFromEP = (String)driversFromEP.getKey();
                Element driverStateFromEP = (Element)((Pair)driversFromEP.getValue()).getFirst();
                PluginDescriptor pluginDescriptor = (PluginDescriptor)((Pair)driversFromEP.getValue()).getSecond();
                DatabaseDriverImpl driver = this.myDrivers.get(driverIdFromEP);
                if (driver == null) {
                    driver = this.createDriver(driverIdFromEP, DatabaseDriverImpl.getDriverBaseId(driverStateFromEP), true);
                    this.myDrivers.put(driverIdFromEP, driver);
                    addedDrivers.put(driverIdFromEP, driver);
                } else {
                    modifiedDrivers.put(driverIdFromEP, driver);
                }
                driver.loadState(driverStateFromEP, false, true, version, pluginDescriptor);
            }
            this.myPredefinedDrivers = new LinkedHashMap<String, DatabaseDriverImpl>();
            this.backupPredefined();
            this.loadTestDrivers();
            for (Map.Entry<String, Pair<Element, PluginDescriptor>> driversFromEP : driversFromEPs.entrySet()) {
                String driverId = driversFromEP.getKey();
                if (!modifiedOrCreatedDrivers.containsKey(driverId)) continue;
                this.myDrivers.get(driverId).loadState(modifiedOrCreatedDrivers.get(driverId), true, true, version);
            }
        }
        finally {
            this.updatingDriversLock.writeLock().unlock();
            for (DatabaseDriverImpl removedDriver : removedDrivers.values()) {
                ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverRemoved((DatabaseDriver)removedDriver);
            }
            for (DatabaseDriverImpl addedDriver : addedDrivers.values()) {
                ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverAdded((DatabaseDriver)addedDriver);
            }
            for (DatabaseDriverImpl modifiedDriver : modifiedDrivers.values()) {
                ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverUpdated((DatabaseDriver)modifiedDriver);
            }
        }
    }

    private boolean noneUseIdAsCite(String driverId, Set<String> modifiedOrCreatedDrivers, Set<String> usedDrivers) {
        if (!this.noneUseIdAsCite(driverId, modifiedOrCreatedDrivers)) {
            return false;
        }
        return this.noneUseIdAsCite(driverId, usedDrivers);
    }

    private boolean noneUseIdAsCite(String driverId, Set<String> driversId) {
        for (String id : driversId) {
            DatabaseDriverImpl driver = this.myDrivers.get(id);
            String driverBaseId = driver.getBaseId();
            while (driverBaseId != null) {
                if (driverBaseId.equals(driverId)) {
                    return false;
                }
                driverBaseId = this.myDrivers.get(driverBaseId).getBaseId();
            }
            String groupWithId = driver.getGroupWithId();
            while (groupWithId != null) {
                if (groupWithId.equals(driverId)) {
                    return false;
                }
                groupWithId = this.myDrivers.get(groupWithId).getGroupWithId();
            }
        }
        return true;
    }

    private static Map<String, Pair<Element, PluginDescriptor>> getDriversByIdFromConfigs(Iterable<Pair<PluginDescriptor, URL>> urls) {
        LinkedHashMap<String, Pair<Element, PluginDescriptor>> driversById = new LinkedHashMap<String, Pair<Element, PluginDescriptor>>();
        for (Pair<PluginDescriptor, URL> url : urls) {
            try {
                Element driversState = JDOMUtil.load((URL)((URL)url.getSecond()));
                for (Element driverState : DatabaseDriverManagerImpl.getDrivers(driversState)) {
                    String id = DatabaseDriverManagerImpl.getDriverId(driverState);
                    if (id == null) continue;
                    driversById.put(id, (Pair<Element, PluginDescriptor>)Pair.create((Object)driverState, (Object)((PluginDescriptor)url.getFirst())));
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
        return driversById;
    }

    private void backupPredefined() {
        for (DatabaseDriverImpl driver : this.myDrivers.values()) {
            this.backupPredefined(driver);
        }
    }

    private void backupPredefined(DatabaseDriverImpl driver) {
        if (!driver.isPredefined()) {
            return;
        }
        DatabaseDriverImpl backup = new DatabaseDriverImpl(driver.getId(), true);
        backup.loadState(driver.getState(null), false, true, Integer.MAX_VALUE);
        this.myPredefinedDrivers.put(backup.getId(), backup);
    }

    private void addDriver(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(6);
        }
        this.myDrivers.put(driver.getId(), driver);
        ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverAdded((DatabaseDriver)driver);
    }

    private void removeDriver(@NotNull String id) {
        DatabaseDriverImpl driver;
        if (id == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(7);
        }
        if ((driver = this.myDrivers.remove(id)) != null) {
            ((DatabaseDriverListener)this.getDispatcher().getMulticaster()).driverRemoved((DatabaseDriver)driver);
        }
    }

    @NotNull
    private static List<Element> getDrivers(@NotNull Element state) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(8);
        }
        List list = state.getChildren("driver");
        if (list == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @Nullable
    private static String getDriverId(@NotNull Element state) {
        String id;
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(10);
        }
        return StringUtil.isEmpty((String)(id = state.getAttributeValue("id"))) || id.equals("odbc.sun") ? null : id;
    }

    private DatabaseDriverImpl createDriver(@NotNull String id, @Nullable String baseId, boolean predefined) {
        if (id == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(11);
        }
        DatabaseDriverImpl driver = new DatabaseDriverImpl(id, predefined);
        this.loadBaseState(baseId, driver);
        return driver;
    }

    @Nullable
    private DatabaseDriverImpl getOrCreateDriver(@NotNull String id, @Nullable String baseId, boolean predefined, boolean create2) {
        DatabaseDriverImpl driver;
        if (id == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(12);
        }
        if ((driver = this.myDrivers.get(id)) == null && create2) {
            driver = this.createDriver(id, baseId, predefined);
            this.addDriver(driver);
        }
        return driver;
    }

    public void loadBaseState(@Nullable String baseId, DatabaseDriverImpl driver) {
        if (baseId != null) {
            DatabaseDriverImpl orig = this.myDrivers.get(baseId);
            if (orig != null) {
                driver.loadState(orig.getState(null), false, true, Integer.MAX_VALUE);
                driver.setAbstract(false);
            } else {
                DatabaseDriverManagerImpl.baseNotFound(baseId);
            }
        }
    }

    private static void baseNotFound(@Nullable String baseId) {
        String message = "Base driver not found: " + baseId;
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            LOG.error(message);
        } else {
            LOG.warn(message);
        }
    }

    private void loadLatest(@NotNull Element state, boolean merge, boolean predefined, String version, @Nullable PluginDescriptor descriptor) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(13);
        }
        int ver = DatabaseDriverManagerImpl.parseVersion(version);
        for (Element driverState : DatabaseDriverManagerImpl.getDrivers(state)) {
            String id = DatabaseDriverManagerImpl.getDriverId(driverState);
            String baseId = DatabaseDriverImpl.getDriverBaseId(driverState);
            DatabaseDriverImpl driver = id == null ? null : this.getOrCreateDriver(id, baseId, predefined, true);
            if (driver == null) continue;
            driver.loadState(driverState, merge, true, ver, descriptor);
        }
    }

    private static int parseVersion(String version) {
        Matcher matcher = Pattern.compile("\\d+").matcher(version);
        try {
            if (matcher.find()) {
                return Integer.parseInt(version);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 0;
    }

    private void loadPre141(@NotNull Element state, boolean merge, boolean predefined) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(14);
        }
        this.loadPre141Impl(state, merge, new ArrayList<Element>(), predefined);
    }

    private void loadPre141Impl(@NotNull Element state, boolean merge, @NotNull List<Element> parents, boolean predefined) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(15);
        }
        if (parents == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(16);
        }
        for (Element driverState : DatabaseDriverManagerImpl.getDrivers(state)) {
            String id = DatabaseDriverManagerImpl.getDriverId(driverState);
            DatabaseDriverImpl driver = null;
            if (id != null) {
                boolean instantiable = driverState.getChild("driver") == null && !MIGRATION_MAP.containsKey(id);
                driver = this.getOrCreateDriver(id, null, predefined, instantiable);
            }
            parents.add(driverState);
            if (driver != null) {
                boolean submerge = merge;
                for (Element parent : parents) {
                    driver.loadState(parent, submerge, false, 0);
                    submerge = true;
                }
            }
            this.loadPre141Impl(driverState, merge, parents, predefined);
            parents.remove(parents.size() - 1);
        }
    }

    EventDispatcher<DatabaseDriverListener> getDispatcher() {
        return this.myDispatcher;
    }

    private static List<Project> getOpenProjects() {
        return ContainerUtil.filter((Object[])ProjectManager.getInstance().getOpenProjects(), p2 -> !p2.isDisposed() && p2.isInitialized() && p2.isOpen());
    }

    private static Set<String> getUsedDrivers() {
        HashSet<String> driversId = new HashSet<String>();
        List<Project> projects = DatabaseDriverManagerImpl.getOpenProjects();
        if (projects.isEmpty()) {
            projects = new ArrayList<Project>();
            projects.add(null);
        }
        for (Project project : projects) {
            List createdDataSources = DataSourceStorage.getStorage((Project)project).getDataSources();
            for (LocalDataSource dataSource : createdDataSources) {
                DatabaseDriverImpl driver = (DatabaseDriverImpl)dataSource.getDatabaseDriver();
                if (driver == null || !StringUtil.isNotEmpty((String)driver.getId())) continue;
                driversId.add(driver.getId());
            }
        }
        return driversId;
    }

    private Map<String, Element> getModifiedOrCreatedDrivers() {
        HashMap<String, Element> result = new HashMap<String, Element>();
        Element state = this.getStateImpl();
        for (Element driverState : DatabaseDriverManagerImpl.getDrivers(state)) {
            String id = DatabaseDriverManagerImpl.getDriverId(driverState);
            if (id == null) continue;
            result.put(id, driverState);
        }
        return result;
    }

    private Element getStateImpl() {
        Element result = new Element("LocalDatabaseDriverManager");
        result.setAttribute("version", VERSION_LATEST);
        for (DatabaseDriverImpl driver : this.myDrivers.values()) {
            String baseId;
            DatabaseDriverImpl base = this.myPredefinedDrivers.get(driver.getId());
            if (base != null && base.equalConfiguration(driver)) continue;
            if (base == null && (baseId = driver.getBaseId()) != null && (base = this.myDrivers.get(baseId)) == null) {
                DatabaseDriverManagerImpl.baseNotFound(baseId);
            }
            result.addContent(driver.getState(base));
        }
        return result;
    }

    @Nullable
    public Element getState() {
        this.updatingDriversLock.readLock().lock();
        try {
            Element element = this.getStateImpl();
            return element;
        }
        finally {
            this.updatingDriversLock.readLock().unlock();
        }
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(17);
        }
        this.updatingDriversLock.writeLock().lock();
        try {
            String version = state.getAttributeValue("version");
            if (Objects.equals(version, VERSION_PRE_141)) {
                this.loadPre141(state, true, false);
            } else {
                this.loadLatest(state, true, false, version, null);
            }
        }
        finally {
            this.updatingDriversLock.writeLock().unlock();
        }
    }

    public @Unmodifiable Collection<DatabaseDriverImpl> getDrivers() {
        this.updatingDriversLock.readLock().lock();
        try {
            List list = ContainerUtil.filter(this.myDrivers.values(), d -> !d.isAbstract());
            return list;
        }
        finally {
            this.updatingDriversLock.readLock().unlock();
        }
    }

    public DatabaseDriverImpl getDriver(String id) {
        this.updatingDriversLock.readLock().lock();
        try {
            DatabaseDriverImpl databaseDriverImpl = this.myDrivers.get(StringUtil.notNullize((String)MIGRATION_MAP.get(id), (String)id));
            return databaseDriverImpl;
        }
        finally {
            this.updatingDriversLock.readLock().unlock();
        }
    }

    @NotNull
    public DatabaseDriverImpl createDriver(String name, String driverClass, UrlTemplate urlTemplate) {
        String driverId = driverClass;
        if (this.getDriver(driverId) != null) {
            driverId = null;
        }
        return new DatabaseDriverImpl(driverId, name, driverClass, urlTemplate);
    }

    private DatabaseDriverImpl getPredefinedDriver(String id) {
        this.updatingDriversLock.readLock().lock();
        try {
            DatabaseDriverImpl databaseDriverImpl = this.myPredefinedDrivers.get(id);
            return databaseDriverImpl;
        }
        finally {
            this.updatingDriversLock.readLock().unlock();
        }
    }

    public void resetToPredefined(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(18);
        }
        DatabaseDriverImpl result = (DatabaseDriverImpl)driver;
        DatabaseDriverImpl backup = this.getPredefinedDriver(result.getBaseId());
        ArrayList<SimpleClasspathElement> classPath = new ArrayList<SimpleClasspathElement>(result.getAdditionalClasspathElements());
        result.loadState(backup.getState(null), false, true, Integer.MAX_VALUE);
        result.setAdditionalClasspathElements(classPath);
    }

    public boolean isInPredefinedState(@NotNull DatabaseDriver driver) {
        DatabaseDriverImpl backup;
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(19);
        }
        return (backup = this.getPredefinedDriver(driver.getId())) == null || ((DatabaseDriverImpl)driver).equalConfiguration(backup, true);
    }

    @Nullable
    public String getPredefinedArtifact(@NotNull String id) {
        DatabaseDriverImpl driver;
        if (id == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(20);
        }
        DatabaseDriver.ArtifactRef ref = (driver = this.getPredefinedDriver(id)) == null ? null : (DatabaseDriver.ArtifactRef)ContainerUtil.getFirstItem(driver.getArtifacts());
        return ref == null ? null : ref.getId();
    }

    public void updateDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(21);
        }
        this.updatingDriversLock.writeLock().lock();
        try {
            DatabaseDriverImpl driverImpl = (DatabaseDriverImpl)driver;
            if (!this.myDrivers.containsKey(driverImpl.getId())) {
                this.addDriver(driverImpl);
            }
        }
        finally {
            this.updatingDriversLock.writeLock().unlock();
        }
    }

    public void removeDriver(@NotNull DatabaseDriver driver) {
        if (driver == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(22);
        }
        this.updatingDriversLock.writeLock().lock();
        try {
            if (this.myDrivers.containsKey(driver.getId())) {
                this.removeDriver(driver.getId());
            }
        }
        finally {
            this.updatingDriversLock.writeLock().unlock();
        }
    }

    public void addDriverListener(@NotNull DatabaseDriverListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(23);
        }
        if (parent == null) {
            DatabaseDriverManagerImpl.$$$reportNull$$$0(24);
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    @TestOnly
    public void updateDriversDirectly(Set<String> usedDrivers, Map<String, Pair<Element, PluginDescriptor>> driversFromEPs) {
        this.updateDriversImpl(this.getModifiedOrCreatedDrivers(), usedDrivers, driversFromEPs);
    }

    @TestOnly
    public Map<String, DatabaseDriverImpl> getPredefinedDrivers() {
        return this.myPredefinedDrivers;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DatabaseDriverManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 6: 
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 7: 
            case 11: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parents";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DatabaseDriverManagerImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractUrls";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDrivers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDriver";
                break;
            }
            case 7: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeDriver";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDrivers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDriverId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDriver";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateDriver";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadLatest";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadPre141";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadPre141Impl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resetToPredefined";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isInPredefinedState";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedArtifact";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateDriver";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addDriverListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 9 -> new IllegalStateException(string);
        };
    }
}

