/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hive.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceBriefConfig;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.SimpleSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactory;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.base.introspector.jdbc.JdbcIntrospector;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector;
import com.intellij.database.dialects.hive.introspector.HiveIntrospector$retrieveFunctions$lambda$0$0$;
import com.intellij.database.dialects.hive.model.HiveForeignKey;
import com.intellij.database.dialects.hive.model.HiveFunction;
import com.intellij.database.dialects.hive.model.HiveFunctionBase;
import com.intellij.database.dialects.hive.model.HiveIndex;
import com.intellij.database.dialects.hive.model.HiveLikeTable;
import com.intellij.database.dialects.hive.model.HiveMacro;
import com.intellij.database.dialects.hive.model.HiveMatView;
import com.intellij.database.dialects.hive.model.HivePersistentFunction;
import com.intellij.database.dialects.hive.model.HiveRole;
import com.intellij.database.dialects.hive.model.HiveRoot;
import com.intellij.database.dialects.hive.model.HiveSchema;
import com.intellij.database.dialects.hive.model.HiveTable;
import com.intellij.database.dialects.hive.model.HiveTableColumn;
import com.intellij.database.dialects.hive.model.HiveView;
import com.intellij.database.dialects.hivebase.generator.producers.HiveBaseTableProducersKt;
import com.intellij.database.dialects.hivebase.model.HiveBaseLikeTable;
import com.intellij.database.dialects.hivebase.model.HiveBaseSourceAware;
import com.intellij.database.dialects.hivebase.model.HiveBaseTableColumn;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnSortingOrder;
import com.intellij.database.dialects.hivebase.model.properties.HiveTableColumnType;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.Level;
import com.intellij.database.model.properties.references.BasicNameReference;
import com.intellij.database.model.properties.references.BasicParentReference;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.script.SimpleCompositeText;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 P2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003PQRB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J\"\u0010\u001f\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001eH\u0002J1\u0010!\u001a\u0004\u0018\u0001H\"\"\b\b\u0000\u0010\"*\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u001e2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H\"0&H\u0002\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u0004\u0018\u00010\u001e2\u0006\u0010)\u001a\u00020*H\u0002J&\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030/2\u0006\u00100\u001a\u000201H\u0014J\u001e\u00102\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00142\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u001e0/H\u0002J&\u00104\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u00022\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030/H\u0002J\u0010\u00106\u001a\u0002012\u0006\u00107\u001a\u00020\u001eH\u0002JH\u00108\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00142\u000e\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020;0:2\u000e\u0010<\u001a\n\u0012\u0006\b\u0001\u0012\u00020=0:2\u0006\u00107\u001a\u00020\u001e2\u0006\u0010>\u001a\u00020\u001e2\u0006\u0010?\u001a\u000201H\u0002J,\u0010@\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010A\u001a\u00020\u001e2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\r0CH\u0002J\u0018\u0010D\u001a\u00020\r2\u0006\u0010,\u001a\u00020-2\u0006\u0010E\u001a\u00020\u0003H\u0002J\u0010\u0010F\u001a\u00020\r2\u0006\u0010,\u001a\u00020-H\u0014J4\u0010G\u001a\u001e\u0012\u0004\u0012\u00020\u00020HR\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030I2\u0006\u0010J\u001a\u00020-2\u0006\u0010K\u001a\u00020\u0002H\u0014J\u0010\u0010L\u001a\u00020\r2\u0006\u0010,\u001a\u00020-H\u0014J\u0010\u0010M\u001a\u00020\r2\u0006\u0010,\u001a\u00020-H\u0002J\u001c\u0010N\u001a\u00060OR\u00020\u00002\u0006\u0010J\u001a\u00020-2\u0006\u0010E\u001a\u00020\u0003H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/hive/model/HiveRoot;", "Lcom/intellij/database/dialects/hive/model/HiveSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "genericIntrospector", "Lcom/intellij/database/dialects/base/introspector/jdbc/JdbcIntrospector;", "initSpecificThings", "", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "dsConfig", "Lcom/intellij/database/dataSource/DataSourceBriefConfig;", "attachToDB", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "retrieveAndApplySchemas", "getMetadata", "Lcom/intellij/database/dialects/base/introspector/jdbc/wrappers/DatabaseMetaDataWrapper;", "dbConnection", "retrieveSchemasDetailedInfo", "buildObject", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "type", "", "getDdl", "name", "getStatement", "T", "Lcom/intellij/sql/psi/SqlStatement;", "sql", "clazz", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)Lcom/intellij/sql/psi/SqlStatement;", "joinRows", "resultSet", "Lcom/intellij/database/remote/jdbc/RemoteResultSet;", "introspectSchemasAuto", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schemas", "", "whole", "", "retrieveFunctions", "schemaNames", "retrieveFunctionsInner", "root", "isSystemFunction", "funcName", "introspectFunction", "funcFamily", "Lcom/intellij/database/model/families/ModNamingFamily;", "Lcom/intellij/database/dialects/hive/model/HiveFunctionBase;", "macroFamily", "Lcom/intellij/database/dialects/hive/model/HiveMacro;", "qualifiedFuncName", "isBuiltin", "forEachNotNullLine", "statement", "processor", "Lkotlin/Function1;", "introspectOneSchema", "schema", "introspectNamespacesInTran", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "database", "introspectServerObjectsInner", "retrieveRoles", "createSchemaRetriever", "Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$HiveSchemaRetriever;", "Companion", "Factory", "HiveSchemaRetriever", "intellij.database.dialects.hive"})
@SourceDebugExtension(value={"SMAP\nHiveIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveIntrospector.kt\ncom/intellij/database/dialects/hive/introspector/HiveIntrospector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n*L\n1#1,507:1\n1#2:508\n1#2:525\n1563#3:509\n1634#3,3:510\n1869#3,2:513\n1617#3,9:515\n1869#3:524\n1870#3:526\n1626#3:527\n1869#3,2:529\n1869#3,2:544\n1869#3,2:546\n355#4:528\n358#4,6:531\n179#4,7:537\n*S KotlinDebug\n*F\n+ 1 HiveIntrospector.kt\ncom/intellij/database/dialects/hive/introspector/HiveIntrospector\n*L\n259#1:525\n253#1:509\n253#1:510,3\n273#1:513,2\n259#1:515,9\n259#1:524\n259#1:526\n259#1:527\n263#1:529,2\n107#1:544,2\n114#1:546,2\n260#1:528\n260#1:531,6\n357#1:537,7\n*E\n"})
public final class HiveIntrospector
extends BaseSingleDatabaseIntrospector<HiveRoot, HiveSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JdbcIntrospector genericIntrospector;
    @NotNull
    private static final String FUNCTION_CLASS = "Function class:";
    @NotNull
    private static final Set<String> IGNORED_FUNCTIONS;
    @NotNull
    private static final Set<String> IGNORED_PROPERTIES;
    @NotNull
    private static final Map<String, Function4<HiveLikeTable, String, String, String, Unit>> viewProcessors;
    @NotNull
    private static final Map<String, Function4<HiveTable, String, String, String, Unit>> tableProcessors;

    public HiveIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = (BaseIntrospector.Nature)BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.HIVE;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"HIVE");
        super(context, nature, dbms, modelFactory);
        this.genericIntrospector = new JdbcIntrospector(context, (BaseIntrospector.Nature)JdbcIntrospector.Factory.ourNature, this.dbms, modelFactory);
    }

    protected void initSpecificThings(@NotNull BasicModModel model, @NotNull DataSourceBriefConfig dsConfig) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)dsConfig, (String)"dsConfig");
        BasicModModel basicModModel = this.getMyModel();
        Intrinsics.checkNotNull((Object)basicModModel);
        BasicModModel modelByNative = basicModModel;
        BasicModModel modelByJdbc = this.genericIntrospector.init(modelByNative, dsConfig, this.getIntrospectionScope());
        if (!Intrinsics.areEqual((Object)modelByNative, (Object)modelByJdbc)) {
            throw new AssertionError((Object)("Model is changed by delegate: " + modelByNative.getClass().getSimpleName() + " -> " + modelByJdbc.getClass().getSimpleName()));
        }
    }

    public void attachToDB(@NotNull DatabaseConnectionCore connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        super.attachToDB(connection);
        this.genericIntrospector.attachToDB(connection);
    }

    public void retrieveAndApplySchemas() {
        block0: {
            this.genericIntrospector.introspectDatabaseSchemas(new BasicDatabase[0]);
            DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
            if (databaseConnectionCore == null) break block0;
            DatabaseConnectionCore it = databaseConnectionCore;
            boolean bl = false;
            this.retrieveSchemasDetailedInfo(it);
        }
    }

    private final DatabaseMetaDataWrapper getMetadata(DatabaseConnectionCore dbConnection) {
        RemoteDatabaseMetaData metaData = dbConnection.getRemoteConnection().getMetaData();
        DatabaseMetaDataWrapper databaseMetaDataWrapper = DatabaseMetaDataWrapper.create((DatabaseConnectionCore)dbConnection, (RemoteDatabaseMetaData)metaData).withErrorSink(this.getErrorSink());
        Intrinsics.checkNotNullExpressionValue((Object)databaseMetaDataWrapper, (String)"withErrorSink(...)");
        return databaseMetaDataWrapper;
    }

    private final void retrieveSchemasDetailedInfo(DatabaseConnectionCore dbConnection) {
        this.inModel(arg_0 -> HiveIntrospector.retrieveSchemasDetailedInfo$lambda$0(dbConnection, this, arg_0));
    }

    private final void buildObject(BasicModElement obj, String type, DatabaseConnectionCore dbConnection) {
        String string = obj.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String ddl = this.getDdl(dbConnection, type, string);
        SqlCreateStatement sqlCreateStatement = this.getStatement(ddl, SqlCreateStatement.class);
        if (sqlCreateStatement == null) {
            return;
        }
        SqlCreateStatement statement = sqlCreateStatement;
        this.getSqlHelper().getBuilder().build(obj, (DasObject)statement, (SqlObjectBuilder.Context)this.getSqlHelper().getBuilderContext());
    }

    private final String getDdl(DatabaseConnectionCore dbConnection, String type, String name2) {
        return (String)SmartStatementFactoryService.Companion.getInstance().poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute((Object)("show create " + type + " `" + name2 + "`"), StandardResultsProcessors.resultsTransformer(arg_0 -> HiveIntrospector.getDdl$lambda$0(this, arg_0))).rightOr(null);
    }

    private final <T extends SqlStatement> T getStatement(String sql, Class<T> clazz) {
        if (sql == null) {
            return null;
        }
        try {
            return (T)((SqlStatement)this.getSqlHelper().statements(sql, clazz).first());
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.log.error((Throwable)e);
            }
            this.log.warn("Failed to parse sources", (Throwable)e);
            return null;
        }
    }

    private final String joinRows(RemoteResultSet resultSet) {
        StringBuilder sb = new StringBuilder();
        while (resultSet.next()) {
            sb.append(resultSet.getString(1)).append("\n");
        }
        resultSet.close();
        if (((CharSequence)sb).length() == 0) {
            return null;
        }
        return sb.toString();
    }

    /*
     * WARNING - void declaration
     */
    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends HiveSchema> schemas, boolean whole) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        for (HiveSchema hiveSchema : schemas) {
            this.introspectOneSchema(tran, hiveSchema);
        }
        DatabaseConnectionCore databaseConnectionCore = this.getDbConnection();
        if (databaseConnectionCore == null) {
            return;
        }
        DatabaseConnectionCore dbConnection = databaseConnectionCore;
        Iterable iterable = schemas;
        DatabaseConnectionCore databaseConnectionCore2 = dbConnection;
        HiveIntrospector hiveIntrospector = this;
        boolean $i$f$map = false;
        Iterable iterable2 = iterable;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HiveSchema hiveSchema = (HiveSchema)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        hiveIntrospector.retrieveFunctions(databaseConnectionCore2, (List<String>)collection);
    }

    private final void retrieveFunctions(DatabaseConnectionCore dbConnection, List<String> schemaNames) {
        this.handleErrors("Introspecting functions", () -> HiveIntrospector.retrieveFunctions$lambda$0(this, schemaNames, dbConnection));
    }

    private final void retrieveFunctionsInner(DatabaseConnectionCore dbConnection, HiveRoot root, List<? extends HiveSchema> schemas) {
        Map nameToSchema = new LinkedHashMap();
        Iterable $this$forEach$iv = schemas;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HiveSchema it = (HiveSchema)element$iv;
            boolean bl = false;
            nameToSchema.put(it.getName(), it);
        }
        this.forEachNotNullLine(dbConnection, "show functions", (Function1<? super String, Unit>)((Function1)arg_0 -> HiveIntrospector.retrieveFunctionsInner$lambda$1(nameToSchema, this, dbConnection, root, arg_0)));
    }

    private final boolean isSystemFunction(String funcName) {
        SqlLanguageDialect sqlLanguageDialect = this.getSqlHelper().getLanguage();
        Intrinsics.checkNotNull((Object)sqlLanguageDialect, (String)"null cannot be cast to non-null type com.intellij.sql.dialects.SqlLanguageDialectEx");
        return ((SqlLanguageDialectEx)sqlLanguageDialect).getSupportedFunctions().contains(funcName);
    }

    private final void introspectFunction(DatabaseConnectionCore dbConnection, ModNamingFamily<? extends HiveFunctionBase> funcFamily, ModNamingFamily<? extends HiveMacro> macroFamily, String funcName, String qualifiedFuncName, boolean isBuiltin) {
        List description = new ArrayList();
        this.forEachNotNullLine(dbConnection, "describe function extended `" + qualifiedFuncName + "`", (Function1<? super String, Unit>)((Function1)arg_0 -> HiveIntrospector.introspectFunction$lambda$0(description, arg_0)));
        if (description.size() < 3) {
            return;
        }
        String classNameLine = (String)description.get(description.size() - 2);
        if (!StringsKt.startsWith$default((String)classNameLine, (String)FUNCTION_CLASS, (boolean)false, (int)2, null)) {
            return;
        }
        String string = classNameLine.substring(15);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String className = string;
        if (StringsKt.endsWith$default((String)className, (String)"GenericUDFMacro", (boolean)false, (int)2, null)) {
            macroFamily.createOrGet(qualifiedFuncName);
            return;
        }
        HiveFunctionBase function = (HiveFunctionBase)funcFamily.createOrGet(funcName);
        function.setClassName(className);
        HiveFunction hiveFunction = function instanceof HiveFunction ? (HiveFunction)function : null;
        if (hiveFunction != null) {
            HiveFunction hiveFunction2;
            HiveFunction $this$introspectFunction_u24lambda_u241 = hiveFunction2 = hiveFunction;
            boolean bl = false;
            $this$introspectFunction_u24lambda_u241.setTemporary(StringsKt.endsWith$default((String)((String)description.get(description.size() - 1)), (String)"TEMPORARY", (boolean)false, (int)2, null));
            $this$introspectFunction_u24lambda_u241.setAutoCreated(isBuiltin);
        }
        function.setComment(((Object)StringsKt.trim((CharSequence)((String)description.get(0)))).toString());
    }

    private final void forEachNotNullLine(DatabaseConnectionCore dbConnection, String statement, Function1<? super String, Unit> processor) {
        SmartStatementFactoryService.Companion.getInstance().poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute((Object)statement, StandardResultsProcessors.resultsTransformer(arg_0 -> HiveIntrospector.forEachNotNullLine$lambda$0(processor, arg_0)));
    }

    private final void introspectOneSchema(DBTransaction tran, HiveSchema schema) {
        this.handleErrors("Introspect schema " + schema.getName(), () -> HiveIntrospector.introspectOneSchema$lambda$0(this, tran, schema));
    }

    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.retrieveAndApplySchemas();
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<HiveRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull HiveRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        throw new UnsupportedOperationException();
    }

    protected void introspectServerObjectsInner(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        this.retrieveRoles(tran);
    }

    private final void retrieveRoles(DBTransaction tran) {
        this.inModel(arg_0 -> HiveIntrospector.retrieveRoles$lambda$0(this, arg_0));
    }

    @NotNull
    protected HiveSchemaRetriever createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull HiveSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new HiveSchemaRetriever(transaction, schema);
    }

    private static final Unit retrieveSchemasDetailedInfo$lambda$0(DatabaseConnectionCore $dbConnection, HiveIntrospector this$0, HiveRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        for (HiveSchema schema : root.getSchemas()) {
            SmartStatementFactoryService.Companion.getInstance().poweredBy($dbConnection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute((Object)("describe schema extended `" + schema.getName() + "`"), StandardResultsProcessors.resultsTransformer(arg_0 -> HiveIntrospector.retrieveSchemasDetailedInfo$lambda$0$0(schema, arg_0)));
            Intrinsics.checkNotNull((Object)schema);
            this$0.buildObject((BasicModElement)schema, "schema", $dbConnection);
        }
        return Unit.INSTANCE;
    }

    private static final Unit retrieveSchemasDetailedInfo$lambda$0$0(HiveSchema $schema, RemoteResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        if (!rs.next()) {
            return Unit.INSTANCE;
        }
        $schema.setComment(rs.getString(2));
        $schema.setLocation(rs.getString(3));
        return Unit.INSTANCE;
    }

    private static final String getDdl$lambda$0(HiveIntrospector this$0, RemoteResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        return this$0.joinRows(resultSet);
    }

    private static final Unit retrieveFunctions$lambda$0(HiveIntrospector this$0, List $schemaNames, DatabaseConnectionCore $dbConnection) {
        this$0.inModel(arg_0 -> HiveIntrospector.retrieveFunctions$lambda$0$0($schemaNames, this$0, $dbConnection, arg_0));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit retrieveFunctions$lambda$0$0(List $schemaNames, HiveIntrospector this$0, DatabaseConnectionCore $dbConnection, HiveRoot root) {
        HiveSchema schema;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Iterable $this$mapNotNull$iv = $schemaNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HiveSchema it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if ((HiveSchema)root.getSchemas().get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List schemas = (List)destination$iv$iv;
        boolean $i$f$modifyFamiliesAndCleanup = false;
        Function1 it = retrieveFunctions$lambda$0$0$$inlined$modifyFamiliesAndCleanup$1.INSTANCE;
        boolean bl = false;
        ModNamingFamily<? extends HiveFunction> modNamingFamily = root.getFunctions();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getFunctions(...)");
        it.invoke(modNamingFamily);
        ModNamingFamily<? extends HiveMacro> modNamingFamily2 = root.getMacros();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getMacros(...)");
        it.invoke(modNamingFamily2);
        Iterable $this$forEach$iv = schemas;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            schema = (HiveSchema)element$iv;
            boolean bl4 = false;
            ModNamingFamily<? extends HivePersistentFunction> modNamingFamily3 = schema.getFunctions();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getFunctions(...)");
            it.invoke(modNamingFamily3);
        }
        boolean bl5 = false;
        this$0.retrieveFunctionsInner($dbConnection, root, schemas);
        it = retrieveFunctions$lambda$0$0$$inlined$modifyFamiliesAndCleanup$2.INSTANCE;
        bl = false;
        ModNamingFamily<? extends HiveFunction> modNamingFamily4 = root.getFunctions();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily4, (String)"getFunctions(...)");
        it.invoke(modNamingFamily4);
        ModNamingFamily<? extends HiveMacro> modNamingFamily5 = root.getMacros();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily5, (String)"getMacros(...)");
        it.invoke(modNamingFamily5);
        $this$forEach$iv = schemas;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            schema = (HiveSchema)element$iv;
            boolean bl6 = false;
            ModNamingFamily<? extends HivePersistentFunction> modNamingFamily6 = schema.getFunctions();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily6, (String)"getFunctions(...)");
            it.invoke(modNamingFamily6);
        }
        return Unit.INSTANCE;
    }

    private static final Unit retrieveFunctionsInner$lambda$1(Map $nameToSchema, HiveIntrospector this$0, DatabaseConnectionCore $dbConnection, HiveRoot $root, String qualifiedFuncName) {
        Intrinsics.checkNotNullParameter((Object)qualifiedFuncName, (String)"qualifiedFuncName");
        if (IGNORED_FUNCTIONS.contains(qualifiedFuncName)) {
            return Unit.INSTANCE;
        }
        int dot = StringsKt.indexOf$default((CharSequence)qualifiedFuncName, (char)'.', (int)0, (boolean)false, (int)6, null);
        if (dot != -1) {
            String string = qualifiedFuncName.substring(0, dot);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            HiveSchema hiveSchema = (HiveSchema)$nameToSchema.get(string);
            if (hiveSchema == null) {
                return Unit.INSTANCE;
            }
            HiveSchema schema = hiveSchema;
            String string2 = qualifiedFuncName.substring(dot + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String funcName = string2;
            ModNamingFamily<? extends HivePersistentFunction> modNamingFamily = schema.getFunctions();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getFunctions(...)");
            ModNamingFamily<? extends HiveMacro> modNamingFamily2 = $root.getMacros();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getMacros(...)");
            this$0.introspectFunction($dbConnection, modNamingFamily, modNamingFamily2, funcName, qualifiedFuncName, false);
        } else {
            HiveFunction function;
            boolean isBuiltin = this$0.isSystemFunction(qualifiedFuncName);
            if (isBuiltin && (function = (HiveFunction)$root.getFunctions().get(qualifiedFuncName)) != null) {
                function.setAutoCreated(true);
                function.resetSyncPending();
                return Unit.INSTANCE;
            }
            ModNamingFamily<? extends HiveFunction> modNamingFamily = $root.getFunctions();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getFunctions(...)");
            ModNamingFamily<? extends HiveMacro> modNamingFamily3 = $root.getMacros();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily3, (String)"getMacros(...)");
            this$0.introspectFunction($dbConnection, modNamingFamily, modNamingFamily3, qualifiedFuncName, qualifiedFuncName, isBuiltin);
        }
        return Unit.INSTANCE;
    }

    private static final Unit introspectFunction$lambda$0(List $description, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $description.add(it);
        return Unit.INSTANCE;
    }

    private static final Unit forEachNotNullLine$lambda$0(Function1 $processor, RemoteResultSet rs) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        while (rs.next()) {
            String it;
            if (rs.getString(1) == null) continue;
            boolean bl = false;
            $processor.invoke((Object)it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit introspectOneSchema$lambda$0(HiveIntrospector this$0, DBTransaction $tran, HiveSchema $schema) {
        HiveSchemaRetriever retriever = this$0.createSchemaRetriever($tran, $schema);
        retriever.process();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoles$lambda$0(HiveIntrospector this$0, HiveRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)root.getRoles();
        boolean removeUnaffected$iv = true;
        boolean $i$f$modifyAndCleanup = false;
        $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
        ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
        boolean bl = false;
        DatabaseConnectionCore databaseConnectionCore = this$0.getDbConnection();
        if (databaseConnectionCore != null) {
            DatabaseConnectionCore dbConnection = databaseConnectionCore;
            SmartStatementFactory statements = SmartStatementFactoryService.Companion.getInstance().poweredBy(dbConnection);
            List roles = (List)statements.simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute((Object)"show roles", StandardResultsProcessors.listOfStrings((int)1)).rightOr((Object)CollectionsKt.emptyList());
            for (Object e : roles) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                String role = (String)e;
                root.getRoles().createOrGet(role);
            }
            statements.simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute((Object)"show principals admin", StandardResultsProcessors.resultsTransformer(arg_0 -> HiveIntrospector.retrieveRoles$lambda$0$0$0(root, arg_0)));
        }
        $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
        $this$modifyAndCleanup_u24default$iv.sort();
        return Unit.INSTANCE;
    }

    private static final Unit retrieveRoles$lambda$0$0$0(HiveRoot $root, RemoteResultSet resultSet) {
        Intrinsics.checkNotNullParameter((Object)resultSet, (String)"resultSet");
        while (resultSet.next()) {
            String userName = resultSet.getString(1);
            String principalType = resultSet.getString(2);
            if (!Intrinsics.areEqual((Object)principalType, (Object)"USER")) continue;
            BasicModNamedElement basicModNamedElement = $root.getRoles().createOrGet(userName);
            HiveRole $this$retrieveRoles_u24lambda_u240_u240_u240_u240 = (HiveRole)basicModNamedElement;
            boolean bl = false;
            $this$retrieveRoles_u24lambda_u240_u240_u240_u240.setCanLogin(true);
            $this$retrieveRoles_u24lambda_u240_u240_u240_u240.setSuperRole(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit viewProcessors$lambda$0(HiveLikeTable $this$to, String string, String key, String value) {
        Intrinsics.checkNotNullParameter((Object)$this$to, (String)"$this$to");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value != null && !IGNORED_PROPERTIES.contains(key)) {
            List<NameValue> list = $this$to.getProperties();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getProperties(...)");
            $this$to.setProperties(CollectionsKt.plus((Collection)list, (Object)new NameValue(key, value)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit viewProcessors$lambda$1(HiveLikeTable $this$snd, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((BasicModModel)$this$snd.getModel()).writeSources(() -> HiveIntrospector.viewProcessors$lambda$1$0($this$snd, it));
        return Unit.INSTANCE;
    }

    private static final void viewProcessors$lambda$1$0(HiveLikeTable $this_snd, String $it) {
        Intrinsics.checkNotNull((Object)$this_snd, (String)"null cannot be cast to non-null type com.intellij.database.dialects.hivebase.model.HiveBaseSourceAware");
        ((HiveBaseSourceAware)((Object)$this_snd)).setSourceText((CompositeText)new SimpleCompositeText((CharSequence)$it, CompositeText.Kind.ORIGINAL_TEXT));
    }

    private static final Unit viewProcessors$lambda$2(HiveLikeTable $this$snd, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)it, (Object)"null")) {
            ((BasicModModel)$this$snd.getModel()).writeSources(() -> HiveIntrospector.viewProcessors$lambda$2$0($this$snd, it));
        }
        return Unit.INSTANCE;
    }

    private static final void viewProcessors$lambda$2$0(HiveLikeTable $this_snd, String $it) {
        Intrinsics.checkNotNull((Object)$this_snd, (String)"null cannot be cast to non-null type com.intellij.database.dialects.hivebase.model.HiveBaseSourceAware");
        ((HiveBaseSourceAware)((Object)$this_snd)).setSourceText((CompositeText)new SimpleCompositeText((CharSequence)$it, CompositeText.Kind.ORIGINAL_TEXT));
    }

    private static final Unit tableProcessors$lambda$0(HiveTable $this$snd, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$snd.setLocation(it);
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$1(HiveTable $this$snd, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$snd.setExternal(StringsKt.startsWith$default((String)it, (String)"EXTERNAL_TABLE", (boolean)false, (int)2, null));
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$2(HiveTable $this$to, String string, String key, String value) {
        Intrinsics.checkNotNullParameter((Object)$this$to, (String)"$this$to");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value != null) {
            if (Intrinsics.areEqual((Object)key, (Object)"transient_lastDdlTime")) {
                $this$to.setTemporary(false);
            }
            if (!IGNORED_PROPERTIES.contains(key)) {
                List list = $this$to.getProperties();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getProperties(...)");
                $this$to.setProperties(CollectionsKt.plus((Collection)list, (Object)new NameValue(key, value)));
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$3(HiveTable $this$to, String colName, String string, String string2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$to, (String)"$this$to");
            Intrinsics.checkNotNullParameter((Object)colName, (String)"colName");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
            if (StringsKt.isBlank((CharSequence)colName) || StringsKt.startsWith$default((String)colName, (String)"#", (boolean)false, (int)2, null)) break block1;
            HiveTableColumn hiveTableColumn = (HiveTableColumn)$this$to.getColumns().get(colName);
            if (hiveTableColumn != null) {
                ((HiveBaseTableColumn)hiveTableColumn).setType(HiveTableColumnType.PARTITIONING);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$4(HiveTable $this$snd, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$snd.setRowFormatSerde(it);
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$5(HiveTable $this$snd, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$snd.setInputFormat(it);
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$6(HiveTable $this$snd, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$snd.setOutputFormat(it);
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$7(HiveTable $this$snd, String v) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        int it = Integer.parseInt(v);
        boolean bl = false;
        if (it > 0) {
            $this$snd.setBucketsNum(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$8(HiveTable $this$snd, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$snd.setStoredAsDirectories(StringsKt.contains$default((CharSequence)it, (CharSequence)"Yes", (boolean)false, (int)2, null));
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$9(HiveTable $this$snd, String it) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)it, (Object)"[]")) {
            String string = it.substring(1, it.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String[] stringArray = new String[]{", "};
            $this$snd.setSkewedByColumns(StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$10(HiveTable $this$snd, String v) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (Intrinsics.areEqual((Object)v, (Object)"[]")) {
            $this$snd.setSkewedByValues("()");
        } else {
            String string = v.substring(2, v.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String[] stringArray = new String[]{"], ["};
            $this$snd.setSkewedByValues(CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, HiveIntrospector::tableProcessors$lambda$10$0, (int)24, null));
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence tableProcessors$lambda$10$0(String list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        String[] stringArray = new String[]{", "};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)list, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, HiveIntrospector::tableProcessors$lambda$10$0$0, (int)24, null);
    }

    private static final CharSequence tableProcessors$lambda$10$0$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return HiveBaseTableProducersKt.getHiveSqlString(it);
    }

    private static final Unit tableProcessors$lambda$11(HiveTable $this$snd, String v) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (!Intrinsics.areEqual((Object)v, (Object)"[]")) {
            String string = v.substring(1, v.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String[] stringArray = new String[]{", "};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String colName = (String)element$iv;
                boolean bl = false;
                HiveTableColumn hiveTableColumn = (HiveTableColumn)$this$snd.getColumns().get(colName);
                if (hiveTableColumn != null) {
                    ((HiveBaseTableColumn)hiveTableColumn).setType(HiveTableColumnType.CLUSTERING);
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$12(HiveTable $this$snd, String v) {
        Intrinsics.checkNotNullParameter((Object)$this$snd, (String)"$this$snd");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (!Intrinsics.areEqual((Object)v, (Object)"[]")) {
            String string = v.substring(7, v.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String[] stringArray = new String[]{"), Order("};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String name2;
                String order = (String)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)order.substring(4, StringsKt.indexOf$default((CharSequence)order, (String)", order:", (int)0, (boolean)false, (int)6, null)), (String)"substring(...)");
                HiveTableColumn hiveTableColumn = (HiveTableColumn)$this$snd.getColumns().get(name2);
                if (hiveTableColumn != null) {
                    ((HiveBaseTableColumn)hiveTableColumn).setSorting(StringsKt.endsWith$default((String)order, (String)"0", (boolean)false, (int)2, null) ? HiveTableColumnSortingOrder.DESC : HiveTableColumnSortingOrder.ASC);
                }
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit tableProcessors$lambda$13(HiveTable $this$to, String string, String key, String value) {
        Intrinsics.checkNotNullParameter((Object)$this$to, (String)"$this$to");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (value != null && !Intrinsics.areEqual((Object)key, (Object)"serialization.format")) {
            List<NameValue> list = $this$to.getSerdeProperties();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getSerdeProperties(...)");
            $this$to.setSerdeProperties(CollectionsKt.plus((Collection)list, (Object)new NameValue(key, value)));
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"!", "!=", "$sum0", "%", "&", "*", "+", "-", "/", "<", "<=", "<=>", "<>", "=", "==", ">", ">=", "^", "and", "between", "case", "div", "in", "like", "or", "regexp", "rlike", "when", "|", "~"};
        IGNORED_FUNCTIONS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"transient_lastDdlTime", "last_modified_by", "last_modified_time", "numFiles", "numRows", "totalSize", "EXTERNAL", "comment", "rawDataSize", "numPartitions", "COLUMN_STATS_ACCURATE"};
        IGNORED_PROPERTIES = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"Table Parameters:", HiveIntrospector::viewProcessors$lambda$0), TuplesKt.to((Object)"View Original Text:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::viewProcessors$lambda$1)), TuplesKt.to((Object)"View Expanded Text:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::viewProcessors$lambda$2)), TuplesKt.to((Object)"View Rewrite Enabled:", (Object)HiveIntrospector.Companion.noop())};
        viewProcessors = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)"Location:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$0)), TuplesKt.to((Object)"Table Type:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$1)), TuplesKt.to((Object)"Table Parameters:", HiveIntrospector::tableProcessors$lambda$2), TuplesKt.to((Object)"# Partition Information", HiveIntrospector::tableProcessors$lambda$3), TuplesKt.to((Object)"SerDe Library:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$4)), TuplesKt.to((Object)"InputFormat:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$5)), TuplesKt.to((Object)"OutputFormat:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$6)), TuplesKt.to((Object)"Compressed:", (Object)HiveIntrospector.Companion.noop()), TuplesKt.to((Object)"Num Buckets:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$7)), TuplesKt.to((Object)"Stored As SubDirectories:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$8)), TuplesKt.to((Object)"Skewed Columns:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$9)), TuplesKt.to((Object)"Skewed Values:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$10)), TuplesKt.to((Object)"Bucket Columns:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$11)), TuplesKt.to((Object)"Sort Columns:", (Object)HiveIntrospector.Companion.snd(HiveIntrospector::tableProcessors$lambda$12)), TuplesKt.to((Object)"Storage Desc Params:", HiveIntrospector::tableProcessors$lambda$13), TuplesKt.to((Object)"# Constraints", (Object)HiveIntrospector.Companion.noop()), TuplesKt.to((Object)"# Foreign Keys", (Object)new Function4<HiveTable, String, String, String, Unit>(){
            private HiveForeignKey currentConstraint;
            private final Map<String, Integer> columnsPos;
            private final Map<String, Integer> refColumnsPos;
            {
                this.columnsPos = new LinkedHashMap<K, V>();
                this.refColumnsPos = new LinkedHashMap<K, V>();
            }

            public final HiveForeignKey getCurrentConstraint() {
                return this.currentConstraint;
            }

            public final void setCurrentConstraint(HiveForeignKey hiveForeignKey) {
                this.currentConstraint = hiveForeignKey;
            }

            public final Map<String, Integer> getColumnsPos() {
                return this.columnsPos;
            }

            public final Map<String, Integer> getRefColumnsPos() {
                return this.refColumnsPos;
            }

            /*
             * Unable to fully structure code
             */
            public void invoke(HiveTable t, String key, String v1, String position) {
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
                        if (!Intrinsics.areEqual((Object)key, (Object)"Constraint Name:")) break block5;
                        this.currentConstraint = (HiveForeignKey)t.getForeignKeys().createOrGet(v1);
                        this.columnsPos.clear();
                        this.refColumnsPos.clear();
                        break block6;
                    }
                    if (!StringsKt.startsWith$default((String)key, (String)"Parent Column Name:", (boolean)false, (int)2, null)) break block6;
                    v0 = this.currentConstraint;
                    if (v0 == null) {
                        return;
                    }
                    fKey = v0;
                    var7_6 = v1;
                    var8_7 = 12;
                    v1 = var7_6.substring(var8_7);
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"substring(...)");
                    colName = v1;
                    var8_8 = key;
                    var9_11 = 19;
                    v2 = var8_8.substring(var9_11);
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"substring(...)");
                    refCol = v2;
                    dot1 = StringsKt.indexOf$default((CharSequence)refCol, (String)".", (int)0, (boolean)false, (int)6, null);
                    dot2 = StringsKt.lastIndexOf$default((CharSequence)refCol, (String)".", (int)0, (boolean)false, (int)6, null);
                    var11_12 = refCol;
                    var12_14 = dot2 + 1;
                    v3 = var11_12.substring(var12_14);
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"substring(...)");
                    refColName = v3;
                    v4 = position;
                    if (v4 == null) ** GOTO lbl-1000
                    var13_17 = v4;
                    var14_19 = 13;
                    v5 = var13_17.substring(var14_19);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"substring(...)");
                    v4 = v5;
                    if (v5 != null) {
                        v6 = Integer.parseInt(v4) + -1;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = fKey.getColNames().size();
                    }
                    pos = v6;
                    var12_15 = this.columnsPos;
                    var13_17 = pos;
                    var12_15.put(colName, (Integer)var13_17);
                    var12_15 = this.refColumnsPos;
                    var13_17 = pos;
                    var12_15.put(refColName, (Integer)var13_17);
                    $this$invoke_u24lambda_u240 = fKey;
                    $i$a$-with-HiveIntrospector$Companion$tableProcessors$15$invoke$1 = false;
                    v7 = refCol.substring(0, dot1);
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"substring(...)");
                    v8 = refCol.substring(dot1 + 1, dot2);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"substring(...)");
                    $this$invoke_u24lambda_u240.setRefTableRef(BasicParentReference.create((String)v7, (BasicReference)((BasicReference)BasicNameReference.create((String)v8))));
                    v9 = $this$invoke_u24lambda_u240.getRefColNames();
                    Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getRefColNames(...)");
                    var15_21 = var14_20 = CollectionsKt.toMutableList((Collection)v9);
                    var16_22 = $this$invoke_u24lambda_u240;
                    $i$a$-apply-HiveIntrospector$Companion$tableProcessors$15$invoke$1$1 = false;
                    $this$invoke_u24lambda_u240_u240.add(refColName);
                    $this$sortBy$iv = $this$invoke_u24lambda_u240_u240;
                    $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(this){
                            final /* synthetic */ Companion.tableProcessors.15 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final int compare(T a, T b) {
                                String it = (String)a;
                                boolean bl = false;
                                Integer n = this.this$0.getRefColumnsPos().get(it);
                                Intrinsics.checkNotNull((Object)n);
                                it = (String)b;
                                Comparable comparable = n;
                                bl = false;
                                Integer n2 = this.this$0.getRefColumnsPos().get(it);
                                Intrinsics.checkNotNull((Object)n2);
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n2);
                            }
                        });
                    }
                    var16_22.setRefColNames(var14_20);
                    v10 = $this$invoke_u24lambda_u240.getColNames();
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getColNames(...)");
                    $this$invoke_u24lambda_u240_u240 = var14_20 = CollectionsKt.toMutableList((Collection)v10);
                    var16_22 = $this$invoke_u24lambda_u240;
                    $i$a$-apply-HiveIntrospector$Companion$tableProcessors$15$invoke$1$2 = false;
                    $this$invoke_u24lambda_u240_u241.add(colName);
                    $this$sortBy$iv = $this$invoke_u24lambda_u240_u241;
                    $i$f$sortBy = false;
                    if ($this$sortBy$iv.size() > 1) {
                        CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(this){
                            final /* synthetic */ Companion.tableProcessors.15 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public final int compare(T a, T b) {
                                String it = (String)a;
                                boolean bl = false;
                                Integer n = this.this$0.getColumnsPos().get(it);
                                Intrinsics.checkNotNull((Object)n);
                                it = (String)b;
                                Comparable comparable = n;
                                bl = false;
                                Integer n2 = this.this$0.getColumnsPos().get(it);
                                Intrinsics.checkNotNull((Object)n2);
                                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n2);
                            }
                        });
                    }
                    var16_22.setColNames(var14_20);
                }
            }
        })};
        tableProcessors = MapsKt.mapOf((Pair[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JV\u0010\u000b\u001a'\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f\"\b\b\u0000\u0010\r*\u00020\u00102\u001d\u0010\u0011\u001a\u0019\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\u0002\b\u000fH\u0002J7\u0010\u0013\u001a'\u0012\u0004\u0012\u0002H\r\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f\"\b\b\u0000\u0010\r*\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR?\u0010\u0014\u001a3\u0012\u0004\u0012\u00020\u0005\u0012)\u0012'\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R?\u0010\u0016\u001a3\u0012\u0004\u0012\u00020\u0005\u0012)\u0012'\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$Companion;", "", "<init>", "()V", "FUNCTION_CLASS", "", "IGNORED_FUNCTIONS", "", "IGNORED_PROPERTIES", "getIGNORED_PROPERTIES", "()Ljava/util/Set;", "snd", "Lkotlin/Function4;", "T", "", "Lkotlin/ExtensionFunctionType;", "Lcom/intellij/database/dialects/hive/model/HiveLikeTable;", "p", "Lkotlin/Function2;", "noop", "viewProcessors", "", "tableProcessors", "Lcom/intellij/database/dialects/hive/model/HiveTable;", "intellij.database.dialects.hive"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getIGNORED_PROPERTIES() {
            return IGNORED_PROPERTIES;
        }

        private final <T extends HiveLikeTable> Function4<T, String, String, String, Unit> snd(Function2<? super T, ? super String, Unit> p) {
            return (arg_0, arg_1, arg_2, arg_3) -> Companion.snd$lambda$0(p, arg_0, arg_1, arg_2, arg_3);
        }

        private final <T extends HiveLikeTable> Function4<T, String, String, String, Unit> noop() {
            return Companion::noop$lambda$0;
        }

        private static final Unit snd$lambda$0(Function2 $p, HiveLikeTable hiveLikeTable, String string, String v, String string2) {
            Intrinsics.checkNotNullParameter((Object)hiveLikeTable, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            $p.invoke((Object)hiveLikeTable, (Object)v);
            return Unit.INSTANCE;
        }

        private static final Unit noop$lambda$0(HiveLikeTable hiveLikeTable, String string, String string2, String string3) {
            Intrinsics.checkNotNullParameter((Object)hiveLikeTable, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<unused var>");
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "isOutdatedCheckSupported", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "isSupported", "version", "Lcom/intellij/database/util/Version;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "VERSION", "intellij.database.dialects.hive"})
    public static final class Factory
    implements DBIntrospector.Factory {
        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return (DBIntrospector)new HiveIntrospector(context, modelFactory);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            return true;
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.hive"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0019\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J`\u0010\u0018\u001a\u00020\u0010\"\b\b\u0000\u0010\u0019*\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u0002H\u001927\u0010\u001c\u001a3\u0012\u0004\u0012\u00020\u001e\u0012)\u0012'\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u001e\u0012\u0004\u0012\u00020\u00100\u001f\u00a2\u0006\u0002\b 0\u001dH\u0002\u00a2\u0006\u0002\u0010!\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector$HiveSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/hive/model/HiveSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/hive/model/HiveRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/hive/introspector/HiveIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/hive/model/HiveSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "level", "Lcom/intellij/database/model/properties/Level;", "process", "", "retrieveJdbcMetadata", "dbConnection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "retrieveDetailedInfo", "retrieveIndices", "retrieveTablesDetailedInfo", "retrieveViewsDetailedInfo", "parseDescription", "T", "Lcom/intellij/database/dialects/hive/model/HiveLikeTable;", "table", "processors", "", "", "Lkotlin/Function4;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/database/dataSource/DatabaseConnectionCore;Lcom/intellij/database/dialects/hive/model/HiveLikeTable;Ljava/util/Map;)V", "intellij.database.dialects.hive"})
    @SourceDebugExtension(value={"SMAP\nHiveIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveIntrospector.kt\ncom/intellij/database/dialects/hive/introspector/HiveIntrospector$HiveSchemaRetriever\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,507:1\n1563#2:508\n1634#2,3:509\n1563#2:530\n1634#2,3:531\n1869#2,2:545\n1869#2,2:547\n1869#2,2:555\n1869#2,2:557\n1563#2:559\n1634#2,3:560\n337#3,3:512\n340#3:517\n198#3,11:518\n341#3:529\n337#3,3:534\n340#3:539\n198#3,5:540\n204#3,5:549\n341#3:554\n37#4,2:515\n37#4,2:537\n*S KotlinDebug\n*F\n+ 1 HiveIntrospector.kt\ncom/intellij/database/dialects/hive/introspector/HiveIntrospector$HiveSchemaRetriever\n*L\n428#1:508\n428#1:509,3\n452#1:530\n452#1:531,3\n458#1:545,2\n459#1:547,2\n406#1:555,2\n407#1:557,2\n435#1:559\n435#1:560,3\n428#1:512,3\n428#1:517\n428#1:518,11\n428#1:529\n452#1:534,3\n452#1:539\n452#1:540,5\n452#1:549,5\n452#1:554\n428#1:515,2\n452#1:537,2\n*E\n"})
    protected final class HiveSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<HiveSchema> {
        public HiveSchemaRetriever(@NotNull DBTransaction transaction, HiveSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)HiveIntrospector.this, transaction, (BasicModSchema)schema);
        }

        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull HiveSchema schema, @NotNull Level level) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            return false;
        }

        public void process() {
            DatabaseConnectionCore databaseConnectionCore = HiveIntrospector.this.getDbConnection();
            if (databaseConnectionCore == null) {
                return;
            }
            DatabaseConnectionCore dbConnection = databaseConnectionCore;
            this.retrieveJdbcMetadata(dbConnection);
            this.retrieveDetailedInfo(dbConnection);
        }

        private final void retrieveJdbcMetadata(DatabaseConnectionCore dbConnection) {
            String string = ((HiveSchema)this.getSchema()).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            HiveIntrospector.this.reportIntrospectingSchemaUsingJdbc(string);
            DatabaseMetaDataWrapper metadata = HiveIntrospector.this.getMetadata(dbConnection);
            this.inSchema(arg_0 -> HiveSchemaRetriever.retrieveJdbcMetadata$lambda$0(HiveIntrospector.this, metadata, arg_0));
            this.inSchema(arg_0 -> HiveSchemaRetriever.retrieveJdbcMetadata$lambda$1(HiveIntrospector.this, metadata, arg_0));
            this.inSchema(arg_0 -> HiveSchemaRetriever.retrieveJdbcMetadata$lambda$2(HiveIntrospector.this, metadata, arg_0));
            this.inSchema(arg_0 -> HiveSchemaRetriever.retrieveJdbcMetadata$lambda$3(HiveIntrospector.this, metadata, arg_0));
        }

        private final void retrieveDetailedInfo(DatabaseConnectionCore dbConnection) {
            this.inSchema(arg_0 -> HiveSchemaRetriever.retrieveDetailedInfo$lambda$0(this, dbConnection, arg_0));
            this.inSchema(arg_0 -> HiveSchemaRetriever.retrieveDetailedInfo$lambda$1(this, dbConnection, arg_0));
            this.inSchema(arg_0 -> HiveSchemaRetriever.retrieveDetailedInfo$lambda$2(this, dbConnection, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void retrieveIndices(HiveSchema schema, DatabaseConnectionCore dbConnection) {
            SimpleSmartStatement stmt = SmartStatementFactoryService.Companion.getInstance().poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM));
            String currentSchema = null;
            try {
                currentSchema = dbConnection.getRemoteConnection().getSchema();
            }
            catch (Throwable t) {
                this.log.warn(t);
            }
            try {
                void families$iv$iv;
                void families$iv;
                void $this$mapTo$iv$iv;
                stmt.execute((Object)("use `" + schema.getName() + "`"), HiveSchemaRetriever::retrieveIndices$lambda$0);
                ModNamingFamily<? extends HiveTable> modNamingFamily = schema.getTables();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
                Iterable $this$map$iv = (Iterable)modNamingFamily;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    HiveTable hiveTable = (HiveTable)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getIndices());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean removeUnaffected$iv = true;
                boolean $i$f$modifyFamiliesAndCleanup = false;
                ModFamily[] $this$toTypedArray$iv$iv = families$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
                $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
                boolean removeUnaffected$iv$iv = removeUnaffected$iv;
                boolean $i$f$modifyFamiliesAndCleanup2 = false;
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.markChildrenAsSyncPending();
                }
                boolean bl = false;
                for (HiveTable table : schema.getTables()) {
                    stmt.execute((Object)("show indexes on `" + table.getName() + "`"), StandardResultsProcessors.resultsTransformer(arg_0 -> HiveSchemaRetriever.retrieveIndices$lambda$2$0(table, arg_0)));
                }
                for (void f$iv$iv : families$iv$iv) {
                    f$iv$iv.removeSyncPendingChildren();
                    f$iv$iv.sort();
                }
            }
            finally {
                if (currentSchema != null) {
                    stmt.execute((Object)("use `" + currentSchema + "`"), HiveSchemaRetriever::retrieveIndices$lambda$3);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveTablesDetailedInfo(HiveSchema schema, DatabaseConnectionCore dbConnection) {
            void families$iv$iv;
            void families$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            HiveIntrospector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends HiveTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = (Iterable)modNamingFamily;
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HiveTable hiveTable = (HiveTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getForeignKeys());
            }
            $this$map$iv = (List)destination$iv$iv;
            object = HiveIntrospector.this;
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            for (HiveTable table : schema.getTables()) {
                HiveTableColumn it;
                ProgressIndicator progressIndicator = object.getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                table.setSerdeProperties(CollectionsKt.emptyList());
                table.setProperties(CollectionsKt.emptyList());
                ModPositioningNamingFamily<? extends HiveTableColumn> modPositioningNamingFamily = table.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily, (String)"getColumns(...)");
                Iterable $this$forEach$iv = (Iterable)modPositioningNamingFamily;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (HiveTableColumn)element$iv;
                    boolean bl2 = false;
                    it.setType(HiveTableColumnType.REGULAR);
                }
                ModPositioningNamingFamily<? extends HiveTableColumn> modPositioningNamingFamily2 = table.getColumns();
                Intrinsics.checkNotNullExpressionValue(modPositioningNamingFamily2, (String)"getColumns(...)");
                $this$forEach$iv = (Iterable)modPositioningNamingFamily2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (HiveTableColumn)element$iv;
                    boolean bl3 = false;
                    it.setSorting(HiveTableColumnSortingOrder.NONE);
                }
                table.setSkewedByColumns(CollectionsKt.emptyList());
                table.setStoredAsDirectories(false);
                table.setTemporary(true);
                Intrinsics.checkNotNull((Object)table);
                this.parseDescription(dbConnection, (HiveLikeTable)table, tableProcessors);
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        private final void retrieveViewsDetailedInfo(HiveSchema schema, DatabaseConnectionCore dbConnection) {
            ObjectKind objectKind = ObjectKind.VIEW;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"VIEW");
            HiveIntrospector.this.reportRetrieving(objectKind);
            for (HiveView view : schema.getViews()) {
                ProgressIndicator progressIndicator = HiveIntrospector.this.getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                view.setProperties(CollectionsKt.emptyList());
                Intrinsics.checkNotNull((Object)view);
                this.parseDescription(dbConnection, (HiveLikeTable)view, viewProcessors);
            }
            for (HiveMatView matView : schema.getMatViews()) {
                ProgressIndicator progressIndicator = HiveIntrospector.this.getProgressIndicator();
                if (progressIndicator != null) {
                    progressIndicator.checkCanceled();
                }
                matView.setProperties(CollectionsKt.emptyList());
                Intrinsics.checkNotNull((Object)matView);
                this.parseDescription(dbConnection, (HiveLikeTable)matView, viewProcessors);
            }
        }

        private final <T extends HiveLikeTable> void parseDescription(DatabaseConnectionCore dbConnection, T table, Map<String, ? extends Function4<? super T, ? super String, ? super String, ? super String, Unit>> processors) {
            Ref.ObjectRef processor = new Ref.ObjectRef();
            SmartStatementFactoryService.Companion.getInstance().poweredBy(dbConnection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).execute((Object)("describe formatted `" + ((HiveBaseLikeTable)table).getName() + "`"), StandardResultsProcessors.resultsTransformer(arg_0 -> HiveSchemaRetriever.parseDescription$lambda$0(processors, processor, table, arg_0)));
        }

        private static final Unit retrieveJdbcMetadata$lambda$0(HiveIntrospector this$0, DatabaseMetaDataWrapper $metadata, HiveSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.genericIntrospector.introspectTablesInSchema($metadata, (BasicModSchema)it);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveJdbcMetadata$lambda$1(HiveIntrospector this$0, DatabaseMetaDataWrapper $metadata, HiveSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.genericIntrospector.introspectColumnsInSchema($metadata, (BasicModSchema)it);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveJdbcMetadata$lambda$2(HiveIntrospector this$0, DatabaseMetaDataWrapper $metadata, HiveSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends HiveTable> modNamingFamily = it.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HiveTable t = (HiveTable)element$iv;
                boolean bl = false;
                this$0.genericIntrospector.introspectTableKeys($metadata, (BasicModTableOrView)t, true);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveJdbcMetadata$lambda$3(HiveIntrospector this$0, DatabaseMetaDataWrapper $metadata, HiveSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            ModNamingFamily<? extends HiveTable> modNamingFamily = it.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HiveTable t = (HiveTable)element$iv;
                boolean bl = false;
                this$0.genericIntrospector.introspectTableForeignKeys($metadata, (BasicModTableOrView)t);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDetailedInfo$lambda$0(HiveSchemaRetriever this$0, DatabaseConnectionCore $dbConnection, HiveSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.retrieveTablesDetailedInfo(it, $dbConnection);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDetailedInfo$lambda$1(HiveSchemaRetriever this$0, DatabaseConnectionCore $dbConnection, HiveSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.retrieveViewsDetailedInfo(it, $dbConnection);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveDetailedInfo$lambda$2(HiveSchemaRetriever this$0, DatabaseConnectionCore $dbConnection, HiveSchema it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.retrieveIndices(it, $dbConnection);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveIndices$lambda$0(ResultsProducer it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit retrieveIndices$lambda$2$0(HiveTable $table, RemoteResultSet rs) {
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            while (rs.next()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String string = rs.getString(1);
                String name2 = string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null;
                CharSequence charSequence = name2;
                if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                    return Unit.INSTANCE;
                }
                HiveIndex index = (HiveIndex)$table.getIndices().createOrGet(name2);
                String string2 = rs.getString(3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                Object object = new String[]{", "};
                object = StringsKt.split$default((CharSequence)string2, (String[])object, (boolean)false, (int)0, (int)6, null);
                HiveIndex hiveIndex = index;
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string3 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                }
                hiveIndex.setColNames((List)destination$iv$iv);
                String string4 = rs.getString(4);
                index.setIndexTableRef((BasicReference)BasicNameReference.create((String)(string4 != null ? ((Object)StringsKt.trim((CharSequence)string4)).toString() : null)));
                String string5 = rs.getString(5);
                index.setType(string5 != null ? ((Object)StringsKt.trim((CharSequence)string5)).toString() : null);
                String string6 = rs.getString(6);
                index.setComment(string6 != null ? ((Object)StringsKt.trim((CharSequence)string6)).toString() : null);
            }
            return Unit.INSTANCE;
        }

        private static final Unit retrieveIndices$lambda$3(ResultsProducer it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Unit.INSTANCE;
        }

        private static final Unit parseDescription$lambda$0(Map $processors, Ref.ObjectRef $processor, HiveLikeTable $table, RemoteResultSet rs) {
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            while (rs.next()) {
                String string;
                Function4 p;
                String string2 = rs.getString(1);
                if (string2 == null || (string2 = ((Object)StringsKt.trim((CharSequence)string2)).toString()) == null) continue;
                String headerOrKey = string2;
                Function4 newProcessor = (Function4)$processors.get(headerOrKey);
                if (newProcessor != null) {
                    $processor.element = newProcessor;
                }
                if ((p = (Function4)$processor.element) == null || (string = rs.getString(2)) == null || (string = ((Object)StringsKt.trim((CharSequence)string)).toString()) == null) continue;
                String v2 = string;
                String string3 = rs.getString(3);
                String v3 = string3 != null ? ((Object)StringsKt.trim((CharSequence)string3)).toString() : null;
                p.invoke((Object)$table, (Object)headerOrKey, (Object)v2, (Object)v3);
            }
            return Unit.INSTANCE;
        }
    }
}

