/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.IndexesExporterIOResult;
import com.intellij.indexing.shared.generator.IndexesExporterKt;
import com.intellij.indexing.shared.generator.IndexesExporterRequest;
import com.intellij.indexing.shared.generator.IndexesExporterResult;
import com.intellij.indexing.shared.generator.IndexesExporterTask;
import com.intellij.indexing.shared.generator.IndexesExporterTaskResult;
import com.intellij.indexing.shared.generator.OptimisticErrorsCollector;
import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatistics;
import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatisticsDumper;
import com.intellij.indexing.shared.platform.api.IdeSharedIndexesState;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureOs;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/indexing/shared/generator/IndexesExporter;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "exportIndexesChunk", "Lcom/intellij/indexing/shared/generator/IndexesExporterResult;", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/indexing/shared/generator/IndexesExporterRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared.generator"})
@SourceDebugExtension(value={"SMAP\nIndexesExporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexesExporter.kt\ncom/intellij/indexing/shared/generator/IndexesExporter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,195:1\n13#2:196\n*S KotlinDebug\n*F\n+ 1 IndexesExporter.kt\ncom/intellij/indexing/shared/generator/IndexesExporter\n*L\n132#1:196\n*E\n"})
public final class IndexesExporter {
    @NotNull
    public static final IndexesExporter INSTANCE = new IndexesExporter();
    @NotNull
    private static final Logger LOG;

    private IndexesExporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final IndexesExporterResult exportIndexesChunk(@NotNull Project project, @NotNull IndexesExporterRequest request, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        IndexesExporterKt.access$ensureVfsInitialized();
        request.ensureHashProvidersExist();
        Path tempHome = request.getTempDir().resolve("shared-indexes-" + UUID.randomUUID());
        Path ijxFile = tempHome.resolve("shared-index.ijx");
        Path chunkRoot = tempHome.resolve("shared-index.unpacked");
        ErrorsCollector errorsCollector = new OptimisticErrorsCollector();
        try {
            Instant startTime = Instant.now();
            Intrinsics.checkNotNull((Object)tempHome);
            PathKt.createDirectories((Path)tempHome);
            Intrinsics.checkNotNull((Object)chunkRoot);
            PathKt.createDirectories((Path)chunkRoot);
            LOG.warn("Building shared indexes...");
            LOG.warn("Metadata = " + request.getAdditionalMetadata());
            IndexExportStatistics exportStatistics = new IndexExportStatistics();
            IdeSharedIndexesState state = new IdeSharedIndexesState().withSupportedOs((Collection)CollectionsKt.toSet((Iterable)((Iterable)EntriesMappings.entries$0)));
            Intrinsics.checkNotNull((Object)state);
            IndexesExporterTaskResult result = new IndexesExporterTask(project, state, request, exportStatistics, errorsCollector).exportIndexesChunk(indicator, chunkRoot);
            exportStatistics.getIndexingTimeMs().set(Duration.between(startTime, Instant.now()).toMillis());
            errorsCollector.report();
            Intrinsics.checkNotNull((Object)ijxFile);
            UtilKt.uncompressedZip((Path)chunkRoot, (Path)ijxFile, (ProgressIndicator)indicator);
            String ijxExtension = ".ijx" + request.getCompression().getExtensionSuffix();
            Path ijxCompressed = tempHome.resolve("shared-index" + ijxExtension);
            SharedIndexCompression sharedIndexCompression = request.getCompression();
            Intrinsics.checkNotNull((Object)ijxCompressed);
            sharedIndexCompression.compress(ijxFile, ijxCompressed, indicator);
            IndexesExporterIOResult files = IndexesExporterKt.deliverToOutputDir(ijxCompressed, result.getMetadata(), request.getNamePrefix(), ijxExtension, request.getOutputDir(), request.getAddHashToOutputNames());
            exportStatistics.getTotalTimeMs().set(Duration.between(startTime, Instant.now()).toMillis());
            exportStatistics.getIndexSizeBytes().set(UtilKt.getFileOrDirectorySize((Path)files.getIndexPath()));
            IndexExportStatisticsDumper.INSTANCE.dumpStatistics(request.getChunk().getName(), exportStatistics);
            IndexesExporterResult indexesExporterResult = new IndexesExporterResult(result.getIndexInfrastructureVersion(), files);
            return indexesExporterResult;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            throw new RuntimeException("Failed to generate shared indexes. " + e.getMessage(), e);
        }
        finally {
            FileUtil.delete((Path)tempHome);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IndexesExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<IndexInfrastructureOs> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])IndexInfrastructureOs.values()));
        }
    }
}

