/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trac;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.trac.TracRepositoryType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import icons.TasksCoreIcons;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.xmlrpc.CommonsXmlRpcTransport;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcTransport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="Trac")
public final class TracRepository
extends BaseRepositoryImpl {
    private String myDefaultSearch = "status!=closed&owner={username}&summary~={query}";
    private Boolean myMaxSupported;

    public Task[] getIssues(@Nullable String query, int max, long since) throws Exception {
        Transport transport = new Transport(this);
        return this.getIssues(query, max, transport);
    }

    private Task[] getIssues(@Nullable String query, int max, Transport transport) throws Exception {
        XmlRpcClient client = this.getRpcClient();
        Vector<Object> result = null;
        Object search = this.myDefaultSearch + "&max=" + max;
        if (this.myMaxSupported == null) {
            try {
                this.myMaxSupported = true;
                result = this.runQuery(query, transport, client, (String)search);
            }
            catch (XmlRpcException e) {
                if (e.getMessage().contains("t.max")) {
                    this.myMaxSupported = false;
                }
                throw e;
            }
        }
        if (!this.myMaxSupported.booleanValue()) {
            search = this.myDefaultSearch;
        }
        if (result == null) {
            result = this.runQuery(query, transport, client, (String)search);
        }
        if (result == null) {
            throw new Exception("Cannot connect to " + this.getUrl());
        }
        ArrayList tasks = new ArrayList(max);
        int min = Math.min(max, result.size());
        for (int i = 0; i < min; ++i) {
            Task task = this.getTask((Integer)result.get(i), client, transport);
            ContainerUtil.addIfNotNull(tasks, (Object)task);
        }
        return tasks.toArray(Task.EMPTY_ARRAY);
    }

    private Vector<Object> runQuery(@Nullable String query, Transport transport, XmlRpcClient client, String search) throws XmlRpcException, IOException {
        if (query != null) {
            search = search.replace("{query}", query);
        }
        search = search.replace("{username}", this.getUsername());
        XmlRpcRequest request = new XmlRpcRequest("ticket.query", new Vector<String>(Collections.singletonList(search)));
        return (Vector)client.execute((XmlRpcClientRequest)request, (XmlRpcTransport)transport);
    }

    private XmlRpcClient getRpcClient() throws MalformedURLException {
        return new XmlRpcClient(this.getUrl());
    }

    @Nullable
    public Task findTask(@NotNull String id) throws Exception {
        if (id == null) {
            TracRepository.$$$reportNull$$$0(0);
        }
        return this.getTask(Integer.parseInt(id), this.getRpcClient(), new Transport(this));
    }

    public String getDefaultSearch() {
        return this.myDefaultSearch;
    }

    public void setDefaultSearch(String defaultSearch) {
        this.myDefaultSearch = defaultSearch;
    }

    @Nullable
    private Task getTask(int id, XmlRpcClient client, Transport transport) throws IOException, XmlRpcException {
        XmlRpcRequest request = new XmlRpcRequest("ticket.get", new Vector<Integer>(Collections.singletonList(id)));
        Object response = client.execute((XmlRpcClientRequest)request, (XmlRpcTransport)transport);
        if (response == null) {
            return null;
        }
        final Vector vector = (Vector)response;
        final Hashtable map = (Hashtable)vector.get(3);
        return new Task(){

            @NotNull
            public String getId() {
                String string = vector.get(0).toString();
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = (String)map.get("summary");
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Nullable
            public String getDescription() {
                return null;
            }

            public Comment @NotNull [] getComments() {
                if (Comment.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(2);
                }
                return Comment.EMPTY_ARRAY;
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = TasksCoreIcons.Trac;
                if (icon == null) {
                    1.$$$reportNull$$$0(3);
                }
                return icon;
            }

            @NotNull
            public TaskType getType() {
                String type;
                String string = type = (String)map.get("type");
                int n = 0;
                TaskType taskType = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"Feature", "enhancement", "Bug", "defect", "error", "Exception"}, (Object)string, n)) {
                    case 0, 1 -> TaskType.FEATURE;
                    case 2, 3, 4 -> TaskType.BUG;
                    case 5 -> TaskType.EXCEPTION;
                    default -> TaskType.OTHER;
                };
                if (taskType == null) {
                    1.$$$reportNull$$$0(4);
                }
                return taskType;
            }

            @NotNull
            public Date getUpdated() {
                Date date = TracRepository.getDate(vector.get(2));
                if (date == null) {
                    1.$$$reportNull$$$0(5);
                }
                return date;
            }

            @NotNull
            public Date getCreated() {
                Date date = TracRepository.getDate(vector.get(1));
                if (date == null) {
                    1.$$$reportNull$$$0(6);
                }
                return date;
            }

            public boolean isClosed() {
                return false;
            }

            public boolean isIssue() {
                return true;
            }

            @Nullable
            public String getIssueUrl() {
                return null;
            }

            @NotNull
            public TaskRepository getRepository() {
                TracRepository tracRepository = TracRepository.this;
                if (tracRepository == null) {
                    1.$$$reportNull$$$0(7);
                }
                return tracRepository;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/tasks/trac/TracRepository$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComments";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getType";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUpdated";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCreated";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRepository";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static Date getDate(Object o) {
        return o instanceof Date ? (Date)o : new Date((long)((Integer)o).intValue() * 1000L);
    }

    @Nullable
    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){
            Transport myTransport;

            protected void doTest() throws Exception {
                this.myTransport = new Transport(TracRepository.this);
                TracRepository.this.getIssues("", 1, this.myTransport);
            }

            public void cancel() {
                this.myTransport.cancel();
            }
        };
    }

    @NotNull
    public BaseRepository clone() {
        return new TracRepository(this);
    }

    public TracRepository() {
    }

    public TracRepository(TracRepositoryType repositoryType) {
        super((TaskRepositoryType)repositoryType);
        this.setUrl("http://myserver.com/login/rpc");
        this.myUseHttpAuthentication = true;
    }

    private TracRepository(TracRepository other) {
        super((BaseRepositoryImpl)other);
        this.myDefaultSearch = other.myDefaultSearch;
    }

    public boolean equals(Object o) {
        return super.equals(o) && Objects.equals(((TracRepository)((Object)o)).getDefaultSearch(), this.getDefaultSearch());
    }

    protected int getFeatures() {
        return super.getFeatures() | 1;
    }

    static {
        XmlRpc.setDefaultInputEncoding((String)"UTF-8");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/tasks/trac/TracRepository", "findTask"));
    }

    private class Transport
    extends CommonsXmlRpcTransport {
        Transport(TracRepository tracRepository) throws MalformedURLException {
            super(new URL(tracRepository.getUrl()), tracRepository.getHttpClient());
        }

        void cancel() {
            this.method.abort();
        }
    }
}

