/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.javaee.appServers.appServerIntegrations.AppServerIntegration;
import com.intellij.javaee.appServers.appServerIntegrations.AppServerLibrariesProvider;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServerHelper;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServerPersistentData;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServerPersistentDataEditor;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServerUrlMapping;
import com.intellij.javaee.appServers.context.FacetContextProvider;
import com.intellij.javaee.appServers.context.WebModuleContextProvider;
import com.intellij.javaee.appServers.deployment.DeploymentModel;
import com.intellij.javaee.appServers.deployment.DeploymentProvider;
import com.intellij.javaee.appServers.deployment.DeploymentSource;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.run.localRun.ExecutableObject;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.server.AppServerLibrariesProviderImpl;
import com.intellij.javaee.oss.server.JavaeeDeploymentModel;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerHelper;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.web.WebFacetContextProvider;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaeeIntegration
extends AppServerIntegration {
    private static final Logger LOG = Logger.getInstance(JavaeeIntegration.class);
    private JavaeeServerHelper myServerHelper;
    private JavaeeDescriptorsManager myDescriptorsManager;
    private ApplicationServerUrlMapping myUrlMapping;

    public String getPresentableName() {
        return AppServersCommonBundle.getText("Integration.name", this.getName());
    }

    public String getIntegrationId() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @NotNull
    public ApplicationServerHelper getApplicationServerHelper() {
        if (this.myServerHelper == null) {
            this.myServerHelper = this.createServerHelper();
        }
        JavaeeServerHelper javaeeServerHelper = this.myServerHelper;
        if (javaeeServerHelper == null) {
            JavaeeIntegration.$$$reportNull$$$0(0);
        }
        return javaeeServerHelper;
    }

    protected JavaeeServerHelper createServerHelper() {
        return new JavaeeServerHelper(this);
    }

    public ApplicationServerPersistentDataEditor createNewServerEditor() {
        return this.getApplicationServerHelper().createConfigurable();
    }

    public DeploymentProvider getDeploymentProvider(boolean local) {
        return new JavaeeDeploymentProvider();
    }

    @NotNull
    public ApplicationServerUrlMapping getDeployedFileUrlProvider() {
        if (this.myUrlMapping == null) {
            final WebFacetContextProvider webFacetContextProvider = new WebFacetContextProvider(){

                protected String getContextServerSpecific(@NotNull DeploymentModel deploymentModel, @NotNull WebFacet facet) {
                    String facetContext;
                    if (deploymentModel == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (facet == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (StringUtil.isNotEmpty((String)(facetContext = JavaeeIntegration.this.getContextRoot((JavaeeFacet)facet)))) {
                        return facetContext;
                    }
                    return ((JavaeeServerModel)deploymentModel.getServerModel()).getServerSpecificContext(deploymentModel);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "deploymentModel";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "facet";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/javaee/oss/server/JavaeeIntegration$1";
                    objectArray[2] = "getContextServerSpecific";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.myUrlMapping = new ApplicationServerUrlMapping(){

                protected void collectFacetContextProviders(List<FacetContextProvider> facetContextProvider) {
                    super.collectFacetContextProviders(facetContextProvider);
                    facetContextProvider.add((FacetContextProvider)webFacetContextProvider);
                }

                protected void collectWebModuleContextProviders(List<WebModuleContextProvider> webModuleContextProviders) {
                    if (JavaeeIntegration.this instanceof WebModuleContextProvider) {
                        webModuleContextProviders.add((WebModuleContextProvider)JavaeeIntegration.this);
                    }
                    super.collectWebModuleContextProviders(webModuleContextProviders);
                }
            };
        }
        ApplicationServerUrlMapping applicationServerUrlMapping = this.myUrlMapping;
        if (applicationServerUrlMapping == null) {
            JavaeeIntegration.$$$reportNull$$$0(1);
        }
        return applicationServerUrlMapping;
    }

    public JavaeeDescriptorsManager getDescriptorsManager() {
        if (this.myDescriptorsManager == null) {
            this.myDescriptorsManager = new JavaeeDescriptorsManager(this);
            this.collectDescriptors(this.myDescriptorsManager);
        }
        return this.myDescriptorsManager;
    }

    @Nullable
    public AppServerLibrariesProvider createLibrariesProvider(@NotNull ApplicationServerPersistentData persistentData) {
        if (persistentData == null) {
            JavaeeIntegration.$$$reportNull$$$0(2);
        }
        if (!(persistentData instanceof JavaeePersistentData)) {
            return null;
        }
        if (this.getFrameworkLibrariesDescriptionPath() == null && this.getFrameworkLibrariesDescriptionRemoteName() == null) {
            return null;
        }
        return new AppServerLibrariesProviderImpl(this, (JavaeePersistentData)persistentData);
    }

    protected abstract void collectDescriptors(JavaeeDescriptorsManager var1);

    @NotNull
    public abstract String getName();

    @NotNull
    public abstract Icon getIcon();

    @NotNull
    public abstract Icon getBigIcon();

    @Nullable
    @NonNls
    public abstract String getNameFromTemplate(String var1) throws Exception;

    @Nullable
    @NonNls
    public abstract String getVersionFromTemplate(String var1) throws Exception;

    @NotNull
    @NonNls
    public abstract String getServerVersion(JavaeePersistentData var1) throws Exception;

    @NotNull
    @NonNls
    public String getServerVersionSilently(JavaeePersistentData persistentData) {
        String string;
        try {
            string = this.getServerVersion(persistentData);
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            return "";
        }
        if (string == null) {
            JavaeeIntegration.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected abstract void checkValidServerHome(String var1, String var2) throws Exception;

    protected void addLibraryLocations(JavaeePersistentData persistentData, List<Path> locations) {
        this.addLibraryLocations(persistentData.HOME, locations);
    }

    protected abstract void addLibraryLocations(String var1, List<Path> var2);

    public static void checkFile(@NonNls String home, @NonNls String path) throws IOException {
        if (!new File(home, path).exists()) {
            throw new FileNotFoundException(AppServersCommonBundle.getText("Error.fileNotFound", path));
        }
    }

    public static void checkDir(File dir) throws FileNotFoundException {
        if (!dir.isDirectory()) {
            throw new FileNotFoundException(AppServersCommonBundle.getText("JavaeeIntegration.message.text.cant.find.directory", dir.getAbsolutePath()));
        }
    }

    @Nullable
    public SettingsEditor<DeploymentModel> createAdditionalDeploymentSettingsEditor(CommonModel commonModel, DeploymentSource source) {
        return null;
    }

    public DeploymentModel createNewDeploymentModel(CommonModel commonModel, DeploymentSource source) {
        return new JavaeeDeploymentModel(commonModel, source);
    }

    @NotNull
    public String detectVersion(JavaeePersistentData data) throws Exception {
        String result = this.getServerVersion(data);
        this.checkValidServerHome(data.HOME, result);
        String string = result;
        if (string == null) {
            JavaeeIntegration.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public abstract String getContextRoot(JavaeeFacet var1);

    public boolean isStartupScriptTerminating(@NotNull ExecutableObject startupScript) {
        if (startupScript == null) {
            JavaeeIntegration.$$$reportNull$$$0(5);
        }
        return this.isStartupScriptTerminating();
    }

    public boolean isStartupScriptTerminating() {
        return false;
    }

    public boolean isAsyncWrapped() {
        return false;
    }

    @Nullable
    public String getFrameworkLibrariesDescriptionPath() {
        String directoryName = this.getFrameworkLibrariesDescriptionRemoteName();
        return directoryName != null ? "/libraries/" + directoryName + ".xml" : null;
    }

    @Nullable
    public String getFrameworkLibrariesDescriptionRemoteName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/oss/server/JavaeeIntegration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupScript";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationServerHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeployedFileUrlProvider";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/oss/server/JavaeeIntegration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerVersionSilently";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "detectVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLibrariesProvider";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStartupScriptTerminating";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 5 -> new IllegalArgumentException(string);
        };
    }
}

