let queryRegistry = require('query-registry');

(async function () {
  async function loadChunk(from, size) {
    let searchResults = await queryRegistry.searchPackages(
      {
        query: {
          quality: 0.0,
          popularity: 1.0,
          maintenance: 0.0,
          from,
          size,
          text: "boost-exact:false"
        }
      }
    )
    // for (let resultElement of searchResults.objects) {
    //     console.log(resultElement.score.detail.popularity.toFixed(3) + " " + resultElement.package.name);
    // }
    return searchResults.objects
  }

  async function sleep(ms) {
    let promise = new Promise((resolve) => {
      setTimeout(resolve, ms)
    })
    await promise
  }

  let objects = []
  for (let i = 0; i < 4; i++) {
    let chunk = await loadChunk(250 * i, 250)
    objects = objects.concat(chunk)
    // sleep to not get banned based on https://docs.npmjs.com/policies/crawlers
    await sleep(1500)
  }
  console.log(JSON.stringify(objects, ["package", "name", "description"], 2))
})()


