"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.hljs = exports.renderMarkdown = void 0;
var marked_1 = require("marked");
var core_1 = __importDefault(require("highlight.js/lib/core"));
exports.hljs = core_1.default;
var json_1 = __importDefault(require("highlight.js/lib/languages/json"));
core_1.default.registerLanguage('json', json_1.default);
var yaml_1 = __importDefault(require("highlight.js/lib/languages/yaml"));
core_1.default.registerLanguage('yaml', yaml_1.default);
var bash_1 = __importDefault(require("highlight.js/lib/languages/bash"));
core_1.default.registerLanguage('bash', bash_1.default);
var markedOptions = {
    langPrefix: 'hljs language-',
    highlight: function (code, language) {
        if (!core_1.default.getLanguage(language)) {
            return code;
        }
        try {
            return core_1.default.highlight(code, { language: language }).value;
        }
        catch (e) {
            return code;
        }
    },
};
function renderMarkdown(content) {
    return (0, marked_1.marked)(content, markedOptions);
}
exports.renderMarkdown = renderMarkdown;
//# sourceMappingURL=marked.js.map