/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.notification.NotificationAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesProvider;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesUi;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.VcsShowToolWindowTabAction;
import git4idea.i18n.GitBundle;
import git4idea.index.GitStageContentProviderKt;
import git4idea.index.GitStageManagerKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashTracker;
import git4idea.stash.GitStashTrackerKt;
import git4idea.stash.ui.GitStashContentProviderKt;
import git4idea.stash.ui.GitStashProvider;
import git4idea.stash.ui.GitStashUIHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/stash/ui/GitStashUIHandlerImpl;", "Lgit4idea/stash/ui/GitStashUIHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "isStashTabAvailable", "", "isStashTabAvailableInWindow", "isStashTabVisible", "isStashesAndShelvesTabAvailable", "canSwitchStashesAndShelvesTab", "showStashes", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "showStashesNotificationActions", "", "Lcom/intellij/notification/NotificationAction;", "roots", "", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStashUIHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashUIHandler.kt\ngit4idea/stash/ui/GitStashUIHandlerImpl\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n30#2,2:94\n1#3:96\n808#4,11:97\n*S KotlinDebug\n*F\n+ 1 GitStashUIHandler.kt\ngit4idea/stash/ui/GitStashUIHandlerImpl\n*L\n50#1:94,2\n69#1:97,11\n*E\n"})
final class GitStashUIHandlerImpl
implements GitStashUIHandler {
    @NotNull
    private final Project project;

    public GitStashUIHandlerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Override
    public boolean isStashTabAvailable() {
        return GitStashContentProviderKt.stashToolWindowRegistryOption().asBoolean();
    }

    @Override
    public boolean isStashTabAvailableInWindow() {
        return this.isStashTabAvailable() && ChangesViewContentManager.Companion.getToolWindowFor(this.project, "Stash") != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isStashTabVisible() {
        if (!this.isStashTabAvailable()) {
            return false;
        }
        if (this.isStashesAndShelvesTabAvailable()) return true;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitStashTracker> serviceClass$iv = GitStashTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        if (!GitStashTrackerKt.isNotEmpty((GitStashTracker)object)) return false;
        return true;
    }

    @Override
    public boolean isStashesAndShelvesTabAvailable() {
        return ShelvedChangesViewManager.hideDefaultShelfTab((Project)this.project);
    }

    @Override
    public boolean canSwitchStashesAndShelvesTab() {
        return true;
    }

    @Override
    public void showStashes() {
        VcsShowToolWindowTabAction.Companion.activateVcsTab(this.project, "Stash", true);
    }

    @Override
    public void showStashes(@Nullable VirtualFile root) {
        GitRepository gitRepository;
        VirtualFile virtualFile = root;
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            gitRepository = (GitRepository)GitRepositoryManager.getInstance(this.project).getRepositoryForRootQuick(root);
        } else {
            gitRepository = null;
        }
        GitRepository repository2 = gitRepository;
        GitStageContentProviderKt.showToolWindowTab(this.project, "Stash", (Function1<? super JComponent, Unit>)((Function1)arg_0 -> GitStashUIHandlerImpl.showStashes$lambda$1(repository2, arg_0)));
    }

    @Override
    @NotNull
    public List<NotificationAction> showStashesNotificationActions(@NotNull Collection<? extends VirtualFile> roots) {
        List list;
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        List $this$showStashesNotificationActions_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (this.isStashTabAvailable()) {
            NotificationAction notificationAction = NotificationAction.createSimple((String)GitBundle.message((String)"stash.view.stashes.link", (Object[])new Object[0]), () -> GitStashUIHandlerImpl.showStashesNotificationActions$lambda$0$0(this, roots));
            Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimple(...)");
            $this$showStashesNotificationActions_u24lambda_u240.add(notificationAction);
        } else if (GitStageManagerKt.isStagingAreaAvailable(this.project)) {
            NotificationAction notificationAction = NotificationAction.createSimpleExpiring((String)GitBundle.message((String)"stash.enable.stashes.link", (Object[])new Object[0]), () -> GitStashUIHandlerImpl.showStashesNotificationActions$lambda$0$1(this, roots));
            Intrinsics.checkNotNullExpressionValue((Object)notificationAction, (String)"createSimpleExpiring(...)");
            $this$showStashesNotificationActions_u24lambda_u240.add(notificationAction);
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit showStashes$lambda$1(GitRepository $repository, JComponent component2) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        SavedPatchesUi savedPatchesUi = component2 instanceof SavedPatchesUi ? (SavedPatchesUi)component2 : null;
        if (savedPatchesUi == null) {
            return Unit.INSTANCE;
        }
        SavedPatchesUi savedPatchesUi2 = savedPatchesUi;
        Iterable $this$filterIsInstance$iv = savedPatchesUi2.getProviders();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GitStashProvider)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        GitStashProvider gitStashProvider = (GitStashProvider)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        if (gitStashProvider == null) {
            return Unit.INSTANCE;
        }
        GitStashProvider provider = gitStashProvider;
        if ($repository == null) {
            savedPatchesUi2.showFirstUnderProvider((SavedPatchesProvider)provider);
        } else {
            savedPatchesUi2.showFirstUnderObject((SavedPatchesProvider)provider, (Object)$repository);
        }
        return Unit.INSTANCE;
    }

    private static final void showStashesNotificationActions$lambda$0$0(GitStashUIHandlerImpl this$0, Collection $roots) {
        this$0.showStashes((VirtualFile)CollectionsKt.firstOrNull((Iterable)$roots));
    }

    private static final void showStashesNotificationActions$lambda$0$1(GitStashUIHandlerImpl this$0, Collection $roots) {
        GitStashContentProviderKt.stashToolWindowRegistryOption().setValue(true);
        this$0.showStashes((VirtualFile)CollectionsKt.firstOrNull((Iterable)$roots));
    }
}

