/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.spring.modulith.SpringModulithBundle;
import com.intellij.spring.modulith.SpringModulithLibraryUtilsKt;
import com.intellij.spring.modulith.codeInsight.SpringModulithDependenciesCompletionContributorKt;
import com.intellij.spring.modulith.model.ApplicationModule;
import com.intellij.spring.modulith.model.ModulithDependency;
import com.intellij.spring.modulith.model.NamedInterface;
import com.intellij.spring.modulith.model.SpringModulithModelService;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000fH\u0002J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u000fH\u0002J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/spring/modulith/highlighting/SpringModulithAllowedDependencyInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkDependency", "", "dependency", "", "appModules", "", "Lcom/intellij/spring/modulith/model/ApplicationModule;", "psiElement", "Lcom/intellij/psi/PsiElement;", "reportEmptyDependencyIdentifier", "reportMissingModule", "moduleId", "reportMissingNamedInterface", "namedInterfaceName", "reportMalformedDependency", "intellij.spring.modulith"})
@SourceDebugExtension(value={"SMAP\nSpringModulithAllowedDependencyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringModulithAllowedDependencyInspection.kt\ncom/intellij/spring/modulith/highlighting/SpringModulithAllowedDependencyInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1761#2,3:127\n295#2,2:130\n1761#2,3:132\n*S KotlinDebug\n*F\n+ 1 SpringModulithAllowedDependencyInspection.kt\ncom/intellij/spring/modulith/highlighting/SpringModulithAllowedDependencyInspection\n*L\n61#1:127,3\n72#1:130,2\n78#1:132,3\n*E\n"})
public final class SpringModulithAllowedDependencyInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile());
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        if (!SpringModulithLibraryUtilsKt.hasModulithLibrary(module2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<ApplicationModule> appModules = SpringModulithModelService.Companion.getInstance$intellij_spring_modulith(project).getModel$intellij_spring_modulith(module2);
        if (appModules.isEmpty()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new PsiElementVisitor(this, appModules, holder){
            final /* synthetic */ SpringModulithAllowedDependencyInspection this$0;
            final /* synthetic */ List<ApplicationModule> $appModules;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$appModules = $appModules;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ProgressIndicatorProvider.checkCanceled();
                if (!SpringModulithDependenciesCompletionContributorKt.getDEPENDENCY_PATTERN().accepts((Object)element) || !(element instanceof PsiLiteralExpression)) {
                    return;
                }
                String string = ElementManipulators.getValueText((PsiElement)element);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValueText(...)");
                String dependency = string;
                SpringModulithAllowedDependencyInspection.access$checkDependency(this.this$0, dependency, this.$appModules, element, this.$holder);
            }
        };
    }

    private final void checkDependency(String dependency, List<ApplicationModule> appModules, PsiElement psiElement, ProblemsHolder holder) {
        if (StringsKt.isBlank((CharSequence)dependency)) {
            this.reportEmptyDependencyIdentifier(holder, psiElement);
            return;
        }
        ModulithDependency parsedDependency = ModulithDependency.Companion.fromString(dependency);
        if (parsedDependency == null) {
            this.reportMalformedDependency(holder, psiElement);
            return;
        }
        ModulithDependency modulithDependency = parsedDependency;
        if (modulithDependency instanceof ModulithDependency.ModuleModulithDependency) {
            boolean hasModule;
            block17: {
                Iterable $this$any$iv = appModules;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ApplicationModule it = (ApplicationModule)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)((ModulithDependency.ModuleModulithDependency)parsedDependency).getModuleId())) continue;
                        v0 = true;
                        break block17;
                    }
                    v0 = hasModule = false;
                }
            }
            if (!hasModule) {
                this.reportMissingModule(holder, psiElement, ((ModulithDependency.ModuleModulithDependency)parsedDependency).getModuleId());
            }
        } else if (modulithDependency instanceof ModulithDependency.NamedInterfaceModulithDependency) {
            boolean hasNamedInterface;
            block19: {
                Object v1;
                block18: {
                    if (StringsKt.isBlank((CharSequence)((ModulithDependency.NamedInterfaceModulithDependency)parsedDependency).getModuleId()) || StringsKt.isBlank((CharSequence)((ModulithDependency.NamedInterfaceModulithDependency)parsedDependency).getNamedInterfaceId())) {
                        this.reportMalformedDependency(holder, psiElement);
                        return;
                    }
                    Iterable $this$firstOrNull$iv = appModules;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ApplicationModule it = (ApplicationModule)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)((ModulithDependency.NamedInterfaceModulithDependency)parsedDependency).getModuleId())) continue;
                        v1 = element$iv;
                        break block18;
                    }
                    v1 = null;
                }
                ApplicationModule appModule = v1;
                if (appModule == null) {
                    this.reportMissingModule(holder, psiElement, ((ModulithDependency.NamedInterfaceModulithDependency)parsedDependency).getModuleId());
                    return;
                }
                Iterable $this$any$iv = appModule.getNamedInterfaces();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        NamedInterface it = (NamedInterface)element$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)it.getName(), (Object)((ModulithDependency.NamedInterfaceModulithDependency)parsedDependency).getNamedInterfaceId()) || Intrinsics.areEqual((Object)((ModulithDependency.NamedInterfaceModulithDependency)parsedDependency).getNamedInterfaceId(), (Object)"*"))) continue;
                        v2 = true;
                        break block19;
                    }
                    v2 = hasNamedInterface = false;
                }
            }
            if (!hasNamedInterface) {
                this.reportMissingNamedInterface(holder, psiElement, ((ModulithDependency.NamedInterfaceModulithDependency)parsedDependency).getNamedInterfaceId());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void reportEmptyDependencyIdentifier(ProblemsHolder holder, PsiElement psiElement) {
        holder.registerProblem(psiElement, SpringModulithBundle.message("inspection.invalid.dependency.empty", new Object[0]), new LocalQuickFix[0]);
    }

    private final void reportMissingModule(ProblemsHolder holder, PsiElement psiElement, String moduleId) {
        Object[] objectArray = new Object[]{moduleId};
        holder.registerProblem(psiElement, SpringModulithBundle.message("inspection.invalid.dependency.missing.module", objectArray), new LocalQuickFix[0]);
    }

    private final void reportMissingNamedInterface(ProblemsHolder holder, PsiElement psiElement, String namedInterfaceName) {
        Object[] objectArray = new Object[]{namedInterfaceName};
        holder.registerProblem(psiElement, SpringModulithBundle.message("inspection.invalid.dependency.missing.named.interface", objectArray), new LocalQuickFix[0]);
    }

    private final void reportMalformedDependency(ProblemsHolder holder, PsiElement psiElement) {
        holder.registerProblem(psiElement, SpringModulithBundle.message("inspection.invalid.dependency.malformed", new Object[0]), new LocalQuickFix[0]);
    }

    public static final /* synthetic */ void access$checkDependency(SpringModulithAllowedDependencyInspection $this, String dependency, List appModules, PsiElement psiElement, ProblemsHolder holder) {
        $this.checkDependency(dependency, appModules, psiElement, holder);
    }
}

