/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class MissingLambdaBodyFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            MissingLambdaBodyFixer.$$$reportNull$$$0(0);
        }
        ASTNode body = null;
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_LAMBDA_EXPRESSION)) {
            ASTNode lastChild = astNode.getLastChildNode();
            if (BasicJavaAstTreeUtil.is(lastChild, BasicJavaElementType.EXPRESSION_SET) || BasicJavaAstTreeUtil.is(lastChild, BasicJavaElementType.BASIC_CODE_BLOCK)) {
                body = lastChild;
            }
        } else if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_SWITCH_LABELED_RULE)) {
            body = BasicJavaAstTreeUtil.getRuleBody(astNode);
        } else {
            return;
        }
        if (body != null) {
            return;
        }
        PsiElement psiElement = BasicJavaAstTreeUtil.toPsi(astNode);
        if (psiElement == null) {
            return;
        }
        PsiElement arrow = PsiTreeUtil.getDeepestVisibleLast((PsiElement)psiElement);
        if (arrow == null || !arrow.getNode().getElementType().equals(JavaTokenType.ARROW)) {
            return;
        }
        int offset = arrow.getTextRange().getEndOffset();
        processor.insertBracesWithNewLine(editor, offset);
        editor.getCaretModel().moveToOffset(offset + 1);
        processor.commit(editor);
        processor.reformat(psiElement);
        processor.setSkipEnter(BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_LAMBDA_EXPRESSION));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/MissingLambdaBodyFixer", "apply"));
    }
}

