/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsc.refreshable;

import com.intellij.lang.typescript.tsc.refreshable.SymbolKey;
import com.intellij.lang.typescript.tsc.refreshable.TscObjectPointer;
import com.intellij.lang.typescript.tsc.refreshable.TscRefreshableObject;
import com.intellij.lang.typescript.tsc.refreshable.TypeKey;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0002*\b\b\u0002\u0010\u0004*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00040\u0005BN\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012/\u0010\b\u001a+\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\f0\t\u0012\u0006\u0010\r\u001a\u00028\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0017\u001a\u0004\u0018\u00018\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R:\u0010\b\u001a+\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\r\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001e"}, d2={"Lcom/intellij/lang/typescript/tsc/refreshable/TscObjectMapEntryPointer;", "S", "", "K", "O", "Lcom/intellij/lang/typescript/tsc/refreshable/TscObjectPointer;", "source", "Lcom/intellij/lang/typescript/tsc/refreshable/TscRefreshableObject;", "valueProvider", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "", "key", "<init>", "(Lcom/intellij/lang/typescript/tsc/refreshable/TscRefreshableObject;Lkotlin/jvm/functions/Function1;Ljava/lang/Object;)V", "getSource", "()Lcom/intellij/lang/typescript/tsc/refreshable/TscRefreshableObject;", "getValueProvider", "()Lkotlin/jvm/functions/Function1;", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getValue", "reportErrors", "", "(Z)Ljava/lang/Object;", "toString", "", "shouldIgnoreErrorRefreshing", "intellij.javascript.backend"})
public final class TscObjectMapEntryPointer<S, K, O>
implements TscObjectPointer<S, O> {
    @NotNull
    private final TscRefreshableObject<S> source;
    @NotNull
    private final Function1<S, Map<K, O>> valueProvider;
    @NotNull
    private final K key;

    public TscObjectMapEntryPointer(@NotNull TscRefreshableObject<S> source, @NotNull Function1<? super S, ? extends Map<K, ? extends O>> valueProvider, @NotNull K key) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(valueProvider, (String)"valueProvider");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.source = source;
        this.valueProvider = valueProvider;
        this.key = key;
    }

    @Override
    @NotNull
    public TscRefreshableObject<S> getSource() {
        return this.source;
    }

    @NotNull
    public final Function1<S, Map<K, O>> getValueProvider() {
        return this.valueProvider;
    }

    @NotNull
    public final K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public O getValue(boolean reportErrors) {
        S value = this.getSource().getValue();
        Map map = (Map)this.valueProvider.invoke(value);
        if (map == null && reportErrors) {
            TscRefreshableObject.Companion.logError$intellij_javascript_backend$default(TscRefreshableObject.Companion, null, () -> TscObjectMapEntryPointer.getValue$lambda$0(this, value), 1, null);
        }
        Map map2 = map;
        return map2 != null ? (O)map2.get(this.key) : null;
    }

    @Override
    @NotNull
    public String toString() {
        return "TscObjectMapEntryPointer(\nkey=" + this.key + ",\nmap=" + this.valueProvider.invoke(this.getSource().getValue()) + "\n)";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldIgnoreErrorRefreshing() {
        if (this.key instanceof TypeKey) {
            SymbolKey symbolKey = ((TypeKey)this.key).getSymbol();
            if (Intrinsics.areEqual((Object)(symbolKey != null ? symbolKey.getEscapedName() : null), (Object)"toLocaleString")) return true;
        }
        if (!(this.key instanceof SymbolKey)) return false;
        if (!Intrinsics.areEqual((Object)((SymbolKey)this.key).getEscapedName(), (Object)"toLocaleString")) return false;
        return true;
    }

    private static final String getValue$lambda$0(TscObjectMapEntryPointer this$0, Object $value) {
        return "Value provider " + this$0.valueProvider + " on source object " + this$0.getSource() + " with value\n" + $value + "\nreturned `null` in TscObjectMapEntryPointer:\n" + this$0 + ".";
    }
}

