/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ElementsHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJSRefactoringHandler
implements RefactoringActionHandler,
ElementsHandler {
    @NlsContexts.DialogTitle
    @NotNull
    private final String myRefactoringName;
    private final @NlsContexts.DialogMessage @NotNull String myCannotRefactorReason;

    public BaseJSRefactoringHandler(@NlsContexts.DialogTitle @NotNull String refactoringName, @NlsContexts.DialogMessage @NotNull String cannotRefactorReason) {
        if (refactoringName == null) {
            BaseJSRefactoringHandler.$$$reportNull$$$0(0);
        }
        if (cannotRefactorReason == null) {
            BaseJSRefactoringHandler.$$$reportNull$$$0(1);
        }
        this.myRefactoringName = refactoringName;
        this.myCannotRefactorReason = cannotRefactorReason;
    }

    public boolean isEnabledOnElements(PsiElement[] elements) {
        return elements.length == 1;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            BaseJSRefactoringHandler.$$$reportNull$$$0(2);
        }
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element2 = file.findElementAt(offset);
        while (true) {
            if (element2 instanceof JSFile) {
                element2 = JSResolveUtil.getXmlBackedClass((JSFile)((JSFile)element2));
            }
            if (element2 == null || element2 instanceof PsiFile) {
                if (element2 != null && FlexSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element2))) {
                    this.invoke(project, new PsiElement[]{XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element2))}, dataContext);
                } else {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)this.myCannotRefactorReason), (String)this.myRefactoringName, null);
                }
                return;
            }
            if (element2.getNode().getElementType() == JSElementTypes.IMPLEMENTS_LIST && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)((JSFile)element2.getContainingFile()))) {
                element2 = JSResolveUtil.getXmlBackedClass((JSFile)((JSFile)element2.getContainingFile()));
            }
            if (!JSRefactoringUtil.checkReadOnlyStatus(element2, editor, this.myRefactoringName)) {
                return;
            }
            if (JSUtils.isMember((PsiElement)element2) || element2 instanceof JSClass) {
                this.invoke(project, new PsiElement[]{element2}, dataContext);
                return;
            }
            element2 = element2.getParent();
        }
    }

    @Nullable
    protected static JSClass getClass(PsiElement element2) {
        if (element2 instanceof JSClass) {
            return (JSClass)element2;
        }
        if (element2 instanceof JSFile) {
            return JSPsiImplUtils.findClass((JSFile)((JSFile)element2));
        }
        if (element2 instanceof PsiFile && FlexSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element2))) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)((XmlFile)element2));
        }
        return JSUtils.getMemberContainingClass((PsiElement)element2);
    }

    protected boolean checkEcma(PsiElement element2, Editor editor) {
        if (!BaseJSRefactoringHandler.doCheckEcma(element2)) {
            CommonRefactoringUtil.showErrorHint((Project)element2.getProject(), (Editor)editor, (String)JavaScriptBundle.message((String)"error.not.available.in.javascript.code", (Object[])new Object[]{this.myRefactoringName}), (String)this.myRefactoringName, null);
            return false;
        }
        return true;
    }

    public static boolean doCheckEcma(PsiElement element2) {
        if (element2 instanceof XmlBackedJSClassImpl) {
            return FlexSupportLoader.isFlexMxmFile((PsiFile)element2.getContainingFile());
        }
        if (element2 instanceof XmlFile) {
            return FlexSupportLoader.isFlexMxmFile((PsiFile)((PsiFile)element2));
        }
        return element2.getContainingFile().getLanguage().isKindOf((Language)FlexSupportLoader.ECMA_SCRIPT_L4);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cannotRefactorReason";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/refactoring/BaseJSRefactoringHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

