/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenPullServerLogger;
import org.jetbrains.idea.maven.server.MavenRemoteObjectWrapper;
import org.jetbrains.idea.maven.server.MavenRemoteProcessSupportFactory;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerConnectorBase;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.server.ServerLogEvent;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 $2\u00020\u0001:\u0003\"#$B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\f\u0010\u0018\u001a\u00060\u0019R\u00020\u0000H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0002R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006%"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl;", "Lorg/jetbrains/idea/maven/server/MavenServerConnectorBase;", "project", "Lcom/intellij/openapi/project/Project;", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "vmOptions", "", "debugPort", "", "mavenDistribution", "Lorg/jetbrains/idea/maven/server/MavenDistribution;", "multimoduleDirectory", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/idea/maven/server/MavenDistribution;Ljava/lang/String;)V", "myExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "myLoggerConnectFailedCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "myDownloadConnectFailedCount", "myPullingLoggerFuture", "Ljava/util/concurrent/ScheduledFuture;", "myPullingDownloadFuture", "newStartServerTask", "Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl$StartServerTask;", "cleanUpFutures", "", "supportType", "getSupportType", "()Ljava/lang/String;", "startPullingLogger", "server", "Lorg/jetbrains/idea/maven/server/MavenServer;", "CoroutineService", "StartServerTask", "Companion", "intellij.maven"})
public class MavenServerConnectorImpl
extends MavenServerConnectorBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScheduledExecutorService myExecutor;
    @NotNull
    private final AtomicInteger myLoggerConnectFailedCount;
    @NotNull
    private final AtomicInteger myDownloadConnectFailedCount;
    @Nullable
    private ScheduledFuture<?> myPullingLoggerFuture;
    @Nullable
    private ScheduledFuture<?> myPullingDownloadFuture;
    @NotNull
    private static final Logger LOG;

    public MavenServerConnectorImpl(@NotNull Project project, @NotNull Sdk jdk, @NotNull String vmOptions, @Nullable Integer debugPort, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        Intrinsics.checkNotNullParameter((Object)vmOptions, (String)"vmOptions");
        Intrinsics.checkNotNullParameter((Object)mavenDistribution, (String)"mavenDistribution");
        Intrinsics.checkNotNullParameter((Object)multimoduleDirectory, (String)"multimoduleDirectory");
        super(project, jdk, vmOptions, mavenDistribution, multimoduleDirectory, debugPort);
        ScheduledExecutorService scheduledExecutorService = AppExecutorUtil.createBoundedScheduledExecutorService((String)"Maven connector pulling", (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"createBoundedScheduledExecutorService(...)");
        this.myExecutor = scheduledExecutorService;
        this.myLoggerConnectFailedCount = new AtomicInteger(0);
        this.myDownloadConnectFailedCount = new AtomicInteger(0);
    }

    @Override
    @NotNull
    protected StartServerTask newStartServerTask() {
        return new StartServerTask();
    }

    @Override
    protected void cleanUpFutures() {
        try {
            int count;
            MavenServerConnectorImpl.Companion.cancelFuture(this.myPullingDownloadFuture);
            MavenServerConnectorImpl.Companion.cancelFuture(this.myPullingLoggerFuture);
            if (!this.myExecutor.isShutdown()) {
                this.myExecutor.shutdownNow();
            }
            if ((count = this.myLoggerConnectFailedCount.get()) != 0) {
                MavenLog.LOG.warn("Maven pulling logger failed: " + count + " times");
            }
            if ((count = this.myDownloadConnectFailedCount.get()) != 0) {
                MavenLog.LOG.warn("Maven pulling download listener failed: " + count + " times");
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    @NotNull
    public String getSupportType() {
        String string;
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport support;
        MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mavenRemoteProcessSupport = support = this.mySupport;
        if (mavenRemoteProcessSupport == null) {
            string = "???";
        } else {
            String string2 = mavenRemoteProcessSupport.type();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"type(...)");
        }
        return string;
    }

    private final void startPullingLogger(MavenServer server) throws RemoteException {
        MavenPullServerLogger logger = server.createPullLogger(MavenRemoteObjectWrapper.ourToken);
        if (logger == null) {
            return;
        }
        this.myPullingLoggerFuture = this.myExecutor.scheduleWithFixedDelay(() -> MavenServerConnectorImpl.startPullingLogger$lambda$0(logger, this), 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private static final void startPullingLogger$lambda$0(MavenPullServerLogger $logger, MavenServerConnectorImpl this$0) {
        try {
            List list = $logger.pull();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"pull(...)");
            List logEvents = list;
            block7: for (ServerLogEvent e : logEvents) {
                switch (WhenMappings.$EnumSwitchMapping$0[e.getType().ordinal()]) {
                    case 1: {
                        MavenLog.LOG.debug(e.getMessage());
                        continue block7;
                    }
                    case 2: 
                    case 3: {
                        MavenLog.LOG.info(e.getMessage());
                        continue block7;
                    }
                    case 4: 
                    case 5: {
                        MavenLog.LOG.warn(e.getMessage());
                        continue block7;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            this$0.myLoggerConnectFailedCount.set(0);
        }
        catch (RemoteException e) {
            if (!Thread.currentThread().isInterrupted()) {
                this$0.myLoggerConnectFailedCount.incrementAndGet();
            }
            MavenLog.LOG.warn("Maven pulling logger stopped", (Throwable)e);
            ScheduledFuture<?> scheduledFuture = this$0.myPullingLoggerFuture;
            Intrinsics.checkNotNull(scheduledFuture);
            scheduledFuture.cancel(true);
        }
    }

    public static final /* synthetic */ void access$startPullingLogger(MavenServerConnectorImpl $this, MavenServer server) {
        $this.startPullingLogger(server);
    }

    static {
        Logger logger = Logger.getInstance(MavenServerConnectorImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "cancelFuture", "", "future", "Ljava/util/concurrent/ScheduledFuture;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private final void cancelFuture(ScheduledFuture<?> future) {
            if (future != null) {
                try {
                    future.cancel(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Service(value={Service.Level.PROJECT})
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl$CoroutineService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "intellij.maven"})
    private static final class CoroutineService {
        @NotNull
        private final CoroutineScope coroutineScope;

        public CoroutineService(@NotNull CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.coroutineScope = coroutineScope;
        }

        @NotNull
        public final CoroutineScope getCoroutineScope() {
            return this.coroutineScope;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl$StartServerTask;", "Ljava/lang/Runnable;", "<init>", "(Lorg/jetbrains/idea/maven/server/MavenServerConnectorImpl;)V", "run", "", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenServerConnectorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenServerConnectorImpl.kt\norg/jetbrains/idea/maven/server/MavenServerConnectorImpl$StartServerTask\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,152:1\n30#2,2:153\n*S KotlinDebug\n*F\n+ 1 MavenServerConnectorImpl.kt\norg/jetbrains/idea/maven/server/MavenServerConnectorImpl$StartServerTask\n*L\n88#1:153,2\n*E\n"})
    public final class StartServerTask
    implements Runnable {
        @Override
        public void run() {
            ProgressIndicator indicator = (ProgressIndicator)new EmptyProgressIndicator();
            Object e = MavenServerConnectorImpl.this.myMultimoduleDirectories.iterator().next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String dirForLogs = (String)e;
            MavenLog.LOG.debug("Connecting maven connector in " + dirForLogs);
            try {
                if (MavenServerConnectorImpl.this.myDebugPort != null) {
                    System.out.println((Object)("Listening for transport dt_socket at address: " + MavenServerConnectorImpl.this.myDebugPort));
                }
                Project project = MavenServerConnectorImpl.this.getProject();
                Intrinsics.checkNotNull((Object)project);
                MavenRemoteProcessSupportFactory mavenRemoteProcessSupportFactory = MavenRemoteProcessSupportFactory.forProject(project);
                Intrinsics.checkNotNullExpressionValue((Object)mavenRemoteProcessSupportFactory, (String)"forProject(...)");
                MavenRemoteProcessSupportFactory factory = mavenRemoteProcessSupportFactory;
                MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mavenRemoteProcessSupport = MavenServerConnectorImpl.this.mySupport = factory.create(MavenServerConnectorImpl.this.getJdk(), MavenServerConnectorImpl.this.getVmOptions(), MavenServerConnectorImpl.this.getMavenDistribution(), MavenServerConnectorImpl.this.getProject(), MavenServerConnectorImpl.this.myDebugPort);
                Intrinsics.checkNotNull((Object)((Object)mavenRemoteProcessSupport));
                mavenRemoteProcessSupport.onTerminate(arg_0 -> StartServerTask.run$lambda$0(MavenServerConnectorImpl.this, arg_0));
                Project project2 = MavenServerConnectorImpl.this.getProject();
                Intrinsics.checkNotNull((Object)project2);
                ComponentManager $this$service$iv = (ComponentManager)project2;
                boolean $i$f$service = false;
                Class<CoroutineService> serviceClass$iv = CoroutineService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Object t = FutureKt.asCompletableFuture((Deferred)BuildersKt.async((CoroutineScope)((CoroutineService)object).getCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result<? extends Unit>>, Object>(MavenServerConnectorImpl.this, indicator, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ MavenServerConnectorImpl this$0;
                    final /* synthetic */ ProgressIndicator $indicator;
                    {
                        this.this$0 = $receiver;
                        this.$indicator = $indicator;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final Object invokeSuspend(Object $result) {
                        CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object;
                                void $this$async;
                                ResultKt.throwOnFailure((Object)$result);
                                void var3_3 = $this$async;
                                MavenServerConnectorImpl mavenServerConnectorImpl = this.this$0;
                                ProgressIndicator progressIndicator = this.$indicator;
                                try {
                                    void $this$invokeSuspend_u24lambda_u240 = var3_3;
                                    boolean bl = false;
                                    MavenRemoteProcessSupportFactory.MavenRemoteProcessSupport mavenRemoteProcessSupport = mavenServerConnectorImpl.mySupport;
                                    Intrinsics.checkNotNull((Object)((Object)mavenRemoteProcessSupport));
                                    MavenServer server = (MavenServer)mavenRemoteProcessSupport.acquire($this$invokeSuspend_u24lambda_u240, "", progressIndicator);
                                    Intrinsics.checkNotNull((Object)server);
                                    MavenServerConnectorImpl.access$startPullingLogger(mavenServerConnectorImpl, server);
                                    mavenServerConnectorImpl.myServerPromise.setResult((Object)server);
                                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                                }
                                catch (Throwable throwable) {
                                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                                }
                                return Result.box-impl((Object)object);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Result<Unit>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }))).get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                Object object2 = ((Result)t).unbox-impl();
                ResultKt.throwOnFailure((Object)object2);
                MavenLog.LOG.debug("[connector] in " + dirForLogs + " has been connected " + MavenServerConnectorImpl.this);
            }
            catch (Throwable e2) {
                MavenLog.LOG.warn("[connector] cannot connect in " + dirForLogs, e2);
                MavenServerConnectorImpl.this.myServerPromise.setError(e2);
            }
        }

        private static final void run$lambda$0(MavenServerConnectorImpl this$0, ProcessEvent it) {
            block0: {
                MavenServerManager mavenServerManager;
                MavenLog.LOG.debug("[connector] terminate " + this$0);
                MavenServerManager mavenServerManager2 = mavenServerManager = (MavenServerManager)ApplicationManager.getApplication().getServiceIfCreated(MavenServerManager.class);
                if (mavenServerManager2 == null) break block0;
                mavenServerManager2.shutdownConnector(this$0, false);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ServerLogEvent.Type.values().length];
            try {
                nArray[ServerLogEvent.Type.DEBUG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerLogEvent.Type.PRINT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerLogEvent.Type.INFO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerLogEvent.Type.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServerLogEvent.Type.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

