/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editing;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/javascript/editing/JSLineIndentProvider;", "Lcom/intellij/psi/impl/source/codeStyle/lineIndent/JavaLikeLangLineIndentProvider;", "<init>", "()V", "isSuitableForLanguage", "", "language", "Lcom/intellij/lang/Language;", "mapType", "Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition$SyntaxElement;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "Companion", "intellij.javascript.psi.impl"})
public final class JSLineIndentProvider
extends JavaLikeLangLineIndentProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP;

    public boolean isSuitableForLanguage(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language.isKindOf((Language)JavascriptLanguage.INSTANCE) && !JSLineIndentProvider.Companion.isActionScript(language);
    }

    @Nullable
    protected SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return SYNTAX_MAP.get(tokenType);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)JSTokenTypes.WHITE_SPACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace), TuplesKt.to((Object)JSTokenTypes.SEMICOLON, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon), TuplesKt.to((Object)JSTokenTypes.LBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace), TuplesKt.to((Object)JSTokenTypes.RBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace), TuplesKt.to((Object)JSTokenTypes.XML_LBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace), TuplesKt.to((Object)JSTokenTypes.XML_RBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace), TuplesKt.to((Object)JSTokenTypes.XML_START_TAG_START, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace), TuplesKt.to((Object)JSTokenTypes.XML_END_TAG_START, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace), TuplesKt.to((Object)JSTokenTypes.XML_EMPTY_TAG_END, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace), TuplesKt.to((Object)JSTokenTypes.LBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket), TuplesKt.to((Object)JSTokenTypes.RBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket), TuplesKt.to((Object)JSTokenTypes.LPAR, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis), TuplesKt.to((Object)JSTokenTypes.RPAR, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis), TuplesKt.to((Object)JSTokenTypes.COLON, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon), TuplesKt.to((Object)JSTokenTypes.CASE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase), TuplesKt.to((Object)JSTokenTypes.DEFAULT_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault), TuplesKt.to((Object)JSTokenTypes.IF_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword), TuplesKt.to((Object)JSTokenTypes.ELSE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword), TuplesKt.to((Object)JSTokenTypes.FOR_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword), TuplesKt.to((Object)JSTokenTypes.DO_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword), TuplesKt.to((Object)JSTokenTypes.C_STYLE_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment), TuplesKt.to((Object)JSDocTokenTypes.DOC_COMMENT_END, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.DocBlockEnd), TuplesKt.to((Object)JSDocTokenTypes.DOC_COMMENT_START, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.DocBlockStart), TuplesKt.to((Object)JSTokenTypes.COMMA, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma), TuplesKt.to((Object)JSTokenTypes.END_OF_LINE_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment)};
        SYNTAX_MAP = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/lang/javascript/editing/JSLineIndentProvider$Companion;", "", "<init>", "()V", "SYNTAX_MAP", "", "Lcom/intellij/psi/tree/IElementType;", "Lcom/intellij/psi/impl/source/codeStyle/SemanticEditorPosition$SyntaxElement;", "isActionScript", "", "language", "Lcom/intellij/lang/Language;", "intellij.javascript.psi.impl"})
    private static final class Companion {
        private Companion() {
        }

        private final boolean isActionScript(Language language) {
            return language instanceof JSLanguageDialect && ((JSLanguageDialect)language).getOptionHolder().isECMA4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

