//! For each operating system, list the signals that can be caught.

#[cfg(target_os = "freebsd")]
pub const SIGNALS: &[libc::c_int] = &[
    libc::SIGHUP,
    libc::SIGINT,
    libc::SIGQUIT,
    libc::SIGILL,
    libc::SIGTRAP,
    libc::SIGABRT,
    libc::SIGEMT,
    libc::SIGFPE,
    libc::SIGKILL,
    libc::SIGBUS,
    libc::SIGSEGV,
    libc::SIGSYS,
    libc::SIGPIPE,
    libc::SIGALRM,
    libc::SIGTERM,
    libc::SIGURG,
    libc::SIGSTOP,
    libc::SIGTSTP,
    libc::SIGCONT,
    libc::SIGCHLD,
    libc::SIGTTIN,
    libc::SIGTTOU,
    libc::SIGIO,
    libc::SIGXCPU,
    libc::SIGXFSZ,
    libc::SIGVTALRM,
    libc::SIGPROF,
    libc::SIGWINCH,
    libc::SIGINFO,
    libc::SIGUSR1,
    libc::SIGUSR2,
    libc::SIGTHR,
    libc::SIGLIBRT,
];

#[cfg(target_os = "openbsd")]
pub const SIGNALS: &[libc::c_int] = &[
    libc::SIGHUP,
    libc::SIGINT,
    libc::SIGQUIT,
    libc::SIGILL,
    libc::SIGTRAP,
    libc::SIGABRT,
    libc::SIGEMT,
    libc::SIGKILL,
    libc::SIGBUS,
    libc::SIGSEGV,
    libc::SIGSYS,
    libc::SIGPIPE,
    libc::SIGALRM,
    libc::SIGTERM,
    libc::SIGURG,
    libc::SIGSTOP,
    libc::SIGTSTP,
    libc::SIGCONT,
    libc::SIGCHLD,
    libc::SIGTTIN,
    libc::SIGTTOU,
    libc::SIGIO,
    libc::SIGXCPU,
    libc::SIGXFSZ,
    libc::SIGVTALRM,
    libc::SIGPROF,
    libc::SIGWINCH,
    libc::SIGINFO,
    libc::SIGUSR1,
    libc::SIGUSR2,
    libc::SIGTHR,
];

#[cfg(any(target_os = "android", target_os = "linux"))]
pub const SIGNALS: &[libc::c_int] = &[
    libc::SIGHUP,
    libc::SIGINT,
    libc::SIGQUIT,
    libc::SIGILL,
    libc::SIGTRAP,
    libc::SIGABRT,
    libc::SIGBUS,
    libc::SIGFPE,
    libc::SIGKILL,
    libc::SIGUSR1,
    libc::SIGSEGV,
    libc::SIGUSR2,
    libc::SIGPIPE,
    libc::SIGALRM,
    libc::SIGTERM,
    libc::SIGSTKFLT,
    libc::SIGCHLD,
    libc::SIGCONT,
    libc::SIGSTOP,
    libc::SIGTSTP,
    libc::SIGTTIN,
    libc::SIGTTOU,
    libc::SIGURG,
    libc::SIGXCPU,
    libc::SIGXFSZ,
    libc::SIGVTALRM,
    libc::SIGPROF,
    libc::SIGWINCH,
    libc::SIGIO,
    libc::SIGPWR,
    libc::SIGSYS,
];

#[cfg(target_os = "macos")]
pub const SIGNALS: &[libc::c_int] = &[
    libc::SIGHUP,
    libc::SIGINT,
    libc::SIGQUIT,
    libc::SIGILL,
    libc::SIGTRAP,
    libc::SIGABRT,
    libc::SIGEMT,
    libc::SIGFPE,
    libc::SIGKILL,
    libc::SIGBUS,
    libc::SIGSEGV,
    libc::SIGSYS,
    libc::SIGPIPE,
    libc::SIGALRM,
    libc::SIGTERM,
    libc::SIGURG,
    libc::SIGSTOP,
    libc::SIGTSTP,
    libc::SIGCONT,
    libc::SIGCHLD,
    libc::SIGTTIN,
    libc::SIGTTOU,
    libc::SIGIO,
    libc::SIGXCPU,
    libc::SIGXFSZ,
    libc::SIGVTALRM,
    libc::SIGPROF,
    libc::SIGWINCH,
    libc::SIGINFO,
    libc::SIGUSR1,
    libc::SIGUSR2,
];

#[cfg(any(target_os = "solaris", target_os = "illumos"))]
pub const SIGNALS: &[libc::c_int] = &[
    libc::SIGHUP,
    libc::SIGINT,
    libc::SIGQUIT,
    libc::SIGILL,
    libc::SIGTRAP,
    libc::SIGABRT,
    libc::SIGEMT,
    libc::SIGFPE,
    libc::SIGKILL,
    libc::SIGBUS,
    libc::SIGSEGV,
    libc::SIGSYS,
    libc::SIGPIPE,
    libc::SIGALRM,
    libc::SIGTERM,
    libc::SIGUSR1,
    libc::SIGUSR2,
    libc::SIGCHLD,
    libc::SIGPWR,
    libc::SIGWINCH,
    libc::SIGURG,
    libc::SIGPOLL,
    libc::SIGSTOP,
    libc::SIGTSTP,
    libc::SIGCONT,
    libc::SIGTTIN,
    libc::SIGTTOU,
    libc::SIGVTALRM,
    libc::SIGPROF,
    libc::SIGXCPU,
    libc::SIGXFSZ,
    libc::SIGWAITING,
    libc::SIGLWP,
    libc::SIGFREEZE,
    libc::SIGTHAW,
    libc::SIGCANCEL,
    libc::SIGLOST,
    libc::SIGXRES,
    libc::SIGJVM1,
    libc::SIGJVM2,
];
