// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::invoke_model_with_response_stream::_invoke_model_with_response_stream_output::InvokeModelWithResponseStreamOutputBuilder;

pub use crate::operation::invoke_model_with_response_stream::_invoke_model_with_response_stream_input::InvokeModelWithResponseStreamInputBuilder;

impl crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.invoke_model_with_response_stream();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `InvokeModelWithResponseStream`.
///
/// <p>Invoke the specified Amazon Bedrock model to run inference using the prompt and inference parameters provided in the request body. The response is returned in a stream.</p>
/// <p>To see if a model supports streaming, call <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetFoundationModel.html">GetFoundationModel</a> and check the <code>responseStreamingSupported</code> field in the response.</p><note>
/// <p>The CLI doesn't support streaming operations in Amazon Bedrock, including <code>InvokeModelWithResponseStream</code>.</p>
/// </note>
/// <p>For example code, see <i>Invoke model with streaming code example</i> in the <i>Amazon Bedrock User Guide</i>.</p>
/// <p>This operation requires permissions to perform the <code>bedrock:InvokeModelWithResponseStream</code> action.</p><important>
/// <p>To deny all inference access to resources that you specify in the modelId field, you need to deny access to the <code>bedrock:InvokeModel</code> and <code>bedrock:InvokeModelWithResponseStream</code> actions. Doing this also denies access to the resource through the Converse API actions (<a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_ConverseStream.html">ConverseStream</a>). For more information see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/security_iam_id-based-policy-examples.html#security_iam_id-based-policy-examples-deny-inference">Deny access for inference on specific models</a>.</p>
/// </important>
/// <p>For troubleshooting some of the common errors you might encounter when using the <code>InvokeModelWithResponseStream</code> API, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/troubleshooting-api-error-codes.html">Troubleshooting Amazon Bedrock API Error Codes</a> in the Amazon Bedrock User Guide</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct InvokeModelWithResponseStreamFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamOutput,
        crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError,
    > for InvokeModelWithResponseStreamFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamOutput,
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl InvokeModelWithResponseStreamFluentBuilder {
    /// Creates a new `InvokeModelWithResponseStreamFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the InvokeModelWithResponseStream as a reference.
    pub fn as_input(&self) -> &crate::operation::invoke_model_with_response_stream::builders::InvokeModelWithResponseStreamInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStream::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        let mut output =
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStream::orchestrate(&runtime_plugins, input).await?;

        // Converts any error encountered beyond this point into an `SdkError` response error
        // with an `HttpResponse`. However, since we have already exited the `orchestrate`
        // function, the original `HttpResponse` is no longer available and cannot be restored.
        // This means that header information from the original response has been lost.
        //
        // Note that the response body would have been consumed by the deserializer
        // regardless, even if the initial message was hypothetically processed during
        // the orchestrator's deserialization phase but later resulted in an error.
        fn response_error(
            err: impl ::std::convert::Into<::aws_smithy_runtime_api::box_error::BoxError>,
        ) -> ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        > {
            ::aws_smithy_runtime_api::client::result::SdkError::response_error(
                err,
                ::aws_smithy_runtime_api::client::orchestrator::HttpResponse::new(
                    ::aws_smithy_runtime_api::http::StatusCode::try_from(200).expect("valid successful code"),
                    ::aws_smithy_types::body::SdkBody::empty(),
                ),
            )
        }

        let message = output.body.try_recv_initial_response().await.map_err(response_error)?;

        match message {
            ::std::option::Option::Some(_message) => ::std::result::Result::Ok(output),
            ::std::option::Option::None => ::std::result::Result::Ok(output),
        }
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamOutput,
        crate::operation::invoke_model_with_response_stream::InvokeModelWithResponseStreamError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// <p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p>
    pub fn body(mut self, input: ::aws_smithy_types::Blob) -> Self {
        self.inner = self.inner.body(input);
        self
    }
    /// <p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p>
    pub fn set_body(mut self, input: ::std::option::Option<::aws_smithy_types::Blob>) -> Self {
        self.inner = self.inner.set_body(input);
        self
    }
    /// <p>The prompt and inference parameters in the format specified in the <code>contentType</code> in the header. You must provide the body in JSON format. To see the format and content of the request and response bodies for different models, refer to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/api-methods-run.html">Run inference</a> in the Bedrock User Guide.</p>
    pub fn get_body(&self) -> &::std::option::Option<::aws_smithy_types::Blob> {
        self.inner.get_body()
    }
    /// <p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p>
    pub fn content_type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.content_type(input.into());
        self
    }
    /// <p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p>
    pub fn set_content_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_content_type(input);
        self
    }
    /// <p>The MIME type of the input data in the request. You must specify <code>application/json</code>.</p>
    pub fn get_content_type(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_content_type()
    }
    /// <p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p>
    pub fn accept(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.accept(input.into());
        self
    }
    /// <p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p>
    pub fn set_accept(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_accept(input);
        self
    }
    /// <p>The desired MIME type of the inference body in the response. The default value is <code>application/json</code>.</p>
    pub fn get_accept(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_accept()
    }
    /// <p>The unique identifier of the model to invoke to run inference.</p>
    /// <p>The <code>modelId</code> to provide depends on the type of model or throughput that you use:</p>
    /// <ul>
    /// <li>
    /// <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile IDs, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a custom model, specify the ARN of the custom model deployment (for on-demand inference) or the ARN of your provisioned model (for Provisioned Throughput). For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.</p></li>
    /// </ul>
    pub fn model_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.model_id(input.into());
        self
    }
    /// <p>The unique identifier of the model to invoke to run inference.</p>
    /// <p>The <code>modelId</code> to provide depends on the type of model or throughput that you use:</p>
    /// <ul>
    /// <li>
    /// <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile IDs, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a custom model, specify the ARN of the custom model deployment (for on-demand inference) or the ARN of your provisioned model (for Provisioned Throughput). For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.</p></li>
    /// </ul>
    pub fn set_model_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_model_id(input);
        self
    }
    /// <p>The unique identifier of the model to invoke to run inference.</p>
    /// <p>The <code>modelId</code> to provide depends on the type of model or throughput that you use:</p>
    /// <ul>
    /// <li>
    /// <p>If you use a base model, specify the model ID or its ARN. For a list of model IDs for base models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#model-ids-arns">Amazon Bedrock base model IDs (on-demand throughput)</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an inference profile, specify the inference profile ID or its ARN. For a list of inference profile IDs, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference-support.html">Supported Regions and models for cross-region inference</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a provisioned model, specify the ARN of the Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-thru-use.html">Run inference using a Provisioned Throughput</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use a custom model, specify the ARN of the custom model deployment (for on-demand inference) or the ARN of your provisioned model (for Provisioned Throughput). For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-use.html">Use a custom model in Amazon Bedrock</a> in the Amazon Bedrock User Guide.</p></li>
    /// <li>
    /// <p>If you use an <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">imported model</a>, specify the ARN of the imported model. You can get the model ARN from a successful call to <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateModelImportJob.html">CreateModelImportJob</a> or from the Imported models page in the Amazon Bedrock console.</p></li>
    /// </ul>
    pub fn get_model_id(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_model_id()
    }
    /// <p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p>
    pub fn trace(mut self, input: crate::types::Trace) -> Self {
        self.inner = self.inner.trace(input);
        self
    }
    /// <p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p>
    pub fn set_trace(mut self, input: ::std::option::Option<crate::types::Trace>) -> Self {
        self.inner = self.inner.set_trace(input);
        self
    }
    /// <p>Specifies whether to enable or disable the Bedrock trace. If enabled, you can see the full Bedrock trace.</p>
    pub fn get_trace(&self) -> &::std::option::Option<crate::types::Trace> {
        self.inner.get_trace()
    }
    /// <p>The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is applied to the invocation.</p>
    /// <p>An error is thrown in the following situations.</p>
    /// <ul>
    /// <li>
    /// <p>You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p></li>
    /// <li>
    /// <p>You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.</p></li>
    /// <li>
    /// <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.</p></li>
    /// </ul>
    pub fn guardrail_identifier(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.guardrail_identifier(input.into());
        self
    }
    /// <p>The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is applied to the invocation.</p>
    /// <p>An error is thrown in the following situations.</p>
    /// <ul>
    /// <li>
    /// <p>You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p></li>
    /// <li>
    /// <p>You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.</p></li>
    /// <li>
    /// <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.</p></li>
    /// </ul>
    pub fn set_guardrail_identifier(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_guardrail_identifier(input);
        self
    }
    /// <p>The unique identifier of the guardrail that you want to use. If you don't provide a value, no guardrail is applied to the invocation.</p>
    /// <p>An error is thrown in the following situations.</p>
    /// <ul>
    /// <li>
    /// <p>You don't provide a guardrail identifier but you specify the <code>amazon-bedrock-guardrailConfig</code> field in the request body.</p></li>
    /// <li>
    /// <p>You enable the guardrail but the <code>contentType</code> isn't <code>application/json</code>.</p></li>
    /// <li>
    /// <p>You provide a guardrail identifier, but <code>guardrailVersion</code> isn't specified.</p></li>
    /// </ul>
    pub fn get_guardrail_identifier(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_guardrail_identifier()
    }
    /// <p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p>
    pub fn guardrail_version(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.guardrail_version(input.into());
        self
    }
    /// <p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p>
    pub fn set_guardrail_version(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_guardrail_version(input);
        self
    }
    /// <p>The version number for the guardrail. The value can also be <code>DRAFT</code>.</p>
    pub fn get_guardrail_version(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_guardrail_version()
    }
    /// <p>Model performance settings for the request.</p>
    pub fn performance_config_latency(mut self, input: crate::types::PerformanceConfigLatency) -> Self {
        self.inner = self.inner.performance_config_latency(input);
        self
    }
    /// <p>Model performance settings for the request.</p>
    pub fn set_performance_config_latency(mut self, input: ::std::option::Option<crate::types::PerformanceConfigLatency>) -> Self {
        self.inner = self.inner.set_performance_config_latency(input);
        self
    }
    /// <p>Model performance settings for the request.</p>
    pub fn get_performance_config_latency(&self) -> &::std::option::Option<crate::types::PerformanceConfigLatency> {
        self.inner.get_performance_config_latency()
    }
}
