
/******************************************/
/* Begin Kernel                           */
/******************************************/
.amdgcn_target "amdgcn-amd-amdhsa--gfx942"
.text
.protected Custom_Cijk_Ailk_Bljk_F8NH_HHS_BH_Bias_AS_SAB_SAV_shortname0_gfx942
.globl Custom_Cijk_Ailk_Bljk_F8NH_HHS_BH_Bias_AS_SAB_SAV_shortname0_gfx942
.p2align 8
.type Custom_Cijk_Ailk_Bljk_F8NH_HHS_BH_Bias_AS_SAB_SAV_shortname0_gfx942,@function
.section .rodata,#alloc
.p2align 6
.amdhsa_kernel Custom_Cijk_Ailk_Bljk_F8NH_HHS_BH_Bias_AS_SAB_SAV_shortname0_gfx942
  .amdhsa_user_sgpr_kernarg_segment_ptr 1
  .amdhsa_accum_offset 128 // accvgpr offset
  .amdhsa_next_free_vgpr 256 // vgprs
  .amdhsa_next_free_sgpr 80 // sgprs
  .amdhsa_group_segment_fixed_size 4096 // lds bytes
  .amdhsa_private_segment_fixed_size 0
  .amdhsa_system_sgpr_workgroup_id_x 1
  .amdhsa_system_sgpr_workgroup_id_y 1
  .amdhsa_system_sgpr_workgroup_id_z 1
  .amdhsa_system_vgpr_workitem_id 0
  .amdhsa_float_denorm_mode_32 3
  .amdhsa_float_denorm_mode_16_64 3
.end_amdhsa_kernel
.text
/* Num VGPR   =96 */
/* Num AccVGPR=32 */
/* Num SGPR   =80 */

/******************************************/
/* Optimizations and Config:              */
/******************************************/
/* ThreadTile= 32 x 1 */
/* SubGroup= 16 x 16 */
/* VectorWidthA=8 */
/* VectorWidthB=1 */
/* GlobalReadVectorWidthA=8, GlobalReadVectorWidthB=2 */
/* DirectToLdsA=False */
/* DirectToLdsB=False */
/* UseSgprForGRO=1 */
.amdgpu_metadata
---
custom.config:
   ProblemType:
      OperationType: GEMM
      DataTypeA: f8n
      DataTypeB: h
      UseScaleAB: "Scalar"
      DataType: h
      DestDataType: h
      ComputeDataType: s
      HighPrecisionAccumulate: True
      TransposeA: False
      TransposeB: False
      UseBeta: True
      Batched: True
      UseBias: 1
      Activation: True
      UseScaleAlphaVec: 1
   1LDSBuffer: 1
   DepthU: 32
   StaggerU: 4
   WorkGroupMapping: 1
   WaveSeparateGlobalReadA: 0
   WaveSeparateGlobalReadB: 0
   GlobalReadVectorWidthA: 8
   GlobalReadVectorWidthB: 2
   AssertFree0ElementMultiple: 8
   AssertSummationElementMultiple: 1
   GlobalSplitU: 16
   GlobalSplitUAlgorithm: MultipleBuffer
   InternalSupportParams: {KernArgsVersion: 0, SupportCustomWGM: True, SupportUserGSU: True, SupportCustomStaggerU: True, UseUniversalArgs: False}
   PreloadKernArgs: 0
   NoReject: 1
amdhsa.version:
  - 1
  - 1
amdhsa.kernels:
  - .name: Custom_Cijk_Ailk_Bljk_F8NH_HHS_BH_Bias_AS_SAB_SAV_shortname0_gfx942
    .symbol: 'Custom_Cijk_Ailk_Bljk_F8NH_HHS_BH_Bias_AS_SAB_SAV_shortname0_gfx942.kd'
    .language:                   OpenCL C
    .language_version:
      - 2
      - 0
    .args:
      - .name:            SizesFree0
        .size:            4
        .offset:          0
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesFree1
        .size:            4
        .offset:          4
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesFree2
        .size:            4
        .offset:          8
        .value_kind:      by_value
        .value_type:      u32
      - .name:            SizesSum0
        .size:            4
        .offset:          12
        .value_kind:      by_value
        .value_type:      u32
      - .name:            D
        .size:            8
        .offset:          16
        .value_kind:      global_buffer
        .value_type:      f16
        .address_space:   generic
      - .name:            C
        .size:            8
        .offset:          24
        .value_kind:      global_buffer
        .value_type:      f16
        .address_space:   generic
      - .name:            A
        .size:            8
        .offset:          32
        .value_kind:      global_buffer
        .value_type:      f16
        .address_space:   generic
      - .name:            B
        .size:            8
        .offset:          40
        .value_kind:      global_buffer
        .value_type:      f16
        .address_space:   generic
      - .name:            strideD0
        .size:            4
        .offset:          48
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideD1
        .size:            4
        .offset:          52
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideC0
        .size:            4
        .offset:          56
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideC1
        .size:            4
        .offset:          60
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideA0
        .size:            4
        .offset:          64
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideA1
        .size:            4
        .offset:          68
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideB0
        .size:            4
        .offset:          72
        .value_kind:      by_value
        .value_type:      u32
      - .name:            strideB1
        .size:            4
        .offset:          76
        .value_kind:      by_value
        .value_type:      u32
      - .name:            alpha
        .size:            4
        .offset:          80
        .value_kind:      by_value
        .value_type:      f32
      - .name:            beta
        .size:            4
        .offset:          84
        .value_kind:      by_value
        .value_type:      f32
      - .name:            internalArgs
        .size:            4
        .offset:          88
        .value_kind:      by_value
        .value_type:      u32
      - .name:            AddressScaleA
        .size:            8
        .offset:          92
        .value_kind:      global_buffer
        .value_type:      f32
        .address_space:   generic
      - .name:            AddressScaleB
        .size:            8
        .offset:          100
        .value_kind:      global_buffer
        .value_type:      f32
        .address_space:   generic
      - .name:            AddressScaleAlphaVec
        .size:            8
        .offset:          108
        .value_kind:      global_buffer
        .value_type:      f32
        .address_space:   generic
      - .name:            bias
        .size:            8
        .offset:          116
        .value_kind:      global_buffer
        .value_type:      void
        .address_space:   generic
      - .name:            biasType
        .size:            4
        .offset:          124
        .value_kind:      by_value
        .value_type:      u32
      - .name:            StrideBias
        .size:            4
        .offset:          128
        .value_kind:      by_value
        .value_type:      u32
      - .name:            activationAlpha
        .size:            4
        .offset:          132
        .value_kind:      by_value
        .value_type:      f32
      - .name:            activationBeta
        .size:            4
        .offset:          136
        .value_kind:      by_value
        .value_type:      f32
      - .name:            activationType
        .size:            4
        .offset:          140
        .value_kind:      by_value
        .value_type:      u32
    .group_segment_fixed_size:   4096
    .kernarg_segment_align:      8
    .kernarg_segment_size:       144
    .max_flat_workgroup_size:    256
    .private_segment_fixed_size: 0
    .sgpr_count:                 80
    .sgpr_spill_count:           0
    .vgpr_count:                 96
    .vgpr_spill_count:           0
    .wavefront_size:             64
...
.end_amdgpu_metadata
Custom_Cijk_Ailk_Bljk_F8NH_HHS_BH_Bias_AS_SAB_SAV_shortname0_gfx942:
.long 0xC0120600, 0x00000000
.long 0xC00A0A00, 0x00000040
.long 0xC0060B00, 0x00000050
.long 0xC0020B80, 0x00000058
.long 0xBEC100FF, 0x05040100
.long 0xBEC200FF, 0x07060302
.long 0xBEFC00FF, 0x00001000
.long 0x7E920300
.long 0x260292BF
.long 0x2600028F
.long 0x20020284
.long 0x26020280
.long 0x24020284
.long 0x68000101
.long 0x24000083
.long 0x260292BF
.long 0x20020284
.long 0x2402028B
.long 0x68000101
.long 0x20029286
.long 0x26020283
.long 0x24020287
.long 0x68000101
.long 0x260492BF
.long 0x2602048F
.long 0x24020285
.long 0x20040484
.long 0x26040480
.long 0x24040489
.long 0x68020302
.long 0x260492BF
.long 0x20040484
.long 0x24040482
.long 0x68020302
.long 0x20009288
.long 0xBECA0090
.long 0xD2850000, 0x0002004A
.long 0xD1FE0024, 0x02060300
.long 0x20044887
.long 0x24040483
.long 0x68484902
.long 0x20029286
.long 0x260092BF
.long 0x24000083
.long 0x7E080301
.long 0x20049284
.long 0x2606928F
.long 0x24060681
.long 0x7E0A0303
.long 0x104A04A0
.long 0xD1FE0025, 0x02064B05
.long 0x200C4A87
.long 0x240C0C83
.long 0x684A4B06
.long 0xBF8CC07F
.long 0x8609FF2E, 0x0000FF00
.long 0x8F098809
.long 0x862FFF2E, 0xFFFF0000
.long 0x8F2F902F
.long 0x862EFF2E, 0x000000FF
.long 0x7E1002FF, 0x00000200
.long 0x7E0E0218
.long 0x7E0C0D08
.long 0x7E0C4706
.long 0x7E120D07
.long 0x0A0C1306
.long 0x7E0C0F06
.long 0x10121106
.long 0x6A121307
.long 0xD0CD006A, 0x00010109
.long 0xD11C6A06, 0x01A90106
.long 0x7E100290
.long 0x7E0E0219
.long 0x7E280506
.long 0x7E0C0D08
.long 0x7E0C4706
.long 0x7E120D07
.long 0x0A0C1306
.long 0x7E0C0F06
.long 0x10121106
.long 0x6A121307
.long 0xD0CD006A, 0x00010109
.long 0xD11C6A06, 0x01A90106
.long 0xBF800000
.long 0x7E2A0506
.long 0x80A08820
.long 0x82A18021
.long 0x80A28422
.long 0x82A38023
.long 0xD042006A, 0x0001002C
.long 0xBF860001
.long 0xBE9B0080
.long 0xBF06812E
.long 0xBF850012
.long 0x7E0C0C2E
.long 0x7E0C4706
.long 0x7E0E0C03
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00005D06
.long 0x6A0E0E03
.long 0xD0DA007E, 0x00005D07
.long 0x680C0C81
.long 0x7E0E0280
.long 0xBEFE01C1
.long 0x7E060506
.long 0x7E0C0507
.long 0xBE850081
.long 0xBE880082
.long 0xBF820003
.long 0xBE860180
.long 0xBE850081
.long 0xBE880081
.long 0xBF0B8109
.long 0xBF850035
.long 0x7E0C0C09
.long 0x7E0C4706
.long 0x7E0E0C03
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00001306
.long 0x6A0E0E03
.long 0xD0DA007E, 0x00001307
.long 0x680C0C81
.long 0xBEFE01C1
.long 0x7E980506
.long 0x924D094C
.long 0x80CD4D03
.long 0x924D144D
.long 0x804D024D
.long 0x7E0C0C09
.long 0x7E0C4706
.long 0x7E0E0C15
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00001306
.long 0x6A0E0E15
.long 0xD0DA007E, 0x00001307
.long 0x680C0C81
.long 0xBEFE01C1
.long 0x7E940506
.long 0x924B4A09
.long 0x80CE4B15
.long 0xBF06804E
.long 0xBECE0209
.long 0xBF094A4C
.long 0x854A094E
.long 0x7E0C0C4A
.long 0x7E0C4706
.long 0x7E0E0C4D
.long 0x0A0C0F06
.long 0x7E0C0F06
.long 0xD1080007, 0x00009506
.long 0x6A0E0E4D
.long 0xD0DA007E, 0x00009507
.long 0x680C0C81
.long 0x7E0E0280
.long 0xBEFE01C1
.long 0x7E040506
.long 0x7E060507
.long 0x924C094C
.long 0x80034C03
.long 0x260292BF
.long 0x2600028F
.long 0x24000083
.long 0x20020284
.long 0xD2850001, 0x00020284
.long 0xD2850001, 0x00020228
.long 0x68000101
.long 0x20029286
.long 0x26020283
.long 0x24020287
.long 0x684C0101
.long 0x684C4C88
.long 0x92438128
.long 0x92448228
.long 0x92458328
.long 0x92469028
.long 0x92479128
.long 0x92489228
.long 0x92499328
.long 0xD2850006, 0x0002042A
.long 0x324E0D03
.long 0x684E4E82
.long 0x244E4E81
.long 0x964DFF02, 0x00000200
.long 0x924CFF02, 0x00000200
.long 0x964B06A0
.long 0x924A06A0
.long 0x964B284A
.long 0x924A284A
.long 0x804C4A4C
.long 0x824D4B4D
.long 0xBE960081
.long 0xBE970080
.long 0x80CA8118
.long 0x964B4A81
.long 0x924A4A81
.long 0x80164A16
.long 0x82174B17
.long 0x80CA811B
.long 0x964B4A28
.long 0x924A4A28
.long 0x80164A16
.long 0x82174B17
.long 0x80964C16
.long 0x82974D17
.long 0x80168816
.long 0x82178017
.long 0xBF068017
.long 0x8532C116
.long 0x964B0429
.long 0x924A0429
.long 0x804C4A4C
.long 0x824D4B4D
.long 0x80304C20
.long 0x82314D21
.long 0xBEB300FF, 0x00020000
.long 0x964D9003
.long 0x924C9003
.long 0x964D2A4C
.long 0x924C2A4C
.long 0x964B06A0
.long 0x924A06A0
.long 0x804C4A4C
.long 0x824D4B4D
.long 0xBEB80081
.long 0xBEB90080
.long 0x80CA811B
.long 0x964B4A81
.long 0x924A4A81
.long 0x80384A38
.long 0x82394B39
.long 0x80CA8119
.long 0x964B4A2A
.long 0x924A4A2A
.long 0x80384A38
.long 0x82394B39
.long 0x80B84C38
.long 0x82B94D39
.long 0x8EB88138
.long 0x80388438
.long 0x82398039
.long 0xBF068039
.long 0x8536C138
.long 0x964B042B
.long 0x924A042B
.long 0x804C4A4C
.long 0x824D4B4D
.long 0x8ECC814C
.long 0x80344C22
.long 0x82354D23
.long 0xBEB700FF, 0x00020000
.long 0x924AA02E
.long 0x923F284A
.long 0x8731F531
.long 0x8735F535
.long 0x924AC02E
.long 0xBEC0004A
.long 0x8F0A851B
.long 0xBF06812E
.long 0xBF850012
.long 0x7E000C2E
.long 0x7E004700
.long 0x7E020C0A
.long 0x0A000300
.long 0x7E000F00
.long 0xD1080001, 0x00005D00
.long 0x6A02020A
.long 0xD0DA007E, 0x00005D01
.long 0x68000081
.long 0x7E020280
.long 0xBEFE01C1
.long 0x7E140500
.long 0x7E0E0501
.long 0x804A0A81
.long 0xBF0A0706
.long 0xBE8A024A
.long 0xBE8B000A
.long 0x864CFF2F, 0x00001F00
.long 0x8F4C884C
.long 0x864DFF2F, 0x0000E000
.long 0x862FFF2F, 0x000000FF
.long 0xBECA002F
.long 0x8E4B4C4A
.long 0xBF094B0B
.long 0xBF850002
.long 0x8F4A814A
.long 0xBF82FFFB
.long 0x80CB814A
.long 0xBF09814A
.long 0x853A804B
.long 0xBF06804D
.long 0xBF850002
.long 0xBECA0002
.long 0xBF820016
.long 0xBF06FF4D, 0x00002000
.long 0xBF850002
.long 0xBECA0003
.long 0xBF820011
.long 0xBF06FF4D, 0x00004000
.long 0xBF850002
.long 0xBECA00C1
.long 0xBF82000C
.long 0xBF06FF4D, 0x00006000
.long 0xBF850004
.long 0x924B0314
.long 0x804A4B4A
.long 0x804A024A
.long 0xBF820005
.long 0xBF06FF4D, 0x00008000
.long 0xBF850002
.long 0xBECA00C1
.long 0xBF820000
.long 0x863A4A3A
.long 0x8E3A4C3A
.long 0x96CB3F3A
.long 0x924A3F3A
.long 0x96BC3F0A
.long 0x923B3F0A
.long 0x80BB3B3F
.long 0x82BC3C80
.long 0x80304A30
.long 0x82314B31
.long 0x80964A16
.long 0x82974B17
.long 0xBF068017
.long 0x8532C116
.long 0x96CB403A
.long 0x924A403A
.long 0x96BE400A
.long 0x923D400A
.long 0x80BD3D40
.long 0x82BE3E80
.long 0x80344A34
.long 0x82354B35
.long 0x80B84A38
.long 0x82B94B39
.long 0xBF068039
.long 0x8536C138
.long 0x803A823A
.long 0xBF06800A
.long 0xBF850026
.long 0xE0501000, 0x800D4827
.long 0xE0541000, 0x800C2A26
.long 0xE0541000, 0x430C2E26
.long 0xE0541000, 0x440C3226
.long 0xE0541000, 0x450C3626
.long 0xE0541000, 0x460C3A26
.long 0xE0541000, 0x470C3E26
.long 0xE0541000, 0x480C4226
.long 0xE0541000, 0x490C4626
.long 0x804C810A
.long 0xBF064C3A
.long 0x854A3F3B
.long 0x854B803C
.long 0x80304A30
.long 0x82314B31
.long 0x80964A16
.long 0x82974B17
.long 0xBF068017
.long 0x8532C116
.long 0x804C810A
.long 0xBF064C3A
.long 0x854A403D
.long 0x854B803E
.long 0x80344A34
.long 0x82354B35
.long 0x80B84A38
.long 0x82B94B39
.long 0xBF068039
.long 0x8536C138
.long 0xBE8C001C
.long 0xBE8D001D
.long 0xBE8E00FF, 0x80000000
.long 0xBE8F00FF, 0x00020000
.long 0xBE90001E
.long 0xBE91001F
.long 0xBE9200FF, 0x80000000
.long 0xBE9300FF, 0x00020000
.long 0x924C0390
.long 0x964B264C
.long 0x924A264C
.long 0x8ECA054A
.long 0x80104A1E
.long 0x82114B1F
.long 0x964B244C
.long 0x924A244C
.long 0x8ECA084A
.long 0x800C4A1C
.long 0x820D4B1D
.long 0x964B2704
.long 0x924A2704
.long 0x8ECA054A
.long 0x80104A10
.long 0x82114B11
.long 0x964B2504
.long 0x924A2504
.long 0x8ECA084A
.long 0x800C4A0C
.long 0x820D4B0D
.long 0xBF06812E
.long 0xBF850011
.long 0x964B0618
.long 0x924A0618
.long 0x80CE8119
.long 0x924E064E
.long 0x964D264E
.long 0x924C264E
.long 0x804A4C4A
.long 0x824B4D4B
.long 0x80CE811A
.long 0x924E064E
.long 0x964D274E
.long 0x924C274E
.long 0x804A4C4A
.long 0x824B4D4B
.long 0x8ECA824A
.long 0x800C4A0C
.long 0x820D4B0D
.long 0xD3D94000, 0x18000080
.long 0xD3D94001, 0x18000080
.long 0xD3D94002, 0x18000080
.long 0xD3D94003, 0x18000080
.long 0xD3D94004, 0x18000080
.long 0xD3D94005, 0x18000080
.long 0xD3D94006, 0x18000080
.long 0xD3D94007, 0x18000080
.long 0xD3D94008, 0x18000080
.long 0xD3D94009, 0x18000080
.long 0xD3D9400A, 0x18000080
.long 0xD3D9400B, 0x18000080
.long 0xD3D9400C, 0x18000080
.long 0xD3D9400D, 0x18000080
.long 0xD3D9400E, 0x18000080
.long 0xD3D9400F, 0x18000080
.long 0xD3D94010, 0x18000080
.long 0xD3D94011, 0x18000080
.long 0xD3D94012, 0x18000080
.long 0xD3D94013, 0x18000080
.long 0xD3D94014, 0x18000080
.long 0xD3D94015, 0x18000080
.long 0xD3D94016, 0x18000080
.long 0xD3D94017, 0x18000080
.long 0xD3D94018, 0x18000080
.long 0xD3D94019, 0x18000080
.long 0xD3D9401A, 0x18000080
.long 0xD3D9401B, 0x18000080
.long 0xD3D9401C, 0x18000080
.long 0xD3D9401D, 0x18000080
.long 0xD3D9401E, 0x18000080
.long 0xD3D9401F, 0x18000080
.long 0xBF06800A
.long 0xBF840006
.long 0xBECA1C00
.long 0x814C84FF, 0x00000D20
.long 0x804A4C4A
.long 0x824B804B
.long 0xBE801D4A
.long 0xBF8C0F70
.long 0x7E94712A
.long 0x7E98712E
.long 0x7E9C7132
.long 0x7EA07136
.long 0x7EA4713A
.long 0x7EA8713E
.long 0x7EAC7142
.long 0x7EB07146
.long 0xD81A0000, 0x00004825
.long 0x2A4A4AFF, 0x00000800
.long 0xBF06810A
.long 0xBF850012
.long 0xE0501000, 0x800D4827
.long 0xE0541000, 0x800C2A26
.long 0xE0541000, 0x430C2E26
.long 0xE0541000, 0x440C3226
.long 0xE0541000, 0x450C3626
.long 0xE0541000, 0x460C3A26
.long 0xE0541000, 0x470C3E26
.long 0xE0541000, 0x480C4226
.long 0xE0541000, 0x490C4626
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0x7EB4ACF9, 0x0004064A
.long 0x7E0014F9, 0x0006145A
.long 0x7E0414F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064A
.long 0x7E0814F9, 0x0006145A
.long 0x7E0C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x0004064B
.long 0x7E1014F9, 0x0006145A
.long 0x7E1414F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064B
.long 0x7E1814F9, 0x0006145A
.long 0x7E1C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x0004064C
.long 0x7E0014F9, 0x0006155A
.long 0x7E0414F9, 0x0006155B
.long 0x7EB4ACF9, 0x0005064C
.long 0x7E0814F9, 0x0006155A
.long 0x7E0C14F9, 0x0006155B
.long 0x7EB4ACF9, 0x0004064D
.long 0x7E1014F9, 0x0006155A
.long 0x7E1414F9, 0x0006155B
.long 0x7EB4ACF9, 0x0005064D
.long 0x7E1814F9, 0x0006155A
.long 0x7E1C14F9, 0x0006155B
.long 0x7EB4ACF9, 0x0004064E
.long 0x7E0214F9, 0x0006145A
.long 0x7E0614F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064E
.long 0x7E0A14F9, 0x0006145A
.long 0x7E0E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x0004064F
.long 0x7E1214F9, 0x0006145A
.long 0x7E1614F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064F
.long 0x7E1A14F9, 0x0006145A
.long 0x7E1E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040650
.long 0x7E0214F9, 0x0006155A
.long 0x7E0614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050650
.long 0x7E0A14F9, 0x0006155A
.long 0x7E0E14F9, 0x0006155B
.long 0x7EB4ACF9, 0x00040651
.long 0x7E1214F9, 0x0006155A
.long 0x7E1614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050651
.long 0x7E1A14F9, 0x0006155A
.long 0x7E1E14F9, 0x0006155B
.long 0xD8EC0000, 0x20000024
.long 0xBF06810A
.long 0xBF850237
.long 0xBF0B820A
.long 0xBF850125
.long 0xBF8CC07F
.long 0xD3CD8000, 0x04020120
.long 0xBF063A0A
.long 0x854A3F3B
.long 0x854B803C
.long 0x80304A30
.long 0x82314B31
.long 0x80964A16
.long 0x82974B17
.long 0xBF068017
.long 0x8532C116
.long 0xBF063A0A
.long 0x854A403D
.long 0x854B803E
.long 0x80344A34
.long 0x82354B35
.long 0x80B84A38
.long 0x82B94B39
.long 0xBF068039
.long 0x8536C138
.long 0xD3CD8004, 0x04120520
.long 0xBF8C0F78
.long 0xD81A0000, 0x00004825
.long 0xE0501000, 0x800D4827
.long 0x7EB4ACF9, 0x00040652
.long 0x7E2014F9, 0x0006145A
.long 0x7E2414F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050652
.long 0x7E2814F9, 0x0006145A
.long 0x7E2C14F9, 0x0006145B
.long 0xD3CD8008, 0x04220920
.long 0xBF8C0F78
.long 0x7E94712A
.long 0xE0541000, 0x800C2A26
.long 0x7EB4ACF9, 0x00040653
.long 0x7E3014F9, 0x0006145A
.long 0x7E3414F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050653
.long 0x7E3814F9, 0x0006145A
.long 0x7E3C14F9, 0x0006145B
.long 0xD3CD800C, 0x04320D20
.long 0xBF8C0F78
.long 0x7E98712E
.long 0xE0541000, 0x430C2E26
.long 0x7EB4ACF9, 0x00040654
.long 0x7E2014F9, 0x0006155A
.long 0x7E2414F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050654
.long 0x7E2814F9, 0x0006155A
.long 0x7E2C14F9, 0x0006155B
.long 0xBF8C0F78
.long 0x7E9C7132
.long 0xE0541000, 0x440C3226
.long 0xD3CD8010, 0x04421120
.long 0xBF8C0F78
.long 0x7EA07136
.long 0xE0541000, 0x450C3626
.long 0x7EB4ACF9, 0x00040655
.long 0x7E3014F9, 0x0006155A
.long 0x7E3414F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050655
.long 0x7E3814F9, 0x0006155A
.long 0x7E3C14F9, 0x0006155B
.long 0xD8EC0020, 0x22000024
.long 0xD3CD8014, 0x04521520
.long 0xBF8C0F78
.long 0x7EA4713A
.long 0xE0541000, 0x460C3A26
.long 0x7EB4ACF9, 0x00040656
.long 0x7E2214F9, 0x0006145A
.long 0x7E2614F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050656
.long 0x7E2A14F9, 0x0006145A
.long 0x7E2E14F9, 0x0006145B
.long 0xD3CD8018, 0x04621920
.long 0xBF8C0F78
.long 0x7EA8713E
.long 0xE0541000, 0x470C3E26
.long 0x7EB4ACF9, 0x00040657
.long 0x7E3214F9, 0x0006145A
.long 0x7E3614F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050657
.long 0x7E3A14F9, 0x0006145A
.long 0x7E3E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040658
.long 0x7E2214F9, 0x0006155A
.long 0x7E2614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050658
.long 0x7E2A14F9, 0x0006155A
.long 0x7E2E14F9, 0x0006155B
.long 0x7EB4ACF9, 0x00040659
.long 0x7E3214F9, 0x0006155A
.long 0x7E3614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050659
.long 0x7E3A14F9, 0x0006155A
.long 0x7E3E14F9, 0x0006155B
.long 0xD3CD801C, 0x04721D20
.long 0xBF8C0F78
.long 0x7EAC7142
.long 0xE0541000, 0x480C4226
.long 0x7EB4ACF9, 0x0004064A
.long 0x7E0014F9, 0x0006145A
.long 0x7E0414F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064A
.long 0x7E0814F9, 0x0006145A
.long 0x7E0C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x0004064B
.long 0x7E1014F9, 0x0006145A
.long 0x7E1414F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064B
.long 0x7E1814F9, 0x0006145A
.long 0x7E1C14F9, 0x0006145B
.long 0xD3CD8000, 0x04022122
.long 0xBF8C0F78
.long 0x7EB07146
.long 0xE0541000, 0x490C4626
.long 0x7EB4ACF9, 0x0004064C
.long 0x7E0014F9, 0x0006155A
.long 0x7E0414F9, 0x0006155B
.long 0x7EB4ACF9, 0x0005064C
.long 0x7E0814F9, 0x0006155A
.long 0x7E0C14F9, 0x0006155B
.long 0xD3CD8004, 0x04122522
.long 0x2A4A4AFF, 0x00000800
.long 0x2A4848FF, 0x00000800
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD8EC0000, 0x20000024
.long 0xD3CD8008, 0x04222922
.long 0x7EB4ACF9, 0x0004064D
.long 0x7E1014F9, 0x0006155A
.long 0x7E1414F9, 0x0006155B
.long 0x7EB4ACF9, 0x0005064D
.long 0x7E1814F9, 0x0006155A
.long 0x7E1C14F9, 0x0006155B
.long 0xD3CD800C, 0x04322D22
.long 0x7EB4ACF9, 0x0004064E
.long 0x7E0214F9, 0x0006145A
.long 0x7E0614F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064E
.long 0x7E0A14F9, 0x0006145A
.long 0x7E0E14F9, 0x0006145B
.long 0xD3CD8010, 0x04423122
.long 0x7EB4ACF9, 0x0004064F
.long 0x7E1214F9, 0x0006145A
.long 0x7E1614F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064F
.long 0x7E1A14F9, 0x0006145A
.long 0x7E1E14F9, 0x0006145B
.long 0xD3CD8014, 0x04523522
.long 0x7EB4ACF9, 0x00040650
.long 0x7E0214F9, 0x0006155A
.long 0x7E0614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050650
.long 0x7E0A14F9, 0x0006155A
.long 0x7E0E14F9, 0x0006155B
.long 0xD3CD8018, 0x04623922
.long 0x7EB4ACF9, 0x00040651
.long 0x7E1214F9, 0x0006155A
.long 0x7E1614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050651
.long 0x7E1A14F9, 0x0006155A
.long 0x7E1E14F9, 0x0006155B
.long 0xD3CD801C, 0x04723D22
.long 0x808A810A
.long 0xBF00820A
.long 0xBF84FEDB
.long 0xBF8CC07F
.long 0xD3CD8000, 0x04020120
.long 0x7EB4ACF9, 0x00040652
.long 0x7E2014F9, 0x0006145A
.long 0x7E2414F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050652
.long 0x7E2814F9, 0x0006145A
.long 0x7E2C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040653
.long 0x7E3014F9, 0x0006145A
.long 0x7E3414F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050653
.long 0x7E3814F9, 0x0006145A
.long 0x7E3C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040654
.long 0x7E2014F9, 0x0006155A
.long 0x7E2414F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050654
.long 0x7E2814F9, 0x0006155A
.long 0x7E2C14F9, 0x0006155B
.long 0x7EB4ACF9, 0x00040655
.long 0x7E3014F9, 0x0006155A
.long 0x7E3414F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050655
.long 0x7E3814F9, 0x0006155A
.long 0x7E3C14F9, 0x0006155B
.long 0x7EB4ACF9, 0x00040656
.long 0x7E2214F9, 0x0006145A
.long 0x7E2614F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050656
.long 0x7E2A14F9, 0x0006145A
.long 0x7E2E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040657
.long 0x7E3214F9, 0x0006145A
.long 0x7E3614F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050657
.long 0x7E3A14F9, 0x0006145A
.long 0x7E3E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040658
.long 0x7E2214F9, 0x0006155A
.long 0x7E2614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050658
.long 0x7E2A14F9, 0x0006155A
.long 0x7E2E14F9, 0x0006155B
.long 0x7EB4ACF9, 0x00040659
.long 0x7E3214F9, 0x0006155A
.long 0x7E3614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050659
.long 0x7E3A14F9, 0x0006155A
.long 0x7E3E14F9, 0x0006155B
.long 0xBF063A0A
.long 0xD3CD8004, 0x04120520
.long 0x854A3F3B
.long 0xD3CD8008, 0x04220920
.long 0x854B803C
.long 0xD3CD800C, 0x04320D20
.long 0x80304A30
.long 0xD3CD8010, 0x04421120
.long 0xD8EC0020, 0x22000024
.long 0x82314B31
.long 0x80964A16
.long 0x82974B17
.long 0xBF068017
.long 0x8532C116
.long 0xBF063A0A
.long 0x854A403D
.long 0x854B803E
.long 0x80344A34
.long 0x82354B35
.long 0x80B84A38
.long 0x82B94B39
.long 0xBF068039
.long 0x8536C138
.long 0xBF8C0F78
.long 0xD81A0000, 0x00004825
.long 0xBF8C0F77
.long 0x7E94712A
.long 0xBF8C0F76
.long 0x7E98712E
.long 0xBF8C0F75
.long 0x7E9C7132
.long 0xBF8C0F74
.long 0x7EA07136
.long 0xBF8C0F73
.long 0x7EA4713A
.long 0xBF8C0F72
.long 0x7EA8713E
.long 0xBF8C0F71
.long 0x7EAC7142
.long 0xBF8C0F70
.long 0x7EB07146
.long 0x2A4A4AFF, 0x00000800
.long 0xD3CD8014, 0x04521520
.long 0xD3CD8018, 0x04621920
.long 0x2A4848FF, 0x00000800
.long 0xD3CD801C, 0x04721D20
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD3CD8000, 0x04022122
.long 0xD3CD8004, 0x04122522
.long 0xD3CD8008, 0x04222922
.long 0xD3CD800C, 0x04322D22
.long 0xD3CD8010, 0x04423122
.long 0xD8EC0000, 0x20000024
.long 0xD3CD8014, 0x04523522
.long 0xD3CD8018, 0x04623922
.long 0x7EB4ACF9, 0x0004064A
.long 0x7E0014F9, 0x0006145A
.long 0x7E0414F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064A
.long 0x7E0814F9, 0x0006145A
.long 0x7E0C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x0004064B
.long 0x7E1014F9, 0x0006145A
.long 0x7E1414F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064B
.long 0x7E1814F9, 0x0006145A
.long 0x7E1C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x0004064C
.long 0x7E0014F9, 0x0006155A
.long 0x7E0414F9, 0x0006155B
.long 0x7EB4ACF9, 0x0005064C
.long 0x7E0814F9, 0x0006155A
.long 0x7E0C14F9, 0x0006155B
.long 0x7EB4ACF9, 0x0004064D
.long 0x7E1014F9, 0x0006155A
.long 0x7E1414F9, 0x0006155B
.long 0x7EB4ACF9, 0x0005064D
.long 0x7E1814F9, 0x0006155A
.long 0x7E1C14F9, 0x0006155B
.long 0x7EB4ACF9, 0x0004064E
.long 0x7E0214F9, 0x0006145A
.long 0x7E0614F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064E
.long 0x7E0A14F9, 0x0006145A
.long 0x7E0E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x0004064F
.long 0x7E1214F9, 0x0006145A
.long 0x7E1614F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064F
.long 0x7E1A14F9, 0x0006145A
.long 0x7E1E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040650
.long 0x7E0214F9, 0x0006155A
.long 0x7E0614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050650
.long 0x7E0A14F9, 0x0006155A
.long 0x7E0E14F9, 0x0006155B
.long 0x7EB4ACF9, 0x00040651
.long 0x7E1214F9, 0x0006155A
.long 0x7E1614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050651
.long 0x7E1A14F9, 0x0006155A
.long 0x7E1E14F9, 0x0006155B
.long 0xD3CD801C, 0x04723D22
.long 0xBF06812E
.long 0xBF840000
.long 0xBF8CC07F
.long 0xD3CD8000, 0x04020120
.long 0x7EB4ACF9, 0x00040652
.long 0x7E2014F9, 0x0006145A
.long 0x7E2414F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050652
.long 0x7E2814F9, 0x0006145A
.long 0x7E2C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040653
.long 0x7E3014F9, 0x0006145A
.long 0x7E3414F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050653
.long 0x7E3814F9, 0x0006145A
.long 0x7E3C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040654
.long 0x7E2014F9, 0x0006155A
.long 0x7E2414F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050654
.long 0x7E2814F9, 0x0006155A
.long 0x7E2C14F9, 0x0006155B
.long 0x7EB4ACF9, 0x00040655
.long 0x7E3014F9, 0x0006155A
.long 0x7E3414F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050655
.long 0x7E3814F9, 0x0006155A
.long 0x7E3C14F9, 0x0006155B
.long 0x7EB4ACF9, 0x00040656
.long 0x7E2214F9, 0x0006145A
.long 0x7E2614F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050656
.long 0x7E2A14F9, 0x0006145A
.long 0x7E2E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040657
.long 0x7E3214F9, 0x0006145A
.long 0x7E3614F9, 0x0006145B
.long 0x7EB4ACF9, 0x00050657
.long 0x7E3A14F9, 0x0006145A
.long 0x7E3E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040658
.long 0x7E2214F9, 0x0006155A
.long 0x7E2614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050658
.long 0x7E2A14F9, 0x0006155A
.long 0x7E2E14F9, 0x0006155B
.long 0x7EB4ACF9, 0x00040659
.long 0x7E3214F9, 0x0006155A
.long 0x7E3614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050659
.long 0x7E3A14F9, 0x0006155A
.long 0x7E3E14F9, 0x0006155B
.long 0xD3CD8004, 0x04120520
.long 0xD3CD8008, 0x04220920
.long 0xD3CD800C, 0x04320D20
.long 0xD3CD8010, 0x04421120
.long 0xD8EC0020, 0x22000024
.long 0xD3CD8014, 0x04521520
.long 0xD3CD8018, 0x04621920
.long 0xD3CD801C, 0x04721D20
.long 0xBF8CC07F
.long 0xD3CD8000, 0x04022122
.long 0xD3CD8004, 0x04122522
.long 0xD3CD8008, 0x04222922
.long 0xD3CD800C, 0x04322D22
.long 0xD3CD8010, 0x04423122
.long 0xD3CD8014, 0x04523522
.long 0xD3CD8018, 0x04623922
.long 0xD3CD801C, 0x04723D22
.long 0x264A4AFF, 0x00F007FF
.long 0x860A1B9F
.long 0xBF070706
.long 0xBE8A0280
.long 0xBF06800A
.long 0xBE8B0080
.long 0xBF85020F
.long 0x81CA3A83
.long 0x96CB3F4A
.long 0x924A3F4A
.long 0x80CA3B4A
.long 0x82CB3C4B
.long 0x80304A30
.long 0x82314B31
.long 0x80964A16
.long 0x82974B17
.long 0xBF068017
.long 0x8532C116
.long 0x81CA3A83
.long 0x96CB404A
.long 0x924A404A
.long 0x80CA3D4A
.long 0x82CB3E4B
.long 0x80344A34
.long 0x82354B35
.long 0x80B84A38
.long 0x82B94B39
.long 0xBF068039
.long 0x8536C138
.long 0xE0801000, 0x800C2A26
.long 0xE0801001, 0x800C0026
.long 0xE0841002, 0x800C0126
.long 0xE0841003, 0x800C0226
.long 0xE0801004, 0x800C2B26
.long 0xE0801005, 0x800C0426
.long 0xE0841006, 0x800C0526
.long 0xE0841007, 0x800C0626
.long 0xBF8C0F76
.long 0x24000088
.long 0x2854012A
.long 0xBF8C0F75
.long 0x2854032A
.long 0xBF8C0F74
.long 0x24040488
.long 0x2854052A
.long 0xBF8C0F72
.long 0x24080888
.long 0x2856092B
.long 0xBF8C0F71
.long 0x28560B2B
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x28560D2B
.long 0xE0801000, 0x430C2E26
.long 0xE0801001, 0x430C0026
.long 0xE0841002, 0x430C0126
.long 0xE0841003, 0x430C0226
.long 0xE0801004, 0x430C2F26
.long 0xE0801005, 0x430C0426
.long 0xE0841006, 0x430C0526
.long 0xE0841007, 0x430C0626
.long 0xBF8C0F76
.long 0x24000088
.long 0x285C012E
.long 0xBF8C0F75
.long 0x285C032E
.long 0xBF8C0F74
.long 0x24040488
.long 0x285C052E
.long 0xBF8C0F72
.long 0x24080888
.long 0x285E092F
.long 0xBF8C0F71
.long 0x285E0B2F
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x285E0D2F
.long 0xE0801000, 0x440C3226
.long 0xE0801001, 0x440C0026
.long 0xE0841002, 0x440C0126
.long 0xE0841003, 0x440C0226
.long 0xE0801004, 0x440C3326
.long 0xE0801005, 0x440C0426
.long 0xE0841006, 0x440C0526
.long 0xE0841007, 0x440C0626
.long 0xBF8C0F76
.long 0x24000088
.long 0x28640132
.long 0xBF8C0F75
.long 0x28640332
.long 0xBF8C0F74
.long 0x24040488
.long 0x28640532
.long 0xBF8C0F72
.long 0x24080888
.long 0x28660933
.long 0xBF8C0F71
.long 0x28660B33
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x28660D33
.long 0xE0801000, 0x450C3626
.long 0xE0801001, 0x450C0026
.long 0xE0841002, 0x450C0126
.long 0xE0841003, 0x450C0226
.long 0xE0801004, 0x450C3726
.long 0xE0801005, 0x450C0426
.long 0xE0841006, 0x450C0526
.long 0xE0841007, 0x450C0626
.long 0xBF8C0F76
.long 0x24000088
.long 0x286C0136
.long 0xBF8C0F75
.long 0x286C0336
.long 0xBF8C0F74
.long 0x24040488
.long 0x286C0536
.long 0xBF8C0F72
.long 0x24080888
.long 0x286E0937
.long 0xBF8C0F71
.long 0x286E0B37
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x286E0D37
.long 0xE0801000, 0x460C3A26
.long 0xE0801001, 0x460C0026
.long 0xE0841002, 0x460C0126
.long 0xE0841003, 0x460C0226
.long 0xE0801004, 0x460C3B26
.long 0xE0801005, 0x460C0426
.long 0xE0841006, 0x460C0526
.long 0xE0841007, 0x460C0626
.long 0xBF8C0F76
.long 0x24000088
.long 0x2874013A
.long 0xBF8C0F75
.long 0x2874033A
.long 0xBF8C0F74
.long 0x24040488
.long 0x2874053A
.long 0xBF8C0F72
.long 0x24080888
.long 0x2876093B
.long 0xBF8C0F71
.long 0x28760B3B
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x28760D3B
.long 0xE0801000, 0x470C3E26
.long 0xE0801001, 0x470C0026
.long 0xE0841002, 0x470C0126
.long 0xE0841003, 0x470C0226
.long 0xE0801004, 0x470C3F26
.long 0xE0801005, 0x470C0426
.long 0xE0841006, 0x470C0526
.long 0xE0841007, 0x470C0626
.long 0xBF8C0F76
.long 0x24000088
.long 0x287C013E
.long 0xBF8C0F75
.long 0x287C033E
.long 0xBF8C0F74
.long 0x24040488
.long 0x287C053E
.long 0xBF8C0F72
.long 0x24080888
.long 0x287E093F
.long 0xBF8C0F71
.long 0x287E0B3F
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x287E0D3F
.long 0xE0801000, 0x480C4226
.long 0xE0801001, 0x480C0026
.long 0xE0841002, 0x480C0126
.long 0xE0841003, 0x480C0226
.long 0xE0801004, 0x480C4326
.long 0xE0801005, 0x480C0426
.long 0xE0841006, 0x480C0526
.long 0xE0841007, 0x480C0626
.long 0xBF8C0F76
.long 0x24000088
.long 0x28840142
.long 0xBF8C0F75
.long 0x28840342
.long 0xBF8C0F74
.long 0x24040488
.long 0x28840542
.long 0xBF8C0F72
.long 0x24080888
.long 0x28860943
.long 0xBF8C0F71
.long 0x28860B43
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x28860D43
.long 0xE0801000, 0x490C4626
.long 0xE0801001, 0x490C0026
.long 0xE0841002, 0x490C0126
.long 0xE0841003, 0x490C0226
.long 0xE0801004, 0x490C4726
.long 0xE0801005, 0x490C0426
.long 0xE0841006, 0x490C0526
.long 0xE0841007, 0x490C0626
.long 0xBF8C0F76
.long 0x24000088
.long 0x288C0146
.long 0xBF8C0F75
.long 0x288C0346
.long 0xBF8C0F74
.long 0x24040488
.long 0x288C0546
.long 0xBF8C0F72
.long 0x24080888
.long 0x288E0947
.long 0xBF8C0F71
.long 0x288E0B47
.long 0xBF8C0F70
.long 0x240C0C88
.long 0x288E0D47
.long 0xE0901000, 0x800D4827
.long 0xE0941002, 0x800D0027
.long 0xBF8C0F70
.long 0x28900148
.long 0xBF8C0F70
.long 0xBF8A0000
.long 0x7E94712A
.long 0x7E98712E
.long 0x7E9C7132
.long 0x7EA07136
.long 0x7EA4713A
.long 0x7EA8713E
.long 0x7EAC7142
.long 0x7EB07146
.long 0xD81A0000, 0x00004825
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0x264848FF, 0x000007FF
.long 0x7EB4ACF9, 0x0004064A
.long 0x7E0014F9, 0x0006145A
.long 0x7E0414F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064A
.long 0x7E0814F9, 0x0006145A
.long 0x7E0C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x0004064B
.long 0x7E1014F9, 0x0006145A
.long 0x7E1414F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064B
.long 0x7E1814F9, 0x0006145A
.long 0x7E1C14F9, 0x0006145B
.long 0x7EB4ACF9, 0x0004064C
.long 0x7E0014F9, 0x0006155A
.long 0x7E0414F9, 0x0006155B
.long 0x7EB4ACF9, 0x0005064C
.long 0x7E0814F9, 0x0006155A
.long 0x7E0C14F9, 0x0006155B
.long 0x7EB4ACF9, 0x0004064D
.long 0x7E1014F9, 0x0006155A
.long 0x7E1414F9, 0x0006155B
.long 0x7EB4ACF9, 0x0005064D
.long 0x7E1814F9, 0x0006155A
.long 0x7E1C14F9, 0x0006155B
.long 0x7EB4ACF9, 0x0004064E
.long 0x7E0214F9, 0x0006145A
.long 0x7E0614F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064E
.long 0x7E0A14F9, 0x0006145A
.long 0x7E0E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x0004064F
.long 0x7E1214F9, 0x0006145A
.long 0x7E1614F9, 0x0006145B
.long 0x7EB4ACF9, 0x0005064F
.long 0x7E1A14F9, 0x0006145A
.long 0x7E1E14F9, 0x0006145B
.long 0x7EB4ACF9, 0x00040650
.long 0x7E0214F9, 0x0006155A
.long 0x7E0614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050650
.long 0x7E0A14F9, 0x0006155A
.long 0x7E0E14F9, 0x0006155B
.long 0x7EB4ACF9, 0x00040651
.long 0x7E1214F9, 0x0006155A
.long 0x7E1614F9, 0x0006155B
.long 0x7EB4ACF9, 0x00050651
.long 0x7E1A14F9, 0x0006155A
.long 0x7E1E14F9, 0x0006155B
.long 0x7E947152
.long 0x7E987154
.long 0x7E9C7156
.long 0x7EA07158
.long 0xD8EC0000, 0x20000024
.long 0xBE8500A0
.long 0x32484805
.long 0xBF8CC07F
.long 0x266892BF
.long 0x20686884
.long 0x24686882
.long 0xD0C6004A, 0x00001534
.long 0xD1000000, 0x01290100
.long 0xD1000002, 0x01290102
.long 0xD1000004, 0x01290104
.long 0xD1000006, 0x01290106
.long 0xD1000008, 0x01290108
.long 0xD100000A, 0x0129010A
.long 0xD100000C, 0x0129010C
.long 0xD100000E, 0x0129010E
.long 0xD1000001, 0x01290101
.long 0xD1000003, 0x01290103
.long 0xD1000005, 0x01290105
.long 0xD1000007, 0x01290107
.long 0xD1000009, 0x01290109
.long 0xD100000B, 0x0129010B
.long 0xD100000D, 0x0129010D
.long 0xD100000F, 0x0129010F
.long 0xD1000020, 0x01290120
.long 0xD1000021, 0x01290121
.long 0x6A68680A
.long 0xD0C1004A, 0x00010934
.long 0x864C830A
.long 0x80CC4C84
.long 0x8E4C844C
.long 0xD28F0036, 0x0002004C
.long 0xD1000000, 0x012A6D00
.long 0xD1000001, 0x012A6F01
.long 0xD28F0036, 0x0002044C
.long 0xD1000002, 0x012A6D02
.long 0xD1000003, 0x012A6F03
.long 0xD28F0036, 0x0002084C
.long 0xD1000004, 0x012A6D04
.long 0xD1000005, 0x012A6F05
.long 0xD28F0036, 0x00020C4C
.long 0xD1000006, 0x012A6D06
.long 0xD1000007, 0x012A6F07
.long 0xD28F0036, 0x0002104C
.long 0xD1000008, 0x012A6D08
.long 0xD1000009, 0x012A6F09
.long 0xD28F0036, 0x0002144C
.long 0xD100000A, 0x012A6D0A
.long 0xD100000B, 0x012A6F0B
.long 0xD28F0036, 0x0002184C
.long 0xD100000C, 0x012A6D0C
.long 0xD100000D, 0x012A6F0D
.long 0xD28F0036, 0x00021C4C
.long 0xD100000E, 0x012A6D0E
.long 0xD100000F, 0x012A6F0F
.long 0xD28F0036, 0x0002404C
.long 0xD1000020, 0x012A6D20
.long 0xD1000021, 0x012A6F21
.long 0xBF800001
.long 0xD3CD8000, 0x04020120
.long 0xD3CD8004, 0x04120520
.long 0xD3CD8008, 0x04220920
.long 0xD3CD800C, 0x04320D20
.long 0xD3CD8010, 0x04421120
.long 0xD3CD8014, 0x04521520
.long 0xD3CD8018, 0x04621920
.long 0xD3CD801C, 0x04721D20
.long 0x818A900A
.long 0x800B900B
.long 0xBF05800A
.long 0xBF84FF1D
.long 0xBF06812E
.long 0xBF840006
.long 0xC00E0C00, 0x0000005C
.long 0xC00A0E00, 0x0000007C
.long 0xC0020F00, 0x0000008C
.long 0x20089286
.long 0x200A0882
.long 0xD2850005, 0x00020A90
.long 0x260292BF
.long 0x20020284
.long 0x24020282
.long 0xD1FE0001, 0x02020305
.long 0xD2850002, 0x00004D01
.long 0xD2850003, 0x00004901
.long 0x26000883
.long 0xD2850000, 0x00020090
.long 0x260A928F
.long 0xD1FE0000, 0x020E0105
.long 0x920502FF, 0x00000200
.long 0x68000005
.long 0x92050390
.long 0x68020205
.long 0xBF8CC07F
.long 0xBF06812E
.long 0xBF8500FC
.long 0x864818FF, 0x000001FF
.long 0x804914C1
.long 0xBF094902
.long 0x85488048
.long 0xB5480000
.long 0xBF850064
.long 0x8648198F
.long 0x804915C1
.long 0xBF094903
.long 0x85488048
.long 0xB5480000
.long 0xBF85005E
.long 0xD1FE0006, 0x020A0103
.long 0xD3D84008, 0x18000100
.long 0xD3D84009, 0x18000104
.long 0xD3D8400A, 0x18000108
.long 0xD3D8400B, 0x1800010C
.long 0xD3D8400C, 0x18000110
.long 0xD3D8400D, 0x18000114
.long 0xD3D8400E, 0x18000118
.long 0xD3D8400F, 0x1800011C
.long 0xD3D84010, 0x18000101
.long 0xD3D84011, 0x18000105
.long 0xD3D84012, 0x18000109
.long 0xD3D84013, 0x1800010D
.long 0xD3D84014, 0x18000111
.long 0xD3D84015, 0x18000115
.long 0xD3D84016, 0x18000119
.long 0xD3D84017, 0x1800011D
.long 0xD3D84018, 0x18000102
.long 0xD3D84019, 0x18000106
.long 0xD3D8401A, 0x1800010A
.long 0xD3D8401B, 0x1800010E
.long 0xD3D8401C, 0x18000112
.long 0xD3D8401D, 0x18000116
.long 0xD3D8401E, 0x1800011A
.long 0xD3D8401F, 0x1800011E
.long 0xD3D84020, 0x18000103
.long 0xD3D84021, 0x18000107
.long 0xD3D84022, 0x1800010B
.long 0xD3D84023, 0x1800010F
.long 0xD3D84024, 0x18000113
.long 0xD3D84025, 0x18000117
.long 0xD3D84026, 0x1800011B
.long 0xD3D84027, 0x1800011F
.long 0xBF800001
.long 0xE07C1000, 0x80030806
.long 0xE07C1010, 0x80030C06
.long 0x8E3E8224
.long 0x800C3E0C
.long 0x820D800D
.long 0xE07C1000, 0x80031006
.long 0xE07C1010, 0x80031406
.long 0x8E3E8224
.long 0x800C3E0C
.long 0x820D800D
.long 0xE07C1000, 0x80031806
.long 0xE07C1010, 0x80031C06
.long 0x8E3E8224
.long 0x800C3E0C
.long 0x820D800D
.long 0xE07C1000, 0x80032006
.long 0xE07C1010, 0x80032406
.long 0xBF800000
.long 0xBF82008B
.long 0x7E3402FF, 0x80000000
.long 0xD0C90048, 0x00003100
.long 0xD0C9004C, 0x00003301
.long 0x86CC4C48
.long 0xD1FE0006, 0x020A0103
.long 0xD1000006, 0x01320D1A
.long 0xD1196A01, 0x00010301
.long 0xD1340002, 0x00004D02
.long 0xD1340003, 0x00004903
.long 0xD0C90048, 0x00003100
.long 0xD0C9004C, 0x00003301
.long 0x86CC4C48
.long 0xD1FE0007, 0x020A0103
.long 0xD1000007, 0x01320F1A
.long 0xD1196A01, 0x00010301
.long 0xD1340002, 0x00004D02
.long 0xD1340003, 0x00004903
.long 0xD0C90048, 0x00003100
.long 0xD0C9004C, 0x00003301
.long 0x86CC4C48
.long 0xD1FE0018, 0x020A0103
.long 0xD1000018, 0x0132311A
.long 0xD1196A01, 0x00010301
.long 0xD1340002, 0x00004D02
.long 0xD1340003, 0x00004903
.long 0xD0C90048, 0x00003100
.long 0xD0C9004C, 0x00003301
.long 0x86CC4C48
.long 0xD1FE0019, 0x020A0103
.long 0xD1000019, 0x0132331A
.long 0xD3D84008, 0x18000100
.long 0xD3D84009, 0x18000104
.long 0xD3D8400A, 0x18000108
.long 0xD3D8400B, 0x1800010C
.long 0xD3D8400C, 0x18000110
.long 0xD3D8400D, 0x18000114
.long 0xD3D8400E, 0x18000118
.long 0xD3D8400F, 0x1800011C
.long 0xD3D84010, 0x18000101
.long 0xD3D84011, 0x18000105
.long 0xD3D84012, 0x18000109
.long 0xD3D84013, 0x1800010D
.long 0xD3D84014, 0x18000111
.long 0xD3D84015, 0x18000115
.long 0xD3D84016, 0x18000119
.long 0xD3D84017, 0x1800011D
.long 0xD3D84020, 0x18000102
.long 0xD3D84021, 0x18000106
.long 0xD3D84022, 0x1800010A
.long 0xD3D84023, 0x1800010E
.long 0xD3D84024, 0x18000112
.long 0xD3D84025, 0x18000116
.long 0xD3D84026, 0x1800011A
.long 0xD3D84027, 0x1800011E
.long 0xD3D84028, 0x18000103
.long 0xD3D84029, 0x18000107
.long 0xD3D8402A, 0x1800010B
.long 0xD3D8402B, 0x1800010F
.long 0xD3D8402C, 0x18000113
.long 0xD3D8402D, 0x18000117
.long 0xD3D8402E, 0x1800011B
.long 0xD3D8402F, 0x1800011F
.long 0xBF800001
.long 0xE07C1000, 0x80030806
.long 0xE07C1010, 0x80030C06
.long 0xE07C1000, 0x80031007
.long 0xE07C1010, 0x80031407
.long 0xE07C1000, 0x80032018
.long 0xE07C1010, 0x80032418
.long 0xE07C1000, 0x80032819
.long 0xE07C1010, 0x80032C19
.long 0xBF800000
.long 0xBF820000
.long 0xBEC81C00
.long 0x814A84FF, 0x0000299C
.long 0x80484A48
.long 0x82498049
.long 0xBE801D48
.long 0xBE8500F2
.long 0xBF128030
.long 0xBF850002
.long 0xC0020158, 0x00000000
.long 0xBEAF00F2
.long 0xBF128032
.long 0xBF850002
.long 0xC0020BD9, 0x00000000
.long 0xBEC00034
.long 0xBEC10035
.long 0xBEC300FF, 0x00020000
.long 0xBF128034
.long 0xBF840002
.long 0xBEC20080
.long 0xBF820001
.long 0xBEC20018
.long 0x92424284
.long 0x803D8104
.long 0x923D3D39
.long 0xBF06803D
.long 0x853D3D18
.long 0xBEC40036
.long 0xBEC50037
.long 0xBEC700FF, 0x00020000
.long 0xBF128036
.long 0xBF840002
.long 0xBEC60080
.long 0xBF820001
.long 0xBEC6003D
.long 0xB4B80000
.long 0xBF850018
.long 0x92464684
.long 0x923D02FF, 0x00000200
.long 0x6810923D
.long 0x923D0439
.long 0x6810103D
.long 0x24101082
.long 0xE0501000, 0x80110408
.long 0x681010FF, 0x00000400
.long 0xE0501000, 0x80110508
.long 0x24109282
.long 0xBF8C0F71
.long 0xBF8A0000
.long 0xD81A0000, 0x00000408
.long 0x681010FF, 0x00000400
.long 0xBF8C0F70
.long 0xD81A0000, 0x00000508
.long 0xBF82001C
.long 0xB4B80004
.long 0xBF85001A
.long 0x92464682
.long 0x923D02FF, 0x00000200
.long 0x6810923D
.long 0x923D0439
.long 0x6810103D
.long 0x24101081
.long 0xE0901000, 0x80110408
.long 0x681010FF, 0x00000200
.long 0xE0901000, 0x80110508
.long 0x24109282
.long 0xBF8C0F71
.long 0xBF8A0000
.long 0x7E081704
.long 0xD81A0000, 0x00000408
.long 0x681010FF, 0x00000400
.long 0xBF8C0F70
.long 0x7E0A1705
.long 0xD81A0000, 0x00000508
.long 0xBF820000
.long 0x7E08022C
.long 0xBF8CC07F
.long 0xD1050004, 0x00000B04
.long 0xD1050004, 0x00005F04
.long 0xBF800000
.long 0x7E580504
.long 0xB43C0001
.long 0xBF850014
.long 0xB43C0002
.long 0xBF850018
.long 0xB43C0003
.long 0xBF85001C
.long 0xB43C0004
.long 0xBF850020
.long 0xB43C0005
.long 0xBF850024
.long 0xB43C0006
.long 0xBF850028
.long 0xB43C0007
.long 0xBF85002C
.long 0xB43C0009
.long 0xBF850030
.long 0xBEBE1C00
.long 0x810584FF, 0x00001FC4
.long 0x803E053E
.long 0x823F803F
.long 0xBF820030
.long 0xBEBE1C00
.long 0x810584FF, 0x00001FB0
.long 0x803E053E
.long 0x823F803F
.long 0xBF82002A
.long 0xBEBE1C00
.long 0x810584FF, 0x00001FDC
.long 0x803E053E
.long 0x823F803F
.long 0xBF820024
.long 0xBEBE1C00
.long 0x810584FF, 0x00002048
.long 0x803E053E
.long 0x823F803F
.long 0xBF82001E
.long 0xBEBE1C00
.long 0x810584FF, 0x00002234
.long 0x803E053E
.long 0x823F803F
.long 0xBF820018
.long 0xBEBE1C00
.long 0x810584FF, 0x000022A0
.long 0x803E053E
.long 0x823F803F
.long 0xBF820012
.long 0xBEBE1C00
.long 0x810584FF, 0x000022CC
.long 0x803E053E
.long 0x823F803F
.long 0xBF82000C
.long 0xBEBE1C00
.long 0x810584FF, 0x00002398
.long 0x803E053E
.long 0x823F803F
.long 0xBF820006
.long 0xBEBE1C00
.long 0x810584FF, 0x000024E4
.long 0x803E053E
.long 0x823F803F
.long 0xBF820000
.long 0xB42D0000
.long 0xBF840387
.long 0x864A18FF, 0x000001FF
.long 0x804B14C1
.long 0xBF094B02
.long 0x854A804A
.long 0xB54A0000
.long 0xBF8501A1
.long 0x864A198F
.long 0x804B15C1
.long 0xBF094B03
.long 0x854A804A
.long 0xB54A0000
.long 0xBF85019B
.long 0x924A02FF, 0x00000200
.long 0xD135000F, 0x00009500
.long 0x241E1E82
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD9FE0000, 0x1800000F
.long 0xD9FE0010, 0x1C00000F
.long 0x24200082
.long 0xE05C1000, 0x80102010
.long 0xE05C1010, 0x80102410
.long 0xD1FE000D, 0x02060103
.long 0xD3D84028, 0x18000100
.long 0xD3D84029, 0x18000104
.long 0xD3D8402A, 0x18000108
.long 0xD3D8402B, 0x1800010C
.long 0xD3D8402C, 0x18000110
.long 0xD3D8402D, 0x18000114
.long 0xD3D8402E, 0x18000118
.long 0xD3D8402F, 0x1800011C
.long 0xD3D84030, 0x18000101
.long 0xD3D84031, 0x18000105
.long 0xD3D84032, 0x18000109
.long 0xD3D84033, 0x1800010D
.long 0xD3D84034, 0x18000111
.long 0xD3D84035, 0x18000115
.long 0xD3D84036, 0x18000119
.long 0xD3D84037, 0x1800011D
.long 0xBF800001
.long 0x0A50502C
.long 0x0A52522C
.long 0x0A54542C
.long 0x0A56562C
.long 0x0A58582C
.long 0x0A5A5A2C
.long 0x0A5C5C2C
.long 0x0A5E5E2C
.long 0x0A60602C
.long 0x0A62622C
.long 0x0A64642C
.long 0x0A66662C
.long 0x0A68682C
.long 0x0A6A6A2C
.long 0x0A6C6C2C
.long 0x0A6E6E2C
.long 0xBF8C0000
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14028, 0x18025120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B1402A, 0x18025522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B1402C, 0x18025924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B1402E, 0x18025D26
.long 0xD3B24004, 0x18025118
.long 0xD3B24006, 0x1802551A
.long 0xD3B24008, 0x1802591C
.long 0xD3B2400A, 0x18025D1E
.long 0xBEC81E3E
.long 0x7E500304
.long 0x7E520305
.long 0x7E540306
.long 0x7E560307
.long 0x7E580308
.long 0x7E5A0309
.long 0x7E5C030A
.long 0x7E5E030B
.long 0x7E501528
.long 0x7E521529
.long 0xD2A00028, 0x00025328
.long 0x7E54152A
.long 0x7E56152B
.long 0xD2A00029, 0x0002572A
.long 0x7E58152C
.long 0x7E5A152D
.long 0xD2A0002A, 0x00025B2C
.long 0x7E5C152E
.long 0x7E5E152F
.long 0xD2A0002B, 0x00025F2E
.long 0xE07C1000, 0x8003280D
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14030, 0x18026120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B14032, 0x18026522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B14034, 0x18026924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B14036, 0x18026D26
.long 0xD3B24004, 0x18026118
.long 0xD3B24006, 0x1802651A
.long 0xD3B24008, 0x1802691C
.long 0xD3B2400A, 0x18026D1E
.long 0xBEC81E3E
.long 0x7E600304
.long 0x7E620305
.long 0x7E640306
.long 0x7E660307
.long 0x7E680308
.long 0x7E6A0309
.long 0x7E6C030A
.long 0x7E6E030B
.long 0x7E601530
.long 0x7E621531
.long 0xD2A00030, 0x00026330
.long 0x7E641532
.long 0x7E661533
.long 0xD2A00031, 0x00026732
.long 0x7E681534
.long 0x7E6A1535
.long 0xD2A00032, 0x00026B34
.long 0x7E6C1536
.long 0x7E6E1537
.long 0xD2A00033, 0x00026F36
.long 0x8E4A8124
.long 0x800C4A0C
.long 0x820D800D
.long 0xE07C1000, 0x8003300D
.long 0xBF800000
.long 0x924A02FF, 0x00000200
.long 0xD135000F, 0x00009500
.long 0x241E1E82
.long 0xD9FE0000, 0x1800000F
.long 0xD9FE0010, 0x1C00000F
.long 0xE05C1000, 0x80102010
.long 0xE05C1010, 0x80102410
.long 0xD3D84028, 0x18000102
.long 0xD3D84029, 0x18000106
.long 0xD3D8402A, 0x1800010A
.long 0xD3D8402B, 0x1800010E
.long 0xD3D8402C, 0x18000112
.long 0xD3D8402D, 0x18000116
.long 0xD3D8402E, 0x1800011A
.long 0xD3D8402F, 0x1800011E
.long 0xD3D84030, 0x18000103
.long 0xD3D84031, 0x18000107
.long 0xD3D84032, 0x1800010B
.long 0xD3D84033, 0x1800010F
.long 0xD3D84034, 0x18000113
.long 0xD3D84035, 0x18000117
.long 0xD3D84036, 0x1800011B
.long 0xD3D84037, 0x1800011F
.long 0xBF800001
.long 0x0A50502C
.long 0x0A52522C
.long 0x0A54542C
.long 0x0A56562C
.long 0x0A58582C
.long 0x0A5A5A2C
.long 0x0A5C5C2C
.long 0x0A5E5E2C
.long 0x0A60602C
.long 0x0A62622C
.long 0x0A64642C
.long 0x0A66662C
.long 0x0A68682C
.long 0x0A6A6A2C
.long 0x0A6C6C2C
.long 0x0A6E6E2C
.long 0xBF8C0000
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14028, 0x18025120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B1402A, 0x18025522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B1402C, 0x18025924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B1402E, 0x18025D26
.long 0xD3B24004, 0x18025118
.long 0xD3B24006, 0x1802551A
.long 0xD3B24008, 0x1802591C
.long 0xD3B2400A, 0x18025D1E
.long 0xBEC81E3E
.long 0x7E500304
.long 0x7E520305
.long 0x7E540306
.long 0x7E560307
.long 0x7E580308
.long 0x7E5A0309
.long 0x7E5C030A
.long 0x7E5E030B
.long 0x7E501528
.long 0x7E521529
.long 0xD2A00028, 0x00025328
.long 0x7E54152A
.long 0x7E56152B
.long 0xD2A00029, 0x0002572A
.long 0x7E58152C
.long 0x7E5A152D
.long 0xD2A0002A, 0x00025B2C
.long 0x7E5C152E
.long 0x7E5E152F
.long 0xD2A0002B, 0x00025F2E
.long 0x8E4A8124
.long 0x800C4A0C
.long 0x820D800D
.long 0xE07C1000, 0x8003280D
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14030, 0x18026120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B14032, 0x18026522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B14034, 0x18026924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B14036, 0x18026D26
.long 0xD3B24004, 0x18026118
.long 0xD3B24006, 0x1802651A
.long 0xD3B24008, 0x1802691C
.long 0xD3B2400A, 0x18026D1E
.long 0xBEC81E3E
.long 0x7E600304
.long 0x7E620305
.long 0x7E640306
.long 0x7E660307
.long 0x7E680308
.long 0x7E6A0309
.long 0x7E6C030A
.long 0x7E6E030B
.long 0x7E601530
.long 0x7E621531
.long 0xD2A00030, 0x00026330
.long 0x7E641532
.long 0x7E661533
.long 0xD2A00031, 0x00026732
.long 0x7E681534
.long 0x7E6A1535
.long 0xD2A00032, 0x00026B34
.long 0x7E6C1536
.long 0x7E6E1537
.long 0xD2A00033, 0x00026F36
.long 0x8E4A8124
.long 0x800C4A0C
.long 0x820D800D
.long 0xE07C1000, 0x8003300D
.long 0xBF800000
.long 0xBF820814
.long 0x7E5602FF, 0x80000000
.long 0xD0C9004A, 0x00003100
.long 0xD0C9004E, 0x00003301
.long 0x86CE4E4A
.long 0x924A02FF, 0x00000200
.long 0xD135000E, 0x00009500
.long 0x241C1C82
.long 0xD100000E, 0x013A1D2B
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD9FE0000, 0x1000000E
.long 0xD9FE0010, 0x1400000E
.long 0x241E0082
.long 0xE05C1000, 0x8010180F
.long 0xE05C1010, 0x80101C0F
.long 0xD1FE000D, 0x02060103
.long 0xD100000D, 0x013A1B2B
.long 0xD1196A01, 0x00010301
.long 0xD1340002, 0x00004D02
.long 0xD1340003, 0x00004903
.long 0xD0C9004A, 0x00003100
.long 0xD0C9004E, 0x00003301
.long 0x86CE4E4A
.long 0x924A02FF, 0x00000200
.long 0xD1350029, 0x00009500
.long 0x24525282
.long 0xD1000029, 0x013A532B
.long 0x24540082
.long 0xD1FE0028, 0x02060103
.long 0xD1000028, 0x013A512B
.long 0xD3D84020, 0x18000100
.long 0xD3D84021, 0x18000104
.long 0xD3D84022, 0x18000108
.long 0xD3D84023, 0x1800010C
.long 0xD3D84024, 0x18000110
.long 0xD3D84025, 0x18000114
.long 0xD3D84026, 0x18000118
.long 0xD3D84027, 0x1800011C
.long 0xD3D84030, 0x18000101
.long 0xD3D84031, 0x18000105
.long 0xD3D84032, 0x18000109
.long 0xD3D84033, 0x1800010D
.long 0xD3D84034, 0x18000111
.long 0xD3D84035, 0x18000115
.long 0xD3D84036, 0x18000119
.long 0xD3D84037, 0x1800011D
.long 0xBF800001
.long 0x0A40402C
.long 0x0A42422C
.long 0x0A44442C
.long 0x0A46462C
.long 0x0A48482C
.long 0x0A4A4A2C
.long 0x0A4C4C2C
.long 0x0A4E4E2C
.long 0x0A60602C
.long 0x0A62622C
.long 0x0A64642C
.long 0x0A66662C
.long 0x0A68682C
.long 0x0A6A6A2C
.long 0x0A6C6C2C
.long 0x0A6E6E2C
.long 0xBF8C0000
.long 0xD0CC0034, 0x00010042
.long 0xD1000018, 0x00D230F2
.long 0xD1000019, 0x00D232F2
.long 0xD3B14020, 0x18024118
.long 0xD0CC0034, 0x00010042
.long 0xD100001A, 0x00D234F2
.long 0xD100001B, 0x00D236F2
.long 0xD3B14022, 0x1802451A
.long 0xD0CC0034, 0x00010042
.long 0xD100001C, 0x00D238F2
.long 0xD100001D, 0x00D23AF2
.long 0xD3B14024, 0x1802491C
.long 0xD0CC0034, 0x00010042
.long 0xD100001E, 0x00D23CF2
.long 0xD100001F, 0x00D23EF2
.long 0xD3B14026, 0x18024D1E
.long 0xD3B24004, 0x18024110
.long 0xD3B24006, 0x18024512
.long 0xD3B24008, 0x18024914
.long 0xD3B2400A, 0x18024D16
.long 0xBEC81E3E
.long 0x7E400304
.long 0x7E420305
.long 0x7E440306
.long 0x7E460307
.long 0x7E480308
.long 0x7E4A0309
.long 0x7E4C030A
.long 0x7E4E030B
.long 0x7E401520
.long 0x7E421521
.long 0xD2A00020, 0x00024320
.long 0x7E441522
.long 0x7E461523
.long 0xD2A00021, 0x00024722
.long 0x7E481524
.long 0x7E4A1525
.long 0xD2A00022, 0x00024B24
.long 0x7E4C1526
.long 0x7E4E1527
.long 0xD2A00023, 0x00024F26
.long 0xE07C1000, 0x8003200D
.long 0xD0CC0034, 0x00010042
.long 0xD1000018, 0x00D230F2
.long 0xD1000019, 0x00D232F2
.long 0xD3B14030, 0x18026118
.long 0xD0CC0034, 0x00010042
.long 0xD100001A, 0x00D234F2
.long 0xD100001B, 0x00D236F2
.long 0xD3B14032, 0x1802651A
.long 0xD0CC0034, 0x00010042
.long 0xD100001C, 0x00D238F2
.long 0xD100001D, 0x00D23AF2
.long 0xD3B14034, 0x1802691C
.long 0xD0CC0034, 0x00010042
.long 0xD100001E, 0x00D23CF2
.long 0xD100001F, 0x00D23EF2
.long 0xD3B14036, 0x18026D1E
.long 0xD3B24004, 0x18026110
.long 0xD3B24006, 0x18026512
.long 0xD3B24008, 0x18026914
.long 0xD3B2400A, 0x18026D16
.long 0xBEC81E3E
.long 0x7E600304
.long 0x7E620305
.long 0x7E640306
.long 0x7E660307
.long 0x7E680308
.long 0x7E6A0309
.long 0x7E6C030A
.long 0x7E6E030B
.long 0x7E601530
.long 0x7E621531
.long 0xD2A00030, 0x00026330
.long 0x7E641532
.long 0x7E661533
.long 0xD2A00031, 0x00026732
.long 0x7E681534
.long 0x7E6A1535
.long 0xD2A00032, 0x00026B34
.long 0x7E6C1536
.long 0x7E6E1537
.long 0xD2A00033, 0x00026F36
.long 0xE07C1000, 0x80033028
.long 0xBF800000
.long 0x7E5602FF, 0x80000000
.long 0xD1196A01, 0x00010301
.long 0xD1340002, 0x00004D02
.long 0xD1340003, 0x00004903
.long 0xD0C9004A, 0x00003100
.long 0xD0C9004E, 0x00003301
.long 0x86CE4E4A
.long 0x924A02FF, 0x00000200
.long 0xD135000E, 0x00009500
.long 0x241C1C82
.long 0xD100000E, 0x013A1D2B
.long 0xD9FE0000, 0x1000000E
.long 0xD9FE0010, 0x1400000E
.long 0x241E0082
.long 0xE05C1000, 0x8010180F
.long 0xE05C1010, 0x80101C0F
.long 0xD1FE000D, 0x02060103
.long 0xD100000D, 0x013A1B2B
.long 0xD1196A01, 0x00010301
.long 0xD1340002, 0x00004D02
.long 0xD1340003, 0x00004903
.long 0xD0C9004A, 0x00003100
.long 0xD0C9004E, 0x00003301
.long 0x86CE4E4A
.long 0x924A02FF, 0x00000200
.long 0xD1350029, 0x00009500
.long 0x24525282
.long 0xD1000029, 0x013A532B
.long 0x24540082
.long 0xD1FE0028, 0x02060103
.long 0xD1000028, 0x013A512B
.long 0xD3D84020, 0x18000102
.long 0xD3D84021, 0x18000106
.long 0xD3D84022, 0x1800010A
.long 0xD3D84023, 0x1800010E
.long 0xD3D84024, 0x18000112
.long 0xD3D84025, 0x18000116
.long 0xD3D84026, 0x1800011A
.long 0xD3D84027, 0x1800011E
.long 0xD3D84030, 0x18000103
.long 0xD3D84031, 0x18000107
.long 0xD3D84032, 0x1800010B
.long 0xD3D84033, 0x1800010F
.long 0xD3D84034, 0x18000113
.long 0xD3D84035, 0x18000117
.long 0xD3D84036, 0x1800011B
.long 0xD3D84037, 0x1800011F
.long 0xBF800001
.long 0x0A40402C
.long 0x0A42422C
.long 0x0A44442C
.long 0x0A46462C
.long 0x0A48482C
.long 0x0A4A4A2C
.long 0x0A4C4C2C
.long 0x0A4E4E2C
.long 0x0A60602C
.long 0x0A62622C
.long 0x0A64642C
.long 0x0A66662C
.long 0x0A68682C
.long 0x0A6A6A2C
.long 0x0A6C6C2C
.long 0x0A6E6E2C
.long 0xBF8C0000
.long 0xD0CC0034, 0x00010042
.long 0xD1000018, 0x00D230F2
.long 0xD1000019, 0x00D232F2
.long 0xD3B14020, 0x18024118
.long 0xD0CC0034, 0x00010042
.long 0xD100001A, 0x00D234F2
.long 0xD100001B, 0x00D236F2
.long 0xD3B14022, 0x1802451A
.long 0xD0CC0034, 0x00010042
.long 0xD100001C, 0x00D238F2
.long 0xD100001D, 0x00D23AF2
.long 0xD3B14024, 0x1802491C
.long 0xD0CC0034, 0x00010042
.long 0xD100001E, 0x00D23CF2
.long 0xD100001F, 0x00D23EF2
.long 0xD3B14026, 0x18024D1E
.long 0xD3B24004, 0x18024110
.long 0xD3B24006, 0x18024512
.long 0xD3B24008, 0x18024914
.long 0xD3B2400A, 0x18024D16
.long 0xBEC81E3E
.long 0x7E400304
.long 0x7E420305
.long 0x7E440306
.long 0x7E460307
.long 0x7E480308
.long 0x7E4A0309
.long 0x7E4C030A
.long 0x7E4E030B
.long 0x7E401520
.long 0x7E421521
.long 0xD2A00020, 0x00024320
.long 0x7E441522
.long 0x7E461523
.long 0xD2A00021, 0x00024722
.long 0x7E481524
.long 0x7E4A1525
.long 0xD2A00022, 0x00024B24
.long 0x7E4C1526
.long 0x7E4E1527
.long 0xD2A00023, 0x00024F26
.long 0xE07C1000, 0x8003200D
.long 0xD0CC0034, 0x00010042
.long 0xD1000018, 0x00D230F2
.long 0xD1000019, 0x00D232F2
.long 0xD3B14030, 0x18026118
.long 0xD0CC0034, 0x00010042
.long 0xD100001A, 0x00D234F2
.long 0xD100001B, 0x00D236F2
.long 0xD3B14032, 0x1802651A
.long 0xD0CC0034, 0x00010042
.long 0xD100001C, 0x00D238F2
.long 0xD100001D, 0x00D23AF2
.long 0xD3B14034, 0x1802691C
.long 0xD0CC0034, 0x00010042
.long 0xD100001E, 0x00D23CF2
.long 0xD100001F, 0x00D23EF2
.long 0xD3B14036, 0x18026D1E
.long 0xD3B24004, 0x18026110
.long 0xD3B24006, 0x18026512
.long 0xD3B24008, 0x18026914
.long 0xD3B2400A, 0x18026D16
.long 0xBEC81E3E
.long 0x7E600304
.long 0x7E620305
.long 0x7E640306
.long 0x7E660307
.long 0x7E680308
.long 0x7E6A0309
.long 0x7E6C030A
.long 0x7E6E030B
.long 0x7E601530
.long 0x7E621531
.long 0xD2A00030, 0x00026330
.long 0x7E641532
.long 0x7E661533
.long 0xD2A00031, 0x00026732
.long 0x7E681534
.long 0x7E6A1535
.long 0xD2A00032, 0x00026B34
.long 0x7E6C1536
.long 0x7E6E1537
.long 0xD2A00033, 0x00026F36
.long 0xE07C1000, 0x80033028
.long 0xBF800000
.long 0xBF820635
.long 0x864A18FF, 0x000001FF
.long 0x804B14C1
.long 0xBF094B02
.long 0x854A804A
.long 0xB54A0000
.long 0xBF8501F6
.long 0x864A198F
.long 0x804B15C1
.long 0xBF094B03
.long 0x854A804A
.long 0xB54A0000
.long 0xBF8501F0
.long 0xD1FE000E, 0x02060102
.long 0xE05C1000, 0x8004140E
.long 0x924A02FF, 0x00000200
.long 0xD135000F, 0x00009500
.long 0x241E1E82
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD9FE0000, 0x1800000F
.long 0xD9FE0010, 0x1C00000F
.long 0x24200082
.long 0xE05C1000, 0x80102010
.long 0xE05C1010, 0x80102410
.long 0x8E4A8126
.long 0x80104A10
.long 0x82118011
.long 0xE05C1000, 0x8004300E
.long 0xD1FE000D, 0x02060103
.long 0xD3D84028, 0x18000100
.long 0xD3D84029, 0x18000104
.long 0xD3D8402A, 0x18000108
.long 0xD3D8402B, 0x1800010C
.long 0xD3D8402C, 0x18000110
.long 0xD3D8402D, 0x18000114
.long 0xD3D8402E, 0x18000118
.long 0xD3D8402F, 0x1800011C
.long 0xD3D84038, 0x18000101
.long 0xD3D84039, 0x18000105
.long 0xD3D8403A, 0x18000109
.long 0xD3D8403B, 0x1800010D
.long 0xD3D8403C, 0x18000111
.long 0xD3D8403D, 0x18000115
.long 0xD3D8403E, 0x18000119
.long 0xD3D8403F, 0x1800011D
.long 0xBF800001
.long 0x0A50502C
.long 0x0A52522C
.long 0x0A54542C
.long 0x0A56562C
.long 0x0A58582C
.long 0x0A5A5A2C
.long 0x0A5C5C2C
.long 0x0A5E5E2C
.long 0x0A70702C
.long 0x0A72722C
.long 0x0A74742C
.long 0x0A76762C
.long 0x0A78782C
.long 0x0A7A7A2C
.long 0x0A7C7C2C
.long 0x0A7E7E2C
.long 0xBF8C0071
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14028, 0x18025120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B1402A, 0x18025522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B1402C, 0x18025924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B1402E, 0x18025D26
.long 0xD3A00028, 0x14A2282D
.long 0xD3A01029, 0x14A6282D
.long 0xD3A0002A, 0x14AA2A2D
.long 0xD3A0102B, 0x14AE2A2D
.long 0xD3A0002C, 0x14B22C2D
.long 0xD3A0102D, 0x14B62C2D
.long 0xD3A0002E, 0x14BA2E2D
.long 0xD3A0102F, 0x14BE2E2D
.long 0xD3B24004, 0x18025118
.long 0xD3B24006, 0x1802551A
.long 0xD3B24008, 0x1802591C
.long 0xD3B2400A, 0x18025D1E
.long 0xBEC81E3E
.long 0x7E500304
.long 0x7E520305
.long 0x7E540306
.long 0x7E560307
.long 0x7E580308
.long 0x7E5A0309
.long 0x7E5C030A
.long 0x7E5E030B
.long 0x7E501528
.long 0x7E521529
.long 0xD2A00028, 0x00025328
.long 0x7E54152A
.long 0x7E56152B
.long 0xD2A00029, 0x0002572A
.long 0x7E58152C
.long 0x7E5A152D
.long 0xD2A0002A, 0x00025B2C
.long 0x7E5C152E
.long 0x7E5E152F
.long 0xD2A0002B, 0x00025F2E
.long 0xE07C1000, 0x8003280D
.long 0xBF8C0F71
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14038, 0x18027120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B1403A, 0x18027522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B1403C, 0x18027924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B1403E, 0x18027D26
.long 0xD3A00038, 0x14E2602D
.long 0xD3A01039, 0x14E6602D
.long 0xD3A0003A, 0x14EA622D
.long 0xD3A0103B, 0x14EE622D
.long 0xD3A0003C, 0x14F2642D
.long 0xD3A0103D, 0x14F6642D
.long 0xD3A0003E, 0x14FA662D
.long 0xD3A0103F, 0x14FE662D
.long 0xD3B24004, 0x18027118
.long 0xD3B24006, 0x1802751A
.long 0xD3B24008, 0x1802791C
.long 0xD3B2400A, 0x18027D1E
.long 0xBEC81E3E
.long 0x7E700304
.long 0x7E720305
.long 0x7E740306
.long 0x7E760307
.long 0x7E780308
.long 0x7E7A0309
.long 0x7E7C030A
.long 0x7E7E030B
.long 0x7E701538
.long 0x7E721539
.long 0xD2A00038, 0x00027338
.long 0x7E74153A
.long 0x7E76153B
.long 0xD2A00039, 0x0002773A
.long 0x7E78153C
.long 0x7E7A153D
.long 0xD2A0003A, 0x00027B3C
.long 0x7E7C153E
.long 0x7E7E153F
.long 0xD2A0003B, 0x00027F3E
.long 0x8E4A8124
.long 0x800C4A0C
.long 0x820D800D
.long 0xE07C1000, 0x8003380D
.long 0xBF800000
.long 0x8E4A8126
.long 0x80104A10
.long 0x82118011
.long 0xE05C1000, 0x8004140E
.long 0x924A02FF, 0x00000200
.long 0xD135000F, 0x00009500
.long 0x241E1E82
.long 0xD9FE0000, 0x1800000F
.long 0xD9FE0010, 0x1C00000F
.long 0xE05C1000, 0x80102010
.long 0xE05C1010, 0x80102410
.long 0x8E4A8126
.long 0x80104A10
.long 0x82118011
.long 0xE05C1000, 0x8004300E
.long 0xD3D84028, 0x18000102
.long 0xD3D84029, 0x18000106
.long 0xD3D8402A, 0x1800010A
.long 0xD3D8402B, 0x1800010E
.long 0xD3D8402C, 0x18000112
.long 0xD3D8402D, 0x18000116
.long 0xD3D8402E, 0x1800011A
.long 0xD3D8402F, 0x1800011E
.long 0xD3D84038, 0x18000103
.long 0xD3D84039, 0x18000107
.long 0xD3D8403A, 0x1800010B
.long 0xD3D8403B, 0x1800010F
.long 0xD3D8403C, 0x18000113
.long 0xD3D8403D, 0x18000117
.long 0xD3D8403E, 0x1800011B
.long 0xD3D8403F, 0x1800011F
.long 0xBF800001
.long 0x0A50502C
.long 0x0A52522C
.long 0x0A54542C
.long 0x0A56562C
.long 0x0A58582C
.long 0x0A5A5A2C
.long 0x0A5C5C2C
.long 0x0A5E5E2C
.long 0x0A70702C
.long 0x0A72722C
.long 0x0A74742C
.long 0x0A76762C
.long 0x0A78782C
.long 0x0A7A7A2C
.long 0x0A7C7C2C
.long 0x0A7E7E2C
.long 0xBF8C0071
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14028, 0x18025120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B1402A, 0x18025522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B1402C, 0x18025924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B1402E, 0x18025D26
.long 0xD3A00028, 0x14A2282D
.long 0xD3A01029, 0x14A6282D
.long 0xD3A0002A, 0x14AA2A2D
.long 0xD3A0102B, 0x14AE2A2D
.long 0xD3A0002C, 0x14B22C2D
.long 0xD3A0102D, 0x14B62C2D
.long 0xD3A0002E, 0x14BA2E2D
.long 0xD3A0102F, 0x14BE2E2D
.long 0xD3B24004, 0x18025118
.long 0xD3B24006, 0x1802551A
.long 0xD3B24008, 0x1802591C
.long 0xD3B2400A, 0x18025D1E
.long 0xBEC81E3E
.long 0x7E500304
.long 0x7E520305
.long 0x7E540306
.long 0x7E560307
.long 0x7E580308
.long 0x7E5A0309
.long 0x7E5C030A
.long 0x7E5E030B
.long 0x7E501528
.long 0x7E521529
.long 0xD2A00028, 0x00025328
.long 0x7E54152A
.long 0x7E56152B
.long 0xD2A00029, 0x0002572A
.long 0x7E58152C
.long 0x7E5A152D
.long 0xD2A0002A, 0x00025B2C
.long 0x7E5C152E
.long 0x7E5E152F
.long 0xD2A0002B, 0x00025F2E
.long 0x8E4A8124
.long 0x800C4A0C
.long 0x820D800D
.long 0xE07C1000, 0x8003280D
.long 0xBF8C0F71
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14038, 0x18027120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B1403A, 0x18027522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B1403C, 0x18027924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B1403E, 0x18027D26
.long 0xD3A00038, 0x14E2602D
.long 0xD3A01039, 0x14E6602D
.long 0xD3A0003A, 0x14EA622D
.long 0xD3A0103B, 0x14EE622D
.long 0xD3A0003C, 0x14F2642D
.long 0xD3A0103D, 0x14F6642D
.long 0xD3A0003E, 0x14FA662D
.long 0xD3A0103F, 0x14FE662D
.long 0xD3B24004, 0x18027118
.long 0xD3B24006, 0x1802751A
.long 0xD3B24008, 0x1802791C
.long 0xD3B2400A, 0x18027D1E
.long 0xBEC81E3E
.long 0x7E700304
.long 0x7E720305
.long 0x7E740306
.long 0x7E760307
.long 0x7E780308
.long 0x7E7A0309
.long 0x7E7C030A
.long 0x7E7E030B
.long 0x7E701538
.long 0x7E721539
.long 0xD2A00038, 0x00027338
.long 0x7E74153A
.long 0x7E76153B
.long 0xD2A00039, 0x0002773A
.long 0x7E78153C
.long 0x7E7A153D
.long 0xD2A0003A, 0x00027B3C
.long 0x7E7C153E
.long 0x7E7E153F
.long 0xD2A0003B, 0x00027F3E
.long 0x8E4A8124
.long 0x800C4A0C
.long 0x820D800D
.long 0xE07C1000, 0x8003380D
.long 0xBF800000
.long 0xBF820438
.long 0x7E2E02FF, 0x80000000
.long 0xD0C9004A, 0x00003100
.long 0xD0C9004E, 0x00003301
.long 0x86CE4E4A
.long 0xD1FE000D, 0x02060102
.long 0xD100000D, 0x013A1B17
.long 0xE05C1000, 0x8004100D
.long 0x924A02FF, 0x00000200
.long 0xD135000E, 0x00009500
.long 0x241C1C82
.long 0xD100000E, 0x013A1D17
.long 0xBF8CC07F
.long 0xBF8A0000
.long 0xD9FE0000, 0x1800000E
.long 0xD9FE0010, 0x1C00000E
.long 0x241E0082
.long 0xE05C1000, 0x8010200F
.long 0xE05C1010, 0x8010240F
.long 0xD1FE000D, 0x02060103
.long 0xD100000D, 0x013A1B17
.long 0xD1196A01, 0x00010301
.long 0xD1340002, 0x00004D02
.long 0xD1340003, 0x00004903
.long 0xD0C9004A, 0x00003100
.long 0xD0C9004E, 0x00003301
.long 0x86CE4E4A
.long 0xD1FE0014, 0x02060102
.long 0xD1000014, 0x013A2917
.long 0xE05C1000, 0x80043014
.long 0x924A02FF, 0x00000200
.long 0xD1350015, 0x00009500
.long 0x242A2A82
.long 0xD1000015, 0x013A2B17
.long 0x242C0082
.long 0xD1FE0014, 0x02060103
.long 0xD1000014, 0x013A2917
.long 0xD3D84028, 0x18000100
.long 0xD3D84029, 0x18000104
.long 0xD3D8402A, 0x18000108
.long 0xD3D8402B, 0x1800010C
.long 0xD3D8402C, 0x18000110
.long 0xD3D8402D, 0x18000114
.long 0xD3D8402E, 0x18000118
.long 0xD3D8402F, 0x1800011C
.long 0xD3D84038, 0x18000101
.long 0xD3D84039, 0x18000105
.long 0xD3D8403A, 0x18000109
.long 0xD3D8403B, 0x1800010D
.long 0xD3D8403C, 0x18000111
.long 0xD3D8403D, 0x18000115
.long 0xD3D8403E, 0x18000119
.long 0xD3D8403F, 0x1800011D
.long 0xBF800001
.long 0x0A50502C
.long 0x0A52522C
.long 0x0A54542C
.long 0x0A56562C
.long 0x0A58582C
.long 0x0A5A5A2C
.long 0x0A5C5C2C
.long 0x0A5E5E2C
.long 0x0A70702C
.long 0x0A72722C
.long 0x0A74742C
.long 0x0A76762C
.long 0x0A78782C
.long 0x0A7A7A2C
.long 0x0A7C7C2C
.long 0x0A7E7E2C
.long 0xBF8C0000
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14028, 0x18025120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B1402A, 0x18025522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B1402C, 0x18025924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B1402E, 0x18025D26
.long 0xD3A00028, 0x14A2202D
.long 0xD3A01029, 0x14A6202D
.long 0xD3A0002A, 0x14AA222D
.long 0xD3A0102B, 0x14AE222D
.long 0xD3A0002C, 0x14B2242D
.long 0xD3A0102D, 0x14B6242D
.long 0xD3A0002E, 0x14BA262D
.long 0xD3A0102F, 0x14BE262D
.long 0xD3B24004, 0x18025118
.long 0xD3B24006, 0x1802551A
.long 0xD3B24008, 0x1802591C
.long 0xD3B2400A, 0x18025D1E
.long 0xBEC81E3E
.long 0x7E500304
.long 0x7E520305
.long 0x7E540306
.long 0x7E560307
.long 0x7E580308
.long 0x7E5A0309
.long 0x7E5C030A
.long 0x7E5E030B
.long 0x7E501528
.long 0x7E521529
.long 0xD2A00028, 0x00025328
.long 0x7E54152A
.long 0x7E56152B
.long 0xD2A00029, 0x0002572A
.long 0x7E58152C
.long 0x7E5A152D
.long 0xD2A0002A, 0x00025B2C
.long 0x7E5C152E
.long 0x7E5E152F
.long 0xD2A0002B, 0x00025F2E
.long 0xE07C1000, 0x8003280D
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14038, 0x18027120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B1403A, 0x18027522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B1403C, 0x18027924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B1403E, 0x18027D26
.long 0xD3A00038, 0x14E2602D
.long 0xD3A01039, 0x14E6602D
.long 0xD3A0003A, 0x14EA622D
.long 0xD3A0103B, 0x14EE622D
.long 0xD3A0003C, 0x14F2642D
.long 0xD3A0103D, 0x14F6642D
.long 0xD3A0003E, 0x14FA662D
.long 0xD3A0103F, 0x14FE662D
.long 0xD3B24004, 0x18027118
.long 0xD3B24006, 0x1802751A
.long 0xD3B24008, 0x1802791C
.long 0xD3B2400A, 0x18027D1E
.long 0xBEC81E3E
.long 0x7E700304
.long 0x7E720305
.long 0x7E740306
.long 0x7E760307
.long 0x7E780308
.long 0x7E7A0309
.long 0x7E7C030A
.long 0x7E7E030B
.long 0x7E701538
.long 0x7E721539
.long 0xD2A00038, 0x00027338
.long 0x7E74153A
.long 0x7E76153B
.long 0xD2A00039, 0x0002773A
.long 0x7E78153C
.long 0x7E7A153D
.long 0xD2A0003A, 0x00027B3C
.long 0x7E7C153E
.long 0x7E7E153F
.long 0xD2A0003B, 0x00027F3E
.long 0xE07C1000, 0x80033814
.long 0xBF800000
.long 0x7E2E02FF, 0x80000000
.long 0xD1196A01, 0x00010301
.long 0xD1340002, 0x00004D02
.long 0xD1340003, 0x00004903
.long 0xD0C9004A, 0x00003100
.long 0xD0C9004E, 0x00003301
.long 0x86CE4E4A
.long 0xD1FE000D, 0x02060102
.long 0xD100000D, 0x013A1B17
.long 0xE05C1000, 0x8004100D
.long 0x924A02FF, 0x00000200
.long 0xD135000E, 0x00009500
.long 0x241C1C82
.long 0xD100000E, 0x013A1D17
.long 0xD9FE0000, 0x1800000E
.long 0xD9FE0010, 0x1C00000E
.long 0x241E0082
.long 0xE05C1000, 0x8010200F
.long 0xE05C1010, 0x8010240F
.long 0xD1FE000D, 0x02060103
.long 0xD100000D, 0x013A1B17
.long 0xD1196A01, 0x00010301
.long 0xD1340002, 0x00004D02
.long 0xD1340003, 0x00004903
.long 0xD0C9004A, 0x00003100
.long 0xD0C9004E, 0x00003301
.long 0x86CE4E4A
.long 0xD1FE0014, 0x02060102
.long 0xD1000014, 0x013A2917
.long 0xE05C1000, 0x80043014
.long 0x924A02FF, 0x00000200
.long 0xD1350015, 0x00009500
.long 0x242A2A82
.long 0xD1000015, 0x013A2B17
.long 0x242C0082
.long 0xD1FE0014, 0x02060103
.long 0xD1000014, 0x013A2917
.long 0xD3D84028, 0x18000102
.long 0xD3D84029, 0x18000106
.long 0xD3D8402A, 0x1800010A
.long 0xD3D8402B, 0x1800010E
.long 0xD3D8402C, 0x18000112
.long 0xD3D8402D, 0x18000116
.long 0xD3D8402E, 0x1800011A
.long 0xD3D8402F, 0x1800011E
.long 0xD3D84038, 0x18000103
.long 0xD3D84039, 0x18000107
.long 0xD3D8403A, 0x1800010B
.long 0xD3D8403B, 0x1800010F
.long 0xD3D8403C, 0x18000113
.long 0xD3D8403D, 0x18000117
.long 0xD3D8403E, 0x1800011B
.long 0xD3D8403F, 0x1800011F
.long 0xBF800001
.long 0x0A50502C
.long 0x0A52522C
.long 0x0A54542C
.long 0x0A56562C
.long 0x0A58582C
.long 0x0A5A5A2C
.long 0x0A5C5C2C
.long 0x0A5E5E2C
.long 0x0A70702C
.long 0x0A72722C
.long 0x0A74742C
.long 0x0A76762C
.long 0x0A78782C
.long 0x0A7A7A2C
.long 0x0A7C7C2C
.long 0x0A7E7E2C
.long 0xBF8C0000
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14028, 0x18025120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B1402A, 0x18025522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B1402C, 0x18025924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B1402E, 0x18025D26
.long 0xD3A00028, 0x14A2202D
.long 0xD3A01029, 0x14A6202D
.long 0xD3A0002A, 0x14AA222D
.long 0xD3A0102B, 0x14AE222D
.long 0xD3A0002C, 0x14B2242D
.long 0xD3A0102D, 0x14B6242D
.long 0xD3A0002E, 0x14BA262D
.long 0xD3A0102F, 0x14BE262D
.long 0xD3B24004, 0x18025118
.long 0xD3B24006, 0x1802551A
.long 0xD3B24008, 0x1802591C
.long 0xD3B2400A, 0x18025D1E
.long 0xBEC81E3E
.long 0x7E500304
.long 0x7E520305
.long 0x7E540306
.long 0x7E560307
.long 0x7E580308
.long 0x7E5A0309
.long 0x7E5C030A
.long 0x7E5E030B
.long 0x7E501528
.long 0x7E521529
.long 0xD2A00028, 0x00025328
.long 0x7E54152A
.long 0x7E56152B
.long 0xD2A00029, 0x0002572A
.long 0x7E58152C
.long 0x7E5A152D
.long 0xD2A0002A, 0x00025B2C
.long 0x7E5C152E
.long 0x7E5E152F
.long 0xD2A0002B, 0x00025F2E
.long 0xE07C1000, 0x8003280D
.long 0xD0CC0034, 0x00010042
.long 0xD1000020, 0x00D240F2
.long 0xD1000021, 0x00D242F2
.long 0xD3B14038, 0x18027120
.long 0xD0CC0034, 0x00010042
.long 0xD1000022, 0x00D244F2
.long 0xD1000023, 0x00D246F2
.long 0xD3B1403A, 0x18027522
.long 0xD0CC0034, 0x00010042
.long 0xD1000024, 0x00D248F2
.long 0xD1000025, 0x00D24AF2
.long 0xD3B1403C, 0x18027924
.long 0xD0CC0034, 0x00010042
.long 0xD1000026, 0x00D24CF2
.long 0xD1000027, 0x00D24EF2
.long 0xD3B1403E, 0x18027D26
.long 0xD3A00038, 0x14E2602D
.long 0xD3A01039, 0x14E6602D
.long 0xD3A0003A, 0x14EA622D
.long 0xD3A0103B, 0x14EE622D
.long 0xD3A0003C, 0x14F2642D
.long 0xD3A0103D, 0x14F6642D
.long 0xD3A0003E, 0x14FA662D
.long 0xD3A0103F, 0x14FE662D
.long 0xD3B24004, 0x18027118
.long 0xD3B24006, 0x1802751A
.long 0xD3B24008, 0x1802791C
.long 0xD3B2400A, 0x18027D1E
.long 0xBEC81E3E
.long 0x7E700304
.long 0x7E720305
.long 0x7E740306
.long 0x7E760307
.long 0x7E780308
.long 0x7E7A0309
.long 0x7E7C030A
.long 0x7E7E030B
.long 0x7E701538
.long 0x7E721539
.long 0xD2A00038, 0x00027338
.long 0x7E74153A
.long 0x7E76153B
.long 0xD2A00039, 0x0002773A
.long 0x7E78153C
.long 0x7E7A153D
.long 0xD2A0003A, 0x00027B3C
.long 0x7E7C153E
.long 0x7E7E153F
.long 0xD2A0003B, 0x00027F3E
.long 0xE07C1000, 0x80033814
.long 0xBF800000
.long 0xBF820201
.long 0xBE801D48
.long 0x260808FF, 0x7FFFFFFF
.long 0x260A0AFF, 0x7FFFFFFF
.long 0x260C0CFF, 0x7FFFFFFF
.long 0x260E0EFF, 0x7FFFFFFF
.long 0x261010FF, 0x7FFFFFFF
.long 0x261212FF, 0x7FFFFFFF
.long 0x261414FF, 0x7FFFFFFF
.long 0x261616FF, 0x7FFFFFFF
.long 0xBE801D48
.long 0xD044006A, 0x00007504
.long 0x1408083B
.long 0x00080880
.long 0xD044006A, 0x00007505
.long 0x140A0A3B
.long 0x000A0A80
.long 0xD044006A, 0x00007506
.long 0x140C0C3B
.long 0x000C0C80
.long 0xD044006A, 0x00007507
.long 0x140E0E3B
.long 0x000E0E80
.long 0xD044006A, 0x00007508
.long 0x1410103B
.long 0x00101080
.long 0xD044006A, 0x00007509
.long 0x1412123B
.long 0x00121280
.long 0xD044006A, 0x0000750A
.long 0x1414143B
.long 0x00141480
.long 0xD044006A, 0x0000750B
.long 0x1416163B
.long 0x00161680
.long 0xBE801D48
.long 0x0A1808FF, 0x3D372713
.long 0xD1CB000C, 0x03CA1904
.long 0x0A181904
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181904
.long 0x0A0818F0
.long 0x0A180AFF, 0x3D372713
.long 0xD1CB000C, 0x03CA1905
.long 0x0A181905
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181905
.long 0x0A0A18F0
.long 0x0A180CFF, 0x3D372713
.long 0xD1CB000C, 0x03CA1906
.long 0x0A181906
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181906
.long 0x0A0C18F0
.long 0x0A180EFF, 0x3D372713
.long 0xD1CB000C, 0x03CA1907
.long 0x0A181907
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181907
.long 0x0A0E18F0
.long 0x0A1810FF, 0x3D372713
.long 0xD1CB000C, 0x03CA1908
.long 0x0A181908
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181908
.long 0x0A1018F0
.long 0x0A1812FF, 0x3D372713
.long 0xD1CB000C, 0x03CA1909
.long 0x0A181909
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181909
.long 0x0A1218F0
.long 0x0A1814FF, 0x3D372713
.long 0xD1CB000C, 0x03CA190A
.long 0x0A18190A
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A18190A
.long 0x0A1418F0
.long 0x0A1816FF, 0x3D372713
.long 0xD1CB000C, 0x03CA190B
.long 0x0A18190B
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A18190B
.long 0x0A1618F0
.long 0xBE801D48
.long 0x0A18083A
.long 0xD046006A, 0x00010104
.long 0x0008090C
.long 0x0A180A3A
.long 0xD046006A, 0x00010105
.long 0x000A0B0C
.long 0x0A180C3A
.long 0xD046006A, 0x00010106
.long 0x000C0D0C
.long 0x0A180E3A
.long 0xD046006A, 0x00010107
.long 0x000E0F0C
.long 0x0A18103A
.long 0xD046006A, 0x00010108
.long 0x0010110C
.long 0x0A18123A
.long 0xD046006A, 0x00010109
.long 0x0012130C
.long 0x0A18143A
.long 0xD046006A, 0x0001010A
.long 0x0014150C
.long 0x0A18163A
.long 0xD046006A, 0x0001010B
.long 0x0016170C
.long 0xBE801D48
.long 0xD10B0004, 0x00010104
.long 0xD10B0005, 0x00010105
.long 0xD10B0006, 0x00010106
.long 0xD10B0007, 0x00010107
.long 0xD10B0008, 0x00010108
.long 0xD10B0009, 0x00010109
.long 0xD10B000A, 0x0001010A
.long 0xD10B000B, 0x0001010B
.long 0xBE801D48
.long 0x0A0808FF, 0xBFB8AA3B
.long 0x7E084104
.long 0xBF800000
.long 0x020808F2
.long 0x7E084504
.long 0xBF800000
.long 0x0A0A0AFF, 0xBFB8AA3B
.long 0x7E0A4105
.long 0xBF800000
.long 0x020A0AF2
.long 0x7E0A4505
.long 0xBF800000
.long 0x0A0C0CFF, 0xBFB8AA3B
.long 0x7E0C4106
.long 0xBF800000
.long 0x020C0CF2
.long 0x7E0C4506
.long 0xBF800000
.long 0x0A0E0EFF, 0xBFB8AA3B
.long 0x7E0E4107
.long 0xBF800000
.long 0x020E0EF2
.long 0x7E0E4507
.long 0xBF800000
.long 0x0A1010FF, 0xBFB8AA3B
.long 0x7E104108
.long 0xBF800000
.long 0x021010F2
.long 0x7E104508
.long 0xBF800000
.long 0x0A1212FF, 0xBFB8AA3B
.long 0x7E124109
.long 0xBF800000
.long 0x021212F2
.long 0x7E124509
.long 0xBF800000
.long 0x0A1414FF, 0xBFB8AA3B
.long 0x7E14410A
.long 0xBF800000
.long 0x021414F2
.long 0x7E14450A
.long 0xBF800000
.long 0x0A1616FF, 0xBFB8AA3B
.long 0x7E16410B
.long 0xBF800000
.long 0x021616F2
.long 0x7E16450B
.long 0xBF800000
.long 0xBE801D48
.long 0x0A08083A
.long 0x0A0808FF, 0x4038AA3B
.long 0x7E084104
.long 0xBF800000
.long 0x020808F2
.long 0x7E084504
.long 0xBF800000
.long 0xD1CB0004, 0x03CA08F5
.long 0x0A08083B
.long 0x0A0A0A3A
.long 0x0A0A0AFF, 0x4038AA3B
.long 0x7E0A4105
.long 0xBF800000
.long 0x020A0AF2
.long 0x7E0A4505
.long 0xBF800000
.long 0xD1CB0005, 0x03CA0AF5
.long 0x0A0A0A3B
.long 0x0A0C0C3A
.long 0x0A0C0CFF, 0x4038AA3B
.long 0x7E0C4106
.long 0xBF800000
.long 0x020C0CF2
.long 0x7E0C4506
.long 0xBF800000
.long 0xD1CB0006, 0x03CA0CF5
.long 0x0A0C0C3B
.long 0x0A0E0E3A
.long 0x0A0E0EFF, 0x4038AA3B
.long 0x7E0E4107
.long 0xBF800000
.long 0x020E0EF2
.long 0x7E0E4507
.long 0xBF800000
.long 0xD1CB0007, 0x03CA0EF5
.long 0x0A0E0E3B
.long 0x0A10103A
.long 0x0A1010FF, 0x4038AA3B
.long 0x7E104108
.long 0xBF800000
.long 0x021010F2
.long 0x7E104508
.long 0xBF800000
.long 0xD1CB0008, 0x03CA10F5
.long 0x0A10103B
.long 0x0A12123A
.long 0x0A1212FF, 0x4038AA3B
.long 0x7E124109
.long 0xBF800000
.long 0x021212F2
.long 0x7E124509
.long 0xBF800000
.long 0xD1CB0009, 0x03CA12F5
.long 0x0A12123B
.long 0x0A14143A
.long 0x0A1414FF, 0x4038AA3B
.long 0x7E14410A
.long 0xBF800000
.long 0x021414F2
.long 0x7E14450A
.long 0xBF800000
.long 0xD1CB000A, 0x03CA14F5
.long 0x0A14143B
.long 0x0A16163A
.long 0x0A1616FF, 0x4038AA3B
.long 0x7E16410B
.long 0xBF800000
.long 0x021616F2
.long 0x7E16450B
.long 0xBF800000
.long 0xD1CB000B, 0x03CA16F5
.long 0x0A16163B
.long 0xBE801D48
.long 0x0A1808FF, 0x3D372713
.long 0xD1CB000C, 0x03CA1904
.long 0x0A181904
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181904
.long 0x0A1818F0
.long 0x0A08183A
.long 0x0A180AFF, 0x3D372713
.long 0xD1CB000C, 0x03CA1905
.long 0x0A181905
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181905
.long 0x0A1818F0
.long 0x0A0A183A
.long 0x0A180CFF, 0x3D372713
.long 0xD1CB000C, 0x03CA1906
.long 0x0A181906
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181906
.long 0x0A1818F0
.long 0x0A0C183A
.long 0x0A180EFF, 0x3D372713
.long 0xD1CB000C, 0x03CA1907
.long 0x0A181907
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181907
.long 0x0A1818F0
.long 0x0A0E183A
.long 0x0A1810FF, 0x3D372713
.long 0xD1CB000C, 0x03CA1908
.long 0x0A181908
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181908
.long 0x0A1818F0
.long 0x0A10183A
.long 0x0A1812FF, 0x3D372713
.long 0xD1CB000C, 0x03CA1909
.long 0x0A181909
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A181909
.long 0x0A1818F0
.long 0x0A12183A
.long 0x0A1814FF, 0x3D372713
.long 0xD1CB000C, 0x03CA190A
.long 0x0A18190A
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A18190A
.long 0x0A1818F0
.long 0x0A14183A
.long 0x0A1816FF, 0x3D372713
.long 0xD1CB000C, 0x03CA190B
.long 0x0A18190B
.long 0x0A1818FF, 0x40135761
.long 0x7E18410C
.long 0xBF800000
.long 0x021818F2
.long 0x7E18450C
.long 0xBF800000
.long 0xD1CB000C, 0x03D218F5
.long 0x0A18190B
.long 0x0A1818F0
.long 0x0A16183A
.long 0xBE801D48
.long 0xBF810000
