/*
 * This C file has been generated by smidump 0.5.0.
 * It is intended to be used with the NET-SNMP library.
 *
 * This C file is derived from the BRIDGE-MIB module.
 *
 * $Id$
 */

#include <stdlib.h>

#include <ucd-snmp/asn1.h>
#include <ucd-snmp/snmp.h>
#include <ucd-snmp/snmp_api.h>
#include <ucd-snmp/snmp_client.h>

#include "bridge-mib.h"

static oid dot1dBaseBridgeAddress[] = {1, 3, 6, 1, 2, 1, 17, 1, 1};
static oid dot1dBaseNumPorts[] = {1, 3, 6, 1, 2, 1, 17, 1, 2};
static oid dot1dBaseType[] = {1, 3, 6, 1, 2, 1, 17, 1, 3};
static oid dot1dBasePort[] = {1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 1};
static oid dot1dBasePortIfIndex[] = {1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 2};
static oid dot1dBasePortCircuit[] = {1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 3};
static oid dot1dBasePortDelayExceededDiscards[] = {1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 4};
static oid dot1dBasePortMtuExceededDiscards[] = {1, 3, 6, 1, 2, 1, 17, 1, 4, 1, 5};
static oid dot1dStpProtocolSpecification[] = {1, 3, 6, 1, 2, 1, 17, 2, 1};
static oid dot1dStpPriority[] = {1, 3, 6, 1, 2, 1, 17, 2, 2};
static oid dot1dStpTimeSinceTopologyChange[] = {1, 3, 6, 1, 2, 1, 17, 2, 3};
static oid dot1dStpTopChanges[] = {1, 3, 6, 1, 2, 1, 17, 2, 4};
static oid dot1dStpDesignatedRoot[] = {1, 3, 6, 1, 2, 1, 17, 2, 5};
static oid dot1dStpRootCost[] = {1, 3, 6, 1, 2, 1, 17, 2, 6};
static oid dot1dStpRootPort[] = {1, 3, 6, 1, 2, 1, 17, 2, 7};
static oid dot1dStpMaxAge[] = {1, 3, 6, 1, 2, 1, 17, 2, 8};
static oid dot1dStpHelloTime[] = {1, 3, 6, 1, 2, 1, 17, 2, 9};
static oid dot1dStpHoldTime[] = {1, 3, 6, 1, 2, 1, 17, 2, 10};
static oid dot1dStpForwardDelay[] = {1, 3, 6, 1, 2, 1, 17, 2, 11};
static oid dot1dStpBridgeMaxAge[] = {1, 3, 6, 1, 2, 1, 17, 2, 12};
static oid dot1dStpBridgeHelloTime[] = {1, 3, 6, 1, 2, 1, 17, 2, 13};
static oid dot1dStpBridgeForwardDelay[] = {1, 3, 6, 1, 2, 1, 17, 2, 14};
static oid dot1dStpPort[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 1};
static oid dot1dStpPortPriority[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 2};
static oid dot1dStpPortState[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 3};
static oid dot1dStpPortEnable[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 4};
static oid dot1dStpPortPathCost[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 5};
static oid dot1dStpPortDesignatedRoot[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 6};
static oid dot1dStpPortDesignatedCost[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 7};
static oid dot1dStpPortDesignatedBridge[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 8};
static oid dot1dStpPortDesignatedPort[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 9};
static oid dot1dStpPortForwardTransitions[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 10};
static oid dot1dStpPortPathCost32[] = {1, 3, 6, 1, 2, 1, 17, 2, 15, 1, 11};
static oid dot1dTpLearnedEntryDiscards[] = {1, 3, 6, 1, 2, 1, 17, 4, 1};
static oid dot1dTpAgingTime[] = {1, 3, 6, 1, 2, 1, 17, 4, 2};
static oid dot1dTpFdbAddress[] = {1, 3, 6, 1, 2, 1, 17, 4, 3, 1, 1};
static oid dot1dTpFdbPort[] = {1, 3, 6, 1, 2, 1, 17, 4, 3, 1, 2};
static oid dot1dTpFdbStatus[] = {1, 3, 6, 1, 2, 1, 17, 4, 3, 1, 3};
static oid dot1dTpPort[] = {1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 1};
static oid dot1dTpPortMaxInfo[] = {1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 2};
static oid dot1dTpPortInFrames[] = {1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 3};
static oid dot1dTpPortOutFrames[] = {1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 4};
static oid dot1dTpPortInDiscards[] = {1, 3, 6, 1, 2, 1, 17, 4, 4, 1, 5};
static oid dot1dStaticAddress[] = {1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 1};
static oid dot1dStaticReceivePort[] = {1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 2};
static oid dot1dStaticAllowedToGoTo[] = {1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 3};
static oid dot1dStaticStatus[] = {1, 3, 6, 1, 2, 1, 17, 5, 1, 1, 4};

int bridge_mib_mgr_get_dot1dBase(struct snmp_session *s, dot1dBase_t **dot1dBase)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, dot1dBaseBridgeAddress, sizeof(dot1dBaseBridgeAddress)/sizeof(oid));
    snmp_add_null_var(request, dot1dBaseNumPorts, sizeof(dot1dBaseNumPorts)/sizeof(oid));
    snmp_add_null_var(request, dot1dBaseType, sizeof(dot1dBaseType)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        snmp_free_pdu(request);
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *dot1dBase = (dot1dBase_t *) malloc(sizeof(dot1dBase_t));
    if (! *dot1dBase) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(dot1dBaseBridgeAddress)/sizeof(oid)
            && memcmp(vars->name, dot1dBaseBridgeAddress, sizeof(dot1dBaseBridgeAddress)) == 0) {
            memcpy((*dot1dBase)->__dot1dBaseBridgeAddress, vars->val.string, vars->val_len);
            (*dot1dBase)->dot1dBaseBridgeAddress = (*dot1dBase)->__dot1dBaseBridgeAddress;
        }
        if (vars->name_length > sizeof(dot1dBaseNumPorts)/sizeof(oid)
            && memcmp(vars->name, dot1dBaseNumPorts, sizeof(dot1dBaseNumPorts)) == 0) {
            (*dot1dBase)->__dot1dBaseNumPorts = *vars->val.integer;
            (*dot1dBase)->dot1dBaseNumPorts = &((*dot1dBase)->__dot1dBaseNumPorts);
        }
        if (vars->name_length > sizeof(dot1dBaseType)/sizeof(oid)
            && memcmp(vars->name, dot1dBaseType, sizeof(dot1dBaseType)) == 0) {
            (*dot1dBase)->__dot1dBaseType = *vars->val.integer;
            (*dot1dBase)->dot1dBaseType = &((*dot1dBase)->__dot1dBaseType);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int bridge_mib_mgr_get_dot1dBasePortEntry(struct snmp_session *s, dot1dBasePortEntry_t **dot1dBasePortEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, dot1dBasePort, sizeof(dot1dBasePort)/sizeof(oid));
    snmp_add_null_var(request, dot1dBasePortIfIndex, sizeof(dot1dBasePortIfIndex)/sizeof(oid));
    snmp_add_null_var(request, dot1dBasePortCircuit, sizeof(dot1dBasePortCircuit)/sizeof(oid));
    snmp_add_null_var(request, dot1dBasePortDelayExceededDiscards, sizeof(dot1dBasePortDelayExceededDiscards)/sizeof(oid));
    snmp_add_null_var(request, dot1dBasePortMtuExceededDiscards, sizeof(dot1dBasePortMtuExceededDiscards)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        snmp_free_pdu(request);
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *dot1dBasePortEntry = (dot1dBasePortEntry_t *) malloc(sizeof(dot1dBasePortEntry_t));
    if (! *dot1dBasePortEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(dot1dBasePort)/sizeof(oid)
            && memcmp(vars->name, dot1dBasePort, sizeof(dot1dBasePort)) == 0) {
            (*dot1dBasePortEntry)->__dot1dBasePort = *vars->val.integer;
            (*dot1dBasePortEntry)->dot1dBasePort = &((*dot1dBasePortEntry)->__dot1dBasePort);
        }
        if (vars->name_length > sizeof(dot1dBasePortIfIndex)/sizeof(oid)
            && memcmp(vars->name, dot1dBasePortIfIndex, sizeof(dot1dBasePortIfIndex)) == 0) {
            (*dot1dBasePortEntry)->__dot1dBasePortIfIndex = *vars->val.integer;
            (*dot1dBasePortEntry)->dot1dBasePortIfIndex = &((*dot1dBasePortEntry)->__dot1dBasePortIfIndex);
        }
        if (vars->name_length > sizeof(dot1dBasePortCircuit)/sizeof(oid)
            && memcmp(vars->name, dot1dBasePortCircuit, sizeof(dot1dBasePortCircuit)) == 0) {
        }
        if (vars->name_length > sizeof(dot1dBasePortDelayExceededDiscards)/sizeof(oid)
            && memcmp(vars->name, dot1dBasePortDelayExceededDiscards, sizeof(dot1dBasePortDelayExceededDiscards)) == 0) {
            (*dot1dBasePortEntry)->__dot1dBasePortDelayExceededDiscards = *vars->val.integer;
            (*dot1dBasePortEntry)->dot1dBasePortDelayExceededDiscards = &((*dot1dBasePortEntry)->__dot1dBasePortDelayExceededDiscards);
        }
        if (vars->name_length > sizeof(dot1dBasePortMtuExceededDiscards)/sizeof(oid)
            && memcmp(vars->name, dot1dBasePortMtuExceededDiscards, sizeof(dot1dBasePortMtuExceededDiscards)) == 0) {
            (*dot1dBasePortEntry)->__dot1dBasePortMtuExceededDiscards = *vars->val.integer;
            (*dot1dBasePortEntry)->dot1dBasePortMtuExceededDiscards = &((*dot1dBasePortEntry)->__dot1dBasePortMtuExceededDiscards);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int bridge_mib_mgr_get_dot1dStp(struct snmp_session *s, dot1dStp_t **dot1dStp)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, dot1dStpProtocolSpecification, sizeof(dot1dStpProtocolSpecification)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPriority, sizeof(dot1dStpPriority)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpTimeSinceTopologyChange, sizeof(dot1dStpTimeSinceTopologyChange)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpTopChanges, sizeof(dot1dStpTopChanges)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpDesignatedRoot, sizeof(dot1dStpDesignatedRoot)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpRootCost, sizeof(dot1dStpRootCost)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpRootPort, sizeof(dot1dStpRootPort)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpMaxAge, sizeof(dot1dStpMaxAge)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpHelloTime, sizeof(dot1dStpHelloTime)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpHoldTime, sizeof(dot1dStpHoldTime)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpForwardDelay, sizeof(dot1dStpForwardDelay)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpBridgeMaxAge, sizeof(dot1dStpBridgeMaxAge)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpBridgeHelloTime, sizeof(dot1dStpBridgeHelloTime)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpBridgeForwardDelay, sizeof(dot1dStpBridgeForwardDelay)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        snmp_free_pdu(request);
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *dot1dStp = (dot1dStp_t *) malloc(sizeof(dot1dStp_t));
    if (! *dot1dStp) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(dot1dStpProtocolSpecification)/sizeof(oid)
            && memcmp(vars->name, dot1dStpProtocolSpecification, sizeof(dot1dStpProtocolSpecification)) == 0) {
            (*dot1dStp)->__dot1dStpProtocolSpecification = *vars->val.integer;
            (*dot1dStp)->dot1dStpProtocolSpecification = &((*dot1dStp)->__dot1dStpProtocolSpecification);
        }
        if (vars->name_length > sizeof(dot1dStpPriority)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPriority, sizeof(dot1dStpPriority)) == 0) {
            (*dot1dStp)->__dot1dStpPriority = *vars->val.integer;
            (*dot1dStp)->dot1dStpPriority = &((*dot1dStp)->__dot1dStpPriority);
        }
        if (vars->name_length > sizeof(dot1dStpTimeSinceTopologyChange)/sizeof(oid)
            && memcmp(vars->name, dot1dStpTimeSinceTopologyChange, sizeof(dot1dStpTimeSinceTopologyChange)) == 0) {
            (*dot1dStp)->__dot1dStpTimeSinceTopologyChange = *vars->val.integer;
            (*dot1dStp)->dot1dStpTimeSinceTopologyChange = &((*dot1dStp)->__dot1dStpTimeSinceTopologyChange);
        }
        if (vars->name_length > sizeof(dot1dStpTopChanges)/sizeof(oid)
            && memcmp(vars->name, dot1dStpTopChanges, sizeof(dot1dStpTopChanges)) == 0) {
            (*dot1dStp)->__dot1dStpTopChanges = *vars->val.integer;
            (*dot1dStp)->dot1dStpTopChanges = &((*dot1dStp)->__dot1dStpTopChanges);
        }
        if (vars->name_length > sizeof(dot1dStpDesignatedRoot)/sizeof(oid)
            && memcmp(vars->name, dot1dStpDesignatedRoot, sizeof(dot1dStpDesignatedRoot)) == 0) {
            memcpy((*dot1dStp)->__dot1dStpDesignatedRoot, vars->val.string, vars->val_len);
            (*dot1dStp)->dot1dStpDesignatedRoot = (*dot1dStp)->__dot1dStpDesignatedRoot;
        }
        if (vars->name_length > sizeof(dot1dStpRootCost)/sizeof(oid)
            && memcmp(vars->name, dot1dStpRootCost, sizeof(dot1dStpRootCost)) == 0) {
            (*dot1dStp)->__dot1dStpRootCost = *vars->val.integer;
            (*dot1dStp)->dot1dStpRootCost = &((*dot1dStp)->__dot1dStpRootCost);
        }
        if (vars->name_length > sizeof(dot1dStpRootPort)/sizeof(oid)
            && memcmp(vars->name, dot1dStpRootPort, sizeof(dot1dStpRootPort)) == 0) {
            (*dot1dStp)->__dot1dStpRootPort = *vars->val.integer;
            (*dot1dStp)->dot1dStpRootPort = &((*dot1dStp)->__dot1dStpRootPort);
        }
        if (vars->name_length > sizeof(dot1dStpMaxAge)/sizeof(oid)
            && memcmp(vars->name, dot1dStpMaxAge, sizeof(dot1dStpMaxAge)) == 0) {
            (*dot1dStp)->__dot1dStpMaxAge = *vars->val.integer;
            (*dot1dStp)->dot1dStpMaxAge = &((*dot1dStp)->__dot1dStpMaxAge);
        }
        if (vars->name_length > sizeof(dot1dStpHelloTime)/sizeof(oid)
            && memcmp(vars->name, dot1dStpHelloTime, sizeof(dot1dStpHelloTime)) == 0) {
            (*dot1dStp)->__dot1dStpHelloTime = *vars->val.integer;
            (*dot1dStp)->dot1dStpHelloTime = &((*dot1dStp)->__dot1dStpHelloTime);
        }
        if (vars->name_length > sizeof(dot1dStpHoldTime)/sizeof(oid)
            && memcmp(vars->name, dot1dStpHoldTime, sizeof(dot1dStpHoldTime)) == 0) {
            (*dot1dStp)->__dot1dStpHoldTime = *vars->val.integer;
            (*dot1dStp)->dot1dStpHoldTime = &((*dot1dStp)->__dot1dStpHoldTime);
        }
        if (vars->name_length > sizeof(dot1dStpForwardDelay)/sizeof(oid)
            && memcmp(vars->name, dot1dStpForwardDelay, sizeof(dot1dStpForwardDelay)) == 0) {
            (*dot1dStp)->__dot1dStpForwardDelay = *vars->val.integer;
            (*dot1dStp)->dot1dStpForwardDelay = &((*dot1dStp)->__dot1dStpForwardDelay);
        }
        if (vars->name_length > sizeof(dot1dStpBridgeMaxAge)/sizeof(oid)
            && memcmp(vars->name, dot1dStpBridgeMaxAge, sizeof(dot1dStpBridgeMaxAge)) == 0) {
            (*dot1dStp)->__dot1dStpBridgeMaxAge = *vars->val.integer;
            (*dot1dStp)->dot1dStpBridgeMaxAge = &((*dot1dStp)->__dot1dStpBridgeMaxAge);
        }
        if (vars->name_length > sizeof(dot1dStpBridgeHelloTime)/sizeof(oid)
            && memcmp(vars->name, dot1dStpBridgeHelloTime, sizeof(dot1dStpBridgeHelloTime)) == 0) {
            (*dot1dStp)->__dot1dStpBridgeHelloTime = *vars->val.integer;
            (*dot1dStp)->dot1dStpBridgeHelloTime = &((*dot1dStp)->__dot1dStpBridgeHelloTime);
        }
        if (vars->name_length > sizeof(dot1dStpBridgeForwardDelay)/sizeof(oid)
            && memcmp(vars->name, dot1dStpBridgeForwardDelay, sizeof(dot1dStpBridgeForwardDelay)) == 0) {
            (*dot1dStp)->__dot1dStpBridgeForwardDelay = *vars->val.integer;
            (*dot1dStp)->dot1dStpBridgeForwardDelay = &((*dot1dStp)->__dot1dStpBridgeForwardDelay);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int bridge_mib_mgr_get_dot1dStpPortEntry(struct snmp_session *s, dot1dStpPortEntry_t **dot1dStpPortEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, dot1dStpPort, sizeof(dot1dStpPort)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPortPriority, sizeof(dot1dStpPortPriority)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPortState, sizeof(dot1dStpPortState)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPortEnable, sizeof(dot1dStpPortEnable)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPortPathCost, sizeof(dot1dStpPortPathCost)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPortDesignatedRoot, sizeof(dot1dStpPortDesignatedRoot)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPortDesignatedCost, sizeof(dot1dStpPortDesignatedCost)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPortDesignatedBridge, sizeof(dot1dStpPortDesignatedBridge)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPortDesignatedPort, sizeof(dot1dStpPortDesignatedPort)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPortForwardTransitions, sizeof(dot1dStpPortForwardTransitions)/sizeof(oid));
    snmp_add_null_var(request, dot1dStpPortPathCost32, sizeof(dot1dStpPortPathCost32)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        snmp_free_pdu(request);
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *dot1dStpPortEntry = (dot1dStpPortEntry_t *) malloc(sizeof(dot1dStpPortEntry_t));
    if (! *dot1dStpPortEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(dot1dStpPort)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPort, sizeof(dot1dStpPort)) == 0) {
            (*dot1dStpPortEntry)->__dot1dStpPort = *vars->val.integer;
            (*dot1dStpPortEntry)->dot1dStpPort = &((*dot1dStpPortEntry)->__dot1dStpPort);
        }
        if (vars->name_length > sizeof(dot1dStpPortPriority)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPortPriority, sizeof(dot1dStpPortPriority)) == 0) {
            (*dot1dStpPortEntry)->__dot1dStpPortPriority = *vars->val.integer;
            (*dot1dStpPortEntry)->dot1dStpPortPriority = &((*dot1dStpPortEntry)->__dot1dStpPortPriority);
        }
        if (vars->name_length > sizeof(dot1dStpPortState)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPortState, sizeof(dot1dStpPortState)) == 0) {
            (*dot1dStpPortEntry)->__dot1dStpPortState = *vars->val.integer;
            (*dot1dStpPortEntry)->dot1dStpPortState = &((*dot1dStpPortEntry)->__dot1dStpPortState);
        }
        if (vars->name_length > sizeof(dot1dStpPortEnable)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPortEnable, sizeof(dot1dStpPortEnable)) == 0) {
            (*dot1dStpPortEntry)->__dot1dStpPortEnable = *vars->val.integer;
            (*dot1dStpPortEntry)->dot1dStpPortEnable = &((*dot1dStpPortEntry)->__dot1dStpPortEnable);
        }
        if (vars->name_length > sizeof(dot1dStpPortPathCost)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPortPathCost, sizeof(dot1dStpPortPathCost)) == 0) {
            (*dot1dStpPortEntry)->__dot1dStpPortPathCost = *vars->val.integer;
            (*dot1dStpPortEntry)->dot1dStpPortPathCost = &((*dot1dStpPortEntry)->__dot1dStpPortPathCost);
        }
        if (vars->name_length > sizeof(dot1dStpPortDesignatedRoot)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPortDesignatedRoot, sizeof(dot1dStpPortDesignatedRoot)) == 0) {
            memcpy((*dot1dStpPortEntry)->__dot1dStpPortDesignatedRoot, vars->val.string, vars->val_len);
            (*dot1dStpPortEntry)->dot1dStpPortDesignatedRoot = (*dot1dStpPortEntry)->__dot1dStpPortDesignatedRoot;
        }
        if (vars->name_length > sizeof(dot1dStpPortDesignatedCost)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPortDesignatedCost, sizeof(dot1dStpPortDesignatedCost)) == 0) {
            (*dot1dStpPortEntry)->__dot1dStpPortDesignatedCost = *vars->val.integer;
            (*dot1dStpPortEntry)->dot1dStpPortDesignatedCost = &((*dot1dStpPortEntry)->__dot1dStpPortDesignatedCost);
        }
        if (vars->name_length > sizeof(dot1dStpPortDesignatedBridge)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPortDesignatedBridge, sizeof(dot1dStpPortDesignatedBridge)) == 0) {
            memcpy((*dot1dStpPortEntry)->__dot1dStpPortDesignatedBridge, vars->val.string, vars->val_len);
            (*dot1dStpPortEntry)->dot1dStpPortDesignatedBridge = (*dot1dStpPortEntry)->__dot1dStpPortDesignatedBridge;
        }
        if (vars->name_length > sizeof(dot1dStpPortDesignatedPort)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPortDesignatedPort, sizeof(dot1dStpPortDesignatedPort)) == 0) {
            memcpy((*dot1dStpPortEntry)->__dot1dStpPortDesignatedPort, vars->val.string, vars->val_len);
            (*dot1dStpPortEntry)->dot1dStpPortDesignatedPort = (*dot1dStpPortEntry)->__dot1dStpPortDesignatedPort;
        }
        if (vars->name_length > sizeof(dot1dStpPortForwardTransitions)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPortForwardTransitions, sizeof(dot1dStpPortForwardTransitions)) == 0) {
            (*dot1dStpPortEntry)->__dot1dStpPortForwardTransitions = *vars->val.integer;
            (*dot1dStpPortEntry)->dot1dStpPortForwardTransitions = &((*dot1dStpPortEntry)->__dot1dStpPortForwardTransitions);
        }
        if (vars->name_length > sizeof(dot1dStpPortPathCost32)/sizeof(oid)
            && memcmp(vars->name, dot1dStpPortPathCost32, sizeof(dot1dStpPortPathCost32)) == 0) {
            (*dot1dStpPortEntry)->__dot1dStpPortPathCost32 = *vars->val.integer;
            (*dot1dStpPortEntry)->dot1dStpPortPathCost32 = &((*dot1dStpPortEntry)->__dot1dStpPortPathCost32);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int bridge_mib_mgr_get_dot1dTp(struct snmp_session *s, dot1dTp_t **dot1dTp)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, dot1dTpLearnedEntryDiscards, sizeof(dot1dTpLearnedEntryDiscards)/sizeof(oid));
    snmp_add_null_var(request, dot1dTpAgingTime, sizeof(dot1dTpAgingTime)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        snmp_free_pdu(request);
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *dot1dTp = (dot1dTp_t *) malloc(sizeof(dot1dTp_t));
    if (! *dot1dTp) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(dot1dTpLearnedEntryDiscards)/sizeof(oid)
            && memcmp(vars->name, dot1dTpLearnedEntryDiscards, sizeof(dot1dTpLearnedEntryDiscards)) == 0) {
            (*dot1dTp)->__dot1dTpLearnedEntryDiscards = *vars->val.integer;
            (*dot1dTp)->dot1dTpLearnedEntryDiscards = &((*dot1dTp)->__dot1dTpLearnedEntryDiscards);
        }
        if (vars->name_length > sizeof(dot1dTpAgingTime)/sizeof(oid)
            && memcmp(vars->name, dot1dTpAgingTime, sizeof(dot1dTpAgingTime)) == 0) {
            (*dot1dTp)->__dot1dTpAgingTime = *vars->val.integer;
            (*dot1dTp)->dot1dTpAgingTime = &((*dot1dTp)->__dot1dTpAgingTime);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int bridge_mib_mgr_get_dot1dTpFdbEntry(struct snmp_session *s, dot1dTpFdbEntry_t **dot1dTpFdbEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, dot1dTpFdbAddress, sizeof(dot1dTpFdbAddress)/sizeof(oid));
    snmp_add_null_var(request, dot1dTpFdbPort, sizeof(dot1dTpFdbPort)/sizeof(oid));
    snmp_add_null_var(request, dot1dTpFdbStatus, sizeof(dot1dTpFdbStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        snmp_free_pdu(request);
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *dot1dTpFdbEntry = (dot1dTpFdbEntry_t *) malloc(sizeof(dot1dTpFdbEntry_t));
    if (! *dot1dTpFdbEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(dot1dTpFdbAddress)/sizeof(oid)
            && memcmp(vars->name, dot1dTpFdbAddress, sizeof(dot1dTpFdbAddress)) == 0) {
            memcpy((*dot1dTpFdbEntry)->__dot1dTpFdbAddress, vars->val.string, vars->val_len);
            (*dot1dTpFdbEntry)->dot1dTpFdbAddress = (*dot1dTpFdbEntry)->__dot1dTpFdbAddress;
        }
        if (vars->name_length > sizeof(dot1dTpFdbPort)/sizeof(oid)
            && memcmp(vars->name, dot1dTpFdbPort, sizeof(dot1dTpFdbPort)) == 0) {
            (*dot1dTpFdbEntry)->__dot1dTpFdbPort = *vars->val.integer;
            (*dot1dTpFdbEntry)->dot1dTpFdbPort = &((*dot1dTpFdbEntry)->__dot1dTpFdbPort);
        }
        if (vars->name_length > sizeof(dot1dTpFdbStatus)/sizeof(oid)
            && memcmp(vars->name, dot1dTpFdbStatus, sizeof(dot1dTpFdbStatus)) == 0) {
            (*dot1dTpFdbEntry)->__dot1dTpFdbStatus = *vars->val.integer;
            (*dot1dTpFdbEntry)->dot1dTpFdbStatus = &((*dot1dTpFdbEntry)->__dot1dTpFdbStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int bridge_mib_mgr_get_dot1dTpPortEntry(struct snmp_session *s, dot1dTpPortEntry_t **dot1dTpPortEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, dot1dTpPort, sizeof(dot1dTpPort)/sizeof(oid));
    snmp_add_null_var(request, dot1dTpPortMaxInfo, sizeof(dot1dTpPortMaxInfo)/sizeof(oid));
    snmp_add_null_var(request, dot1dTpPortInFrames, sizeof(dot1dTpPortInFrames)/sizeof(oid));
    snmp_add_null_var(request, dot1dTpPortOutFrames, sizeof(dot1dTpPortOutFrames)/sizeof(oid));
    snmp_add_null_var(request, dot1dTpPortInDiscards, sizeof(dot1dTpPortInDiscards)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        snmp_free_pdu(request);
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *dot1dTpPortEntry = (dot1dTpPortEntry_t *) malloc(sizeof(dot1dTpPortEntry_t));
    if (! *dot1dTpPortEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(dot1dTpPort)/sizeof(oid)
            && memcmp(vars->name, dot1dTpPort, sizeof(dot1dTpPort)) == 0) {
            (*dot1dTpPortEntry)->__dot1dTpPort = *vars->val.integer;
            (*dot1dTpPortEntry)->dot1dTpPort = &((*dot1dTpPortEntry)->__dot1dTpPort);
        }
        if (vars->name_length > sizeof(dot1dTpPortMaxInfo)/sizeof(oid)
            && memcmp(vars->name, dot1dTpPortMaxInfo, sizeof(dot1dTpPortMaxInfo)) == 0) {
            (*dot1dTpPortEntry)->__dot1dTpPortMaxInfo = *vars->val.integer;
            (*dot1dTpPortEntry)->dot1dTpPortMaxInfo = &((*dot1dTpPortEntry)->__dot1dTpPortMaxInfo);
        }
        if (vars->name_length > sizeof(dot1dTpPortInFrames)/sizeof(oid)
            && memcmp(vars->name, dot1dTpPortInFrames, sizeof(dot1dTpPortInFrames)) == 0) {
            (*dot1dTpPortEntry)->__dot1dTpPortInFrames = *vars->val.integer;
            (*dot1dTpPortEntry)->dot1dTpPortInFrames = &((*dot1dTpPortEntry)->__dot1dTpPortInFrames);
        }
        if (vars->name_length > sizeof(dot1dTpPortOutFrames)/sizeof(oid)
            && memcmp(vars->name, dot1dTpPortOutFrames, sizeof(dot1dTpPortOutFrames)) == 0) {
            (*dot1dTpPortEntry)->__dot1dTpPortOutFrames = *vars->val.integer;
            (*dot1dTpPortEntry)->dot1dTpPortOutFrames = &((*dot1dTpPortEntry)->__dot1dTpPortOutFrames);
        }
        if (vars->name_length > sizeof(dot1dTpPortInDiscards)/sizeof(oid)
            && memcmp(vars->name, dot1dTpPortInDiscards, sizeof(dot1dTpPortInDiscards)) == 0) {
            (*dot1dTpPortEntry)->__dot1dTpPortInDiscards = *vars->val.integer;
            (*dot1dTpPortEntry)->dot1dTpPortInDiscards = &((*dot1dTpPortEntry)->__dot1dTpPortInDiscards);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}

int bridge_mib_mgr_get_dot1dStaticEntry(struct snmp_session *s, dot1dStaticEntry_t **dot1dStaticEntry)
{
    struct snmp_session *peer;
    struct snmp_pdu *request, *response;
    struct variable_list *vars;
    int status;

    request = snmp_pdu_create(SNMP_MSG_GETNEXT);
    snmp_add_null_var(request, dot1dStaticAddress, sizeof(dot1dStaticAddress)/sizeof(oid));
    snmp_add_null_var(request, dot1dStaticReceivePort, sizeof(dot1dStaticReceivePort)/sizeof(oid));
    snmp_add_null_var(request, dot1dStaticAllowedToGoTo, sizeof(dot1dStaticAllowedToGoTo)/sizeof(oid));
    snmp_add_null_var(request, dot1dStaticStatus, sizeof(dot1dStaticStatus)/sizeof(oid));

    peer = snmp_open(s);
    if (!peer) {
        snmp_free_pdu(request);
        return -1;
    }

    status = snmp_synch_response(peer, request, &response);
    if (status != STAT_SUCCESS) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -2;
    }

    *dot1dStaticEntry = (dot1dStaticEntry_t *) malloc(sizeof(dot1dStaticEntry_t));
    if (! *dot1dStaticEntry) {
        if (response) snmp_free_pdu(response);
        snmp_close(peer);
        return -4;
    }

    for (vars = response->variables; vars; vars = vars->next_variable) {
        if (vars->name_length > sizeof(dot1dStaticAddress)/sizeof(oid)
            && memcmp(vars->name, dot1dStaticAddress, sizeof(dot1dStaticAddress)) == 0) {
            memcpy((*dot1dStaticEntry)->__dot1dStaticAddress, vars->val.string, vars->val_len);
            (*dot1dStaticEntry)->dot1dStaticAddress = (*dot1dStaticEntry)->__dot1dStaticAddress;
        }
        if (vars->name_length > sizeof(dot1dStaticReceivePort)/sizeof(oid)
            && memcmp(vars->name, dot1dStaticReceivePort, sizeof(dot1dStaticReceivePort)) == 0) {
            (*dot1dStaticEntry)->__dot1dStaticReceivePort = *vars->val.integer;
            (*dot1dStaticEntry)->dot1dStaticReceivePort = &((*dot1dStaticEntry)->__dot1dStaticReceivePort);
        }
        if (vars->name_length > sizeof(dot1dStaticAllowedToGoTo)/sizeof(oid)
            && memcmp(vars->name, dot1dStaticAllowedToGoTo, sizeof(dot1dStaticAllowedToGoTo)) == 0) {
            memcpy((*dot1dStaticEntry)->__dot1dStaticAllowedToGoTo, vars->val.string, vars->val_len);
            (*dot1dStaticEntry)->_dot1dStaticAllowedToGoToLength = vars->val_len;
            (*dot1dStaticEntry)->dot1dStaticAllowedToGoTo = (*dot1dStaticEntry)->__dot1dStaticAllowedToGoTo;
        }
        if (vars->name_length > sizeof(dot1dStaticStatus)/sizeof(oid)
            && memcmp(vars->name, dot1dStaticStatus, sizeof(dot1dStaticStatus)) == 0) {
            (*dot1dStaticEntry)->__dot1dStaticStatus = *vars->val.integer;
            (*dot1dStaticEntry)->dot1dStaticStatus = &((*dot1dStaticEntry)->__dot1dStaticStatus);
        }
    }

    if (response) snmp_free_pdu(response);

    if (snmp_close(peer) == 0) {
        return -5;
    }

    return 0;
}


