/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.provider;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.openhab.core.automation.ManagedRuleProvider;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.internal.provider.AbstractResourceBundleProvider;
import org.openhab.core.automation.internal.provider.AutomationResourceBundlesEventQueue;
import org.openhab.core.automation.internal.provider.HostFragmentMappingUtil;
import org.openhab.core.automation.internal.provider.RuleResourceBundleImporter;
import org.openhab.core.automation.parser.Parser;
import org.openhab.core.common.registry.Provider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

@Component(immediate=true)
public class AutomationResourceBundlesTracker
implements BundleTrackerCustomizer<Bundle> {
    private final List<AutomationResourceBundlesEventQueue> providerEventsQueue = new ArrayList<AutomationResourceBundlesEventQueue>();
    protected RuleResourceBundleImporter rImporter;
    private BundleTracker<Bundle> bTracker;
    private final List<BundleEvent> queue = new LinkedList<BundleEvent>();

    public AutomationResourceBundlesTracker() {
        this.rImporter = this.createImporter();
    }

    protected RuleResourceBundleImporter createImporter() {
        return new RuleResourceBundleImporter();
    }

    @Activate
    protected void activate(BundleContext bc) {
        this.bTracker = new BundleTracker(bc, -2, (BundleTrackerCustomizer)this);
        this.bTracker.open();
    }

    @Deactivate
    protected void deactivate(BundleContext bc) {
        this.bTracker.close();
        this.bTracker = null;
        this.rImporter.deactivate();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(provider.type=bundle)")
    protected void addProvider(Provider provider) {
        if (provider instanceof AbstractResourceBundleProvider) {
            AbstractResourceBundleProvider bundleProvider = (AbstractResourceBundleProvider)provider;
            this.addAbstractResourceBundleProvider(bundleProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAbstractResourceBundleProvider(AbstractResourceBundleProvider provider) {
        AutomationResourceBundlesEventQueue queue = provider.getQueue();
        List<BundleEvent> list = this.queue;
        synchronized (list) {
            queue.addAll(this.queue);
            this.providerEventsQueue.add(queue);
        }
    }

    protected void removeProvider(Provider provider) {
        if (provider instanceof AbstractResourceBundleProvider) {
            AbstractResourceBundleProvider bundleProvider = (AbstractResourceBundleProvider)provider;
            this.removeAbstractResourceBundleProvider(bundleProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAbstractResourceBundleProvider(AbstractResourceBundleProvider provider) {
        AutomationResourceBundlesEventQueue queue = provider.getQueue();
        List<BundleEvent> list = this.queue;
        synchronized (list) {
            this.providerEventsQueue.remove(queue);
        }
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setManagedRuleProvider(ManagedRuleProvider mProvider) {
        this.rImporter.setManagedRuleProvider(mProvider);
        this.rImporter.activate(null);
        this.addAbstractResourceBundleProvider(this.rImporter);
    }

    protected void unsetManagedRuleProvider(ManagedRuleProvider mProvider) {
        this.removeAbstractResourceBundleProvider(this.rImporter);
        this.rImporter.deactivate();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, target="(parser.type=parser.rule)")
    protected void addParser(Parser<Rule> parser, Map<String, String> properties) {
        this.rImporter.addParser(parser, properties);
    }

    protected void removeParser(Parser<Rule> parser, Map<String, String> properties) {
        this.rImporter.removeParser(parser, properties);
    }

    @Reference
    protected void setPackageAdmin(PackageAdmin pkgAdmin) {
        HostFragmentMappingUtil.pkgAdmin = pkgAdmin;
    }

    protected void unsetPackageAdmin(PackageAdmin pkgAdmin) {
        HostFragmentMappingUtil.pkgAdmin = null;
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        block4: {
            block2: {
                block3: {
                    if (!this.isAnAutomationProvider(bundle)) break block2;
                    if (!HostFragmentMappingUtil.isFragmentBundle(bundle)) break block3;
                    List<Bundle> hosts = HostFragmentMappingUtil.returnHostBundles(bundle);
                    if (!HostFragmentMappingUtil.needToProcessFragment(bundle, hosts)) break block4;
                    this.addEvent(bundle, event);
                    HostFragmentMappingUtil.fillHostFragmentMapping(hosts);
                    break block4;
                }
                HostFragmentMappingUtil.fillHostFragmentMapping(bundle);
                this.addEvent(bundle, event);
                break block4;
            }
            if (!HostFragmentMappingUtil.isFragmentBundle(bundle)) {
                List<Bundle> fragments = HostFragmentMappingUtil.fillHostFragmentMapping(bundle);
                for (Bundle fragment : fragments) {
                    if (!this.isAnAutomationProvider(fragment)) continue;
                    this.addEvent(bundle, event);
                    break;
                }
            }
        }
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        int type = event.getType();
        if (type == 8 || type == 32) {
            this.addEvent(bundle, event);
        }
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Bundle object) {
        if (HostFragmentMappingUtil.isFragmentBundle(bundle)) {
            for (Map.Entry<Bundle, List<Bundle>> entry : HostFragmentMappingUtil.getMapping()) {
                if (!entry.getValue().contains(bundle)) continue;
                Bundle host = entry.getKey();
                this.addEvent(host, new BundleEvent(8, host));
            }
        } else {
            this.addEvent(bundle, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEvent(Bundle bundle, BundleEvent event) {
        BundleEvent e = event != null ? event : this.initializeEvent(bundle);
        List<BundleEvent> list = this.queue;
        synchronized (list) {
            this.queue.add(e);
            for (AutomationResourceBundlesEventQueue queue : this.providerEventsQueue) {
                queue.addEvent(bundle, e);
            }
        }
    }

    private BundleEvent initializeEvent(Bundle bundle) {
        switch (bundle.getState()) {
            case 2: {
                return new BundleEvent(1, bundle);
            }
            case 4: {
                return new BundleEvent(32, bundle);
            }
        }
        return new BundleEvent(2, bundle);
    }

    private boolean isAnAutomationProvider(Bundle bundle) {
        return bundle.getEntryPaths("OH-INF/automation") != null;
    }
}

