/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.Item;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.types.State;
import org.openhab.core.types.UnDefType;
import org.openhab.core.util.Statistics;

@NonNullByDefault
public interface QuantityTypeArithmeticGroupFunction
extends GroupFunction {

    public static class Avg
    extends DimensionalGroupFunction {
        public Avg(Unit<?> baseItemUnit) {
            super(baseItemUnit);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            List<QuantityType> systemUnitQuantities;
            if (items != null && !(systemUnitQuantities = this.toQuantityTypesOfUnit(items, this.systemUnit)).isEmpty()) {
                return systemUnitQuantities.stream().reduce(new QuantityType(0, this.systemUnit), QuantityType::add).divide(BigDecimal.valueOf(systemUnitQuantities.size()));
            }
            return UnDefType.UNDEF;
        }
    }

    public static abstract class DimensionalGroupFunction
    implements GroupFunction {
        protected final Unit<?> baseItemUnit;
        protected final Unit<?> systemUnit;

        public DimensionalGroupFunction(Unit<?> baseItemUnit) {
            this.baseItemUnit = baseItemUnit;
            this.systemUnit = baseItemUnit.getSystemUnit();
        }

        @Override
        public <T extends State> @Nullable T getStateAs(@Nullable Set<Item> items, Class<T> stateClass) {
            QuantityType<?> state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                if (state instanceof QuantityType) {
                    QuantityType quantity = state;
                    state = quantity.toInvertibleUnit(this.baseItemUnit);
                }
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }

        private @Nullable QuantityType<?> toQuantityTypeOfUnit(@Nullable State state, Unit<?> unit) {
            QuantityType<?> quantityType;
            if (state instanceof QuantityType) {
                QuantityType quantity = (QuantityType)state;
                quantityType = quantity.toInvertibleUnit(unit);
            } else {
                quantityType = null;
            }
            return quantityType;
        }

        protected List<QuantityType> toQuantityTypesOfUnit(Set<Item> items, Unit<?> unit) {
            return items.stream().map(i -> i.getState()).map(s -> this.toQuantityTypeOfUnit((State)s, unit)).filter(Objects::nonNull).map(s -> s).toList();
        }
    }

    public static class Max
    extends DimensionalGroupFunction {
        public Max(Unit<?> targetUnit) {
            super(targetUnit);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            Optional max;
            if (items != null && (max = this.toQuantityTypesOfUnit(items, this.systemUnit).stream().max(QuantityType::compareTo)).isPresent()) {
                return (State)max.get();
            }
            return UnDefType.UNDEF;
        }
    }

    public static class Median
    extends DimensionalGroupFunction {
        public Median(Unit<?> baseItemUnit) {
            super(baseItemUnit);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            BigDecimal median;
            if (items != null && (median = Statistics.median(this.toQuantityTypesOfUnit(items, this.systemUnit).stream().map(q -> q.toBigDecimal()).toList())) != null) {
                return new QuantityType(median, this.systemUnit);
            }
            return UnDefType.UNDEF;
        }
    }

    public static class Min
    extends DimensionalGroupFunction {
        public Min(Unit<?> baseItemUnit) {
            super(baseItemUnit);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            Optional min;
            if (items != null && (min = this.toQuantityTypesOfUnit(items, this.systemUnit).stream().min(QuantityType::compareTo)).isPresent()) {
                return (State)min.get();
            }
            return UnDefType.UNDEF;
        }
    }

    public static class Sum
    extends DimensionalGroupFunction {
        public Sum(Unit<?> baseItemUnit) {
            super(baseItemUnit);
        }

        @Override
        public State calculate(@Nullable Set<Item> items) {
            List<QuantityType> systemUnitQuantities;
            if (items != null && !(systemUnitQuantities = this.toQuantityTypesOfUnit(items, this.baseItemUnit)).isEmpty()) {
                return systemUnitQuantities.stream().reduce(new QuantityType(0, this.baseItemUnit), QuantityType::add);
            }
            return UnDefType.UNDEF;
        }
    }
}

