/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.DefinitionUtils;
import org.eclipse.californium.elements.config.ValueException;

public class EnumDefinition<E extends Enum<?>>
extends BasicDefinition<E> {
    private final E defaultValue;
    private final List<E> values;
    private final String valuesDocumentation;

    public EnumDefinition(String key, String documentation, E ... values) {
        super(key, documentation, DefinitionUtils.getClass(values), null);
        if (values == null) {
            throw new NullPointerException("Enum set must not be null!");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Enum set must not be empty!");
        }
        for (E in : values) {
            if (in != null) continue;
            throw new IllegalArgumentException("Enum set must not contain null!");
        }
        boolean found = false;
        E defaultValue = values[0];
        for (int index = 1; index < values.length; ++index) {
            if (!((Enum)values[index]).equals(defaultValue)) continue;
            found = true;
            break;
        }
        if (found) {
            this.defaultValue = defaultValue;
            this.values = Arrays.asList((Enum[])Arrays.copyOfRange(values, 1, values.length));
        } else {
            this.defaultValue = null;
            this.values = Arrays.asList((Enum[])Arrays.copyOf(values, values.length));
        }
        this.valuesDocumentation = DefinitionUtils.toNames(Arrays.asList(values), true);
    }

    public EnumDefinition(String key, String documentation, E defaultValue, E[] values) {
        super(key, documentation, DefinitionUtils.getClass(values), null);
        if (values == null) {
            throw new NullPointerException("Enum set must not be null!");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("Enum set must not be empty!");
        }
        for (E in : values) {
            if (in != null) continue;
            throw new IllegalArgumentException("Enum set must not contain null!");
        }
        this.defaultValue = defaultValue;
        this.values = Arrays.asList((Enum[])Arrays.copyOf(values, values.length));
        this.valuesDocumentation = DefinitionUtils.toNames(this.values, true);
        if (defaultValue != null) {
            this.isAssignableFrom(defaultValue);
        }
    }

    @Override
    public String writeValue(E value) {
        return ((Enum)value).name();
    }

    @Override
    public String getDocumentation() {
        return super.getDocumentation() + "\n" + this.valuesDocumentation + ".";
    }

    @Override
    public E getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    protected boolean isAssignableFrom(Object value) {
        if (this.values.contains(value)) {
            return true;
        }
        if (super.isAssignableFrom(value)) {
            throw new IllegalArgumentException(value + " is not in " + this.valuesDocumentation);
        }
        return false;
    }

    @Override
    protected E parseValue(String value) throws ValueException {
        E result = DefinitionUtils.toValue(value, this.values);
        if (result == null) {
            throw new ValueException(value + " is not in " + this.valuesDocumentation);
        }
        return result;
    }
}

