/* SPDX-License-Identifier: GPL-2.0-only OR BSD-2-Clause */
/*
 * Copyright (C) STMicroelectronics 2025 - All Rights Reserved
 * Author: Gabriel Fernandez <gabriel.fernandez@foss.st.com>
 */

#ifndef _DT_BINDINGS_STM32MP21_CLKS_H_
#define _DT_BINDINGS_STM32MP21_CLKS_H_

/* INTERNAL/EXTERNAL OSCILLATORS */
#define HSI_CK			0
#define HSE_CK			1
#define MSI_CK			2
#define LSI_CK			3
#define LSE_CK			4
#define I2S_CK			5
#define RTC_CK			6
#define SPDIF_CK_SYMB		7

/* PLL CLOCKS */
#define PLL1_CK			8
#define PLL2_CK			9
#define PLL4_CK			10
#define PLL5_CK			11
#define PLL6_CK			12
#define PLL7_CK			13
#define PLL8_CK			14

#define CK_CPU1			15

/* APB DIV CLOCKS */
#define CK_ICN_APB1		16
#define CK_ICN_APB2		17
#define CK_ICN_APB3		18
#define CK_ICN_APB4		19
#define CK_ICN_APB5		20
#define CK_ICN_APBDBG		21

/* GLOBAL TIMER */
#define TIMG1_CK		22
#define TIMG2_CK		23

/* FLEXGEN CLOCKS */
#define CK_ICN_HS_MCU		24
#define CK_ICN_SDMMC		25
#define CK_ICN_DDR		26
#define CK_ICN_DISPLAY		27
#define CK_ICN_HSL		28
#define CK_ICN_NIC		29
#define CK_ICN_VID		30
#define CK_FLEXGEN_07		31
#define CK_FLEXGEN_08		32
#define CK_FLEXGEN_09		33
#define CK_FLEXGEN_10		34
#define CK_FLEXGEN_11		35
#define CK_FLEXGEN_12		36
#define CK_FLEXGEN_13		37
#define CK_FLEXGEN_14		38
#define CK_FLEXGEN_15		39
#define CK_FLEXGEN_16		40
#define CK_FLEXGEN_17		41
#define CK_FLEXGEN_18		42
#define CK_FLEXGEN_19		43
#define CK_FLEXGEN_20		44
#define CK_FLEXGEN_21		45
#define CK_FLEXGEN_22		46
#define CK_FLEXGEN_23		47
#define CK_FLEXGEN_24		48
#define CK_FLEXGEN_25		49
#define CK_FLEXGEN_26		50
#define CK_FLEXGEN_27		51
#define CK_FLEXGEN_28		52
#define CK_FLEXGEN_29		53
#define CK_FLEXGEN_30		54
#define CK_FLEXGEN_31		55
#define CK_FLEXGEN_32		56
#define CK_FLEXGEN_33		57
#define CK_FLEXGEN_34		58
#define CK_FLEXGEN_35		59
#define CK_FLEXGEN_36		60
#define CK_FLEXGEN_37		61
#define CK_FLEXGEN_38		62
#define CK_FLEXGEN_39		63
#define CK_FLEXGEN_40		64
#define CK_FLEXGEN_41		65
#define CK_FLEXGEN_42		66
#define CK_FLEXGEN_43		67
#define CK_FLEXGEN_44		68
#define CK_FLEXGEN_45		69
#define CK_FLEXGEN_46		70
#define CK_FLEXGEN_47		71
#define CK_FLEXGEN_48		72
#define CK_FLEXGEN_49		73
#define CK_FLEXGEN_50		74
#define CK_FLEXGEN_51		75
#define CK_FLEXGEN_52		76
#define CK_FLEXGEN_53		77
#define CK_FLEXGEN_54		78
#define CK_FLEXGEN_55		79
#define CK_FLEXGEN_56		80
#define CK_FLEXGEN_57		81
#define CK_FLEXGEN_58		82
#define CK_FLEXGEN_59		83
#define CK_FLEXGEN_60		84
#define CK_FLEXGEN_61		85
#define CK_FLEXGEN_62		86
#define CK_FLEXGEN_63		87

/* LOW SPEED MCU CLOCK */
#define CK_ICN_LS_MCU		88

#define CK_BUS_STM		89
#define CK_BUS_FMC		90
#define CK_BUS_ETH1		91
#define CK_BUS_ETH2		92
#define CK_BUS_DDRPHYC		93
#define CK_BUS_SYSCPU1		94
#define CK_BUS_HPDMA1		95
#define CK_BUS_HPDMA2		96
#define CK_BUS_HPDMA3		97
#define CK_BUS_ADC1		98
#define CK_BUS_ADC2		99
#define CK_BUS_IPCC1		100
#define CK_BUS_DCMIPSSI		101
#define CK_BUS_CRC		102
#define CK_BUS_MDF1		103
#define CK_BUS_BKPSRAM		104
#define CK_BUS_HASH1		105
#define CK_BUS_HASH2		106
#define CK_BUS_RNG1		107
#define CK_BUS_RNG2		108
#define CK_BUS_CRYP1		109
#define CK_BUS_CRYP2		110
#define CK_BUS_SAES		111
#define CK_BUS_PKA		112
#define CK_BUS_GPIOA		113
#define CK_BUS_GPIOB		114
#define CK_BUS_GPIOC		115
#define CK_BUS_GPIOD		116
#define CK_BUS_GPIOE		117
#define CK_BUS_GPIOF		118
#define CK_BUS_GPIOG		119
#define CK_BUS_GPIOH		120
#define CK_BUS_GPIOI		121
#define CK_BUS_GPIOZ		122
#define CK_BUS_RTC		124
#define CK_BUS_LPUART1		125
#define CK_BUS_LPTIM3		126
#define CK_BUS_LPTIM4		127
#define CK_BUS_LPTIM5		128
#define CK_BUS_TIM2		129
#define CK_BUS_TIM3		130
#define CK_BUS_TIM4		131
#define CK_BUS_TIM5		132
#define CK_BUS_TIM6		133
#define CK_BUS_TIM7		134
#define CK_BUS_TIM10		135
#define CK_BUS_TIM11		136
#define CK_BUS_TIM12		137
#define CK_BUS_TIM13		138
#define CK_BUS_TIM14		139
#define CK_BUS_LPTIM1		140
#define CK_BUS_LPTIM2		141
#define CK_BUS_SPI2		142
#define CK_BUS_SPI3		143
#define CK_BUS_SPDIFRX		144
#define CK_BUS_USART2		145
#define CK_BUS_USART3		146
#define CK_BUS_UART4		147
#define CK_BUS_UART5		148
#define CK_BUS_I2C1		149
#define CK_BUS_I2C2		150
#define CK_BUS_I2C3		151
#define CK_BUS_I3C1		152
#define CK_BUS_I3C2		153
#define CK_BUS_I3C3		154
#define CK_BUS_TIM1		155
#define CK_BUS_TIM8		156
#define CK_BUS_TIM15		157
#define CK_BUS_TIM16		158
#define CK_BUS_TIM17		159
#define CK_BUS_SAI1		160
#define CK_BUS_SAI2		161
#define CK_BUS_SAI3		162
#define CK_BUS_SAI4		163
#define CK_BUS_USART1		164
#define CK_BUS_USART6		165
#define CK_BUS_UART7		166
#define CK_BUS_FDCAN		167
#define CK_BUS_SPI1		168
#define CK_BUS_SPI4		169
#define CK_BUS_SPI5		170
#define CK_BUS_SPI6		171
#define CK_BUS_BSEC		172
#define CK_BUS_IWDG1		173
#define CK_BUS_IWDG2		174
#define CK_BUS_IWDG3		175
#define CK_BUS_IWDG4		176
#define CK_BUS_WWDG1		177
#define CK_BUS_VREF		178
#define CK_BUS_DTS		179
#define CK_BUS_SERC		180
#define CK_BUS_HDP		181
#define CK_BUS_DDRPERFM		182
#define CK_BUS_OTG		183
#define CK_BUS_LTDC		184
#define CK_BUS_CSI		185
#define CK_BUS_DCMIPP		186
#define CK_BUS_DDRC		187
#define CK_BUS_DDRCFG		188
#define CK_BUS_STGEN		189
#define CK_SYSDBG		190
#define CK_KER_TIM2		191
#define CK_KER_TIM3		192
#define CK_KER_TIM4		193
#define CK_KER_TIM5		194
#define CK_KER_TIM6		195
#define CK_KER_TIM7		196
#define CK_KER_TIM10		197
#define CK_KER_TIM11		198
#define CK_KER_TIM12		199
#define CK_KER_TIM13		200
#define CK_KER_TIM14		201
#define CK_KER_TIM1		202
#define CK_KER_TIM8		203
#define CK_KER_TIM15		204
#define CK_KER_TIM16		205
#define CK_KER_TIM17		206
#define CK_BUS_SYSRAM		207
#define CK_BUS_RETRAM		208
#define CK_BUS_OSPI1		209
#define CK_BUS_OTFD1		210
#define CK_BUS_SRAM1		211
#define CK_BUS_SDMMC1		212
#define CK_BUS_SDMMC2		213
#define CK_BUS_SDMMC3		214
#define CK_BUS_DDR		215
#define CK_BUS_RISAF4		216
#define CK_BUS_USBHOHCI		217
#define CK_BUS_USBHEHCI		218
#define CK_KER_LPTIM1		219
#define CK_KER_LPTIM2		220
#define CK_KER_USART2		221
#define CK_KER_UART4		222
#define CK_KER_USART3		223
#define CK_KER_UART5		224
#define CK_KER_SPI2		225
#define CK_KER_SPI3		226
#define CK_KER_SPDIFRX		227
#define CK_KER_I2C1		228
#define CK_KER_I2C2		229
#define CK_KER_I3C1		230
#define CK_KER_I3C2		231
#define CK_KER_I2C3		232
#define CK_KER_I3C3		233
#define CK_KER_SPI1		234
#define CK_KER_SPI4		235
#define CK_KER_SPI5		236
#define CK_KER_SPI6		237
#define CK_KER_USART1		238
#define CK_KER_USART6		239
#define CK_KER_UART7		240
#define CK_KER_MDF1		241
#define CK_KER_SAI1		242
#define CK_KER_SAI2		243
#define CK_KER_SAI3		244
#define CK_KER_SAI4		245
#define CK_KER_FDCAN		246
#define CK_KER_CSI		247
#define CK_KER_CSITXESC		248
#define CK_KER_CSIPHY		249
#define CK_KER_STGEN		250
#define CK_KER_USB2PHY2EN	251
#define CK_KER_LPUART1		252
#define CK_KER_LPTIM3		253
#define CK_KER_LPTIM4		254
#define CK_KER_LPTIM5		255
#define CK_KER_TSDBG		256
#define CK_KER_TPIU		257
#define CK_BUS_ETR		258
#define CK_BUS_SYSATB		259
#define CK_KER_ADC1		260
#define CK_KER_ADC2		261
#define CK_KER_OSPI1		262
#define CK_KER_FMC		263
#define CK_KER_SDMMC1		264
#define CK_KER_SDMMC2		265
#define CK_KER_SDMMC3		266
#define CK_KER_ETH1		267
#define CK_KER_ETH2		268
#define CK_KER_ETH1PTP		269
#define CK_KER_ETH2PTP		270
#define CK_KER_USB2PHY1		271
#define CK_KER_USB2PHY2		272
#define CK_MCO1			273
#define CK_MCO2			274
#define CK_KER_DTS		275
#define CK_ETH1_RX		276
#define CK_ETH1_TX		277
#define CK_ETH1_MAC		278
#define CK_ETH2_RX		279
#define CK_ETH2_TX		280
#define CK_ETH2_MAC		281
#define CK_ETH1_STP		282
#define CK_ETH2_STP		283
#define CK_KER_LTDC		284
#define HSE_DIV2_CK		285
#define CK_DBGMCU		286
#define CK_DAP			287
#define CK_KER_ETR		288
#define CK_KER_STM		289

#define CK_SCMI_ICN_HS_MCU	0
#define CK_SCMI_ICN_SDMMC	1
#define CK_SCMI_ICN_DDR		2
#define CK_SCMI_ICN_DISPLAY	3
#define CK_SCMI_ICN_HSL		4
#define CK_SCMI_ICN_NIC		5
#define CK_SCMI_FLEXGEN_07	7
#define CK_SCMI_FLEXGEN_08	8
#define CK_SCMI_FLEXGEN_09	9
#define CK_SCMI_FLEXGEN_10	10
#define CK_SCMI_FLEXGEN_11	11
#define CK_SCMI_FLEXGEN_12	12
#define CK_SCMI_FLEXGEN_13	13
#define CK_SCMI_FLEXGEN_14	14
#define CK_SCMI_FLEXGEN_15	15
#define CK_SCMI_FLEXGEN_16	16
#define CK_SCMI_FLEXGEN_17	17
#define CK_SCMI_FLEXGEN_18	18
#define CK_SCMI_FLEXGEN_19	19
#define CK_SCMI_FLEXGEN_20	20
#define CK_SCMI_FLEXGEN_21	21
#define CK_SCMI_FLEXGEN_22	22
#define CK_SCMI_FLEXGEN_23	23
#define CK_SCMI_FLEXGEN_24	24
#define CK_SCMI_FLEXGEN_25	25
#define CK_SCMI_FLEXGEN_26	26
#define CK_SCMI_FLEXGEN_27	27
#define CK_SCMI_FLEXGEN_28	28
#define CK_SCMI_FLEXGEN_29	29
#define CK_SCMI_FLEXGEN_30	30
#define CK_SCMI_FLEXGEN_31	31
#define CK_SCMI_FLEXGEN_32	32
#define CK_SCMI_FLEXGEN_33	33
#define CK_SCMI_FLEXGEN_34	34
#define CK_SCMI_FLEXGEN_35	35
#define CK_SCMI_FLEXGEN_36	36
#define CK_SCMI_FLEXGEN_37	37
#define CK_SCMI_FLEXGEN_38	38
#define CK_SCMI_FLEXGEN_39	39
#define CK_SCMI_FLEXGEN_40	40
#define CK_SCMI_FLEXGEN_41	41
#define CK_SCMI_FLEXGEN_42	42
#define CK_SCMI_FLEXGEN_43	43
#define CK_SCMI_FLEXGEN_44	44
#define CK_SCMI_FLEXGEN_45	45
#define CK_SCMI_FLEXGEN_46	46
#define CK_SCMI_FLEXGEN_47	47
#define CK_SCMI_FLEXGEN_48	48
#define CK_SCMI_FLEXGEN_49	49
#define CK_SCMI_FLEXGEN_50	50
#define CK_SCMI_FLEXGEN_51	51
#define CK_SCMI_FLEXGEN_52	52
#define CK_SCMI_FLEXGEN_53	53
#define CK_SCMI_FLEXGEN_54	54
#define CK_SCMI_FLEXGEN_55	55
#define CK_SCMI_FLEXGEN_56	56
#define CK_SCMI_FLEXGEN_57	57
#define CK_SCMI_FLEXGEN_58	58
#define CK_SCMI_FLEXGEN_59	59
#define CK_SCMI_FLEXGEN_60	60
#define CK_SCMI_FLEXGEN_61	61
#define CK_SCMI_FLEXGEN_62	62
#define CK_SCMI_FLEXGEN_63	63
#define CK_SCMI_ICN_LS_MCU	64
#define CK_SCMI_HSE		65
#define CK_SCMI_LSE		66
#define CK_SCMI_HSI		67
#define CK_SCMI_LSI		68
#define CK_SCMI_MSI		69
#define CK_SCMI_HSE_DIV2	70
#define CK_SCMI_CPU1		71
#define CK_SCMI_SYSCPU1		72
#define CK_SCMI_PLL2		73
#define CK_SCMI_RTC		74
#define CK_SCMI_RTCCK		75
#define CK_SCMI_ICN_APB1	76
#define CK_SCMI_ICN_APB2	77
#define CK_SCMI_ICN_APB3	78
#define CK_SCMI_ICN_APB4	79
#define CK_SCMI_ICN_APB5	80
#define CK_SCMI_ICN_APBDBG	81
#define CK_SCMI_TIMG1		82
#define CK_SCMI_TIMG2		83
#define CK_SCMI_BKPSRAM		84
#define CK_SCMI_BSEC		85
#define CK_SCMI_BUS_ETR		86
#define CK_SCMI_FMC		87
#define CK_SCMI_GPIOA		88
#define CK_SCMI_GPIOB		89
#define CK_SCMI_GPIOC		90
#define CK_SCMI_GPIOD		91
#define CK_SCMI_GPIOE		92
#define CK_SCMI_GPIOF		93
#define CK_SCMI_GPIOG		94
#define CK_SCMI_GPIOH		95
#define CK_SCMI_GPIOI		96
#define CK_SCMI_GPIOZ		97
#define CK_SCMI_HPDMA1		98
#define CK_SCMI_HPDMA2		99
#define CK_SCMI_HPDMA3		100
#define CK_SCMI_IPCC1		101
#define CK_SCMI_RETRAM		102
#define CK_SCMI_SRAM1		103
#define CK_SCMI_SYSRAM		104
#define CK_SCMI_OSPI1		105
#define CK_SCMI_TPIU		106
#define CK_SCMI_SYSDBG		107
#define CK_SCMI_SYSATB		108
#define CK_SCMI_TSDBG		109
#define CK_SCMI_BUS_STM		110
#define CK_SCMI_KER_STM		111
#define CK_SCMI_KER_ETR		112

#endif /* _DT_BINDINGS_STM32MP21_CLKS_H_ */
