/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.jvm;

import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.Nullable;

public class ClassDirectoryBinaryNamingScheme {
    private final String baseName;
    private final String collapsedName;

    public ClassDirectoryBinaryNamingScheme(String baseName) {
        this.baseName = baseName;
        this.collapsedName = ClassDirectoryBinaryNamingScheme.collapseMain(this.baseName);
    }

    private static String collapseMain(String name) {
        return name.equals("main") ? "" : name;
    }

    public String getDescription() {
        return "classes '" + this.baseName + "'";
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getBinaryName() {
        return this.baseName;
    }

    public String getTaskName(@Nullable String verb) {
        return this.getTaskName(verb, null);
    }

    public String getTaskName(@Nullable String verb, @Nullable String target) {
        String name = this.baseName;
        if (target != null) {
            name = this.collapsedName;
        }
        return GUtil.toLowerCamelCase((CharSequence)(this.nullToEmpty(verb) + " " + name + " " + this.nullToEmpty(target)));
    }

    private String nullToEmpty(String input) {
        return input == null ? "" : input;
    }

    public String getOutputDirectoryBase() {
        return this.baseName;
    }
}

