// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package qappsiface provides an interface to enable mocking the QApps service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package qappsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/qapps"
)

// QAppsAPI provides an interface to enable mocking the
// qapps.QApps service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// QApps.
//	func myFunc(svc qappsiface.QAppsAPI) bool {
//	    // Make svc.AssociateLibraryItemReview request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := qapps.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockQAppsClient struct {
//	    qappsiface.QAppsAPI
//	}
//	func (m *mockQAppsClient) AssociateLibraryItemReview(input *qapps.AssociateLibraryItemReviewInput) (*qapps.AssociateLibraryItemReviewOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockQAppsClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type QAppsAPI interface {
	AssociateLibraryItemReview(*qapps.AssociateLibraryItemReviewInput) (*qapps.AssociateLibraryItemReviewOutput, error)
	AssociateLibraryItemReviewWithContext(aws.Context, *qapps.AssociateLibraryItemReviewInput, ...request.Option) (*qapps.AssociateLibraryItemReviewOutput, error)
	AssociateLibraryItemReviewRequest(*qapps.AssociateLibraryItemReviewInput) (*request.Request, *qapps.AssociateLibraryItemReviewOutput)

	AssociateQAppWithUser(*qapps.AssociateQAppWithUserInput) (*qapps.AssociateQAppWithUserOutput, error)
	AssociateQAppWithUserWithContext(aws.Context, *qapps.AssociateQAppWithUserInput, ...request.Option) (*qapps.AssociateQAppWithUserOutput, error)
	AssociateQAppWithUserRequest(*qapps.AssociateQAppWithUserInput) (*request.Request, *qapps.AssociateQAppWithUserOutput)

	CreateLibraryItem(*qapps.CreateLibraryItemInput) (*qapps.CreateLibraryItemOutput, error)
	CreateLibraryItemWithContext(aws.Context, *qapps.CreateLibraryItemInput, ...request.Option) (*qapps.CreateLibraryItemOutput, error)
	CreateLibraryItemRequest(*qapps.CreateLibraryItemInput) (*request.Request, *qapps.CreateLibraryItemOutput)

	CreateQApp(*qapps.CreateQAppInput) (*qapps.CreateQAppOutput, error)
	CreateQAppWithContext(aws.Context, *qapps.CreateQAppInput, ...request.Option) (*qapps.CreateQAppOutput, error)
	CreateQAppRequest(*qapps.CreateQAppInput) (*request.Request, *qapps.CreateQAppOutput)

	DeleteLibraryItem(*qapps.DeleteLibraryItemInput) (*qapps.DeleteLibraryItemOutput, error)
	DeleteLibraryItemWithContext(aws.Context, *qapps.DeleteLibraryItemInput, ...request.Option) (*qapps.DeleteLibraryItemOutput, error)
	DeleteLibraryItemRequest(*qapps.DeleteLibraryItemInput) (*request.Request, *qapps.DeleteLibraryItemOutput)

	DeleteQApp(*qapps.DeleteQAppInput) (*qapps.DeleteQAppOutput, error)
	DeleteQAppWithContext(aws.Context, *qapps.DeleteQAppInput, ...request.Option) (*qapps.DeleteQAppOutput, error)
	DeleteQAppRequest(*qapps.DeleteQAppInput) (*request.Request, *qapps.DeleteQAppOutput)

	DisassociateLibraryItemReview(*qapps.DisassociateLibraryItemReviewInput) (*qapps.DisassociateLibraryItemReviewOutput, error)
	DisassociateLibraryItemReviewWithContext(aws.Context, *qapps.DisassociateLibraryItemReviewInput, ...request.Option) (*qapps.DisassociateLibraryItemReviewOutput, error)
	DisassociateLibraryItemReviewRequest(*qapps.DisassociateLibraryItemReviewInput) (*request.Request, *qapps.DisassociateLibraryItemReviewOutput)

	DisassociateQAppFromUser(*qapps.DisassociateQAppFromUserInput) (*qapps.DisassociateQAppFromUserOutput, error)
	DisassociateQAppFromUserWithContext(aws.Context, *qapps.DisassociateQAppFromUserInput, ...request.Option) (*qapps.DisassociateQAppFromUserOutput, error)
	DisassociateQAppFromUserRequest(*qapps.DisassociateQAppFromUserInput) (*request.Request, *qapps.DisassociateQAppFromUserOutput)

	GetLibraryItem(*qapps.GetLibraryItemInput) (*qapps.GetLibraryItemOutput, error)
	GetLibraryItemWithContext(aws.Context, *qapps.GetLibraryItemInput, ...request.Option) (*qapps.GetLibraryItemOutput, error)
	GetLibraryItemRequest(*qapps.GetLibraryItemInput) (*request.Request, *qapps.GetLibraryItemOutput)

	GetQApp(*qapps.GetQAppInput) (*qapps.GetQAppOutput, error)
	GetQAppWithContext(aws.Context, *qapps.GetQAppInput, ...request.Option) (*qapps.GetQAppOutput, error)
	GetQAppRequest(*qapps.GetQAppInput) (*request.Request, *qapps.GetQAppOutput)

	GetQAppSession(*qapps.GetQAppSessionInput) (*qapps.GetQAppSessionOutput, error)
	GetQAppSessionWithContext(aws.Context, *qapps.GetQAppSessionInput, ...request.Option) (*qapps.GetQAppSessionOutput, error)
	GetQAppSessionRequest(*qapps.GetQAppSessionInput) (*request.Request, *qapps.GetQAppSessionOutput)

	ImportDocument(*qapps.ImportDocumentInput) (*qapps.ImportDocumentOutput, error)
	ImportDocumentWithContext(aws.Context, *qapps.ImportDocumentInput, ...request.Option) (*qapps.ImportDocumentOutput, error)
	ImportDocumentRequest(*qapps.ImportDocumentInput) (*request.Request, *qapps.ImportDocumentOutput)

	ListLibraryItems(*qapps.ListLibraryItemsInput) (*qapps.ListLibraryItemsOutput, error)
	ListLibraryItemsWithContext(aws.Context, *qapps.ListLibraryItemsInput, ...request.Option) (*qapps.ListLibraryItemsOutput, error)
	ListLibraryItemsRequest(*qapps.ListLibraryItemsInput) (*request.Request, *qapps.ListLibraryItemsOutput)

	ListLibraryItemsPages(*qapps.ListLibraryItemsInput, func(*qapps.ListLibraryItemsOutput, bool) bool) error
	ListLibraryItemsPagesWithContext(aws.Context, *qapps.ListLibraryItemsInput, func(*qapps.ListLibraryItemsOutput, bool) bool, ...request.Option) error

	ListQApps(*qapps.ListQAppsInput) (*qapps.ListQAppsOutput, error)
	ListQAppsWithContext(aws.Context, *qapps.ListQAppsInput, ...request.Option) (*qapps.ListQAppsOutput, error)
	ListQAppsRequest(*qapps.ListQAppsInput) (*request.Request, *qapps.ListQAppsOutput)

	ListQAppsPages(*qapps.ListQAppsInput, func(*qapps.ListQAppsOutput, bool) bool) error
	ListQAppsPagesWithContext(aws.Context, *qapps.ListQAppsInput, func(*qapps.ListQAppsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*qapps.ListTagsForResourceInput) (*qapps.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *qapps.ListTagsForResourceInput, ...request.Option) (*qapps.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*qapps.ListTagsForResourceInput) (*request.Request, *qapps.ListTagsForResourceOutput)

	PredictQApp(*qapps.PredictQAppInput) (*qapps.PredictQAppOutput, error)
	PredictQAppWithContext(aws.Context, *qapps.PredictQAppInput, ...request.Option) (*qapps.PredictQAppOutput, error)
	PredictQAppRequest(*qapps.PredictQAppInput) (*request.Request, *qapps.PredictQAppOutput)

	StartQAppSession(*qapps.StartQAppSessionInput) (*qapps.StartQAppSessionOutput, error)
	StartQAppSessionWithContext(aws.Context, *qapps.StartQAppSessionInput, ...request.Option) (*qapps.StartQAppSessionOutput, error)
	StartQAppSessionRequest(*qapps.StartQAppSessionInput) (*request.Request, *qapps.StartQAppSessionOutput)

	StopQAppSession(*qapps.StopQAppSessionInput) (*qapps.StopQAppSessionOutput, error)
	StopQAppSessionWithContext(aws.Context, *qapps.StopQAppSessionInput, ...request.Option) (*qapps.StopQAppSessionOutput, error)
	StopQAppSessionRequest(*qapps.StopQAppSessionInput) (*request.Request, *qapps.StopQAppSessionOutput)

	TagResource(*qapps.TagResourceInput) (*qapps.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *qapps.TagResourceInput, ...request.Option) (*qapps.TagResourceOutput, error)
	TagResourceRequest(*qapps.TagResourceInput) (*request.Request, *qapps.TagResourceOutput)

	UntagResource(*qapps.UntagResourceInput) (*qapps.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *qapps.UntagResourceInput, ...request.Option) (*qapps.UntagResourceOutput, error)
	UntagResourceRequest(*qapps.UntagResourceInput) (*request.Request, *qapps.UntagResourceOutput)

	UpdateLibraryItem(*qapps.UpdateLibraryItemInput) (*qapps.UpdateLibraryItemOutput, error)
	UpdateLibraryItemWithContext(aws.Context, *qapps.UpdateLibraryItemInput, ...request.Option) (*qapps.UpdateLibraryItemOutput, error)
	UpdateLibraryItemRequest(*qapps.UpdateLibraryItemInput) (*request.Request, *qapps.UpdateLibraryItemOutput)

	UpdateQApp(*qapps.UpdateQAppInput) (*qapps.UpdateQAppOutput, error)
	UpdateQAppWithContext(aws.Context, *qapps.UpdateQAppInput, ...request.Option) (*qapps.UpdateQAppOutput, error)
	UpdateQAppRequest(*qapps.UpdateQAppInput) (*request.Request, *qapps.UpdateQAppOutput)

	UpdateQAppSession(*qapps.UpdateQAppSessionInput) (*qapps.UpdateQAppSessionOutput, error)
	UpdateQAppSessionWithContext(aws.Context, *qapps.UpdateQAppSessionInput, ...request.Option) (*qapps.UpdateQAppSessionOutput, error)
	UpdateQAppSessionRequest(*qapps.UpdateQAppSessionInput) (*request.Request, *qapps.UpdateQAppSessionOutput)
}

var _ QAppsAPI = (*qapps.QApps)(nil)
