﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cognito-idp/model/FirehoseConfigurationType.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace CognitoIdentityProvider {
namespace Model {

FirehoseConfigurationType::FirehoseConfigurationType(JsonView jsonValue) { *this = jsonValue; }

FirehoseConfigurationType& FirehoseConfigurationType::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("StreamArn")) {
    m_streamArn = jsonValue.GetString("StreamArn");
    m_streamArnHasBeenSet = true;
  }
  return *this;
}

JsonValue FirehoseConfigurationType::Jsonize() const {
  JsonValue payload;

  if (m_streamArnHasBeenSet) {
    payload.WithString("StreamArn", m_streamArn);
  }

  return payload;
}

}  // namespace Model
}  // namespace CognitoIdentityProvider
}  // namespace Aws
