﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codedeploy/CodeDeploy_EXPORTS.h>
#include <aws/codedeploy/model/DeploymentInfo.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace CodeDeploy {
namespace Model {
/**
 * <p>Represents the output of a <code>GetDeployment</code>
 * operation.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/GetDeploymentOutput">AWS
 * API Reference</a></p>
 */
class GetDeploymentResult {
 public:
  AWS_CODEDEPLOY_API GetDeploymentResult() = default;
  AWS_CODEDEPLOY_API GetDeploymentResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CODEDEPLOY_API GetDeploymentResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Information about the deployment.</p>
   */
  inline const DeploymentInfo& GetDeploymentInfo() const { return m_deploymentInfo; }
  template <typename DeploymentInfoT = DeploymentInfo>
  void SetDeploymentInfo(DeploymentInfoT&& value) {
    m_deploymentInfoHasBeenSet = true;
    m_deploymentInfo = std::forward<DeploymentInfoT>(value);
  }
  template <typename DeploymentInfoT = DeploymentInfo>
  GetDeploymentResult& WithDeploymentInfo(DeploymentInfoT&& value) {
    SetDeploymentInfo(std::forward<DeploymentInfoT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetDeploymentResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  DeploymentInfo m_deploymentInfo;
  bool m_deploymentInfoHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeDeploy
}  // namespace Aws
