﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codeconnections/CodeConnections_EXPORTS.h>
#include <aws/codeconnections/model/ProviderType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CodeConnections {
namespace Model {

/**
 * <p>Information about the repository link resource, such as the repository link
 * ARN, the associated connection ARN, encryption key ARN, and owner
 * ID.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/codeconnections-2023-12-01/RepositoryLinkInfo">AWS
 * API Reference</a></p>
 */
class RepositoryLinkInfo {
 public:
  AWS_CODECONNECTIONS_API RepositoryLinkInfo() = default;
  AWS_CODECONNECTIONS_API RepositoryLinkInfo(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODECONNECTIONS_API RepositoryLinkInfo& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODECONNECTIONS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the connection associated with the
   * repository link.</p>
   */
  inline const Aws::String& GetConnectionArn() const { return m_connectionArn; }
  inline bool ConnectionArnHasBeenSet() const { return m_connectionArnHasBeenSet; }
  template <typename ConnectionArnT = Aws::String>
  void SetConnectionArn(ConnectionArnT&& value) {
    m_connectionArnHasBeenSet = true;
    m_connectionArn = std::forward<ConnectionArnT>(value);
  }
  template <typename ConnectionArnT = Aws::String>
  RepositoryLinkInfo& WithConnectionArn(ConnectionArnT&& value) {
    SetConnectionArn(std::forward<ConnectionArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the encryption key for the repository
   * associated with the repository link.</p>
   */
  inline const Aws::String& GetEncryptionKeyArn() const { return m_encryptionKeyArn; }
  inline bool EncryptionKeyArnHasBeenSet() const { return m_encryptionKeyArnHasBeenSet; }
  template <typename EncryptionKeyArnT = Aws::String>
  void SetEncryptionKeyArn(EncryptionKeyArnT&& value) {
    m_encryptionKeyArnHasBeenSet = true;
    m_encryptionKeyArn = std::forward<EncryptionKeyArnT>(value);
  }
  template <typename EncryptionKeyArnT = Aws::String>
  RepositoryLinkInfo& WithEncryptionKeyArn(EncryptionKeyArnT&& value) {
    SetEncryptionKeyArn(std::forward<EncryptionKeyArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The owner ID for the repository associated with the repository link, such as
   * the owner ID in GitHub.</p>
   */
  inline const Aws::String& GetOwnerId() const { return m_ownerId; }
  inline bool OwnerIdHasBeenSet() const { return m_ownerIdHasBeenSet; }
  template <typename OwnerIdT = Aws::String>
  void SetOwnerId(OwnerIdT&& value) {
    m_ownerIdHasBeenSet = true;
    m_ownerId = std::forward<OwnerIdT>(value);
  }
  template <typename OwnerIdT = Aws::String>
  RepositoryLinkInfo& WithOwnerId(OwnerIdT&& value) {
    SetOwnerId(std::forward<OwnerIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The provider type for the connection, such as GitHub, associated with the
   * repository link.</p>
   */
  inline ProviderType GetProviderType() const { return m_providerType; }
  inline bool ProviderTypeHasBeenSet() const { return m_providerTypeHasBeenSet; }
  inline void SetProviderType(ProviderType value) {
    m_providerTypeHasBeenSet = true;
    m_providerType = value;
  }
  inline RepositoryLinkInfo& WithProviderType(ProviderType value) {
    SetProviderType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the repository link.</p>
   */
  inline const Aws::String& GetRepositoryLinkArn() const { return m_repositoryLinkArn; }
  inline bool RepositoryLinkArnHasBeenSet() const { return m_repositoryLinkArnHasBeenSet; }
  template <typename RepositoryLinkArnT = Aws::String>
  void SetRepositoryLinkArn(RepositoryLinkArnT&& value) {
    m_repositoryLinkArnHasBeenSet = true;
    m_repositoryLinkArn = std::forward<RepositoryLinkArnT>(value);
  }
  template <typename RepositoryLinkArnT = Aws::String>
  RepositoryLinkInfo& WithRepositoryLinkArn(RepositoryLinkArnT&& value) {
    SetRepositoryLinkArn(std::forward<RepositoryLinkArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the repository link.</p>
   */
  inline const Aws::String& GetRepositoryLinkId() const { return m_repositoryLinkId; }
  inline bool RepositoryLinkIdHasBeenSet() const { return m_repositoryLinkIdHasBeenSet; }
  template <typename RepositoryLinkIdT = Aws::String>
  void SetRepositoryLinkId(RepositoryLinkIdT&& value) {
    m_repositoryLinkIdHasBeenSet = true;
    m_repositoryLinkId = std::forward<RepositoryLinkIdT>(value);
  }
  template <typename RepositoryLinkIdT = Aws::String>
  RepositoryLinkInfo& WithRepositoryLinkId(RepositoryLinkIdT&& value) {
    SetRepositoryLinkId(std::forward<RepositoryLinkIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the repository associated with the repository link.</p>
   */
  inline const Aws::String& GetRepositoryName() const { return m_repositoryName; }
  inline bool RepositoryNameHasBeenSet() const { return m_repositoryNameHasBeenSet; }
  template <typename RepositoryNameT = Aws::String>
  void SetRepositoryName(RepositoryNameT&& value) {
    m_repositoryNameHasBeenSet = true;
    m_repositoryName = std::forward<RepositoryNameT>(value);
  }
  template <typename RepositoryNameT = Aws::String>
  RepositoryLinkInfo& WithRepositoryName(RepositoryNameT&& value) {
    SetRepositoryName(std::forward<RepositoryNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_connectionArn;
  bool m_connectionArnHasBeenSet = false;

  Aws::String m_encryptionKeyArn;
  bool m_encryptionKeyArnHasBeenSet = false;

  Aws::String m_ownerId;
  bool m_ownerIdHasBeenSet = false;

  ProviderType m_providerType{ProviderType::NOT_SET};
  bool m_providerTypeHasBeenSet = false;

  Aws::String m_repositoryLinkArn;
  bool m_repositoryLinkArnHasBeenSet = false;

  Aws::String m_repositoryLinkId;
  bool m_repositoryLinkIdHasBeenSet = false;

  Aws::String m_repositoryName;
  bool m_repositoryNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeConnections
}  // namespace Aws
