﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cleanrooms/model/ChangeType.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace CleanRooms {
namespace Model {
namespace ChangeTypeMapper {

static const int ADD_MEMBER_HASH = HashingUtils::HashString("ADD_MEMBER");

ChangeType GetChangeTypeForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == ADD_MEMBER_HASH) {
    return ChangeType::ADD_MEMBER;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<ChangeType>(hashCode);
  }

  return ChangeType::NOT_SET;
}

Aws::String GetNameForChangeType(ChangeType enumValue) {
  switch (enumValue) {
    case ChangeType::NOT_SET:
      return {};
    case ChangeType::ADD_MEMBER:
      return "ADD_MEMBER";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace ChangeTypeMapper
}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
