﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/chime/model/MemberError.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Chime {
namespace Model {

MemberError::MemberError(JsonView jsonValue) { *this = jsonValue; }

MemberError& MemberError::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("MemberId")) {
    m_memberId = jsonValue.GetString("MemberId");
    m_memberIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ErrorCode")) {
    m_errorCode = ErrorCodeMapper::GetErrorCodeForName(jsonValue.GetString("ErrorCode"));
    m_errorCodeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ErrorMessage")) {
    m_errorMessage = jsonValue.GetString("ErrorMessage");
    m_errorMessageHasBeenSet = true;
  }
  return *this;
}

JsonValue MemberError::Jsonize() const {
  JsonValue payload;

  if (m_memberIdHasBeenSet) {
    payload.WithString("MemberId", m_memberId);
  }

  if (m_errorCodeHasBeenSet) {
    payload.WithString("ErrorCode", ErrorCodeMapper::GetNameForErrorCode(m_errorCode));
  }

  if (m_errorMessageHasBeenSet) {
    payload.WithString("ErrorMessage", m_errorMessage);
  }

  return payload;
}

}  // namespace Model
}  // namespace Chime
}  // namespace Aws
