﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-voice/ChimeSDKVoiceRequest.h>
#include <aws/chime-sdk-voice/ChimeSDKVoice_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ChimeSDKVoice {
namespace Model {

/**
 */
class GetProxySessionRequest : public ChimeSDKVoiceRequest {
 public:
  AWS_CHIMESDKVOICE_API GetProxySessionRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetProxySession"; }

  AWS_CHIMESDKVOICE_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The Voice Connector ID.</p>
   */
  inline const Aws::String& GetVoiceConnectorId() const { return m_voiceConnectorId; }
  inline bool VoiceConnectorIdHasBeenSet() const { return m_voiceConnectorIdHasBeenSet; }
  template <typename VoiceConnectorIdT = Aws::String>
  void SetVoiceConnectorId(VoiceConnectorIdT&& value) {
    m_voiceConnectorIdHasBeenSet = true;
    m_voiceConnectorId = std::forward<VoiceConnectorIdT>(value);
  }
  template <typename VoiceConnectorIdT = Aws::String>
  GetProxySessionRequest& WithVoiceConnectorId(VoiceConnectorIdT&& value) {
    SetVoiceConnectorId(std::forward<VoiceConnectorIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The proxy session ID.</p>
   */
  inline const Aws::String& GetProxySessionId() const { return m_proxySessionId; }
  inline bool ProxySessionIdHasBeenSet() const { return m_proxySessionIdHasBeenSet; }
  template <typename ProxySessionIdT = Aws::String>
  void SetProxySessionId(ProxySessionIdT&& value) {
    m_proxySessionIdHasBeenSet = true;
    m_proxySessionId = std::forward<ProxySessionIdT>(value);
  }
  template <typename ProxySessionIdT = Aws::String>
  GetProxySessionRequest& WithProxySessionId(ProxySessionIdT&& value) {
    SetProxySessionId(std::forward<ProxySessionIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_voiceConnectorId;
  bool m_voiceConnectorIdHasBeenSet = false;

  Aws::String m_proxySessionId;
  bool m_proxySessionIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKVoice
}  // namespace Aws
