/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.features.correctness;

import com.intellij.ml.inline.completion.features.correctness.CommentEnrichmentToolKt;
import com.intellij.ml.inline.completion.features.correctness.CommentRange;
import com.intellij.ml.inline.completion.features.correctness.EnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.RawEnrichmentTool;
import com.intellij.ml.inline.completion.features.correctness.SpecialRange;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionLogger;
import com.intellij.ml.inline.completion.impl.kit.MLCompletionStringLiteralSupporter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.ExtensionsKt;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J>\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J;\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00072\u0018\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00190\u00180\u0007H\u0001\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/inline/completion/features/correctness/CommentEnrichmentTool;", "Lcom/intellij/ml/inline/completion/features/correctness/RawEnrichmentTool;", "stringLiteralSupporter", "Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionStringLiteralSupporter;", "<init>", "(Lcom/intellij/ml/inline/completion/impl/kit/MLCompletionStringLiteralSupporter;)V", "run", "", "Lcom/intellij/ml/inline/completion/features/correctness/SpecialRange;", "editor", "Lcom/intellij/openapi/editor/Editor;", "originalFile", "Lcom/intellij/psi/PsiFile;", "suggestionOffset", "", "suggestion", "", "fileWithSuggestion", "suggestionRange", "Lcom/intellij/openapi/util/TextRange;", "matchCommentRangesWithAttributes", "Lcom/intellij/ml/inline/completion/features/correctness/CommentRange;", "commentRanges", "highlightedRanges", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "matchCommentRangesWithAttributes$intellij_fullLine_core_completion", "Companion", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\nCommentEnrichmentTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommentEnrichmentTool.kt\ncom/intellij/ml/inline/completion/features/correctness/CommentEnrichmentTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/DiagnosticLoggersKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,127:1\n1563#2:128\n1634#2,3:129\n774#2:132\n865#2,2:133\n1563#2:135\n1634#2,3:136\n35#3:139\n14#4:140\n*S KotlinDebug\n*F\n+ 1 CommentEnrichmentTool.kt\ncom/intellij/ml/inline/completion/features/correctness/CommentEnrichmentTool\n*L\n27#1:128\n27#1:129,3\n29#1:132\n29#1:133,2\n30#1:135\n30#1:136,3\n87#1:139\n87#1:140\n*E\n"})
public final class CommentEnrichmentTool
extends RawEnrichmentTool {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final MLCompletionStringLiteralSupporter stringLiteralSupporter;
    @NotNull
    private static final MLCompletionLogger LOG;

    public CommentEnrichmentTool(@NotNull MLCompletionStringLiteralSupporter stringLiteralSupporter) {
        Intrinsics.checkNotNullParameter((Object)stringLiteralSupporter, (String)"stringLiteralSupporter");
        super(EnrichmentTool.Aspect.COMMENTS);
        this.stringLiteralSupporter = stringLiteralSupporter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<SpecialRange> run(@NotNull Editor editor2, @NotNull PsiFile originalFile, int suggestionOffset, @NotNull String suggestion2, @NotNull PsiFile fileWithSuggestion, @NotNull TextRange suggestionRange) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)suggestion2, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)fileWithSuggestion, (String)"fileWithSuggestion");
        Intrinsics.checkNotNullParameter((Object)suggestionRange, (String)"suggestionRange");
        try {
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            TextRange it;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Iterable iterable = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)fileWithSuggestion)).onRange(suggestionRange).filter(arg_0 -> CommentEnrichmentTool.run$lambda$1(arg_0 -> CommentEnrichmentTool.run$lambda$0(this, arg_0), arg_0))).toList();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"toList(...)");
            iterable = iterable;
            boolean $i$f$map = false;
            EditorHighlighter editorHighlighter = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PsiElement psiElement = (PsiElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getTextRange());
            }
            $this$map$iv = CommentEnrichmentToolKt.normalize((List)destination$iv$iv);
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (TextRange)element$iv$iv;
                boolean bl = false;
                if (!(it.getEndOffset() >= suggestionOffset)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (TextRange)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getStartOffset() <= suggestionOffset ? new TextRange(suggestionOffset, it.getEndOffset()) : it);
            }
            List commentRanges = (List)destination$iv$iv;
            if (commentRanges.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            editorHighlighter = editor2.getHighlighter();
            LexerEditorHighlighter lexerEditorHighlighter = editorHighlighter instanceof LexerEditorHighlighter ? (LexerEditorHighlighter)editorHighlighter : null;
            if (lexerEditorHighlighter == null) {
                return CollectionsKt.emptyList();
            }
            LexerEditorHighlighter highlighter = lexerEditorHighlighter;
            List list = highlighter.getAttributesFor(editor2.getDocument(), suggestionRange.getStartOffset(), (CharSequence)suggestion2);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAttributesFor(...)");
            List highlightedRanges = list;
            return this.matchCommentRangesWithAttributes$intellij_fullLine_core_completion(commentRanges, highlightedRanges);
        }
        catch (Throwable e) {
            LOG.errorIfNotMessage(e);
            return CollectionsKt.emptyList();
        }
    }

    @VisibleForTesting
    @NotNull
    public final List<CommentRange> matchCommentRangesWithAttributes$intellij_fullLine_core_completion(@NotNull List<? extends TextRange> commentRanges, @NotNull List<? extends Pair<TextRange, TextAttributes>> highlightedRanges) {
        Intrinsics.checkNotNullParameter(commentRanges, (String)"commentRanges");
        Intrinsics.checkNotNullParameter(highlightedRanges, (String)"highlightedRanges");
        List result2 = new ArrayList();
        int commentIdx = 0;
        int highlightIdx = 0;
        while (commentIdx < commentRanges.size() && highlightIdx < highlightedRanges.size()) {
            TextRange comment = commentRanges.get(commentIdx);
            Pair<TextRange, TextAttributes> pair = highlightedRanges.get(highlightIdx);
            TextRange highlight = (TextRange)ExtensionsKt.component1(pair);
            TextAttributes attr = (TextAttributes)ExtensionsKt.component2(pair);
            if (comment.getEndOffset() <= highlight.getStartOffset()) {
                ++commentIdx;
                continue;
            }
            if (highlight.getEndOffset() <= comment.getStartOffset()) {
                ++highlightIdx;
                continue;
            }
            TextRange intersection = comment.intersection(highlight);
            if (intersection != null && !intersection.isEmpty()) {
                result2.add(new CommentRange(intersection, attr));
            }
            if (comment.getEndOffset() < highlight.getEndOffset()) {
                ++commentIdx;
                continue;
            }
            ++highlightIdx;
        }
        return result2;
    }

    private static final boolean run$lambda$0(CommentEnrichmentTool this$0, PsiElement element) {
        MLCompletionStringLiteralSupporter mLCompletionStringLiteralSupporter = this$0.stringLiteralSupporter;
        Intrinsics.checkNotNull((Object)element);
        return mLCompletionStringLiteralSupporter.isComment(element, element.getTextRange().getStartOffset());
    }

    private static final boolean run$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Companion $this$thisMLCompletionLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisMLCompletionLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = new MLCompletionLogger(logger, MLCompletionLogger.FeatureType.Completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/inline/completion/features/correctness/CommentEnrichmentTool$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/inline/completion/impl/diagnostic/MLCompletionLogger;", "intellij.fullLine.core.completion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

