/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.maven;

import com.intellij.diagram.DiagramColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.util.PlatformIcons;
import icons.MavenIcons;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.navigator.MavenNavigationUtil;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;

@VisibleForTesting
@ApiStatus.Internal
public final class MavenElement
implements Navigatable {
    private final MavenArtifactNode myArtifact;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MavenProject myMavenProject;
    private MavenElement parent;

    public MavenElement(@NotNull Project project, @NotNull MavenProject mavenProject, MavenArtifactNode artifact) {
        if (project == null) {
            MavenElement.$$$reportNull$$$0(0);
        }
        if (mavenProject == null) {
            MavenElement.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myMavenProject = mavenProject;
        this.myArtifact = artifact;
    }

    public boolean isProject() {
        return MavenProjectsManager.getInstance((Project)this.myProject).findProject(this.getMavenId()) != null;
    }

    @NlsSafe
    public String getName() {
        return this.getMavenId().getArtifactId();
    }

    public List<MavenElement> getChildren() {
        List nodes = this.myArtifact != null ? this.myArtifact.getDependencies() : this.myMavenProject.getDependencyTree();
        ArrayList<MavenElement> children = new ArrayList<MavenElement>(nodes.size());
        MavenProject mavenProject = this.getMavenProject();
        MavenProjectsManager manager = MavenProjectsManager.getInstance((Project)this.myProject);
        for (MavenArtifactNode node : nodes) {
            MavenProject pr = manager.findProject(node.getArtifact());
            MavenElement mavenElement = new MavenElement(this.myProject, pr == null ? mavenProject : pr, node);
            mavenElement.setParent(this);
            children.add(mavenElement);
        }
        return children;
    }

    @NlsSafe
    public String getDescription() {
        MavenId id = this.getMavenId();
        return "<html>Group ID: <b>" + id.getGroupId() + "</b><br/>Artifact ID: <b>" + id.getArtifactId() + "</b><br/>Version: <b>" + id.getVersion() + "</b></html>";
    }

    @Nullable
    public MavenArtifactScope getScope() {
        return this.myArtifact == null ? null : MavenArtifactScope.fromString((String)this.myArtifact.getArtifact().getScope());
    }

    public String getId() {
        return this.myArtifact == null ? this.myMavenProject.getMavenId().getKey() : MavenElement.id(this.myArtifact);
    }

    public MavenId getMavenId() {
        return this.myArtifact == null ? this.myMavenProject.getMavenId() : this.myArtifact.getArtifact().getMavenId();
    }

    public Icon getIcon() {
        return this.isProject() ? MavenIcons.MavenProject : PlatformIcons.LIBRARY_ICON;
    }

    public void navigate(boolean requestFocus) {
        Navigatable navigatable = this.getNavigatable();
        if (navigatable != null) {
            navigatable.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return true;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myMavenProject.getFile();
        if (virtualFile == null) {
            MavenElement.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static String id(MavenArtifactNode node) {
        MavenArtifactNode parent = node.getParent();
        String id = node.getArtifact().getDisplayStringWithTypeAndClassifier();
        return parent == null ? id : MavenElement.id(parent) + "/" + id;
    }

    @Nullable
    public MavenArtifactState getState() {
        return this.myArtifact == null ? null : this.myArtifact.getState();
    }

    public MavenArtifactNode getArtifact() {
        return this.myArtifact;
    }

    public Color getTitleColor() {
        if (this.isProject()) {
            return DiagramColors.GENERALIZATION_EDGE.getDefaultColor();
        }
        if (this.hasConflicts()) {
            return JBColor.RED;
        }
        if (this.isTestArtifact()) {
            return DiagramColors.REALIZATION_EDGE.getDefaultColor();
        }
        return JBColor.BLACK;
    }

    private boolean hasConflicts() {
        return this.myArtifact != null && this.myArtifact.getState() == MavenArtifactState.CONFLICT;
    }

    public boolean isTestArtifact() {
        return this.myArtifact != null && MavenArtifactScope.fromString((String)this.myArtifact.getArtifact().getScope()) == MavenArtifactScope.TEST;
    }

    public MavenProject getMavenProject() {
        MavenProject project = MavenProjectsManager.getInstance((Project)this.myProject).findProject(this.getMavenId());
        return project == null ? this.myMavenProject : project;
    }

    @Nullable
    public Navigatable getNavigatable() {
        VirtualFile file;
        if (this.isProject()) {
            return MavenNavigationUtil.createNavigatableForPom((Project)this.getProject(), (VirtualFile)this.getMavenProject().getFile());
        }
        MavenElement p = this.getParent();
        VirtualFile virtualFile = p == null ? this.getVirtualFile() : (file = p.isProject() ? p.getVirtualFile() : MavenNavigationUtil.getArtifactFile((Project)this.getProject(), (MavenId)p.getMavenId()));
        if (file == null) {
            return null;
        }
        MavenArtifactNode artifact = this.getArtifact();
        if (artifact == null) {
            return null;
        }
        return MavenNavigationUtil.createNavigatableForDependency((Project)this.getProject(), (VirtualFile)file, (MavenArtifact)artifact.getArtifact());
    }

    public String toString() {
        return this.getName();
    }

    public MavenElement getParent() {
        return this.parent;
    }

    public void setParent(MavenElement parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenElement element = (MavenElement)o;
        return Objects.equals(this.myArtifact, element.myArtifact) && this.myProject.equals(element.myProject) && this.myMavenProject.equals(element.myMavenProject);
    }

    public int hashCode() {
        return Objects.hash(this.myArtifact, this.myProject, this.myMavenProject);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/maven/MavenElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/maven/MavenElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

