/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceOptionsPanel;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverImpl;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.dataSource.ui.DbOptionsEditor;
import com.intellij.database.dataSource.ui.HardViewport;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospectorFeatures;
import com.intellij.database.run.ui.DescriptionPopup;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.ui.DatabaseDriverConfigurable;
import com.intellij.database.view.ui.DatabaseDriverGeneralPanel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import icons.DatabaseIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DatabaseDriverOptionsPanel {
    private final DatabaseDriverConfigurable myConfigurable;
    private JBScrollPane myRoot;
    private ComboBox<SchemaControl> mySwitchControlBox;
    private EditorTextField myInitScript;
    private JBLabel mySourceLoadingLabel;
    private ComboBox<DBIntrospectionOptions.SourceLoading> mySourceLoading;
    private JBCheckBox myAutoSyncCheckBox;
    private ComboBox<Language> myDialect;
    private JBCheckBox myFormatSourcesOnSyncCheckBox;
    private JCheckBox mySendAppInfo;
    private EditorTextField myKeepAliveQuery;
    private JPanel myTxControlHolder;
    private JPanel myTxControlPanel;
    private ComboBox<Icon> myIcon;
    private JPanel myIconPanel;
    private JComponent myConnectionOptionsPanel;
    private final DbOptionsEditor<DatabaseDriver> myConnectionOptionsEditor;
    private JComponent myIntrospectionOptionsPanel;
    private final DbOptionsEditor<DatabaseDriver> myIntrospectionOptionsEditor;
    private final DescriptionPopup.TxPopup.TxSelector mySelector = new DescriptionPopup.TxPopup.TxSelectorImpl();

    public DatabaseDriverOptionsPanel(DatabaseDriverConfigurable configurable) {
        this.myConfigurable = configurable;
        this.myConnectionOptionsEditor = new DbOptionsEditor<DatabaseDriver>((DatabaseDriver)this.myConfigurable.getTarget(), p2 -> p2.getLocation() == DbOptionProvider.UiLocation.CONNECTION, null, configurable.getDataContext(), 2);
        this.myIntrospectionOptionsEditor = new DbOptionsEditor<DatabaseDriver>((DatabaseDriver)this.myConfigurable.getTarget(), p2 -> p2.getLocation() == DbOptionProvider.UiLocation.INTROSPECTION, null, configurable.getDataContext(), 2);
        DatabaseDriverImpl driver = configurable.getDriver();
        Dbms driverDbms = DbImplUtilCore.getDbms((DatabaseDriver)driver);
        this.$$$setupUI$$$();
        this.mySwitchControlBox.setModel((ComboBoxModel)new EnumComboBoxModel(SchemaControl.class));
        this.mySwitchControlBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DatabaseBundle.message((String)"data.source.settings.options.schema.switch.auto", (Object[])new Object[0]), value -> DataSourceOptionsPanel.getSchemaSwitchComboText(value)));
        this.myDialect.setEditable(false);
        DbUIUtil.initLanguageComboBox(this.myDialect, true);
        this.myDialect.addActionListener(e -> this.resetSQLFieldsDialect(DbSqlUtil.getSqlDialect(configurable.getTempDriver())));
        new ExpandableEditorSupport(this.myInitScript);
        new ExpandableEditorSupport(this.myKeepAliveQuery);
        boolean useLevels = DBIntrospectorFeatures.supportsMultilevelIntrospection((Dbms)driverDbms);
        this.mySourceLoadingLabel.setVisible(!useLevels);
        this.mySourceLoading.setVisible(!useLevels);
        this.mySourceLoading.setModel((ComboBoxModel)new EnumComboBoxModel(DBIntrospectionOptions.SourceLoading.class));
        this.mySourceLoading.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)DatabaseBundle.message((String)"data.source.settings.options.source.loading.none", (Object[])new Object[0]), value -> DataSourceOptionsPanel.getSourceLoadingComboText(value)));
        SortedComboBoxModel codeStyleNamesModel = new SortedComboBoxModel(String.CASE_INSENSITIVE_ORDER);
        List allSchemes = CodeStyleSchemesImpl.getSchemeManager().getAllSchemes();
        for (CodeStyleScheme scheme : allSchemes) {
            codeStyleNamesModel.add((Object)scheme.getName());
        }
        JComponent txComponent = DbUIUtil.createActionComponent((AnAction)new DatabaseDriverGeneralPanel.DriverTxModeAction(this.mySelector), (JComponent)this.myRoot);
        this.myTxControlPanel.setLayout(new BorderLayout());
        this.myTxControlPanel.add((Component)txComponent, "Center");
        this.myTxControlHolder.setVisible(DataSourceUtil.isTransactionsSupported(driverDbms));
        if (driver.isPredefined() && driverDbms.getIcon() == driver.getIcon(0)) {
            this.myIconPanel.setVisible(false);
        }
        LinkedHashMap<Icon, @Nls String> icons = new LinkedHashMap<Icon, String>();
        int genericCount = 1;
        icons.put(DatabaseIcons.UserDriver, DatabaseBundle.message((String)"icon.generic.0", (Object[])new Object[]{genericCount++}));
        JBIterable genericIcons = JBIterable.of((Object[])DatabaseIcons.class.getDeclaredFields()).filter(o -> o.getName().startsWith("Driver")).map(o -> (Icon)ReflectionUtil.getStaticFieldValue(DatabaseIcons.class, Icon.class, (String)o.getName()));
        for (Icon icon : genericIcons) {
            icons.putIfAbsent(icon, DatabaseBundle.message((String)"icon.generic.0", (Object[])new Object[]{genericCount++}));
        }
        for (Dbms dbms : JBIterable.from((Iterable)Dbms.allValues()).sort(Comparator.comparing(Dbms::getDisplayName))) {
            if (dbms == Dbms.UNKNOWN) continue;
            icons.putIfAbsent(dbms.getIcon(), dbms.getDisplayName());
        }
        this.myIcon.setModel((ComboBoxModel)new CollectionComboBoxModel(new ArrayList(icons.keySet()), (Object)driver.getIcon(0)));
        this.myIcon.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            label.setIcon(value);
            label.setText(StringUtil.notNullize((String)((String)icons.get(value)), (String)DatabaseBundle.message((String)"icon.generic.0", (Object[])new Object[]{1})));
        }));
        DatabaseDialogsHelper.setupEnclosingScrollPane((JScrollPane)this.myRoot);
        this.myConnectionOptionsEditor.reset(driver);
        this.myIntrospectionOptionsEditor.reset(driver);
        UIUtil.uiTraverser((Component)this.myRoot).filter(EditorTextField.class).forEach(etf -> etf.setDisposedWith((Disposable)this.myConfigurable));
    }

    public JComponent getComponent() {
        return this.myRoot;
    }

    private void createUIComponents() {
        this.myConnectionOptionsPanel = this.myConnectionOptionsEditor.getComponent();
        this.myIntrospectionOptionsPanel = this.myIntrospectionOptionsEditor.getComponent();
        this.myRoot = new HardViewport.ScrollPane();
        this.myInitScript = new EditorTextField("", this.myConfigurable.getProject(), (FileType)SqlFileType.INSTANCE);
        this.myKeepAliveQuery = new EditorTextField("", this.myConfigurable.getProject(), (FileType)SqlFileType.INSTANCE);
    }

    public void saveData(@NotNull DatabaseDriverImpl driver) {
        Object dialect;
        if (driver == null) {
            DatabaseDriverOptionsPanel.$$$reportNull$$$0(0);
        }
        driver.setSqlDialect((dialect = this.myDialect.getSelectedItem()) instanceof Language ? ((Language)dialect).getID() : null);
        driver.setOption(DatabaseDriver.OPTION_AUTO_COMMIT, this.mySelector.isAuto());
        driver.setOption(DatabaseDriver.OPTION_AUTO_SYNC, this.myAutoSyncCheckBox.isSelected());
        driver.setOption(DatabaseDriver.OPTION_FORMAT_SOURCES_ON_SYNC, this.myFormatSourcesOnSyncCheckBox.isSelected());
        driver.setOption(DatabaseDriver.OPTION_SEND_APP_INFO, this.mySendAppInfo.isSelected());
        driver.setOption(DatabaseDriver.OPTION_SOURCE_LOADING, (DBIntrospectionOptions.SourceLoading)this.mySourceLoading.getSelectedItem());
        driver.setOption(DatabaseDriver.OPTION_SCHEMA_CONTROL, (SchemaControl)this.mySwitchControlBox.getSelectedItem());
        driver.setInitScript(this.myInitScript.getText());
        driver.setKeepAliveQuery(this.myKeepAliveQuery.getText());
        driver.setIcon((Icon)this.myIcon.getSelectedItem());
        this.myConnectionOptionsEditor.apply(driver);
        this.myIntrospectionOptionsEditor.apply(driver);
    }

    public void reset(@NotNull DatabaseDriverImpl driver) {
        if (driver == null) {
            DatabaseDriverOptionsPanel.$$$reportNull$$$0(1);
        }
        this.myDialect.setSelectedItem((Object)Language.findLanguageByID((String)driver.getSqlDialect()));
        this.mySelector.toggle(null, (Boolean)driver.getOption(DatabaseDriver.OPTION_AUTO_COMMIT));
        this.myAutoSyncCheckBox.setSelected(((Boolean)driver.getOption(DatabaseDriver.OPTION_AUTO_SYNC)).booleanValue());
        this.myFormatSourcesOnSyncCheckBox.setSelected(((Boolean)driver.getOption(DatabaseDriver.OPTION_FORMAT_SOURCES_ON_SYNC)).booleanValue());
        this.mySwitchControlBox.setSelectedItem(driver.getOption(DatabaseDriver.OPTION_SCHEMA_CONTROL));
        this.mySourceLoading.setSelectedItem(driver.getOption(DatabaseDriver.OPTION_SOURCE_LOADING));
        this.mySendAppInfo.setSelected((Boolean)driver.getOption(DatabaseDriver.OPTION_SEND_APP_INFO));
        this.myInitScript.setText(driver.getInitScript());
        this.myKeepAliveQuery.setText(driver.getKeepAliveQuery());
        this.myIcon.setSelectedItem((Object)driver.getIcon(0));
        this.resetSQLFieldsDialect(DbSqlUtil.getSqlDialect(driver));
        this.myConnectionOptionsEditor.reset(driver);
        this.myIntrospectionOptionsEditor.reset(driver);
    }

    void resetSQLFieldsDialect(@NotNull SqlLanguageDialect dialect) {
        if (dialect == null) {
            DatabaseDriverOptionsPanel.$$$reportNull$$$0(2);
        }
        DatabaseDialogsHelper.setTextFieldLanguage(this.myInitScript, dialect);
        DatabaseDialogsHelper.setTextFieldLanguage(this.myKeepAliveQuery, dialect);
    }

    public void focusKeepAliveField() {
        ApplicationManager.getApplication().invokeLater(() -> {
            IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myConfigurable.getProject());
            focusManager.requestFocus((Component)this.myKeepAliveQuery, false);
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        ComboBox comboBox;
        JBLabel jBLabel;
        ComboBox comboBox2;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        ComboBox comboBox3;
        JPanel jPanel2;
        JPanel jPanel3;
        ComboBox comboBox4;
        this.createUIComponents();
        JBScrollPane jBScrollPane = this.myRoot;
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("data.source.connection.title"), (int)0, (int)0, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("data.source.switch.schema.label"));
        jPanel5.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySwitchControlBox = comboBox4 = new ComboBox();
        jPanel5.add((Component)comboBox4, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("data.source.startup.script.label"));
        jPanel5.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myInitScript;
        jPanel5.add((Component)editorTextField2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myTxControlHolder = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("data.source.transaction.control.label"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTxControlPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 8, 2, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("database.driver.settings.options.keep.alive.query.label"));
        jPanel5.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField3 = this.myKeepAliveQuery;
        jPanel5.add((Component)editorTextField3, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JComponent jComponent = this.myConnectionOptionsPanel;
        jPanel5.add((Component)jComponent, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("data.source.other.title"), (int)0, (int)0, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("database.driver.settings.options.dialect.label"));
        jPanel6.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDialect = comboBox3 = new ComboBox();
        jPanel6.add((Component)comboBox3, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myFormatSourcesOnSyncCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("database.driver.settings.options.format.synched.sources.label"));
        jPanel6.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 2, 0, null, null, null));
        this.myIconPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("database.driver.settings.options.icon.label"));
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myIcon = comboBox2 = new ComboBox();
        jPanel.add((Component)comboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel4.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("data.source.editor.url.label.Introspection.title"), (int)0, (int)0, null, null));
        this.mySourceLoadingLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("data.source.load.sources.label"));
        jPanel7.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySourceLoading = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel7.add((Component)comboBox, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myAutoSyncCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("data.source.auto.sync.label"));
        jPanel7.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySendAppInfo = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DatabaseDriverOptionsPanel.class).getString("database.driver.settings.options.load.sources.label"));
        jPanel7.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 3, null, null, null));
        JComponent jComponent2 = this.myIntrospectionOptionsPanel;
        jPanel7.add((Component)jComponent2, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor((Component)comboBox4);
        jLabel2.setLabelFor((Component)editorTextField2);
        jLabel4.setLabelFor((Component)editorTextField3);
        jBLabel2.setLabelFor((Component)comboBox3);
        jBLabel3.setLabelFor((Component)comboBox3);
        jBLabel.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c2 = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/view/ui/DatabaseDriverOptionsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "saveData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "resetSQLFieldsDialect";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

