/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcChangesTracker;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.model.ModelEntityStoragePersistentBackendKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemDependent;
import org.jetbrains.annotations.TestOnly;

public class DbSrcStorageManager {
    private static final Logger LOG = Logger.getInstance(DbSrcStorageManager.class);
    private final Project myProject;
    private final @SystemDependent String myRootPath;
    private final Map<String, DbSrcStorage> myStorages = ContainerUtil.createConcurrentSoftValueMap();

    @NotNull
    public static DbSrcStorageManager getInstance(@Nullable Project project) {
        DbSrcStorageManager dbSrcStorageManager = project == null ? (DbSrcStorageManager)ApplicationManager.getApplication().getService(App.class) : (DbSrcStorageManager)project.getService(DbSrcStorageManager.class);
        if (dbSrcStorageManager == null) {
            DbSrcStorageManager.$$$reportNull$$$0(0);
        }
        return dbSrcStorageManager;
    }

    public DbSrcStorageManager(@Nullable Project project) {
        this.myProject = project;
        this.myRootPath = DbSrcStorageManager.getStorageRoot(project).toString();
        Disposer.register((Disposable)(this.myProject == null ? ApplicationManager.getApplication() : this.myProject), this::finish);
        DbSrcChangesTracker.getInstance(null);
    }

    public boolean isStored() {
        return FileSystems.getDefault().getPath(this.myRootPath, new String[0]).toFile().isDirectory();
    }

    public boolean isStored(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcStorageManager.$$$reportNull$$$0(1);
        }
        return FileSystems.getDefault().getPath(this.myRootPath, dataSourceId).toFile().isDirectory();
    }

    /*
     * Loose catch block
     */
    @NotNull
    public List<String> getStoredDataSources() {
        List<String> list;
        Stream<Path> list2;
        block12: {
            Path root = FileSystems.getDefault().getPath(this.myRootPath, new String[0]);
            if (!root.toFile().isDirectory()) {
                List<String> list3 = Collections.emptyList();
                if (list3 == null) {
                    DbSrcStorageManager.$$$reportNull$$$0(2);
                }
                return list3;
            }
            list2 = Files.list(root);
            list = list2.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(p2 -> p2.getFileName().toString()).collect(Collectors.toList());
            if (list2 == null) break block12;
            list2.close();
        }
        List<String> list4 = list;
        if (list4 == null) {
            DbSrcStorageManager.$$$reportNull$$$0(3);
        }
        return list4;
        {
            catch (Throwable throwable) {
                try {
                    if (list2 != null) {
                        try {
                            list2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                    List<String> list5 = Collections.emptyList();
                    if (list5 == null) {
                        DbSrcStorageManager.$$$reportNull$$$0(4);
                    }
                    return list5;
                }
            }
        }
    }

    @NotNull
    public Iterable<DbSrcStorage> getActiveStorages() {
        Collection<DbSrcStorage> collection = this.myStorages.values();
        if (collection == null) {
            DbSrcStorageManager.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Contract(value="_,true->!null")
    public DbSrcStorage getStorage(@NotNull String dataSourceId, boolean write) {
        DbSrcStorage backend;
        if (dataSourceId == null) {
            DbSrcStorageManager.$$$reportNull$$$0(6);
        }
        if ((backend = this.myStorages.get(dataSourceId)) == null) {
            String root = this.myRootPath + File.separator + dataSourceId;
            if (!write && !FileSystems.getDefault().getPath(root, new String[0]).toFile().isDirectory()) {
                return null;
            }
            backend = new DbSrcStorage(this.myProject, this.myRootPath, dataSourceId);
            DbSrcStorage prev2 = this.myStorages.putIfAbsent(dataSourceId, backend);
            if (prev2 != null) {
                backend = prev2;
            }
        }
        return backend;
    }

    public void removeBackend(@NotNull String dataSourceId) {
        if (dataSourceId == null) {
            DbSrcStorageManager.$$$reportNull$$$0(7);
        }
        this.myStorages.remove(dataSourceId);
    }

    @NotNull
    public static Path getStorageRoot(@Nullable Project project) {
        Path storage = DataSourceStorage.getStoragePath((Project)project);
        if (storage == null) {
            String filePath = project.getProjectFilePath();
            Path path = storage = filePath == null ? null : Paths.get(filePath, new String[0]);
        }
        if (storage == null) {
            storage = Paths.get(PathManager.getOptionsPath(), "dummy");
        }
        Path path = storage.getParent().resolve("dataSources").toAbsolutePath().normalize();
        if (path == null) {
            DbSrcStorageManager.$$$reportNull$$$0(8);
        }
        return path;
    }

    public void finish() {
        List<DbSrcStorage> storages = DbSrcBackendUtils.clearAndGetValues(this.myStorages);
        for (DbSrcStorage storage : storages) {
            storage.finish();
        }
    }

    @TestOnly
    public void prune() {
        List<DbSrcStorage> storages = DbSrcBackendUtils.clearAndGetValues(this.myStorages);
        for (DbSrcStorage storage : storages) {
            storage.flushToFs(false);
            storage.resetCaches();
        }
        ModelEntityStoragePersistentBackendKt.closeAll();
        FileUtil.delete((File)new File(this.myRootPath));
        Pair files2 = VfsImplUtil.findCachedFileByPath((NewVirtualFileSystem)DbSrcFileSystem.getInstance(), (String)DbSrcFileSystem.getProjectPath(this.myProject));
        NewVirtualFile file = (NewVirtualFile)ObjectUtils.chooseNotNull((Object)((NewVirtualFile)files2.first), (Object)((NewVirtualFile)files2.second));
        if (file != null) {
            VfsUtil.markDirty((files2.first != null ? 1 : 0) != 0, (boolean)false, (VirtualFile[])new VirtualFile[]{file});
            RefreshQueue.getInstance().refresh(false, true, null, new VirtualFile[]{file});
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorageManager";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSourceId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcStorageManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredDataSources";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveStorages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageRoot";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isStored";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getStorage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeBackend";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static class App
    extends DbSrcStorageManager {
        public App() {
            super(null);
        }
    }
}

