/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.postman.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.httpClient.postman.PostmanMapperKt;
import com.intellij.httpClient.postman.converter.FileType;
import com.intellij.httpClient.postman.converter.PostmanFileCheckerKt;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/httpClient/postman/converter/PostmanFileDetector;", "", "<init>", "()V", "externalizer", "Lcom/intellij/util/io/DataExternalizer;", "Lcom/intellij/httpClient/postman/converter/FileType;", "gist", "Lcom/intellij/util/gist/VirtualFileGist;", "getPostmanFileType", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "retrieveType", "intellij.restClient"})
final class PostmanFileDetector {
    @NotNull
    private final DataExternalizer<FileType> externalizer = (DataExternalizer)new DataExternalizer<FileType>(){

        public void save(DataOutput dataOutput, FileType fileType) {
            Intrinsics.checkNotNullParameter((Object)dataOutput, (String)"dataOutput");
            String string = PostmanMapperKt.getPostmanMapper().writeValueAsString((Object)((Object)fileType));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
            String string2 = string;
            byte[] byArray = string2.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            dataOutput.write(byArray);
        }

        public FileType read(DataInput dataInput) {
            Intrinsics.checkNotNullParameter((Object)dataInput, (String)"dataInput");
            Object object = PostmanMapperKt.getPostmanMapper().readValue(dataInput, FileType.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
            return (FileType)((Object)object);
        }
    };
    @NotNull
    private final VirtualFileGist<FileType> gist;

    public PostmanFileDetector() {
        VirtualFileGist virtualFileGist = GistManager.getInstance().newVirtualFileGist("com.intellij.httpClient.postman.converter.gist.key", 2, this.externalizer, (arg_0, arg_1) -> PostmanFileDetector.gist$lambda$0(this, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileGist, (String)"newVirtualFileGist(...)");
        this.gist = virtualFileGist;
    }

    @Nullable
    public final FileType getPostmanFileType(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return (FileType)((Object)this.gist.getFileData(project, file));
    }

    private final FileType retrieveType(VirtualFile file) {
        JsonNode jsonNode = PostmanFileCheckerKt.access$parseToTree(file);
        if (jsonNode == null) {
            return FileType.OTHER;
        }
        JsonNode tree = jsonNode;
        JsonNode jsonNode2 = tree.get("_postman_variable_scope");
        return Intrinsics.areEqual((Object)(jsonNode2 != null ? jsonNode2.textValue() : null), (Object)"environment") ? FileType.POSTMAN_ENVIRONMENT : (PostmanFileCheckerKt.access$isPostmanCollectionFile(tree) ? FileType.POSTMAN_COLLECTION : FileType.OTHER);
    }

    private static final FileType gist$lambda$0(PostmanFileDetector this$0, Project project, VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)JsonFileType.INSTANCE)) {
            return null;
        }
        return this$0.retrieveType(file);
    }
}

