/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.PseudoCylindricalProjection;
import org.locationtech.proj4j.util.ProjectionMath;

public class SinusoidalProjection
extends PseudoCylindricalProjection {
    @Override
    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        xy.x = lam * Math.cos(phi);
        xy.y = phi;
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        lp.x = x / Math.cos(y);
        lp.y = y;
        return lp;
    }

    public double getWidth(double y) {
        return ProjectionMath.normalizeLongitude(Math.PI) * Math.cos(y);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public boolean isEqualArea() {
        return true;
    }

    @Override
    public String toString() {
        return "Sinusoidal";
    }
}

